/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockRedstoneLamp
extends Block {
    public static final MapCodec<BlockRedstoneLamp> CODEC = BlockRedstoneLamp.simpleCodec(BlockRedstoneLamp::new);
    public static final BlockStateBoolean LIT = BlockRedstoneTorch.LIT;

    public MapCodec<BlockRedstoneLamp> codec() {
        return CODEC;
    }

    public BlockRedstoneLamp(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(LIT, false));
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        return (IBlockData)this.defaultBlockState().setValue(LIT, blockactioncontext.getLevel().hasNeighborSignal(blockactioncontext.getClickedPos()));
    }

    @Override
    protected void neighborChanged(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        boolean flag1;
        if (!world.isClientSide && (flag1 = iblockdata.getValue(LIT).booleanValue()) != world.hasNeighborSignal(blockposition)) {
            if (flag1) {
                world.scheduleTick(blockposition, this, 4);
            } else {
                if (CraftEventFactory.callRedstoneChange(world, blockposition, 0, 15).getNewCurrent() != 15) {
                    return;
                }
                world.setBlock(blockposition, (IBlockData)iblockdata.cycle(LIT), 2);
            }
        }
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue() && !worldserver.hasNeighborSignal(blockposition)) {
            if (CraftEventFactory.callRedstoneChange(worldserver, blockposition, 15, 0).getNewCurrent() != 0) {
                return;
            }
            worldserver.setBlock(blockposition, (IBlockData)iblockdata.cycle(LIT), 2);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(LIT);
    }
}

