/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockRedstoneOre
extends Block {
    public static final MapCodec<BlockRedstoneOre> CODEC = BlockRedstoneOre.simpleCodec(BlockRedstoneOre::new);
    public static final BlockStateBoolean LIT = BlockRedstoneTorch.LIT;

    public MapCodec<BlockRedstoneOre> codec() {
        return CODEC;
    }

    public BlockRedstoneOre(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(LIT, false));
    }

    @Override
    protected void attack(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman) {
        BlockRedstoneOre.interact(iblockdata, world, blockposition, entityhuman);
        super.attack(iblockdata, world, blockposition, entityhuman);
    }

    @Override
    public void stepOn(World world, BlockPosition blockposition, IBlockData iblockdata, net.minecraft.world.entity.Entity entity) {
        if (!entity.isSteppingCarefully()) {
            if (entity instanceof EntityHuman) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, blockposition, null, null, null);
                if (!event.isCancelled()) {
                    BlockRedstoneOre.interact(world.getBlockState(blockposition), world, blockposition, entity);
                }
            } else {
                EntityInteractEvent event = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    BlockRedstoneOre.interact(world.getBlockState(blockposition), world, blockposition, entity);
                }
            }
        }
        super.stepOn(world, blockposition, iblockdata, entity);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        if (world.isClientSide) {
            BlockRedstoneOre.spawnParticles(world, blockposition);
        } else {
            BlockRedstoneOre.interact(iblockdata, world, blockposition, entityhuman);
        }
        return itemstack.getItem() instanceof ItemBlock && new BlockActionContext(entityhuman, enumhand, itemstack, movingobjectpositionblock).canPlace() ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.SUCCESS;
    }

    private static void interact(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        BlockRedstoneOre.spawnParticles(world, blockposition);
        if (!iblockdata.getValue(LIT).booleanValue()) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (IBlockData)iblockdata.setValue(LIT, true))) {
                return;
            }
            world.setBlock(blockposition, (IBlockData)iblockdata.setValue(LIT, true), 3);
        }
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData iblockdata) {
        return iblockdata.getValue(LIT);
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue()) {
            if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, (IBlockData)iblockdata.setValue(LIT, false)).isCancelled()) {
                return;
            }
            worldserver.setBlock(blockposition, (IBlockData)iblockdata.setValue(LIT, false), 3);
        }
    }

    @Override
    protected void spawnAfterBreak(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        super.spawnAfterBreak(iblockdata, worldserver, blockposition, itemstack, flag);
    }

    @Override
    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, UniformInt.of(1, 5));
        }
        return 0;
    }

    @Override
    public void animateTick(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue()) {
            BlockRedstoneOre.spawnParticles(world, blockposition);
        }
    }

    private static void spawnParticles(World world, BlockPosition blockposition) {
        double d0 = 0.5625;
        RandomSource randomsource = world.random;
        for (EnumDirection enumdirection : EnumDirection.values()) {
            BlockPosition blockposition1 = blockposition.relative(enumdirection);
            if (world.getBlockState(blockposition1).isSolidRender(world, blockposition1)) continue;
            EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.getAxis();
            double d1 = enumdirection_enumaxis == EnumDirection.EnumAxis.X ? 0.5 + 0.5625 * (double)enumdirection.getStepX() : (double)randomsource.nextFloat();
            double d2 = enumdirection_enumaxis == EnumDirection.EnumAxis.Y ? 0.5 + 0.5625 * (double)enumdirection.getStepY() : (double)randomsource.nextFloat();
            double d3 = enumdirection_enumaxis == EnumDirection.EnumAxis.Z ? 0.5 + 0.5625 * (double)enumdirection.getStepZ() : (double)randomsource.nextFloat();
            world.addParticle(ParticleParamRedstone.REDSTONE, (double)blockposition.getX() + d1, (double)blockposition.getY() + d2, (double)blockposition.getZ() + d3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(LIT);
    }
}

