/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BaseTorchBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.PluginManager;

public class BlockRedstoneTorch
extends BaseTorchBlock {
    public static final MapCodec<BlockRedstoneTorch> CODEC = BlockRedstoneTorch.simpleCodec(BlockRedstoneTorch::new);
    public static final BlockStateBoolean LIT = BlockProperties.LIT;
    private static final Map<IBlockAccess, List<RedstoneUpdateInfo>> RECENT_TOGGLES = new WeakHashMap<IBlockAccess, List<RedstoneUpdateInfo>>();
    public static final int RECENT_TOGGLE_TIMER = 60;
    public static final int MAX_RECENT_TOGGLES = 8;
    public static final int RESTART_DELAY = 160;
    private static final int TOGGLE_DELAY = 2;

    public MapCodec<? extends BlockRedstoneTorch> codec() {
        return CODEC;
    }

    protected BlockRedstoneTorch(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(LIT, true));
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            world.updateNeighborsAt(blockposition.relative(enumdirection), this);
        }
    }

    @Override
    protected void onRemove(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!flag) {
            for (EnumDirection enumdirection : EnumDirection.values()) {
                world.updateNeighborsAt(blockposition.relative(enumdirection), this);
            }
        }
    }

    @Override
    protected int getSignal(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.getValue(LIT) != false && EnumDirection.UP != enumdirection ? 15 : 0;
    }

    protected boolean hasNeighborSignal(World world, BlockPosition blockposition, IBlockData iblockdata) {
        return world.hasSignal(blockposition.below(), EnumDirection.DOWN);
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        boolean flag = this.hasNeighborSignal(worldserver, blockposition, iblockdata);
        List<RedstoneUpdateInfo> list = RECENT_TOGGLES.get(worldserver);
        while (list != null && !list.isEmpty() && worldserver.getGameTime() - list.get((int)0).when > 60L) {
            list.remove(0);
        }
        PluginManager manager = worldserver.getCraftServer().getPluginManager();
        org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
        int oldCurrent = iblockdata.getValue(LIT) != false ? 15 : 0;
        BlockRedstoneEvent event = new BlockRedstoneEvent(block, oldCurrent, oldCurrent);
        if (iblockdata.getValue(LIT).booleanValue()) {
            if (flag) {
                if (oldCurrent != 0) {
                    event.setNewCurrent(0);
                    manager.callEvent((Event)event);
                    if (event.getNewCurrent() != 0) {
                        return;
                    }
                }
                worldserver.setBlock(blockposition, (IBlockData)iblockdata.setValue(LIT, false), 3);
                if (BlockRedstoneTorch.isToggledTooFrequently(worldserver, blockposition, true)) {
                    worldserver.levelEvent(1502, blockposition, 0);
                    worldserver.scheduleTick(blockposition, worldserver.getBlockState(blockposition).getBlock(), 160);
                }
            }
        } else if (!flag && !BlockRedstoneTorch.isToggledTooFrequently(worldserver, blockposition, false)) {
            if (oldCurrent != 15) {
                event.setNewCurrent(15);
                manager.callEvent((Event)event);
                if (event.getNewCurrent() != 15) {
                    return;
                }
            }
            worldserver.setBlock(blockposition, (IBlockData)iblockdata.setValue(LIT, true), 3);
        }
    }

    @Override
    protected void neighborChanged(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        if (iblockdata.getValue(LIT).booleanValue() == this.hasNeighborSignal(world, blockposition, iblockdata) && !world.getBlockTicks().willTickThisTick(blockposition, this)) {
            world.scheduleTick(blockposition, this, 2);
        }
    }

    @Override
    protected int getDirectSignal(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return enumdirection == EnumDirection.DOWN ? iblockdata.getSignal(iblockaccess, blockposition, enumdirection) : 0;
    }

    @Override
    protected boolean isSignalSource(IBlockData iblockdata) {
        return true;
    }

    @Override
    public void animateTick(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue()) {
            double d0 = (double)blockposition.getX() + 0.5 + (randomsource.nextDouble() - 0.5) * 0.2;
            double d1 = (double)blockposition.getY() + 0.7 + (randomsource.nextDouble() - 0.5) * 0.2;
            double d2 = (double)blockposition.getZ() + 0.5 + (randomsource.nextDouble() - 0.5) * 0.2;
            world.addParticle(ParticleParamRedstone.REDSTONE, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(LIT);
    }

    private static boolean isToggledTooFrequently(World world, BlockPosition blockposition, boolean flag) {
        List list = RECENT_TOGGLES.computeIfAbsent(world, iblockaccess -> Lists.newArrayList());
        if (flag) {
            list.add(new RedstoneUpdateInfo(blockposition.immutable(), world.getGameTime()));
        }
        int i2 = 0;
        for (RedstoneUpdateInfo blockredstonetorch_redstoneupdateinfo : list) {
            if (!blockredstonetorch_redstoneupdateinfo.pos.equals(blockposition) || ++i2 < 8) continue;
            return true;
        }
        return false;
    }

    public static class RedstoneUpdateInfo {
        final BlockPosition pos;
        final long when;

        public RedstoneUpdateInfo(BlockPosition blockposition, long i2) {
            this.pos = blockposition;
            this.when = i2;
        }
    }
}

