/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockObserver;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockRedstoneWire
extends Block {
    public static final MapCodec<BlockRedstoneWire> CODEC = BlockRedstoneWire.simpleCodec(BlockRedstoneWire::new);
    public static final BlockStateEnum<BlockPropertyRedstoneSide> NORTH = BlockProperties.NORTH_REDSTONE;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> EAST = BlockProperties.EAST_REDSTONE;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> SOUTH = BlockProperties.SOUTH_REDSTONE;
    public static final BlockStateEnum<BlockPropertyRedstoneSide> WEST = BlockProperties.WEST_REDSTONE;
    public static final BlockStateInteger POWER = BlockProperties.POWER;
    public static final Map<EnumDirection, BlockStateEnum<BlockPropertyRedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.NORTH, NORTH, (Object)EnumDirection.EAST, EAST, (Object)EnumDirection.SOUTH, SOUTH, (Object)EnumDirection.WEST, WEST));
    protected static final int H = 1;
    protected static final int W = 3;
    protected static final int E = 13;
    protected static final int N = 3;
    protected static final int S = 13;
    private static final VoxelShape SHAPE_DOT = Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<EnumDirection, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.NORTH, (Object)Block.box(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)EnumDirection.SOUTH, (Object)Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)EnumDirection.EAST, (Object)Block.box(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)EnumDirection.WEST, (Object)Block.box(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<EnumDirection, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.NORTH, (Object)VoxelShapes.or(SHAPES_FLOOR.get(EnumDirection.NORTH), Block.box(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)EnumDirection.SOUTH, (Object)VoxelShapes.or(SHAPES_FLOOR.get(EnumDirection.SOUTH), Block.box(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)EnumDirection.EAST, (Object)VoxelShapes.or(SHAPES_FLOOR.get(EnumDirection.EAST), Block.box(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)EnumDirection.WEST, (Object)VoxelShapes.or(SHAPES_FLOOR.get(EnumDirection.WEST), Block.box(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private static final Map<IBlockData, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private static final Vec3D[] COLORS = SystemUtils.make(new Vec3D[16], avec3d -> {
        for (int i2 = 0; i2 <= 15; ++i2) {
            float f2;
            float f1 = f2 * 0.6f + ((f2 = (float)i2 / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f22 = MathHelper.clamp(f2 * f2 * 0.7f - 0.5f, 0.0f, 1.0f);
            float f3 = MathHelper.clamp(f2 * f2 * 0.6f - 0.7f, 0.0f, 1.0f);
            avec3d[i2] = new Vec3D(f1, f22, f3);
        }
    });
    private static final float PARTICLE_DENSITY = 0.2f;
    private final IBlockData crossState;
    private boolean shouldSignal = true;

    public MapCodec<BlockRedstoneWire> codec() {
        return CODEC;
    }

    public BlockRedstoneWire(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(NORTH, BlockPropertyRedstoneSide.NONE)).setValue(EAST, BlockPropertyRedstoneSide.NONE)).setValue(SOUTH, BlockPropertyRedstoneSide.NONE)).setValue(WEST, BlockPropertyRedstoneSide.NONE)).setValue(POWER, 0));
        this.crossState = (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(NORTH, BlockPropertyRedstoneSide.SIDE)).setValue(EAST, BlockPropertyRedstoneSide.SIDE)).setValue(SOUTH, BlockPropertyRedstoneSide.SIDE)).setValue(WEST, BlockPropertyRedstoneSide.SIDE);
        for (IBlockData iblockdata : this.getStateDefinition().getPossibleStates()) {
            if (iblockdata.getValue(POWER) != 0) continue;
            SHAPES_CACHE.put(iblockdata, this.calculateShape(iblockdata));
        }
    }

    private VoxelShape calculateShape(IBlockData iblockdata) {
        VoxelShape voxelshape = SHAPE_DOT;
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPropertyRedstoneSide blockpropertyredstoneside = (BlockPropertyRedstoneSide)iblockdata.getValue(PROPERTY_BY_DIRECTION.get(enumdirection));
            if (blockpropertyredstoneside == BlockPropertyRedstoneSide.SIDE) {
                voxelshape = VoxelShapes.or(voxelshape, SHAPES_FLOOR.get(enumdirection));
                continue;
            }
            if (blockpropertyredstoneside != BlockPropertyRedstoneSide.UP) continue;
            voxelshape = VoxelShapes.or(voxelshape, SHAPES_UP.get(enumdirection));
        }
        return voxelshape;
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return SHAPES_CACHE.get(iblockdata.setValue(POWER, 0));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        return this.getConnectionState(blockactioncontext.getLevel(), this.crossState, blockactioncontext.getClickedPos());
    }

    private IBlockData getConnectionState(IBlockAccess iblockaccess, IBlockData iblockdata, BlockPosition blockposition) {
        boolean flag6;
        boolean flag = BlockRedstoneWire.isDot(iblockdata);
        iblockdata = this.getMissingConnections(iblockaccess, (IBlockData)this.defaultBlockState().setValue(POWER, iblockdata.getValue(POWER)), blockposition);
        if (flag && BlockRedstoneWire.isDot(iblockdata)) {
            return iblockdata;
        }
        boolean flag1 = iblockdata.getValue(NORTH).isConnected();
        boolean flag2 = iblockdata.getValue(SOUTH).isConnected();
        boolean flag3 = iblockdata.getValue(EAST).isConnected();
        boolean flag4 = iblockdata.getValue(WEST).isConnected();
        boolean flag5 = !flag1 && !flag2;
        boolean bl = flag6 = !flag3 && !flag4;
        if (!flag4 && flag5) {
            iblockdata = (IBlockData)iblockdata.setValue(WEST, BlockPropertyRedstoneSide.SIDE);
        }
        if (!flag3 && flag5) {
            iblockdata = (IBlockData)iblockdata.setValue(EAST, BlockPropertyRedstoneSide.SIDE);
        }
        if (!flag1 && flag6) {
            iblockdata = (IBlockData)iblockdata.setValue(NORTH, BlockPropertyRedstoneSide.SIDE);
        }
        if (!flag2 && flag6) {
            iblockdata = (IBlockData)iblockdata.setValue(SOUTH, BlockPropertyRedstoneSide.SIDE);
        }
        return iblockdata;
    }

    private IBlockData getMissingConnections(IBlockAccess iblockaccess, IBlockData iblockdata, BlockPosition blockposition) {
        boolean flag = !iblockaccess.getBlockState(blockposition.above()).isRedstoneConductor(iblockaccess, blockposition);
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (((BlockPropertyRedstoneSide)iblockdata.getValue(PROPERTY_BY_DIRECTION.get(enumdirection))).isConnected()) continue;
            BlockPropertyRedstoneSide blockpropertyredstoneside = this.getConnectingSide(iblockaccess, blockposition, enumdirection, flag);
            iblockdata = (IBlockData)iblockdata.setValue(PROPERTY_BY_DIRECTION.get(enumdirection), blockpropertyredstoneside);
        }
        return iblockdata;
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (enumdirection == EnumDirection.DOWN) {
            return !this.canSurviveOn(generatoraccess, blockposition1, iblockdata1) ? Blocks.AIR.defaultBlockState() : iblockdata;
        }
        if (enumdirection == EnumDirection.UP) {
            return this.getConnectionState(generatoraccess, iblockdata, blockposition);
        }
        BlockPropertyRedstoneSide blockpropertyredstoneside = this.getConnectingSide(generatoraccess, blockposition, enumdirection);
        return blockpropertyredstoneside.isConnected() == ((BlockPropertyRedstoneSide)iblockdata.getValue(PROPERTY_BY_DIRECTION.get(enumdirection))).isConnected() && !BlockRedstoneWire.isCross(iblockdata) ? (IBlockData)iblockdata.setValue(PROPERTY_BY_DIRECTION.get(enumdirection), blockpropertyredstoneside) : this.getConnectionState(generatoraccess, (IBlockData)((IBlockData)this.crossState.setValue(POWER, iblockdata.getValue(POWER))).setValue(PROPERTY_BY_DIRECTION.get(enumdirection), blockpropertyredstoneside), blockposition);
    }

    private static boolean isCross(IBlockData iblockdata) {
        return iblockdata.getValue(NORTH).isConnected() && iblockdata.getValue(SOUTH).isConnected() && iblockdata.getValue(EAST).isConnected() && iblockdata.getValue(WEST).isConnected();
    }

    private static boolean isDot(IBlockData iblockdata) {
        return !iblockdata.getValue(NORTH).isConnected() && !iblockdata.getValue(SOUTH).isConnected() && !iblockdata.getValue(EAST).isConnected() && !iblockdata.getValue(WEST).isConnected();
    }

    @Override
    protected void updateIndirectNeighbourShapes(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPropertyRedstoneSide blockpropertyredstoneside = (BlockPropertyRedstoneSide)iblockdata.getValue(PROPERTY_BY_DIRECTION.get(enumdirection));
            if (blockpropertyredstoneside == BlockPropertyRedstoneSide.NONE || generatoraccess.getBlockState(blockposition_mutableblockposition.setWithOffset((BaseBlockPosition)blockposition, enumdirection)).is(this)) continue;
            blockposition_mutableblockposition.move(EnumDirection.DOWN);
            IBlockData iblockdata1 = generatoraccess.getBlockState(blockposition_mutableblockposition);
            if (iblockdata1.is(this)) {
                BaseBlockPosition blockposition1 = blockposition_mutableblockposition.relative(enumdirection.getOpposite());
                generatoraccess.neighborShapeChanged(enumdirection.getOpposite(), generatoraccess.getBlockState((BlockPosition)blockposition1), blockposition_mutableblockposition, (BlockPosition)blockposition1, i2, j2);
            }
            blockposition_mutableblockposition.setWithOffset((BaseBlockPosition)blockposition, enumdirection).move(EnumDirection.UP);
            IBlockData iblockdata2 = generatoraccess.getBlockState(blockposition_mutableblockposition);
            if (!iblockdata2.is(this)) continue;
            BaseBlockPosition blockposition2 = blockposition_mutableblockposition.relative(enumdirection.getOpposite());
            generatoraccess.neighborShapeChanged(enumdirection.getOpposite(), generatoraccess.getBlockState((BlockPosition)blockposition2), blockposition_mutableblockposition, (BlockPosition)blockposition2, i2, j2);
        }
    }

    private BlockPropertyRedstoneSide getConnectingSide(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return this.getConnectingSide(iblockaccess, blockposition, enumdirection, !iblockaccess.getBlockState(blockposition.above()).isRedstoneConductor(iblockaccess, blockposition));
    }

    private BlockPropertyRedstoneSide getConnectingSide(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, boolean flag) {
        BlockPosition blockposition1 = blockposition.relative(enumdirection);
        IBlockData iblockdata = iblockaccess.getBlockState(blockposition1);
        if (flag) {
            boolean flag1;
            boolean bl = flag1 = iblockdata.getBlock() instanceof BlockTrapdoor || this.canSurviveOn(iblockaccess, blockposition1, iblockdata);
            if (flag1 && BlockRedstoneWire.shouldConnectTo(iblockaccess.getBlockState(blockposition1.above()))) {
                if (iblockdata.isFaceSturdy(iblockaccess, blockposition1, enumdirection.getOpposite())) {
                    return BlockPropertyRedstoneSide.UP;
                }
                return BlockPropertyRedstoneSide.SIDE;
            }
        }
        return !BlockRedstoneWire.shouldConnectTo(iblockdata, enumdirection) && (iblockdata.isRedstoneConductor(iblockaccess, blockposition1) || !BlockRedstoneWire.shouldConnectTo(iblockaccess.getBlockState(blockposition1.below()))) ? BlockPropertyRedstoneSide.NONE : BlockPropertyRedstoneSide.SIDE;
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.below();
        IBlockData iblockdata1 = iworldreader.getBlockState(blockposition1);
        return this.canSurviveOn(iworldreader, blockposition1, iblockdata1);
    }

    private boolean canSurviveOn(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata) {
        return iblockdata.isFaceSturdy(iblockaccess, blockposition, EnumDirection.UP) || iblockdata.is(Blocks.HOPPER);
    }

    private void updatePowerStrength(World world, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = this.calculateTargetStrength(world, blockposition);
        int oldPower = iblockdata.getValue(POWER);
        if (oldPower != i2) {
            BlockRedstoneEvent event = new BlockRedstoneEvent(world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()), oldPower, i2);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            i2 = event.getNewCurrent();
        }
        if (oldPower != i2) {
            if (world.getBlockState(blockposition) == iblockdata) {
                world.setBlock(blockposition, (IBlockData)iblockdata.setValue(POWER, i2), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(blockposition);
            for (EnumDirection enumdirection : EnumDirection.values()) {
                set.add(blockposition.relative(enumdirection));
            }
            for (BlockPosition blockposition1 : set) {
                world.updateNeighborsAt(blockposition1, this);
            }
        }
    }

    private int calculateTargetStrength(World world, BlockPosition blockposition) {
        this.shouldSignal = false;
        int i2 = world.getBestNeighborSignal(blockposition);
        this.shouldSignal = true;
        int j2 = 0;
        if (i2 < 15) {
            for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                BlockPosition blockposition1 = blockposition.relative(enumdirection);
                IBlockData iblockdata = world.getBlockState(blockposition1);
                j2 = Math.max(j2, this.getWireSignal(iblockdata));
                BlockPosition blockposition2 = blockposition.above();
                if (iblockdata.isRedstoneConductor(world, blockposition1) && !world.getBlockState(blockposition2).isRedstoneConductor(world, blockposition2)) {
                    j2 = Math.max(j2, this.getWireSignal(world.getBlockState(blockposition1.above())));
                    continue;
                }
                if (iblockdata.isRedstoneConductor(world, blockposition1)) continue;
                j2 = Math.max(j2, this.getWireSignal(world.getBlockState(blockposition1.below())));
            }
        }
        return Math.max(i2, j2 - 1);
    }

    private int getWireSignal(IBlockData iblockdata) {
        return iblockdata.is(this) ? iblockdata.getValue(POWER) : 0;
    }

    private void checkCornerChangeAt(World world, BlockPosition blockposition) {
        if (world.getBlockState(blockposition).is(this)) {
            world.updateNeighborsAt(blockposition, this);
            for (EnumDirection enumdirection : EnumDirection.values()) {
                world.updateNeighborsAt(blockposition.relative(enumdirection), this);
            }
        }
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata1.is(iblockdata.getBlock()) && !world.isClientSide) {
            this.updatePowerStrength(world, blockposition, iblockdata);
            for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.VERTICAL) {
                world.updateNeighborsAt(blockposition.relative(enumdirection), this);
            }
            this.updateNeighborsOfNeighboringWires(world, blockposition);
        }
    }

    @Override
    protected void onRemove(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!flag && !iblockdata.is(iblockdata1.getBlock())) {
            super.onRemove(iblockdata, world, blockposition, iblockdata1, flag);
            if (!world.isClientSide) {
                for (EnumDirection enumdirection : EnumDirection.values()) {
                    world.updateNeighborsAt(blockposition.relative(enumdirection), this);
                }
                this.updatePowerStrength(world, blockposition, iblockdata);
                this.updateNeighborsOfNeighboringWires(world, blockposition);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(World world, BlockPosition blockposition) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            this.checkCornerChangeAt(world, blockposition.relative(enumdirection));
        }
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition blockposition1 = blockposition.relative(enumdirection);
            if (world.getBlockState(blockposition1).isRedstoneConductor(world, blockposition1)) {
                this.checkCornerChangeAt(world, blockposition1.above());
                continue;
            }
            this.checkCornerChangeAt(world, blockposition1.below());
        }
    }

    @Override
    protected void neighborChanged(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        if (!world.isClientSide) {
            if (iblockdata.canSurvive(world, blockposition)) {
                this.updatePowerStrength(world, blockposition, iblockdata);
            } else {
                BlockRedstoneWire.dropResources(iblockdata, world, blockposition);
                world.removeBlock(blockposition, false);
            }
        }
    }

    @Override
    protected int getDirectSignal(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return !this.shouldSignal ? 0 : iblockdata.getSignal(iblockaccess, blockposition, enumdirection);
    }

    @Override
    protected int getSignal(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        if (this.shouldSignal && enumdirection != EnumDirection.DOWN) {
            int i2 = iblockdata.getValue(POWER);
            return i2 == 0 ? 0 : (enumdirection != EnumDirection.UP && !((BlockPropertyRedstoneSide)this.getConnectionState(iblockaccess, iblockdata, blockposition).getValue(PROPERTY_BY_DIRECTION.get(enumdirection.getOpposite()))).isConnected() ? 0 : i2);
        }
        return 0;
    }

    protected static boolean shouldConnectTo(IBlockData iblockdata) {
        return BlockRedstoneWire.shouldConnectTo(iblockdata, null);
    }

    protected static boolean shouldConnectTo(IBlockData iblockdata, @Nullable EnumDirection enumdirection) {
        if (iblockdata.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (iblockdata.is(Blocks.REPEATER)) {
            EnumDirection enumdirection1 = iblockdata.getValue(BlockRepeater.FACING);
            return enumdirection1 == enumdirection || enumdirection1.getOpposite() == enumdirection;
        }
        return iblockdata.is(Blocks.OBSERVER) ? enumdirection == iblockdata.getValue(BlockObserver.FACING) : iblockdata.isSignalSource() && enumdirection != null;
    }

    @Override
    protected boolean isSignalSource(IBlockData iblockdata) {
        return this.shouldSignal;
    }

    public static int getColorForPower(int i2) {
        Vec3D vec3d = COLORS[i2];
        return MathHelper.color((float)vec3d.x(), (float)vec3d.y(), (float)vec3d.z());
    }

    private void spawnParticlesAlongLine(World world, RandomSource randomsource, BlockPosition blockposition, Vec3D vec3d, EnumDirection enumdirection, EnumDirection enumdirection1, float f2, float f1) {
        float f22 = f1 - f2;
        if (randomsource.nextFloat() < 0.2f * f22) {
            float f3 = 0.4375f;
            float f4 = f2 + f22 * randomsource.nextFloat();
            double d0 = 0.5 + (double)(0.4375f * (float)enumdirection.getStepX()) + (double)(f4 * (float)enumdirection1.getStepX());
            double d1 = 0.5 + (double)(0.4375f * (float)enumdirection.getStepY()) + (double)(f4 * (float)enumdirection1.getStepY());
            double d2 = 0.5 + (double)(0.4375f * (float)enumdirection.getStepZ()) + (double)(f4 * (float)enumdirection1.getStepZ());
            world.addParticle(new ParticleParamRedstone(vec3d.toVector3f(), 1.0f), (double)blockposition.getX() + d0, (double)blockposition.getY() + d1, (double)blockposition.getZ() + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void animateTick(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        int i2 = iblockdata.getValue(POWER);
        if (i2 != 0) {
            block4: for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                BlockPropertyRedstoneSide blockpropertyredstoneside = (BlockPropertyRedstoneSide)iblockdata.getValue(PROPERTY_BY_DIRECTION.get(enumdirection));
                switch (blockpropertyredstoneside) {
                    case UP: {
                        this.spawnParticlesAlongLine(world, randomsource, blockposition, COLORS[i2], enumdirection, EnumDirection.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.spawnParticlesAlongLine(world, randomsource, blockposition, COLORS[i2], EnumDirection.DOWN, enumdirection, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.spawnParticlesAlongLine(world, randomsource, blockposition, COLORS[i2], EnumDirection.DOWN, enumdirection, 0.0f, 0.3f);
            }
        }
    }

    @Override
    protected IBlockData rotate(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        switch (enumblockrotation) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(SOUTH))).setValue(EAST, iblockdata.getValue(WEST))).setValue(SOUTH, iblockdata.getValue(NORTH))).setValue(WEST, iblockdata.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(EAST))).setValue(EAST, iblockdata.getValue(SOUTH))).setValue(SOUTH, iblockdata.getValue(WEST))).setValue(WEST, iblockdata.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(WEST))).setValue(EAST, iblockdata.getValue(NORTH))).setValue(SOUTH, iblockdata.getValue(EAST))).setValue(WEST, iblockdata.getValue(SOUTH));
            }
        }
        return iblockdata;
    }

    @Override
    protected IBlockData mirror(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        switch (enumblockmirror) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(SOUTH))).setValue(SOUTH, iblockdata.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)iblockdata.setValue(EAST, iblockdata.getValue(WEST))).setValue(WEST, iblockdata.getValue(EAST));
            }
        }
        return super.mirror(iblockdata, enumblockmirror);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(NORTH, EAST, SOUTH, WEST, POWER);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (!entityhuman.getAbilities().mayBuild) {
            return EnumInteractionResult.PASS;
        }
        if (BlockRedstoneWire.isCross(iblockdata) || BlockRedstoneWire.isDot(iblockdata)) {
            IBlockData iblockdata1 = BlockRedstoneWire.isCross(iblockdata) ? this.defaultBlockState() : this.crossState;
            iblockdata1 = (IBlockData)iblockdata1.setValue(POWER, iblockdata.getValue(POWER));
            if ((iblockdata1 = this.getConnectionState(world, iblockdata1, blockposition)) != iblockdata) {
                world.setBlock(blockposition, iblockdata1, 3);
                this.updatesOnShapeChange(world, blockposition, iblockdata, iblockdata1);
                return EnumInteractionResult.SUCCESS;
            }
        }
        return EnumInteractionResult.PASS;
    }

    private void updatesOnShapeChange(World world, BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition blockposition1 = blockposition.relative(enumdirection);
            if (((BlockPropertyRedstoneSide)iblockdata.getValue(PROPERTY_BY_DIRECTION.get(enumdirection))).isConnected() == ((BlockPropertyRedstoneSide)iblockdata1.getValue(PROPERTY_BY_DIRECTION.get(enumdirection))).isConnected() || !world.getBlockState(blockposition1).isRedstoneConductor(world, blockposition1)) continue;
            world.updateNeighborsAtExceptFromFacing(blockposition1, iblockdata1.getBlock(), enumdirection.getOpposite());
        }
    }
}

