/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockReed
extends Block {
    public static final MapCodec<BlockReed> CODEC = BlockReed.simpleCodec(BlockReed::new);
    public static final BlockStateInteger AGE = BlockProperties.AGE_15;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);

    public MapCodec<BlockReed> codec() {
        return CODEC;
    }

    protected BlockReed(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (!iblockdata.canSurvive(worldserver, blockposition)) {
            worldserver.destroyBlock(blockposition, true);
        }
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.isEmptyBlock(blockposition.above())) {
            int i2 = 1;
            while (worldserver.getBlockState(blockposition.below(i2)).is(this)) {
                ++i2;
            }
            if (i2 < 3) {
                int j2 = iblockdata.getValue(AGE);
                int modifier = worldserver.spigotConfig.caneModifier;
                if (j2 >= 15 || modifier != 100 && randomsource.nextFloat() < (float)modifier / 1600.0f) {
                    CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition.above(), this.defaultBlockState());
                    worldserver.setBlock(blockposition, (IBlockData)iblockdata.setValue(AGE, 0), 4);
                } else if (modifier == 100 || randomsource.nextFloat() < (float)modifier / 1600.0f) {
                    worldserver.setBlock(blockposition, (IBlockData)iblockdata.setValue(AGE, j2 + 1), 4);
                }
            }
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (!iblockdata.canSurvive(generatoraccess, blockposition)) {
            generatoraccess.scheduleTick(blockposition, this, 1);
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        IBlockData iblockdata1 = iworldreader.getBlockState(blockposition.below());
        if (iblockdata1.is(this)) {
            return true;
        }
        if (iblockdata1.is(TagsBlock.DIRT) || iblockdata1.is(TagsBlock.SAND)) {
            BlockPosition blockposition1 = blockposition.below();
            for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                IBlockData iblockdata2 = iworldreader.getBlockState(blockposition1.relative(enumdirection));
                Fluid fluid = iworldreader.getFluidState(blockposition1.relative(enumdirection));
                if (!fluid.is(TagsFluid.WATER) && !iblockdata2.is(Blocks.FROSTED_ICE)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }
}

