/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.event.player.PlayerSpawnChangeEvent;

public class BlockRespawnAnchor
extends Block {
    public static final MapCodec<BlockRespawnAnchor> CODEC = BlockRespawnAnchor.simpleCodec(BlockRespawnAnchor::new);
    public static final int MIN_CHARGES = 0;
    public static final int MAX_CHARGES = 4;
    public static final BlockStateInteger CHARGE = BlockProperties.RESPAWN_ANCHOR_CHARGES;
    private static final ImmutableList<BaseBlockPosition> RESPAWN_HORIZONTAL_OFFSETS = ImmutableList.of((Object)new BaseBlockPosition(0, 0, -1), (Object)new BaseBlockPosition(-1, 0, 0), (Object)new BaseBlockPosition(0, 0, 1), (Object)new BaseBlockPosition(1, 0, 0), (Object)new BaseBlockPosition(-1, 0, -1), (Object)new BaseBlockPosition(1, 0, -1), (Object)new BaseBlockPosition(-1, 0, 1), (Object)new BaseBlockPosition(1, 0, 1));
    private static final ImmutableList<BaseBlockPosition> RESPAWN_OFFSETS = new ImmutableList.Builder().addAll(RESPAWN_HORIZONTAL_OFFSETS).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(BaseBlockPosition::below).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(BaseBlockPosition::above).iterator()).add((Object)new BaseBlockPosition(0, 1, 0)).build();

    public MapCodec<BlockRespawnAnchor> codec() {
        return CODEC;
    }

    public BlockRespawnAnchor(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(CHARGE, 0));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        if (BlockRespawnAnchor.isRespawnFuel(itemstack) && BlockRespawnAnchor.canBeCharged(iblockdata)) {
            BlockRespawnAnchor.charge(entityhuman, world, blockposition, iblockdata);
            itemstack.consume(1, entityhuman);
            return ItemInteractionResult.sidedSuccess(world.isClientSide);
        }
        return enumhand == EnumHand.MAIN_HAND && BlockRespawnAnchor.isRespawnFuel(entityhuman.getItemInHand(EnumHand.OFF_HAND)) && BlockRespawnAnchor.canBeCharged(iblockdata) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        EntityPlayer entityplayer;
        if (iblockdata.getValue(CHARGE) == 0) {
            return EnumInteractionResult.PASS;
        }
        if (!BlockRespawnAnchor.canSetSpawn(world)) {
            if (!world.isClientSide) {
                this.explode(iblockdata, world, blockposition);
            }
            return EnumInteractionResult.sidedSuccess(world.isClientSide);
        }
        if (!(world.isClientSide || (entityplayer = (EntityPlayer)entityhuman).getRespawnDimension() == world.dimension() && blockposition.equals(entityplayer.getRespawnPosition()))) {
            entityplayer.setRespawnPosition(world.dimension(), blockposition, 0.0f, false, true, PlayerSpawnChangeEvent.Cause.RESPAWN_ANCHOR);
            world.playSound((EntityHuman)null, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, SoundEffects.RESPAWN_ANCHOR_SET_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.CONSUME;
    }

    private static boolean isRespawnFuel(ItemStack itemstack) {
        return itemstack.is(Items.GLOWSTONE);
    }

    private static boolean canBeCharged(IBlockData iblockdata) {
        return iblockdata.getValue(CHARGE) < 4;
    }

    private static boolean isWaterThatWouldFlow(BlockPosition blockposition, World world) {
        Fluid fluid = world.getFluidState(blockposition);
        if (!fluid.is(TagsFluid.WATER)) {
            return false;
        }
        if (fluid.isSource()) {
            return true;
        }
        float f2 = fluid.getAmount();
        if (f2 < 2.0f) {
            return false;
        }
        Fluid fluid1 = world.getFluidState(blockposition.below());
        return !fluid1.is(TagsFluid.WATER);
    }

    private void explode(IBlockData iblockdata, World world, final BlockPosition blockposition) {
        BlockState blockState = CraftBlock.at(world, blockposition).getState();
        world.removeBlock(blockposition, false);
        Stream<EnumDirection> stream = EnumDirection.EnumDirectionLimit.HORIZONTAL.stream();
        Objects.requireNonNull(blockposition);
        boolean flag = stream.map(blockposition::relative).anyMatch(blockposition1 -> BlockRespawnAnchor.isWaterThatWouldFlow(blockposition1, world));
        final boolean flag1 = flag || world.getFluidState(blockposition.above()).is(TagsFluid.WATER);
        ExplosionDamageCalculator explosiondamagecalculator = new ExplosionDamageCalculator(this){

            @Override
            public Optional<Float> getBlockExplosionResistance(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition1, IBlockData iblockdata1, Fluid fluid) {
                return blockposition1.equals(blockposition) && flag1 ? Optional.of(Float.valueOf(Blocks.WATER.getExplosionResistance())) : super.getBlockExplosionResistance(explosion, iblockaccess, blockposition1, iblockdata1, fluid);
            }
        };
        Vec3D vec3d = blockposition.getCenter();
        world.explode((Entity)null, world.damageSources().badRespawnPointExplosion(vec3d, blockState), explosiondamagecalculator, vec3d, 5.0f, true, World.a.BLOCK);
    }

    public static boolean canSetSpawn(World world) {
        return world.dimensionType().respawnAnchorWorks();
    }

    public static void charge(@Nullable Entity entity, World world, BlockPosition blockposition, IBlockData iblockdata) {
        IBlockData iblockdata1 = (IBlockData)iblockdata.setValue(CHARGE, iblockdata.getValue(CHARGE) + 1);
        world.setBlock(blockposition, iblockdata1, 3);
        world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.a.of(entity, iblockdata1));
        world.playSound((EntityHuman)null, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, SoundEffects.RESPAWN_ANCHOR_CHARGE, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public void animateTick(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(CHARGE) != 0) {
            if (randomsource.nextInt(100) == 0) {
                world.playLocalSound(blockposition, SoundEffects.RESPAWN_ANCHOR_AMBIENT, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            double d0 = (double)blockposition.getX() + 0.5 + (0.5 - randomsource.nextDouble());
            double d1 = (double)blockposition.getY() + 1.0;
            double d2 = (double)blockposition.getZ() + 0.5 + (0.5 - randomsource.nextDouble());
            double d3 = (double)randomsource.nextFloat() * 0.04;
            world.addParticle(Particles.REVERSE_PORTAL, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(CHARGE);
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData iblockdata) {
        return true;
    }

    public static int getScaledChargeLevel(IBlockData iblockdata, int i2) {
        return MathHelper.floor((float)(iblockdata.getValue(CHARGE) - 0) / 4.0f * (float)i2);
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return BlockRespawnAnchor.getScaledChargeLevel(iblockdata, 15);
    }

    public static Optional<Vec3D> findStandUpPosition(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition) {
        Optional<Vec3D> optional = BlockRespawnAnchor.findStandUpPosition(entitytypes, icollisionaccess, blockposition, true);
        return optional.isPresent() ? optional : BlockRespawnAnchor.findStandUpPosition(entitytypes, icollisionaccess, blockposition, false);
    }

    private static Optional<Vec3D> findStandUpPosition(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition, boolean flag) {
        Vec3D vec3d;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        UnmodifiableIterator unmodifiableiterator = RESPAWN_OFFSETS.iterator();
        do {
            if (!unmodifiableiterator.hasNext()) {
                return Optional.empty();
            }
            BaseBlockPosition baseblockposition = (BaseBlockPosition)unmodifiableiterator.next();
            blockposition_mutableblockposition.set(blockposition).move(baseblockposition);
        } while ((vec3d = DismountUtil.findSafeDismountLocation(entitytypes, icollisionaccess, blockposition_mutableblockposition, flag)) == null);
        return Optional.of(vec3d);
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }
}

