/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;

public class BlockRotatable
extends Block {
    public static final MapCodec<BlockRotatable> CODEC = BlockRotatable.simpleCodec(BlockRotatable::new);
    public static final BlockStateEnum<EnumDirection.EnumAxis> AXIS = BlockProperties.AXIS;

    public MapCodec<? extends BlockRotatable> codec() {
        return CODEC;
    }

    public BlockRotatable(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(AXIS, EnumDirection.EnumAxis.Y));
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return BlockRotatable.rotatePillar(var0, var1);
    }

    public static IBlockData rotatePillar(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (var0.getValue(AXIS)) {
                    case X: {
                        return (IBlockData)var0.setValue(AXIS, EnumDirection.EnumAxis.Z);
                    }
                    case Z: {
                        return (IBlockData)var0.setValue(AXIS, EnumDirection.EnumAxis.X);
                    }
                }
                return var0;
            }
        }
        return var0;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AXIS);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(AXIS, var0.getClickedFace().getAxis());
    }
}

