/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockScaffolding
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockScaffolding> CODEC = BlockScaffolding.simpleCodec(BlockScaffolding::new);
    private static final int TICK_DELAY = 1;
    private static final VoxelShape STABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE_BOTTOM;
    private static final VoxelShape BELOW_BLOCK;
    public static final int STABILITY_MAX_DISTANCE = 7;
    public static final BlockStateInteger DISTANCE;
    public static final BlockStateBoolean WATERLOGGED;
    public static final BlockStateBoolean BOTTOM;

    public MapCodec<BlockScaffolding> codec() {
        return CODEC;
    }

    protected BlockScaffolding(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(DISTANCE, 7)).setValue(WATERLOGGED, false)).setValue(BOTTOM, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(DISTANCE, WATERLOGGED, BOTTOM);
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return !voxelshapecollision.isHoldingItem(iblockdata.getBlock().asItem()) ? (iblockdata.getValue(BOTTOM).booleanValue() ? UNSTABLE_SHAPE : STABLE_SHAPE) : VoxelShapes.block();
    }

    @Override
    protected VoxelShape getInteractionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return VoxelShapes.block();
    }

    @Override
    protected boolean canBeReplaced(IBlockData iblockdata, BlockActionContext blockactioncontext) {
        return blockactioncontext.getItemInHand().is(this.asItem());
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        BlockPosition blockposition = blockactioncontext.getClickedPos();
        World world = blockactioncontext.getLevel();
        int i2 = BlockScaffolding.getDistance(world, blockposition);
        return (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, world.getFluidState(blockposition).getType() == FluidTypes.WATER)).setValue(DISTANCE, i2)).setValue(BOTTOM, this.isBottom(world, blockposition, i2));
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!world.isClientSide) {
            world.scheduleTick(blockposition, this, 1);
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        if (!generatoraccess.isClientSide()) {
            generatoraccess.scheduleTick(blockposition, this, 1);
        }
        return iblockdata;
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        int i2 = BlockScaffolding.getDistance(worldserver, blockposition);
        IBlockData iblockdata1 = (IBlockData)((IBlockData)iblockdata.setValue(DISTANCE, i2)).setValue(BOTTOM, this.isBottom(worldserver, blockposition, i2));
        if (iblockdata1.getValue(DISTANCE) == 7 && !CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, Blocks.AIR.defaultBlockState()).isCancelled()) {
            if (iblockdata.getValue(DISTANCE) == 7) {
                EntityFallingBlock.fall(worldserver, blockposition, iblockdata1);
            } else {
                worldserver.destroyBlock(blockposition, true);
            }
        } else if (iblockdata != iblockdata1) {
            worldserver.setBlock(blockposition, iblockdata1, 3);
        }
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return BlockScaffolding.getDistance(iworldreader, blockposition) < 7;
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return voxelshapecollision.isAbove(VoxelShapes.block(), blockposition, true) && !voxelshapecollision.isDescending() ? STABLE_SHAPE : (iblockdata.getValue(DISTANCE) != 0 && iblockdata.getValue(BOTTOM) != false && voxelshapecollision.isAbove(BELOW_BLOCK, blockposition, true) ? UNSTABLE_SHAPE_BOTTOM : VoxelShapes.empty());
    }

    @Override
    protected Fluid getFluidState(IBlockData iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? FluidTypes.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    private boolean isBottom(IBlockAccess iblockaccess, BlockPosition blockposition, int i2) {
        return i2 > 0 && !iblockaccess.getBlockState(blockposition.below()).is(this);
    }

    public static int getDistance(IBlockAccess iblockaccess, BlockPosition blockposition) {
        EnumDirection enumdirection;
        IBlockData iblockdata1;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable().move(EnumDirection.DOWN);
        IBlockData iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
        int i2 = 7;
        if (iblockdata.is(Blocks.SCAFFOLDING)) {
            i2 = iblockdata.getValue(DISTANCE);
        } else if (iblockdata.isFaceSturdy(iblockaccess, blockposition_mutableblockposition, EnumDirection.UP)) {
            return 0;
        }
        Iterator<EnumDirection> iterator = EnumDirection.EnumDirectionLimit.HORIZONTAL.iterator();
        while (iterator.hasNext() && (!(iblockdata1 = iblockaccess.getBlockState(blockposition_mutableblockposition.setWithOffset((BaseBlockPosition)blockposition, enumdirection = iterator.next()))).is(Blocks.SCAFFOLDING) || (i2 = Math.min(i2, iblockdata1.getValue(DISTANCE) + 1)) != 1)) {
        }
        return i2;
    }

    static {
        UNSTABLE_SHAPE_BOTTOM = Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
        BELOW_BLOCK = VoxelShapes.block().move(0.0, -1.0, 0.0);
        DISTANCE = BlockProperties.STABILITY_DISTANCE;
        WATERLOGGED = BlockProperties.WATERLOGGED;
        BOTTOM = BlockProperties.BOTTOM;
        VoxelShape voxelshape = Block.box(0.0, 14.0, 0.0, 16.0, 16.0, 16.0);
        VoxelShape voxelshape1 = Block.box(0.0, 0.0, 0.0, 2.0, 16.0, 2.0);
        VoxelShape voxelshape2 = Block.box(14.0, 0.0, 0.0, 16.0, 16.0, 2.0);
        VoxelShape voxelshape3 = Block.box(0.0, 0.0, 14.0, 2.0, 16.0, 16.0);
        VoxelShape voxelshape4 = Block.box(14.0, 0.0, 14.0, 16.0, 16.0, 16.0);
        STABLE_SHAPE = VoxelShapes.or(voxelshape, voxelshape1, voxelshape2, voxelshape3, voxelshape4);
        VoxelShape voxelshape5 = Block.box(0.0, 0.0, 0.0, 2.0, 2.0, 16.0);
        VoxelShape voxelshape6 = Block.box(14.0, 0.0, 0.0, 16.0, 2.0, 16.0);
        VoxelShape voxelshape7 = Block.box(0.0, 0.0, 14.0, 16.0, 2.0, 16.0);
        VoxelShape voxelshape8 = Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 2.0);
        UNSTABLE_SHAPE = VoxelShapes.or(UNSTABLE_SHAPE_BOTTOM, STABLE_SHAPE, voxelshape6, voxelshape5, voxelshape8, voxelshape7);
    }
}

