/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.INamable;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSkullAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockSkull
extends BlockSkullAbstract {
    public static final MapCodec<BlockSkull> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)a.CODEC.fieldOf("kind").forGetter(BlockSkullAbstract::getType), BlockSkull.propertiesCodec()).apply((Applicative)var0, BlockSkull::new));
    public static final int MAX = RotationSegment.getMaxSegmentIndex();
    private static final int ROTATIONS = MAX + 1;
    public static final BlockStateInteger ROTATION = BlockProperties.ROTATION_16;
    protected static final VoxelShape SHAPE = Block.box(4.0, 0.0, 4.0, 12.0, 8.0, 12.0);
    protected static final VoxelShape PIGLIN_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 8.0, 13.0);

    public MapCodec<? extends BlockSkull> codec() {
        return CODEC;
    }

    protected BlockSkull(a var0, BlockBase.Info var1) {
        super(var0, var1);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(ROTATION, 0));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (this.getType() == Type.PIGLIN) {
            return PIGLIN_SHAPE;
        }
        return SHAPE;
    }

    @Override
    protected VoxelShape getOcclusionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return VoxelShapes.empty();
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)super.getStateForPlacement(var0).setValue(ROTATION, RotationSegment.convertToSegment(var0.getRotation()));
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(ROTATION, var1.rotate(var0.getValue(ROTATION), ROTATIONS));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return (IBlockData)var0.setValue(ROTATION, var1.mirror(var0.getValue(ROTATION), ROTATIONS));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        super.createBlockStateDefinition(var0);
        var0.add(ROTATION);
    }

    public static interface a
    extends INamable {
        public static final Map<String, a> TYPES = new Object2ObjectArrayMap();
        public static final Codec<a> CODEC = Codec.stringResolver(INamable::getSerializedName, TYPES::get);
    }

    public static final class Type
    extends Enum<Type>
    implements a {
        public static final /* enum */ Type SKELETON = new Type("skeleton");
        public static final /* enum */ Type WITHER_SKELETON = new Type("wither_skeleton");
        public static final /* enum */ Type PLAYER = new Type("player");
        public static final /* enum */ Type ZOMBIE = new Type("zombie");
        public static final /* enum */ Type CREEPER = new Type("creeper");
        public static final /* enum */ Type PIGLIN = new Type("piglin");
        public static final /* enum */ Type DRAGON = new Type("dragon");
        private final String name;
        private static final /* synthetic */ Type[] k;

        public static Type[] values() {
            return (Type[])k.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(String var2) {
            this.name = var2;
            TYPES.put(var2, this);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{SKELETON, WITHER_SKELETON, PLAYER, ZOMBIE, CREEPER, PIGLIN, DRAGON};
        }

        static {
            k = Type.a();
        }
    }
}

