/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.util.BlockStateListPopulator;
import org.bukkit.event.Event;
import org.bukkit.event.block.SpongeAbsorbEvent;

public class BlockSponge
extends Block {
    public static final MapCodec<BlockSponge> CODEC = BlockSponge.simpleCodec(BlockSponge::new);
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;
    private static final EnumDirection[] ALL_DIRECTIONS = EnumDirection.values();

    public MapCodec<BlockSponge> codec() {
        return CODEC;
    }

    protected BlockSponge(BlockBase.Info blockbase_info) {
        super(blockbase_info);
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata1.is(iblockdata.getBlock())) {
            this.tryAbsorbWater(world, blockposition);
        }
    }

    @Override
    protected void neighborChanged(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        this.tryAbsorbWater(world, blockposition);
        super.neighborChanged(iblockdata, world, blockposition, block, blockposition1, flag);
    }

    protected void tryAbsorbWater(World world, BlockPosition blockposition) {
        if (this.removeWaterBreadthFirstSearch(world, blockposition)) {
            world.setBlock(blockposition, Blocks.WET_SPONGE.defaultBlockState(), 2);
            world.playSound((EntityHuman)null, blockposition, SoundEffects.SPONGE_ABSORB, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean removeWaterBreadthFirstSearch(World world, BlockPosition blockposition) {
        BlockStateListPopulator blockList = new BlockStateListPopulator(world);
        BlockPosition.breadthFirstTraversal(blockposition, 6, 65, (blockposition1, consumer) -> {
            for (EnumDirection enumdirection : ALL_DIRECTIONS) {
                consumer.accept(blockposition1.relative(enumdirection));
            }
        }, blockposition1 -> {
            IFluidSource ifluidsource;
            if (blockposition1.equals(blockposition)) {
                return true;
            }
            IBlockData iblockdata = blockList.getBlockState((BlockPosition)blockposition1);
            Fluid fluid = blockList.getFluidState((BlockPosition)blockposition1);
            if (!fluid.is(TagsFluid.WATER)) {
                return false;
            }
            Block block = iblockdata.getBlock();
            if (block instanceof IFluidSource && !(ifluidsource = (IFluidSource)((Object)block)).pickupBlock(null, blockList, (BlockPosition)blockposition1, iblockdata).isEmpty()) {
                return true;
            }
            if (iblockdata.getBlock() instanceof BlockFluids) {
                blockList.setBlock((BlockPosition)blockposition1, Blocks.AIR.defaultBlockState(), 3);
            } else {
                if (!(iblockdata.is(Blocks.KELP) || iblockdata.is(Blocks.KELP_PLANT) || iblockdata.is(Blocks.SEAGRASS) || iblockdata.is(Blocks.TALL_SEAGRASS))) {
                    return false;
                }
                blockList.setBlock((BlockPosition)blockposition1, Blocks.AIR.defaultBlockState(), 3);
            }
            return true;
        });
        List<CraftBlockState> blocks = blockList.getList();
        if (!blocks.isEmpty()) {
            org.bukkit.block.Block bblock = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            SpongeAbsorbEvent event = new SpongeAbsorbEvent(bblock, blocks);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            for (CraftBlockState block : blocks) {
                BlockPosition blockposition12 = block.getPosition();
                IBlockData iblockdata = world.getBlockState(blockposition12);
                Fluid fluid = world.getFluidState(blockposition12);
                if (fluid.is(TagsFluid.WATER) && (!(iblockdata.getBlock() instanceof IFluidSource) || ((IFluidSource)((Object)iblockdata.getBlock())).pickupBlock(null, blockList, blockposition12, iblockdata).isEmpty()) && !(iblockdata.getBlock() instanceof BlockFluids) && (iblockdata.is(Blocks.KELP) || iblockdata.is(Blocks.KELP_PLANT) || iblockdata.is(Blocks.SEAGRASS) || iblockdata.is(Blocks.TALL_SEAGRASS))) {
                    TileEntity tileentity = iblockdata.hasBlockEntity() ? world.getBlockEntity(blockposition12) : null;
                    BlockSponge.dropResources(iblockdata, world, blockposition12, tileentity);
                }
                world.setBlock(blockposition12, block.getHandle(), block.getFlag());
            }
            return true;
        }
        return false;
    }
}

