/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockStem
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockStem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec(Registries.BLOCK).fieldOf("fruit").forGetter(blockstem -> blockstem.fruit), (App)ResourceKey.codec(Registries.BLOCK).fieldOf("attached_stem").forGetter(blockstem -> blockstem.attachedStem), (App)ResourceKey.codec(Registries.ITEM).fieldOf("seed").forGetter(blockstem -> blockstem.seed), BlockStem.propertiesCodec()).apply((Applicative)instance, BlockStem::new));
    public static final int MAX_AGE = 7;
    public static final BlockStateInteger AGE = BlockProperties.AGE_7;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box(7.0, 0.0, 7.0, 9.0, 2.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 4.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 6.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 8.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 10.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 12.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 14.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 9.0)};
    private final ResourceKey<Block> fruit;
    private final ResourceKey<Block> attachedStem;
    private final ResourceKey<Item> seed;

    public MapCodec<BlockStem> codec() {
        return CODEC;
    }

    protected BlockStem(ResourceKey<Block> resourcekey, ResourceKey<Block> resourcekey1, ResourceKey<Item> resourcekey2, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.fruit = resourcekey;
        this.attachedStem = resourcekey1;
        this.seed = resourcekey2;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return SHAPE_BY_AGE[iblockdata.getValue(AGE)];
    }

    @Override
    protected boolean mayPlaceOn(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.is(Blocks.FARMLAND);
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.getRawBrightness(blockposition, 0) >= 9) {
            float f2 = BlockCrops.getGrowthSpeed(this, worldserver, blockposition);
            double d2 = randomsource.nextFloat();
            int n2 = this == Blocks.PUMPKIN_STEM ? worldserver.spigotConfig.pumpkinModifier : worldserver.spigotConfig.melonModifier;
            if (d2 < (double)n2 / (100.0 * Math.floor(25.0f / f2 + 1.0f))) {
                int i2 = iblockdata.getValue(AGE);
                if (i2 < 7) {
                    iblockdata = (IBlockData)iblockdata.setValue(AGE, i2 + 1);
                    CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, iblockdata, 2);
                } else {
                    EnumDirection enumdirection = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(randomsource);
                    BlockPosition blockposition1 = blockposition.relative(enumdirection);
                    IBlockData iblockdata1 = worldserver.getBlockState(blockposition1.below());
                    if (worldserver.getBlockState(blockposition1).isAir() && (iblockdata1.is(Blocks.FARMLAND) || iblockdata1.is(TagsBlock.DIRT))) {
                        IRegistry<Block> iregistry = worldserver.registryAccess().registryOrThrow(Registries.BLOCK);
                        Optional<Block> optional = iregistry.getOptional(this.fruit);
                        Optional<Block> optional1 = iregistry.getOptional(this.attachedStem);
                        if (optional.isPresent() && optional1.isPresent()) {
                            if (!CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition1, optional.get().defaultBlockState())) {
                                return;
                            }
                            worldserver.setBlockAndUpdate(blockposition, (IBlockData)optional1.get().defaultBlockState().setValue(BlockFacingHorizontal.FACING, enumdirection));
                        }
                    }
                }
            }
        }
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return new ItemStack((IMaterial)DataFixUtils.orElse(iworldreader.registryAccess().registryOrThrow(Registries.ITEM).getOptional(this.seed), (Object)this));
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return iblockdata.getValue(AGE) != 7;
    }

    @Override
    public boolean isBonemealSuccess(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = Math.min(7, iblockdata.getValue(AGE) + MathHelper.nextInt(worldserver.random, 2, 5));
        IBlockData iblockdata1 = (IBlockData)iblockdata.setValue(AGE, i2);
        CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, iblockdata1, 2);
        if (i2 == 7) {
            iblockdata1.randomTick(worldserver, blockposition, worldserver.random);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }
}

