/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.block.TNTPrimeEvent;

public class BlockTNT
extends Block {
    public static final MapCodec<BlockTNT> CODEC = BlockTNT.simpleCodec(BlockTNT::new);
    public static final BlockStateBoolean UNSTABLE = BlockProperties.UNSTABLE;

    public MapCodec<BlockTNT> codec() {
        return CODEC;
    }

    public BlockTNT(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(UNSTABLE, false));
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata1.is(iblockdata.getBlock()) && world.hasNeighborSignal(blockposition) && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.REDSTONE, null, null)) {
            BlockTNT.explode(world, blockposition);
            world.removeBlock(blockposition, false);
        }
    }

    @Override
    protected void neighborChanged(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        if (world.hasNeighborSignal(blockposition) && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.REDSTONE, null, blockposition1)) {
            BlockTNT.explode(world, blockposition);
            world.removeBlock(blockposition, false);
        }
    }

    @Override
    public IBlockData playerWillDestroy(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        if (!world.isClientSide() && !entityhuman.isCreative() && iblockdata.getValue(UNSTABLE).booleanValue() && CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.BLOCK_BREAK, entityhuman, null)) {
            BlockTNT.explode(world, blockposition);
        }
        return super.playerWillDestroy(world, blockposition, iblockdata, entityhuman);
    }

    @Override
    public void wasExploded(World world, BlockPosition blockposition, Explosion explosion) {
        if (!world.isClientSide) {
            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5, explosion.getIndirectSourceEntity());
            int i2 = entitytntprimed.getFuse();
            entitytntprimed.setFuse((short)(world.random.nextInt(i2 / 4) + i2 / 8));
            world.addFreshEntity(entitytntprimed);
        }
    }

    public static void explode(World world, BlockPosition blockposition) {
        BlockTNT.explode(world, blockposition, null);
    }

    private static void explode(World world, BlockPosition blockposition, @Nullable EntityLiving entityliving) {
        if (!world.isClientSide) {
            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5, entityliving);
            world.addFreshEntity(entitytntprimed);
            world.playSound((EntityHuman)null, entitytntprimed.getX(), entitytntprimed.getY(), entitytntprimed.getZ(), SoundEffects.TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)entityliving, GameEvent.PRIME_FUSE, blockposition);
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        if (!itemstack.is(Items.FLINT_AND_STEEL) && !itemstack.is(Items.FIRE_CHARGE)) {
            return super.useItemOn(itemstack, iblockdata, world, blockposition, entityhuman, enumhand, movingobjectpositionblock);
        }
        if (!CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.PLAYER, entityhuman, null)) {
            return ItemInteractionResult.CONSUME;
        }
        BlockTNT.explode(world, blockposition, entityhuman);
        world.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 11);
        Item item = itemstack.getItem();
        if (itemstack.is(Items.FLINT_AND_STEEL)) {
            itemstack.hurtAndBreak(1, entityhuman, EntityLiving.getSlotForHand(enumhand));
        } else {
            itemstack.consume(1, entityhuman);
        }
        entityhuman.awardStat(StatisticList.ITEM_USED.get(item));
        return ItemInteractionResult.sidedSuccess(world.isClientSide);
    }

    @Override
    protected void onProjectileHit(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        if (!world.isClientSide) {
            BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
            Entity entity = iprojectile.getOwner();
            if (iprojectile.isOnFire() && iprojectile.mayInteract(world, blockposition)) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, Blocks.AIR.defaultBlockState()) || !CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.PROJECTILE, iprojectile, null)) {
                    return;
                }
                BlockTNT.explode(world, blockposition, entity instanceof EntityLiving ? (EntityLiving)entity : null);
                world.removeBlock(blockposition, false);
            }
        }
    }

    @Override
    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(UNSTABLE);
    }
}

