/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockTrapdoor
extends BlockFacingHorizontal
implements IBlockWaterlogged {
    public static final MapCodec<BlockTrapdoor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(blocktrapdoor -> blocktrapdoor.type), BlockTrapdoor.propertiesCodec()).apply((Applicative)instance, BlockTrapdoor::new));
    public static final BlockStateBoolean OPEN = BlockProperties.OPEN;
    public static final BlockStateEnum<BlockPropertyHalf> HALF = BlockProperties.HALF;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected static final int AABB_THICKNESS = 3;
    protected static final VoxelShape EAST_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
    protected static final VoxelShape WEST_OPEN_AABB = Block.box(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape SOUTH_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape NORTH_OPEN_AABB = Block.box(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape TOP_AABB = Block.box(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private final BlockSetType type;

    public MapCodec<? extends BlockTrapdoor> codec() {
        return CODEC;
    }

    protected BlockTrapdoor(BlockSetType blocksettype, BlockBase.Info blockbase_info) {
        super(blockbase_info.sound(blocksettype.soundType()));
        this.type = blocksettype;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(OPEN, false)).setValue(HALF, BlockPropertyHalf.BOTTOM)).setValue(POWERED, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        if (!iblockdata.getValue(OPEN).booleanValue()) {
            return iblockdata.getValue(HALF) == BlockPropertyHalf.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        switch (iblockdata.getValue(FACING)) {
            default: {
                return NORTH_OPEN_AABB;
            }
            case SOUTH: {
                return SOUTH_OPEN_AABB;
            }
            case WEST: {
                return WEST_OPEN_AABB;
            }
            case EAST: 
        }
        return EAST_OPEN_AABB;
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        switch (pathmode) {
            case LAND: {
                return iblockdata.getValue(OPEN);
            }
            case WATER: {
                return iblockdata.getValue(WATERLOGGED);
            }
            case AIR: {
                return iblockdata.getValue(OPEN);
            }
        }
        return false;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (!this.type.canOpenByHand()) {
            return EnumInteractionResult.PASS;
        }
        this.toggle(iblockdata, world, blockposition, entityhuman);
        return EnumInteractionResult.sidedSuccess(world.isClientSide);
    }

    @Override
    protected void onExplosionHit(IBlockData iblockdata, World world, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (explosion.canTriggerBlocks() && this.type.canOpenByWindCharge() && !iblockdata.getValue(POWERED).booleanValue()) {
            this.toggle(iblockdata, world, blockposition, null);
        }
        super.onExplosionHit(iblockdata, world, blockposition, explosion, biconsumer);
    }

    private void toggle(IBlockData iblockdata, World world, BlockPosition blockposition, @Nullable EntityHuman entityhuman) {
        IBlockData iblockdata1 = (IBlockData)iblockdata.cycle(OPEN);
        world.setBlock(blockposition, iblockdata1, 2);
        if (iblockdata1.getValue(WATERLOGGED).booleanValue()) {
            world.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(world));
        }
        this.playSound(entityhuman, world, blockposition, iblockdata1.getValue(OPEN));
    }

    protected void playSound(@Nullable EntityHuman entityhuman, World world, BlockPosition blockposition, boolean flag) {
        world.playSound(entityhuman, blockposition, flag ? this.type.trapdoorOpen() : this.type.trapdoorClose(), SoundCategory.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.1f + 0.9f);
        world.gameEvent((Entity)entityhuman, flag ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, blockposition);
    }

    @Override
    protected void neighborChanged(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        boolean flag1;
        if (!world.isClientSide && (flag1 = world.hasNeighborSignal(blockposition)) != iblockdata.getValue(POWERED)) {
            CraftWorld bworld = world.getWorld();
            org.bukkit.block.Block bblock = bworld.getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            int power = bblock.getBlockPower();
            int oldPower = iblockdata.getValue(OPEN) != false ? 15 : 0;
            if (oldPower == 0 ^ power == 0 || block.defaultBlockState().isSignalSource()) {
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bblock, oldPower, power);
                world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            }
            if (iblockdata.getValue(OPEN) != flag1) {
                iblockdata = (IBlockData)iblockdata.setValue(OPEN, flag1);
                this.playSound(null, world, blockposition, flag1);
            }
            world.setBlock(blockposition, (IBlockData)iblockdata.setValue(POWERED, flag1), 2);
            if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
                world.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(world));
            }
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        IBlockData iblockdata = this.defaultBlockState();
        Fluid fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        EnumDirection enumdirection = blockactioncontext.getClickedFace();
        iblockdata = !blockactioncontext.replacingClickedOnBlock() && enumdirection.getAxis().isHorizontal() ? (IBlockData)((IBlockData)iblockdata.setValue(FACING, enumdirection)).setValue(HALF, blockactioncontext.getClickLocation().y - (double)blockactioncontext.getClickedPos().getY() > 0.5 ? BlockPropertyHalf.TOP : BlockPropertyHalf.BOTTOM) : (IBlockData)((IBlockData)iblockdata.setValue(FACING, blockactioncontext.getHorizontalDirection().getOpposite())).setValue(HALF, enumdirection == EnumDirection.UP ? BlockPropertyHalf.BOTTOM : BlockPropertyHalf.TOP);
        if (blockactioncontext.getLevel().hasNeighborSignal(blockactioncontext.getClickedPos())) {
            iblockdata = (IBlockData)((IBlockData)iblockdata.setValue(OPEN, true)).setValue(POWERED, true);
        }
        return (IBlockData)iblockdata.setValue(WATERLOGGED, fluid.getType() == FluidTypes.WATER);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(FACING, OPEN, HALF, POWERED, WATERLOGGED);
    }

    @Override
    protected Fluid getFluidState(IBlockData iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? FluidTypes.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    protected BlockSetType getType() {
        return this.type;
    }
}

