/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.BlockTripwireHook;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.PluginManager;

public class BlockTripwire
extends Block {
    public static final MapCodec<BlockTripwire> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("hook").forGetter(blocktripwire -> blocktripwire.hook), BlockTripwire.propertiesCodec()).apply((Applicative)instance, BlockTripwire::new));
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean ATTACHED = BlockProperties.ATTACHED;
    public static final BlockStateBoolean DISARMED = BlockProperties.DISARMED;
    public static final BlockStateBoolean NORTH = BlockSprawling.NORTH;
    public static final BlockStateBoolean EAST = BlockSprawling.EAST;
    public static final BlockStateBoolean SOUTH = BlockSprawling.SOUTH;
    public static final BlockStateBoolean WEST = BlockSprawling.WEST;
    private static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockTall.PROPERTY_BY_DIRECTION;
    protected static final VoxelShape AABB = Block.box(0.0, 1.0, 0.0, 16.0, 2.5, 16.0);
    protected static final VoxelShape NOT_ATTACHED_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private static final int RECHECK_PERIOD = 10;
    private final Block hook;

    public MapCodec<BlockTripwire> codec() {
        return CODEC;
    }

    public BlockTripwire(Block block, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWERED, false)).setValue(ATTACHED, false)).setValue(DISARMED, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.hook = block;
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return iblockdata.getValue(ATTACHED) != false ? AABB : NOT_ATTACHED_AABB;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        World world = blockactioncontext.getLevel();
        BlockPosition blockposition = blockactioncontext.getClickedPos();
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(NORTH, this.shouldConnectTo(world.getBlockState(blockposition.north()), EnumDirection.NORTH))).setValue(EAST, this.shouldConnectTo(world.getBlockState(blockposition.east()), EnumDirection.EAST))).setValue(SOUTH, this.shouldConnectTo(world.getBlockState(blockposition.south()), EnumDirection.SOUTH))).setValue(WEST, this.shouldConnectTo(world.getBlockState(blockposition.west()), EnumDirection.WEST));
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        return enumdirection.getAxis().isHorizontal() ? (IBlockData)iblockdata.setValue(PROPERTY_BY_DIRECTION.get(enumdirection), this.shouldConnectTo(iblockdata1, enumdirection)) : super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata1.is(iblockdata.getBlock())) {
            this.updateSource(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void onRemove(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!flag && !iblockdata.is(iblockdata1.getBlock())) {
            this.updateSource(world, blockposition, (IBlockData)iblockdata.setValue(POWERED, true));
        }
    }

    @Override
    public IBlockData playerWillDestroy(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        if (!world.isClientSide && !entityhuman.getMainHandItem().isEmpty() && entityhuman.getMainHandItem().is(Items.SHEARS)) {
            world.setBlock(blockposition, (IBlockData)iblockdata.setValue(DISARMED, true), 4);
            world.gameEvent((net.minecraft.world.entity.Entity)entityhuman, GameEvent.SHEAR, blockposition);
        }
        return super.playerWillDestroy(world, blockposition, iblockdata, entityhuman);
    }

    private void updateSource(World world, BlockPosition blockposition, IBlockData iblockdata) {
        block0: for (EnumDirection enumdirection : new EnumDirection[]{EnumDirection.SOUTH, EnumDirection.WEST}) {
            for (int k2 = 1; k2 < 42; ++k2) {
                BlockPosition blockposition1 = blockposition.relative(enumdirection, k2);
                IBlockData iblockdata1 = world.getBlockState(blockposition1);
                if (iblockdata1.is(this.hook)) {
                    if (iblockdata1.getValue(BlockTripwireHook.FACING) != enumdirection.getOpposite()) continue block0;
                    BlockTripwireHook.calculateState(world, blockposition1, iblockdata1, false, true, k2, iblockdata);
                    continue block0;
                }
                if (!iblockdata1.is(this)) continue block0;
            }
        }
    }

    @Override
    protected void entityInside(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        if (!world.isClientSide && !iblockdata.getValue(POWERED).booleanValue()) {
            this.checkPressed(world, blockposition);
        }
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.getBlockState(blockposition).getValue(POWERED).booleanValue()) {
            this.checkPressed(worldserver, blockposition);
        }
    }

    private void checkPressed(World world, BlockPosition blockposition) {
        IBlockData iblockdata = world.getBlockState(blockposition);
        boolean flag = iblockdata.getValue(POWERED);
        boolean flag1 = false;
        List<net.minecraft.world.entity.Entity> list = world.getEntities(null, iblockdata.getShape(world, blockposition).bounds().move(blockposition));
        if (!list.isEmpty()) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (entity.isIgnoringBlockTriggers()) continue;
                flag1 = true;
                break;
            }
        }
        if (flag != flag1 && flag1 && iblockdata.getValue(ATTACHED).booleanValue()) {
            CraftWorld bworld = world.getWorld();
            PluginManager manager = world.getCraftServer().getPluginManager();
            org.bukkit.block.Block block = bworld.getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            boolean allowed = false;
            for (net.minecraft.world.entity.Entity object : list) {
                PlayerInteractEvent cancellable;
                if (object == null) continue;
                if (object instanceof EntityHuman) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)object, Action.PHYSICAL, blockposition, null, null, null);
                } else {
                    if (!(object instanceof net.minecraft.world.entity.Entity)) continue;
                    cancellable = new EntityInteractEvent((Entity)object.getBukkitEntity(), block);
                    manager.callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return;
            }
        }
        if (flag1 != flag) {
            iblockdata = (IBlockData)iblockdata.setValue(POWERED, flag1);
            world.setBlock(blockposition, iblockdata, 3);
            this.updateSource(world, blockposition, iblockdata);
        }
        if (flag1) {
            world.scheduleTick(new BlockPosition(blockposition), this, 10);
        }
    }

    public boolean shouldConnectTo(IBlockData iblockdata, EnumDirection enumdirection) {
        return iblockdata.is(this.hook) ? iblockdata.getValue(BlockTripwireHook.FACING) == enumdirection.getOpposite() : iblockdata.is(this);
    }

    @Override
    protected IBlockData rotate(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        switch (enumblockrotation) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(SOUTH))).setValue(EAST, iblockdata.getValue(WEST))).setValue(SOUTH, iblockdata.getValue(NORTH))).setValue(WEST, iblockdata.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(EAST))).setValue(EAST, iblockdata.getValue(SOUTH))).setValue(SOUTH, iblockdata.getValue(WEST))).setValue(WEST, iblockdata.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(WEST))).setValue(EAST, iblockdata.getValue(NORTH))).setValue(SOUTH, iblockdata.getValue(EAST))).setValue(WEST, iblockdata.getValue(SOUTH));
            }
        }
        return iblockdata;
    }

    @Override
    protected IBlockData mirror(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        switch (enumblockmirror) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(SOUTH))).setValue(SOUTH, iblockdata.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)iblockdata.setValue(EAST, iblockdata.getValue(WEST))).setValue(WEST, iblockdata.getValue(EAST));
            }
        }
        return super.mirror(iblockdata, enumblockmirror);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(POWERED, ATTACHED, DISARMED, NORTH, EAST, WEST, SOUTH);
    }
}

