/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTripwire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockTripwireHook
extends Block {
    public static final MapCodec<BlockTripwireHook> CODEC = BlockTripwireHook.simpleCodec(BlockTripwireHook::new);
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean ATTACHED = BlockProperties.ATTACHED;
    protected static final int WIRE_DIST_MIN = 1;
    protected static final int WIRE_DIST_MAX = 42;
    private static final int RECHECK_PERIOD = 10;
    protected static final int AABB_OFFSET = 3;
    protected static final VoxelShape NORTH_AABB = Block.box(5.0, 0.0, 10.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(5.0, 0.0, 0.0, 11.0, 10.0, 6.0);
    protected static final VoxelShape WEST_AABB = Block.box(10.0, 0.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 5.0, 6.0, 10.0, 11.0);

    public MapCodec<BlockTripwireHook> codec() {
        return CODEC;
    }

    public BlockTripwireHook(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(POWERED, false)).setValue(ATTACHED, false));
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        switch (iblockdata.getValue(FACING)) {
            default: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: 
        }
        return NORTH_AABB;
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        EnumDirection enumdirection = iblockdata.getValue(FACING);
        BlockPosition blockposition1 = blockposition.relative(enumdirection.getOpposite());
        IBlockData iblockdata1 = iworldreader.getBlockState(blockposition1);
        return enumdirection.getAxis().isHorizontal() && iblockdata1.isFaceSturdy(iworldreader, blockposition1, enumdirection);
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        return enumdirection.getOpposite() == iblockdata.getValue(FACING) && !iblockdata.canSurvive(generatoraccess, blockposition) ? Blocks.AIR.defaultBlockState() : super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        EnumDirection[] aenumdirection;
        IBlockData iblockdata = (IBlockData)((IBlockData)this.defaultBlockState().setValue(POWERED, false)).setValue(ATTACHED, false);
        World world = blockactioncontext.getLevel();
        BlockPosition blockposition = blockactioncontext.getClickedPos();
        EnumDirection[] aenumdirection1 = aenumdirection = blockactioncontext.getNearestLookingDirections();
        int i2 = aenumdirection.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumDirection enumdirection1;
            EnumDirection enumdirection = aenumdirection1[j2];
            if (!enumdirection.getAxis().isHorizontal() || !(iblockdata = (IBlockData)iblockdata.setValue(FACING, enumdirection1 = enumdirection.getOpposite())).canSurvive(world, blockposition)) continue;
            return iblockdata;
        }
        return null;
    }

    @Override
    public void setPlacedBy(World world, BlockPosition blockposition, IBlockData iblockdata, EntityLiving entityliving, ItemStack itemstack) {
        BlockTripwireHook.calculateState(world, blockposition, iblockdata, false, false, -1, null);
    }

    public static void calculateState(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag, boolean flag1, int i2, @Nullable IBlockData iblockdata1) {
        Optional<EnumDirection> optional = iblockdata.getOptionalValue(FACING);
        if (optional.isPresent()) {
            BlockPosition blockposition1;
            EnumDirection enumdirection = optional.get();
            boolean flag2 = iblockdata.getOptionalValue(ATTACHED).orElse(false);
            boolean flag3 = iblockdata.getOptionalValue(POWERED).orElse(false);
            Block block = iblockdata.getBlock();
            boolean flag4 = !flag;
            boolean flag5 = false;
            int j2 = 0;
            IBlockData[] aiblockdata = new IBlockData[42];
            for (int k2 = 1; k2 < 42; ++k2) {
                blockposition1 = blockposition.relative(enumdirection, k2);
                IBlockData iblockdata2 = world.getBlockState(blockposition1);
                if (iblockdata2.is(Blocks.TRIPWIRE_HOOK)) {
                    if (iblockdata2.getValue(FACING) != enumdirection.getOpposite()) break;
                    j2 = k2;
                    break;
                }
                if (!iblockdata2.is(Blocks.TRIPWIRE) && k2 != i2) {
                    aiblockdata[k2] = null;
                    flag4 = false;
                    continue;
                }
                if (k2 == i2) {
                    iblockdata2 = (IBlockData)MoreObjects.firstNonNull((Object)iblockdata1, (Object)iblockdata2);
                }
                boolean flag6 = iblockdata2.getValue(BlockTripwire.DISARMED) == false;
                boolean flag7 = iblockdata2.getValue(BlockTripwire.POWERED);
                flag5 |= flag6 && flag7;
                aiblockdata[k2] = iblockdata2;
                if (k2 != i2) continue;
                world.scheduleTick(blockposition, block, 10);
                flag4 &= flag6;
            }
            IBlockData iblockdata3 = (IBlockData)((IBlockData)block.defaultBlockState().trySetValue(ATTACHED, flag4)).trySetValue(POWERED, flag5 &= (flag4 &= j2 > 1));
            if (j2 > 0) {
                blockposition1 = blockposition.relative(enumdirection, j2);
                EnumDirection enumdirection1 = enumdirection.getOpposite();
                world.setBlock(blockposition1, (IBlockData)iblockdata3.setValue(FACING, enumdirection1), 3);
                BlockTripwireHook.notifyNeighbors(block, world, blockposition1, enumdirection1);
                BlockTripwireHook.emitState(world, blockposition1, flag4, flag5, flag2, flag3);
            }
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), 15, 0);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (eventRedstone.getNewCurrent() > 0) {
                return;
            }
            BlockTripwireHook.emitState(world, blockposition, flag4, flag5, flag2, flag3);
            if (!flag) {
                world.setBlock(blockposition, (IBlockData)iblockdata3.setValue(FACING, enumdirection), 3);
                if (flag1) {
                    BlockTripwireHook.notifyNeighbors(block, world, blockposition, enumdirection);
                }
            }
            if (flag2 != flag4) {
                for (int l2 = 1; l2 < j2; ++l2) {
                    BlockPosition blockposition2 = blockposition.relative(enumdirection, l2);
                    IBlockData iblockdata4 = aiblockdata[l2];
                    if (iblockdata4 == null) continue;
                    world.setBlock(blockposition2, (IBlockData)iblockdata4.trySetValue(ATTACHED, flag4), 3);
                    if (world.getBlockState(blockposition2).isAir()) continue;
                }
            }
        }
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        BlockTripwireHook.calculateState(worldserver, blockposition, iblockdata, false, true, -1, null);
    }

    private static void emitState(World world, BlockPosition blockposition, boolean flag, boolean flag1, boolean flag2, boolean flag3) {
        if (flag1 && !flag3) {
            world.playSound((EntityHuman)null, blockposition, SoundEffects.TRIPWIRE_CLICK_ON, SoundCategory.BLOCKS, 0.4f, 0.6f);
            world.gameEvent((Entity)null, GameEvent.BLOCK_ACTIVATE, blockposition);
        } else if (!flag1 && flag3) {
            world.playSound((EntityHuman)null, blockposition, SoundEffects.TRIPWIRE_CLICK_OFF, SoundCategory.BLOCKS, 0.4f, 0.5f);
            world.gameEvent((Entity)null, GameEvent.BLOCK_DEACTIVATE, blockposition);
        } else if (flag && !flag2) {
            world.playSound((EntityHuman)null, blockposition, SoundEffects.TRIPWIRE_ATTACH, SoundCategory.BLOCKS, 0.4f, 0.7f);
            world.gameEvent((Entity)null, GameEvent.BLOCK_ATTACH, blockposition);
        } else if (!flag && flag2) {
            world.playSound((EntityHuman)null, blockposition, SoundEffects.TRIPWIRE_DETACH, SoundCategory.BLOCKS, 0.4f, 1.2f / (world.random.nextFloat() * 0.2f + 0.9f));
            world.gameEvent((Entity)null, GameEvent.BLOCK_DETACH, blockposition);
        }
    }

    private static void notifyNeighbors(Block block, World world, BlockPosition blockposition, EnumDirection enumdirection) {
        world.updateNeighborsAt(blockposition, block);
        world.updateNeighborsAt(blockposition.relative(enumdirection.getOpposite()), block);
    }

    @Override
    protected void onRemove(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!flag && !iblockdata.is(iblockdata1.getBlock())) {
            boolean flag1 = iblockdata.getValue(ATTACHED);
            boolean flag2 = iblockdata.getValue(POWERED);
            if (flag1 || flag2) {
                BlockTripwireHook.calculateState(world, blockposition, iblockdata, true, false, -1, null);
            }
            if (flag2) {
                world.updateNeighborsAt(blockposition, this);
                world.updateNeighborsAt(blockposition.relative(iblockdata.getValue(FACING).getOpposite()), this);
            }
            super.onRemove(iblockdata, world, blockposition, iblockdata1, flag);
        }
    }

    @Override
    protected int getSignal(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.getValue(POWERED) == false ? 0 : (iblockdata.getValue(FACING) == enumdirection ? 15 : 0);
    }

    @Override
    protected boolean isSignalSource(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected IBlockData rotate(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(FACING, POWERED, ATTACHED);
    }
}

