/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockTurtleEgg
extends Block {
    public static final MapCodec<BlockTurtleEgg> CODEC = BlockTurtleEgg.simpleCodec(BlockTurtleEgg::new);
    public static final int MAX_HATCH_LEVEL = 2;
    public static final int MIN_EGGS = 1;
    public static final int MAX_EGGS = 4;
    private static final VoxelShape ONE_EGG_AABB = Block.box(3.0, 0.0, 3.0, 12.0, 7.0, 12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.box(1.0, 0.0, 1.0, 15.0, 7.0, 15.0);
    public static final BlockStateInteger HATCH = BlockProperties.HATCH;
    public static final BlockStateInteger EGGS = BlockProperties.EGGS;

    public MapCodec<BlockTurtleEgg> codec() {
        return CODEC;
    }

    public BlockTurtleEgg(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HATCH, 0)).setValue(EGGS, 1));
    }

    @Override
    public void stepOn(World world, BlockPosition blockposition, IBlockData iblockdata, net.minecraft.world.entity.Entity entity) {
        if (!entity.isSteppingCarefully()) {
            this.destroyEgg(world, iblockdata, blockposition, entity, 100);
        }
        super.stepOn(world, blockposition, iblockdata, entity);
    }

    @Override
    public void fallOn(World world, IBlockData iblockdata, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, float f2) {
        if (!(entity instanceof EntityZombie)) {
            this.destroyEgg(world, iblockdata, blockposition, entity, 3);
        }
        super.fallOn(world, iblockdata, blockposition, entity, f2);
    }

    private void destroyEgg(World world, IBlockData iblockdata, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, int i2) {
        if (this.canDestroyEgg(world, entity) && !world.isClientSide && world.random.nextInt(i2) == 0 && iblockdata.is(Blocks.TURTLE_EGG)) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, blockposition, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, blockposition));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.decreaseEggs(world, blockposition, iblockdata);
        }
    }

    private void decreaseEggs(World world, BlockPosition blockposition, IBlockData iblockdata) {
        world.playSound((EntityHuman)null, blockposition, SoundEffects.TURTLE_EGG_BREAK, SoundCategory.BLOCKS, 0.7f, 0.9f + world.random.nextFloat() * 0.2f);
        int i2 = iblockdata.getValue(EGGS);
        if (i2 <= 1) {
            world.destroyBlock(blockposition, false);
        } else {
            world.setBlock(blockposition, (IBlockData)iblockdata.setValue(EGGS, i2 - 1), 2);
            world.gameEvent(GameEvent.BLOCK_DESTROY, blockposition, GameEvent.a.of(iblockdata));
            world.levelEvent(2001, blockposition, Block.getId(iblockdata));
        }
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (this.shouldUpdateHatchLevel(worldserver) && BlockTurtleEgg.onSand(worldserver, blockposition)) {
            int i2 = iblockdata.getValue(HATCH);
            if (i2 < 2) {
                if (!CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (IBlockData)iblockdata.setValue(HATCH, i2 + 1), 2)) {
                    return;
                }
                worldserver.playSound((EntityHuman)null, blockposition, SoundEffects.TURTLE_EGG_CRACK, SoundCategory.BLOCKS, 0.7f, 0.9f + randomsource.nextFloat() * 0.2f);
                worldserver.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.a.of(iblockdata));
            } else {
                if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, Blocks.AIR.defaultBlockState()).isCancelled()) {
                    return;
                }
                worldserver.playSound((EntityHuman)null, blockposition, SoundEffects.TURTLE_EGG_HATCH, SoundCategory.BLOCKS, 0.7f, 0.9f + randomsource.nextFloat() * 0.2f);
                worldserver.removeBlock(blockposition, false);
                worldserver.gameEvent(GameEvent.BLOCK_DESTROY, blockposition, GameEvent.a.of(iblockdata));
                for (int j2 = 0; j2 < iblockdata.getValue(EGGS); ++j2) {
                    worldserver.levelEvent(2001, blockposition, Block.getId(iblockdata));
                    EntityTurtle entityturtle = EntityTypes.TURTLE.create(worldserver);
                    if (entityturtle == null) continue;
                    entityturtle.setAge(-24000);
                    entityturtle.setHomePos(blockposition);
                    entityturtle.moveTo((double)blockposition.getX() + 0.3 + (double)j2 * 0.2, blockposition.getY(), (double)blockposition.getZ() + 0.3, 0.0f, 0.0f);
                    worldserver.addFreshEntity(entityturtle, CreatureSpawnEvent.SpawnReason.EGG);
                }
            }
        }
    }

    public static boolean onSand(IBlockAccess iblockaccess, BlockPosition blockposition) {
        return BlockTurtleEgg.isSand(iblockaccess, blockposition.below());
    }

    public static boolean isSand(IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockaccess.getBlockState(blockposition).is(TagsBlock.SAND);
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (BlockTurtleEgg.onSand(world, blockposition) && !world.isClientSide) {
            world.levelEvent(2012, blockposition, 15);
        }
    }

    private boolean shouldUpdateHatchLevel(World world) {
        float f2 = world.getTimeOfDay(1.0f);
        return (double)f2 < 0.69 && (double)f2 > 0.65 ? true : world.random.nextInt(500) == 0;
    }

    @Override
    public void playerDestroy(World world, EntityHuman entityhuman, BlockPosition blockposition, IBlockData iblockdata, @Nullable TileEntity tileentity, ItemStack itemstack) {
        super.playerDestroy(world, entityhuman, blockposition, iblockdata, tileentity, itemstack);
        this.decreaseEggs(world, blockposition, iblockdata);
    }

    @Override
    protected boolean canBeReplaced(IBlockData iblockdata, BlockActionContext blockactioncontext) {
        return !blockactioncontext.isSecondaryUseActive() && blockactioncontext.getItemInHand().is(this.asItem()) && iblockdata.getValue(EGGS) < 4 ? true : super.canBeReplaced(iblockdata, blockactioncontext);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        IBlockData iblockdata = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos());
        return iblockdata.is(this) ? (IBlockData)iblockdata.setValue(EGGS, Math.min(4, iblockdata.getValue(EGGS) + 1)) : super.getStateForPlacement(blockactioncontext);
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return iblockdata.getValue(EGGS) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(HATCH, EGGS);
    }

    private boolean canDestroyEgg(World world, net.minecraft.world.entity.Entity entity) {
        return !(entity instanceof EntityTurtle) && !(entity instanceof EntityBat) ? (!(entity instanceof EntityLiving) ? false : entity instanceof EntityHuman || world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) : false;
    }
}

