/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockVine
extends Block {
    public static final MapCodec<BlockVine> CODEC = BlockVine.simpleCodec(BlockVine::new);
    public static final BlockStateBoolean UP = BlockSprawling.UP;
    public static final BlockStateBoolean NORTH = BlockSprawling.NORTH;
    public static final BlockStateBoolean EAST = BlockSprawling.EAST;
    public static final BlockStateBoolean SOUTH = BlockSprawling.SOUTH;
    public static final BlockStateBoolean WEST = BlockSprawling.WEST;
    public static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockSprawling.PROPERTY_BY_DIRECTION.entrySet().stream().filter(entry -> entry.getKey() != EnumDirection.DOWN).collect(SystemUtils.toMap());
    protected static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape WEST_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<IBlockData, VoxelShape> shapesCache;

    public MapCodec<BlockVine> codec() {
        return CODEC;
    }

    public BlockVine(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(UP, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), BlockVine::calculateShape)));
    }

    private static VoxelShape calculateShape(IBlockData iblockdata) {
        VoxelShape voxelshape = VoxelShapes.empty();
        if (iblockdata.getValue(UP).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (iblockdata.getValue(NORTH).booleanValue()) {
            voxelshape = VoxelShapes.or(voxelshape, NORTH_AABB);
        }
        if (iblockdata.getValue(SOUTH).booleanValue()) {
            voxelshape = VoxelShapes.or(voxelshape, SOUTH_AABB);
        }
        if (iblockdata.getValue(EAST).booleanValue()) {
            voxelshape = VoxelShapes.or(voxelshape, EAST_AABB);
        }
        if (iblockdata.getValue(WEST).booleanValue()) {
            voxelshape = VoxelShapes.or(voxelshape, WEST_AABB);
        }
        return voxelshape.isEmpty() ? VoxelShapes.block() : voxelshape;
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.shapesCache.get(iblockdata);
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return true;
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return this.hasFaces(this.getUpdatedState(iblockdata, iworldreader, blockposition));
    }

    private boolean hasFaces(IBlockData iblockdata) {
        return this.countFaces(iblockdata) > 0;
    }

    private int countFaces(IBlockData iblockdata) {
        int i2 = 0;
        for (BlockStateBoolean blockstateboolean : PROPERTY_BY_DIRECTION.values()) {
            if (!iblockdata.getValue(blockstateboolean).booleanValue()) continue;
            ++i2;
        }
        return i2;
    }

    private boolean canSupportAtFace(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        if (enumdirection == EnumDirection.DOWN) {
            return false;
        }
        BlockPosition blockposition1 = blockposition.relative(enumdirection);
        if (BlockVine.isAcceptableNeighbour(iblockaccess, blockposition1, enumdirection)) {
            return true;
        }
        if (enumdirection.getAxis() == EnumDirection.EnumAxis.Y) {
            return false;
        }
        BlockStateBoolean blockstateboolean = PROPERTY_BY_DIRECTION.get(enumdirection);
        IBlockData iblockdata = iblockaccess.getBlockState(blockposition.above());
        return iblockdata.is(this) && iblockdata.getValue(blockstateboolean) != false;
    }

    public static boolean isAcceptableNeighbour(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return MultifaceBlock.canAttachTo(iblockaccess, enumdirection, blockposition, iblockaccess.getBlockState(blockposition));
    }

    private IBlockData getUpdatedState(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.above();
        if (iblockdata.getValue(UP).booleanValue()) {
            iblockdata = (IBlockData)iblockdata.setValue(UP, BlockVine.isAcceptableNeighbour(iblockaccess, blockposition1, EnumDirection.DOWN));
        }
        BlockBase.BlockData iblockdata1 = null;
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockStateBoolean blockstateboolean = BlockVine.getPropertyForFace(enumdirection);
            if (!iblockdata.getValue(blockstateboolean).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(iblockaccess, blockposition, enumdirection);
            if (!flag) {
                if (iblockdata1 == null) {
                    iblockdata1 = iblockaccess.getBlockState(blockposition1);
                }
                flag = iblockdata1.is(this) && iblockdata1.getValue(blockstateboolean) != false;
            }
            iblockdata = (IBlockData)iblockdata.setValue(blockstateboolean, flag);
        }
        return iblockdata;
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (enumdirection == EnumDirection.DOWN) {
            return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
        }
        IBlockData iblockdata2 = this.getUpdatedState(iblockdata, generatoraccess, blockposition);
        return !this.hasFaces(iblockdata2) ? Blocks.AIR.defaultBlockState() : iblockdata2;
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.getGameRules().getBoolean(GameRules.RULE_DO_VINES_SPREAD) && randomsource.nextFloat() < (float)worldserver.spigotConfig.vineModifier / 400.0f) {
            EnumDirection enumdirection = EnumDirection.getRandom(randomsource);
            BlockPosition blockposition1 = blockposition.above();
            if (enumdirection.getAxis().isHorizontal() && !iblockdata.getValue(BlockVine.getPropertyForFace(enumdirection)).booleanValue()) {
                if (this.canSpread(worldserver, blockposition)) {
                    BlockPosition blockposition2 = blockposition.relative(enumdirection);
                    IBlockData iblockdata1 = worldserver.getBlockState(blockposition2);
                    if (iblockdata1.isAir()) {
                        EnumDirection enumdirection1 = enumdirection.getClockWise();
                        EnumDirection enumdirection2 = enumdirection.getCounterClockWise();
                        boolean flag = iblockdata.getValue(BlockVine.getPropertyForFace(enumdirection1));
                        boolean flag1 = iblockdata.getValue(BlockVine.getPropertyForFace(enumdirection2));
                        BlockPosition blockposition3 = blockposition2.relative(enumdirection1);
                        BlockPosition blockposition4 = blockposition2.relative(enumdirection2);
                        BlockPosition source = blockposition;
                        if (flag && BlockVine.isAcceptableNeighbour(worldserver, blockposition3, enumdirection1)) {
                            CraftEventFactory.handleBlockSpreadEvent(worldserver, source, blockposition2, (IBlockData)this.defaultBlockState().setValue(BlockVine.getPropertyForFace(enumdirection1), true), 2);
                        } else if (flag1 && BlockVine.isAcceptableNeighbour(worldserver, blockposition4, enumdirection2)) {
                            CraftEventFactory.handleBlockSpreadEvent(worldserver, source, blockposition2, (IBlockData)this.defaultBlockState().setValue(BlockVine.getPropertyForFace(enumdirection2), true), 2);
                        } else {
                            EnumDirection enumdirection3 = enumdirection.getOpposite();
                            if (flag && worldserver.isEmptyBlock(blockposition3) && BlockVine.isAcceptableNeighbour(worldserver, blockposition.relative(enumdirection1), enumdirection3)) {
                                CraftEventFactory.handleBlockSpreadEvent(worldserver, source, blockposition3, (IBlockData)this.defaultBlockState().setValue(BlockVine.getPropertyForFace(enumdirection3), true), 2);
                            } else if (flag1 && worldserver.isEmptyBlock(blockposition4) && BlockVine.isAcceptableNeighbour(worldserver, blockposition.relative(enumdirection2), enumdirection3)) {
                                CraftEventFactory.handleBlockSpreadEvent(worldserver, source, blockposition4, (IBlockData)this.defaultBlockState().setValue(BlockVine.getPropertyForFace(enumdirection3), true), 2);
                            } else if ((double)randomsource.nextFloat() < 0.05 && BlockVine.isAcceptableNeighbour(worldserver, blockposition2.above(), EnumDirection.UP)) {
                                CraftEventFactory.handleBlockSpreadEvent(worldserver, source, blockposition2, (IBlockData)this.defaultBlockState().setValue(UP, true), 2);
                            }
                        }
                    } else if (BlockVine.isAcceptableNeighbour(worldserver, blockposition2, enumdirection)) {
                        CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (IBlockData)iblockdata.setValue(BlockVine.getPropertyForFace(enumdirection), true), 2);
                    }
                }
            } else {
                IBlockData iblockdata4;
                IBlockData iblockdata3;
                BlockPosition blockposition2;
                IBlockData iblockdata1;
                if (enumdirection == EnumDirection.UP && blockposition.getY() < worldserver.getMaxBuildHeight() - 1) {
                    if (this.canSupportAtFace(worldserver, blockposition, enumdirection)) {
                        CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (IBlockData)iblockdata.setValue(UP, true), 2);
                        return;
                    }
                    if (worldserver.isEmptyBlock(blockposition1)) {
                        if (!this.canSpread(worldserver, blockposition)) {
                            return;
                        }
                        IBlockData iblockdata2 = iblockdata;
                        for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                            if (!randomsource.nextBoolean() && BlockVine.isAcceptableNeighbour(worldserver, blockposition1.relative(enumdirection1), enumdirection1)) continue;
                            iblockdata2 = (IBlockData)iblockdata2.setValue(BlockVine.getPropertyForFace(enumdirection1), false);
                        }
                        if (this.hasHorizontalConnection(iblockdata2)) {
                            CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition1, iblockdata2, 2);
                        }
                        return;
                    }
                }
                if (blockposition.getY() > worldserver.getMinBuildHeight() && ((iblockdata1 = worldserver.getBlockState(blockposition2 = blockposition.below())).isAir() || iblockdata1.is(this)) && (iblockdata3 = iblockdata1.isAir() ? this.defaultBlockState() : iblockdata1) != (iblockdata4 = this.copyRandomFaces(iblockdata, iblockdata3, randomsource)) && this.hasHorizontalConnection(iblockdata4)) {
                    CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition2, iblockdata4, 2);
                }
            }
        }
    }

    private IBlockData copyRandomFaces(IBlockData iblockdata, IBlockData iblockdata1, RandomSource randomsource) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockStateBoolean blockstateboolean;
            if (!randomsource.nextBoolean() || !iblockdata.getValue(blockstateboolean = BlockVine.getPropertyForFace(enumdirection)).booleanValue()) continue;
            iblockdata1 = (IBlockData)iblockdata1.setValue(blockstateboolean, true);
        }
        return iblockdata1;
    }

    private boolean hasHorizontalConnection(IBlockData iblockdata) {
        return iblockdata.getValue(NORTH) != false || iblockdata.getValue(EAST) != false || iblockdata.getValue(SOUTH) != false || iblockdata.getValue(WEST) != false;
    }

    private boolean canSpread(IBlockAccess iblockaccess, BlockPosition blockposition) {
        boolean flag = true;
        Iterable<BlockPosition> iterable = BlockPosition.betweenClosed(blockposition.getX() - 4, blockposition.getY() - 1, blockposition.getZ() - 4, blockposition.getX() + 4, blockposition.getY() + 1, blockposition.getZ() + 4);
        int i2 = 5;
        for (BlockPosition blockposition1 : iterable) {
            if (!iblockaccess.getBlockState(blockposition1).is(this) || --i2 > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean canBeReplaced(IBlockData iblockdata, BlockActionContext blockactioncontext) {
        IBlockData iblockdata1 = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos());
        return iblockdata1.is(this) ? this.countFaces(iblockdata1) < PROPERTY_BY_DIRECTION.size() : super.canBeReplaced(iblockdata, blockactioncontext);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        IBlockData iblockdata = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos());
        boolean flag = iblockdata.is(this);
        IBlockData iblockdata1 = flag ? iblockdata : this.defaultBlockState();
        for (EnumDirection enumdirection : blockactioncontext.getNearestLookingDirections()) {
            boolean flag1;
            if (enumdirection == EnumDirection.DOWN) continue;
            BlockStateBoolean blockstateboolean = BlockVine.getPropertyForFace(enumdirection);
            boolean bl = flag1 = flag && iblockdata.getValue(blockstateboolean) != false;
            if (flag1 || !this.canSupportAtFace(blockactioncontext.getLevel(), blockactioncontext.getClickedPos(), enumdirection)) continue;
            return (IBlockData)iblockdata1.setValue(blockstateboolean, true);
        }
        return flag ? iblockdata1 : null;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(UP, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    protected IBlockData rotate(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        switch (enumblockrotation) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(SOUTH))).setValue(EAST, iblockdata.getValue(WEST))).setValue(SOUTH, iblockdata.getValue(NORTH))).setValue(WEST, iblockdata.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(EAST))).setValue(EAST, iblockdata.getValue(SOUTH))).setValue(SOUTH, iblockdata.getValue(WEST))).setValue(WEST, iblockdata.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(WEST))).setValue(EAST, iblockdata.getValue(NORTH))).setValue(SOUTH, iblockdata.getValue(EAST))).setValue(WEST, iblockdata.getValue(SOUTH));
            }
        }
        return iblockdata;
    }

    @Override
    protected IBlockData mirror(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        switch (enumblockmirror) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)iblockdata.setValue(NORTH, iblockdata.getValue(SOUTH))).setValue(SOUTH, iblockdata.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)iblockdata.setValue(EAST, iblockdata.getValue(WEST))).setValue(WEST, iblockdata.getValue(EAST));
            }
        }
        return super.mirror(iblockdata, enumblockmirror);
    }

    public static BlockStateBoolean getPropertyForFace(EnumDirection enumdirection) {
        return PROPERTY_BY_DIRECTION.get(enumdirection);
    }
}

