/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFlowers;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class BlockWitherRose
extends BlockFlowers {
    public static final MapCodec<BlockWitherRose> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EFFECTS_FIELD.forGetter(BlockFlowers::getSuspiciousEffects), BlockWitherRose.propertiesCodec()).apply((Applicative)instance, BlockWitherRose::new));

    public MapCodec<BlockWitherRose> codec() {
        return CODEC;
    }

    public BlockWitherRose(Holder<MobEffectList> holder, float f2, BlockBase.Info blockbase_info) {
        this(BlockWitherRose.makeEffectList(holder, f2), blockbase_info);
    }

    public BlockWitherRose(SuspiciousStewEffects suspicioussteweffects, BlockBase.Info blockbase_info) {
        super(suspicioussteweffects, blockbase_info);
    }

    @Override
    protected boolean mayPlaceOn(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return super.mayPlaceOn(iblockdata, iblockaccess, blockposition) || iblockdata.is(Blocks.NETHERRACK) || iblockdata.is(Blocks.SOUL_SAND) || iblockdata.is(Blocks.SOUL_SOIL);
    }

    @Override
    public void animateTick(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        VoxelShape voxelshape = this.getShape(iblockdata, world, blockposition, VoxelShapeCollision.empty());
        Vec3D vec3d = voxelshape.bounds().getCenter();
        double d0 = (double)blockposition.getX() + vec3d.x;
        double d1 = (double)blockposition.getZ() + vec3d.z;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!randomsource.nextBoolean()) continue;
            world.addParticle(Particles.SMOKE, d0 + randomsource.nextDouble() / 5.0, (double)blockposition.getY() + (0.5 - randomsource.nextDouble()), d1 + randomsource.nextDouble() / 5.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void entityInside(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity) {
        EntityLiving entityliving;
        if (!world.isClientSide && world.getDifficulty() != EnumDifficulty.PEACEFUL && entity instanceof EntityLiving && !(entityliving = (EntityLiving)entity).isInvulnerableTo(world.damageSources().wither())) {
            entityliving.addEffect(new MobEffect(MobEffects.WITHER, 40), EntityPotionEffectEvent.Cause.WITHER_ROSE);
        }
    }
}

