/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BlockWitherSkull
extends BlockSkull {
    public static final MapCodec<BlockWitherSkull> CODEC = BlockWitherSkull.simpleCodec(BlockWitherSkull::new);
    @Nullable
    private static ShapeDetector witherPatternFull;
    @Nullable
    private static ShapeDetector witherPatternBase;

    public MapCodec<BlockWitherSkull> codec() {
        return CODEC;
    }

    protected BlockWitherSkull(BlockBase.Info blockbase_info) {
        super(BlockSkull.Type.WITHER_SKELETON, blockbase_info);
    }

    @Override
    public void setPlacedBy(World world, BlockPosition blockposition, IBlockData iblockdata, @Nullable EntityLiving entityliving, ItemStack itemstack) {
        BlockWitherSkull.checkSpawn(world, blockposition);
    }

    public static void checkSpawn(World world, BlockPosition blockposition) {
        TileEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof TileEntitySkull) {
            TileEntitySkull tileentityskull = (TileEntitySkull)tileentity;
            BlockWitherSkull.checkSpawn(world, blockposition, tileentityskull);
        }
    }

    public static void checkSpawn(World world, BlockPosition blockposition, TileEntitySkull tileentityskull) {
        if (world.captureBlockStates) {
            return;
        }
        if (!world.isClientSide) {
            EntityWither entitywither;
            ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection;
            boolean flag;
            IBlockData iblockdata = tileentityskull.getBlockState();
            boolean bl = flag = iblockdata.is(Blocks.WITHER_SKELETON_SKULL) || iblockdata.is(Blocks.WITHER_SKELETON_WALL_SKULL);
            if (flag && blockposition.getY() >= world.getMinBuildHeight() && world.getDifficulty() != EnumDifficulty.PEACEFUL && (shapedetector_shapedetectorcollection = BlockWitherSkull.getOrCreateWitherFull().find(world, blockposition)) != null && (entitywither = EntityTypes.WITHER.create(world)) != null) {
                BlockPosition blockposition1 = shapedetector_shapedetectorcollection.getBlock(1, 2, 0).getPos();
                entitywither.moveTo((double)blockposition1.getX() + 0.5, (double)blockposition1.getY() + 0.55, (double)blockposition1.getZ() + 0.5, shapedetector_shapedetectorcollection.getForwards().getAxis() == EnumDirection.EnumAxis.X ? 0.0f : 90.0f, 0.0f);
                entitywither.yBodyRot = shapedetector_shapedetectorcollection.getForwards().getAxis() == EnumDirection.EnumAxis.X ? 0.0f : 90.0f;
                entitywither.makeInvulnerable();
                if (!world.addFreshEntity(entitywither, CreatureSpawnEvent.SpawnReason.BUILD_WITHER)) {
                    return;
                }
                BlockPumpkinCarved.clearPatternBlocks(world, shapedetector_shapedetectorcollection);
                for (EntityPlayer entityplayer : world.getEntitiesOfClass(EntityPlayer.class, entitywither.getBoundingBox().inflate(50.0))) {
                    CriterionTriggers.SUMMONED_ENTITY.trigger(entityplayer, entitywither);
                }
                BlockPumpkinCarved.updatePatternBlocks(world, shapedetector_shapedetectorcollection);
            }
        }
    }

    public static boolean canSpawnMob(World world, BlockPosition blockposition, ItemStack itemstack) {
        return itemstack.is(Items.WITHER_SKELETON_SKULL) && blockposition.getY() >= world.getMinBuildHeight() + 2 && world.getDifficulty() != EnumDifficulty.PEACEFUL && !world.isClientSide ? BlockWitherSkull.getOrCreateWitherBase().find(world, blockposition) != null : false;
    }

    private static ShapeDetector getOrCreateWitherFull() {
        if (witherPatternFull == null) {
            witherPatternFull = ShapeDetectorBuilder.start().aisle("^^^", "###", "~#~").where('#', shapedetectorblock -> shapedetectorblock.getState().is(TagsBlock.WITHER_SUMMON_BASE_BLOCKS)).where('^', ShapeDetectorBlock.hasState(BlockStatePredicate.forBlock(Blocks.WITHER_SKELETON_SKULL).or(BlockStatePredicate.forBlock(Blocks.WITHER_SKELETON_WALL_SKULL)))).where('~', shapedetectorblock -> shapedetectorblock.getState().isAir()).build();
        }
        return witherPatternFull;
    }

    private static ShapeDetector getOrCreateWitherBase() {
        if (witherPatternBase == null) {
            witherPatternBase = ShapeDetectorBuilder.start().aisle("   ", "###", "~#~").where('#', shapedetectorblock -> shapedetectorblock.getState().is(TagsBlock.WITHER_SUMMON_BASE_BLOCKS)).where('~', shapedetectorblock -> shapedetectorblock.getState().isAir()).build();
        }
        return witherPatternBase;
    }
}

