/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Collections;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;

public interface CaveVines {
    public static final VoxelShape SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    public static final BlockStateBoolean BERRIES = BlockProperties.BERRIES;

    public static EnumInteractionResult use(@Nullable Entity entity, IBlockData iblockdata, World world, BlockPosition blockposition) {
        if (iblockdata.getValue(BERRIES).booleanValue()) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (IBlockData)iblockdata.setValue(BERRIES, false))) {
                return EnumInteractionResult.SUCCESS;
            }
            if (entity instanceof EntityHuman) {
                PlayerHarvestBlockEvent event = CraftEventFactory.callPlayerHarvestBlockEvent(world, blockposition, (EntityHuman)entity, EnumHand.MAIN_HAND, Collections.singletonList(new net.minecraft.world.item.ItemStack(Items.GLOW_BERRIES, 1)));
                if (event.isCancelled()) {
                    return EnumInteractionResult.SUCCESS;
                }
                for (ItemStack itemStack : event.getItemsHarvested()) {
                    Block.popResource(world, blockposition, CraftItemStack.asNMSCopy(itemStack));
                }
            } else {
                Block.popResource(world, blockposition, new net.minecraft.world.item.ItemStack(Items.GLOW_BERRIES, 1));
            }
            float f2 = MathHelper.randomBetween(world.random, 0.8f, 1.2f);
            world.playSound((EntityHuman)null, blockposition, SoundEffects.CAVE_VINES_PICK_BERRIES, SoundCategory.BLOCKS, 1.0f, f2);
            IBlockData iblockdata1 = (IBlockData)iblockdata.setValue(BERRIES, false);
            world.setBlock(blockposition, iblockdata1, 2);
            world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.a.of(entity, iblockdata1));
            return EnumInteractionResult.sidedSuccess(world.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public static boolean hasGlowBerries(IBlockData iblockdata) {
        return iblockdata.hasProperty(BERRIES) && iblockdata.getValue(BERRIES) != false;
    }

    public static ToIntFunction<IBlockData> emission(int i2) {
        return iblockdata -> iblockdata.getValue(BlockProperties.BERRIES) != false ? i2 : 0;
    }
}

