/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingStem;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class CaveVinesPlantBlock
extends BlockGrowingStem
implements IBlockFragilePlantElement,
CaveVines {
    public static final MapCodec<CaveVinesPlantBlock> CODEC = CaveVinesPlantBlock.simpleCodec(CaveVinesPlantBlock::new);

    public MapCodec<CaveVinesPlantBlock> codec() {
        return CODEC;
    }

    public CaveVinesPlantBlock(BlockBase.Info var0) {
        super(var0, EnumDirection.DOWN, SHAPE, false);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(BERRIES, false));
    }

    @Override
    protected BlockGrowingTop getHeadBlock() {
        return (BlockGrowingTop)Blocks.CAVE_VINES;
    }

    @Override
    protected IBlockData updateHeadAfterConvertedFromBody(IBlockData var0, IBlockData var1) {
        return (IBlockData)var1.setValue(BERRIES, var0.getValue(BERRIES));
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return new ItemStack(Items.GLOW_BERRIES);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        return CaveVines.use(var3, var0, var1, var2);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(BERRIES);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return var2.getValue(BERRIES) == false;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        var0.setBlock(var2, (IBlockData)var3.setValue(BERRIES, true), 2);
    }
}

