/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class MultifaceSpreader {
    public static final e[] DEFAULT_SPREAD_ORDER = new e[]{e.SAME_POSITION, e.SAME_PLANE, e.WRAP_AROUND};
    private final b config;

    public MultifaceSpreader(MultifaceBlock multifaceblock) {
        this(new a(multifaceblock));
    }

    public MultifaceSpreader(b multifacespreader_b) {
        this.config = multifacespreader_b;
    }

    public boolean canSpreadInAnyDirection(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return EnumDirection.stream().anyMatch(enumdirection1 -> {
            b multifacespreader_b = this.config;
            Objects.requireNonNull(this.config);
            return this.getSpreadFromFaceTowardDirection(iblockdata, iblockaccess, blockposition, enumdirection, (EnumDirection)enumdirection1, multifacespreader_b::canSpreadInto).isPresent();
        });
    }

    public Optional<c> spreadFromRandomFaceTowardRandomDirection(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, RandomSource randomsource) {
        return EnumDirection.allShuffled(randomsource).stream().filter(enumdirection -> this.config.canSpreadFrom(iblockdata, (EnumDirection)enumdirection)).map(enumdirection -> this.spreadFromFaceTowardRandomDirection(iblockdata, generatoraccess, blockposition, (EnumDirection)enumdirection, randomsource, false)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public long spreadAll(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, boolean flag) {
        return EnumDirection.stream().filter(enumdirection -> this.config.canSpreadFrom(iblockdata, (EnumDirection)enumdirection)).map(enumdirection -> this.spreadFromFaceTowardAllDirections(iblockdata, generatoraccess, blockposition, (EnumDirection)enumdirection, flag)).reduce(0L, Long::sum);
    }

    public Optional<c> spreadFromFaceTowardRandomDirection(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection enumdirection, RandomSource randomsource, boolean flag) {
        return EnumDirection.allShuffled(randomsource).stream().map(enumdirection1 -> this.spreadFromFaceTowardDirection(iblockdata, generatoraccess, blockposition, enumdirection, (EnumDirection)enumdirection1, flag)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private long spreadFromFaceTowardAllDirections(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection enumdirection, boolean flag) {
        return EnumDirection.stream().map(enumdirection1 -> this.spreadFromFaceTowardDirection(iblockdata, generatoraccess, blockposition, enumdirection, (EnumDirection)enumdirection1, flag)).filter(Optional::isPresent).count();
    }

    @VisibleForTesting
    public Optional<c> spreadFromFaceTowardDirection(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection enumdirection, EnumDirection enumdirection1, boolean flag) {
        b multifacespreader_b = this.config;
        Objects.requireNonNull(this.config);
        return this.getSpreadFromFaceTowardDirection(iblockdata, generatoraccess, blockposition, enumdirection, enumdirection1, multifacespreader_b::canSpreadInto).flatMap(multifacespreader_c -> this.spreadToFace(generatoraccess, (c)multifacespreader_c, flag));
    }

    public Optional<c> getSpreadFromFaceTowardDirection(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, EnumDirection enumdirection1, d multifacespreader_d) {
        if (enumdirection1.getAxis() == enumdirection.getAxis()) {
            return Optional.empty();
        }
        if (!(this.config.isOtherBlockValidAsSource(iblockdata) || this.config.hasFace(iblockdata, enumdirection) && !this.config.hasFace(iblockdata, enumdirection1))) {
            return Optional.empty();
        }
        for (e multifacespreader_e : this.config.getSpreadTypes()) {
            c multifacespreader_c = multifacespreader_e.getSpreadPos(blockposition, enumdirection1, enumdirection);
            if (!multifacespreader_d.test(iblockaccess, blockposition, multifacespreader_c)) continue;
            return Optional.of(multifacespreader_c);
        }
        return Optional.empty();
    }

    public Optional<c> spreadToFace(GeneratorAccess generatoraccess, c multifacespreader_c, boolean flag) {
        IBlockData iblockdata = generatoraccess.getBlockState(multifacespreader_c.pos());
        return this.config.placeBlock(generatoraccess, multifacespreader_c, iblockdata, flag) ? Optional.of(multifacespreader_c) : Optional.empty();
    }

    public static class a
    implements b {
        protected MultifaceBlock block;

        public a(MultifaceBlock multifaceblock) {
            this.block = multifaceblock;
        }

        @Override
        @Nullable
        public IBlockData getStateForPlacement(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.block.getStateForPlacement(iblockdata, iblockaccess, blockposition, enumdirection);
        }

        protected boolean stateCanBeReplaced(IBlockAccess iblockaccess, BlockPosition blockposition, BlockPosition blockposition1, EnumDirection enumdirection, IBlockData iblockdata) {
            return iblockdata.isAir() || iblockdata.is(this.block) || iblockdata.is(Blocks.WATER) && iblockdata.getFluidState().isSource();
        }

        @Override
        public boolean canSpreadInto(IBlockAccess iblockaccess, BlockPosition blockposition, c multifacespreader_c) {
            IBlockData iblockdata = iblockaccess.getBlockState(multifacespreader_c.pos());
            return this.stateCanBeReplaced(iblockaccess, blockposition, multifacespreader_c.pos(), multifacespreader_c.face(), iblockdata) && this.block.isValidStateForPlacement(iblockaccess, iblockdata, multifacespreader_c.pos(), multifacespreader_c.face());
        }
    }

    public static interface b {
        @Nullable
        public IBlockData getStateForPlacement(IBlockData var1, IBlockAccess var2, BlockPosition var3, EnumDirection var4);

        public boolean canSpreadInto(IBlockAccess var1, BlockPosition var2, c var3);

        default public e[] getSpreadTypes() {
            return DEFAULT_SPREAD_ORDER;
        }

        default public boolean hasFace(IBlockData iblockdata, EnumDirection enumdirection) {
            return MultifaceBlock.hasFace(iblockdata, enumdirection);
        }

        default public boolean isOtherBlockValidAsSource(IBlockData iblockdata) {
            return false;
        }

        default public boolean canSpreadFrom(IBlockData iblockdata, EnumDirection enumdirection) {
            return this.isOtherBlockValidAsSource(iblockdata) || this.hasFace(iblockdata, enumdirection);
        }

        default public boolean placeBlock(GeneratorAccess generatoraccess, c multifacespreader_c, IBlockData iblockdata, boolean flag) {
            IBlockData iblockdata1 = this.getStateForPlacement(iblockdata, generatoraccess, multifacespreader_c.pos(), multifacespreader_c.face());
            if (iblockdata1 != null) {
                if (flag) {
                    generatoraccess.getChunk(multifacespreader_c.pos()).markPosForPostprocessing(multifacespreader_c.pos());
                }
                return CraftEventFactory.handleBlockSpreadEvent(generatoraccess, multifacespreader_c.source(), multifacespreader_c.pos(), iblockdata1, 2);
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface d {
        public boolean test(IBlockAccess var1, BlockPosition var2, c var3);
    }

    public static enum e {
        SAME_POSITION{

            @Override
            public c getSpreadPos(BlockPosition blockposition, EnumDirection enumdirection, EnumDirection enumdirection1) {
                return new c(blockposition, enumdirection, blockposition);
            }
        }
        ,
        SAME_PLANE{

            @Override
            public c getSpreadPos(BlockPosition blockposition, EnumDirection enumdirection, EnumDirection enumdirection1) {
                return new c(blockposition.relative(enumdirection), enumdirection1, blockposition);
            }
        }
        ,
        WRAP_AROUND{

            @Override
            public c getSpreadPos(BlockPosition blockposition, EnumDirection enumdirection, EnumDirection enumdirection1) {
                return new c(blockposition.relative(enumdirection).relative(enumdirection1), enumdirection.getOpposite(), blockposition);
            }
        };


        public abstract c getSpreadPos(BlockPosition var1, EnumDirection var2, EnumDirection var3);
    }

    public record c(BlockPosition pos, EnumDirection face, BlockPosition source) {
    }
}

