/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class PointedDripstoneBlock
extends Block
implements Fallable,
IBlockWaterlogged {
    public static final MapCodec<PointedDripstoneBlock> CODEC = PointedDripstoneBlock.simpleCodec(PointedDripstoneBlock::new);
    public static final BlockStateDirection TIP_DIRECTION = BlockProperties.VERTICAL_DIRECTION;
    public static final BlockStateEnum<DripstoneThickness> THICKNESS = BlockProperties.DRIPSTONE_THICKNESS;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final int MAX_SEARCH_LENGTH_WHEN_CHECKING_DRIP_TYPE = 11;
    private static final int DELAY_BEFORE_FALLING = 2;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK = 0.02f;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK_IF_UNDER_LIQUID_SOURCE = 0.12f;
    private static final int MAX_SEARCH_LENGTH_BETWEEN_STALACTITE_TIP_AND_CAULDRON = 11;
    private static final float WATER_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.17578125f;
    private static final float LAVA_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.05859375f;
    private static final double MIN_TRIDENT_VELOCITY_TO_BREAK_DRIPSTONE = 0.6;
    private static final float STALACTITE_DAMAGE_PER_FALL_DISTANCE_AND_SIZE = 1.0f;
    private static final int STALACTITE_MAX_DAMAGE = 40;
    private static final int MAX_STALACTITE_HEIGHT_FOR_DAMAGE_CALCULATION = 6;
    private static final float STALAGMITE_FALL_DISTANCE_OFFSET = 2.0f;
    private static final int STALAGMITE_FALL_DAMAGE_MODIFIER = 2;
    private static final float AVERAGE_DAYS_PER_GROWTH = 5.0f;
    private static final float GROWTH_PROBABILITY_PER_RANDOM_TICK = 0.011377778f;
    private static final int MAX_GROWTH_LENGTH = 7;
    private static final int MAX_STALAGMITE_SEARCH_RANGE_WHEN_GROWING = 10;
    private static final float STALACTITE_DRIP_START_PIXEL = 0.6875f;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box(5.0, 0.0, 5.0, 11.0, 11.0, 11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box(5.0, 5.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private static final VoxelShape BASE_SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);
    private static final float MAX_HORIZONTAL_OFFSET = 0.125f;
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.box(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);

    public MapCodec<PointedDripstoneBlock> codec() {
        return CODEC;
    }

    public PointedDripstoneBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(TIP_DIRECTION, EnumDirection.UP)).setValue(THICKNESS, DripstoneThickness.TIP)).setValue(WATERLOGGED, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(TIP_DIRECTION, THICKNESS, WATERLOGGED);
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return PointedDripstoneBlock.isValidPointedDripstonePlacement(iworldreader, blockposition, iblockdata.getValue(TIP_DIRECTION));
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        if (enumdirection != EnumDirection.UP && enumdirection != EnumDirection.DOWN) {
            return iblockdata;
        }
        EnumDirection enumdirection1 = iblockdata.getValue(TIP_DIRECTION);
        if (enumdirection1 == EnumDirection.DOWN && generatoraccess.getBlockTicks().hasScheduledTick(blockposition, this)) {
            return iblockdata;
        }
        if (enumdirection == enumdirection1.getOpposite() && !this.canSurvive(iblockdata, generatoraccess, blockposition)) {
            if (enumdirection1 == EnumDirection.DOWN) {
                generatoraccess.scheduleTick(blockposition, this, 2);
            } else {
                generatoraccess.scheduleTick(blockposition, this, 1);
            }
            return iblockdata;
        }
        boolean flag = iblockdata.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.calculateDripstoneThickness(generatoraccess, blockposition, enumdirection1, flag);
        return (IBlockData)iblockdata.setValue(THICKNESS, dripstonethickness);
    }

    @Override
    protected void onProjectileHit(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        BlockPosition blockposition;
        if (!world.isClientSide && iprojectile.mayInteract(world, blockposition = movingobjectpositionblock.getBlockPos()) && iprojectile.mayBreak(world) && iprojectile instanceof EntityThrownTrident && iprojectile.getDeltaMovement().length() > 0.6) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, Blocks.AIR.defaultBlockState())) {
                return;
            }
            world.destroyBlock(blockposition, true);
        }
    }

    @Override
    public void fallOn(World world, IBlockData iblockdata, BlockPosition blockposition, Entity entity, float f2) {
        if (iblockdata.getValue(TIP_DIRECTION) == EnumDirection.UP && iblockdata.getValue(THICKNESS) == DripstoneThickness.TIP) {
            entity.causeFallDamage(f2 + 2.0f, 2.0f, world.damageSources().stalagmite().directBlock(world, blockposition));
        } else {
            super.fallOn(world, iblockdata, blockposition, entity, f2);
        }
    }

    @Override
    public void animateTick(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        float f2;
        if (PointedDripstoneBlock.canDrip(iblockdata) && (f2 = randomsource.nextFloat()) <= 0.12f) {
            PointedDripstoneBlock.getFluidAboveStalactite(world, blockposition, iblockdata).filter(pointeddripstoneblock_a -> f2 < 0.02f || PointedDripstoneBlock.canFillCauldron(pointeddripstoneblock_a.fluid)).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.spawnDripParticle(world, blockposition, iblockdata, pointeddripstoneblock_a.fluid));
        }
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (PointedDripstoneBlock.isStalagmite(iblockdata) && !this.canSurvive(iblockdata, worldserver, blockposition)) {
            worldserver.destroyBlock(blockposition, true);
        } else {
            PointedDripstoneBlock.spawnFallingStalactite(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        PointedDripstoneBlock.maybeTransferFluid(iblockdata, worldserver, blockposition, randomsource.nextFloat());
        if (randomsource.nextFloat() < 0.011377778f && PointedDripstoneBlock.isStalactiteStartPos(iblockdata, worldserver, blockposition)) {
            PointedDripstoneBlock.growStalactiteOrStalagmiteIfPossible(iblockdata, worldserver, blockposition, randomsource);
        }
    }

    @VisibleForTesting
    public static void maybeTransferFluid(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, float f2) {
        Optional<a> optional;
        if ((f2 <= 0.17578125f || f2 <= 0.05859375f) && PointedDripstoneBlock.isStalactiteStartPos(iblockdata, worldserver, blockposition) && !(optional = PointedDripstoneBlock.getFluidAboveStalactite(worldserver, blockposition, iblockdata)).isEmpty()) {
            BlockPosition blockposition1;
            float f1;
            FluidType fluidtype = optional.get().fluid;
            if (fluidtype == FluidTypes.WATER) {
                f1 = 0.17578125f;
            } else {
                if (fluidtype != FluidTypes.LAVA) {
                    return;
                }
                f1 = 0.05859375f;
            }
            if (f2 < f1 && (blockposition1 = PointedDripstoneBlock.findTip(iblockdata, worldserver, blockposition, 11, false)) != null) {
                if (optional.get().sourceState.is(Blocks.MUD) && fluidtype == FluidTypes.WATER) {
                    IBlockData iblockdata1 = Blocks.CLAY.defaultBlockState();
                    worldserver.setBlockAndUpdate(optional.get().pos, iblockdata1);
                    Block.pushEntitiesUp(optional.get().sourceState, iblockdata1, worldserver, optional.get().pos);
                    worldserver.gameEvent(GameEvent.BLOCK_CHANGE, optional.get().pos, GameEvent.a.of(iblockdata1));
                    worldserver.levelEvent(1504, blockposition1, 0);
                } else {
                    BlockPosition blockposition2 = PointedDripstoneBlock.findFillableCauldronBelowStalactiteTip(worldserver, blockposition1, fluidtype);
                    if (blockposition2 != null) {
                        worldserver.levelEvent(1504, blockposition1, 0);
                        int i2 = blockposition1.getY() - blockposition2.getY();
                        int j2 = 50 + i2;
                        IBlockData iblockdata2 = worldserver.getBlockState(blockposition2);
                        worldserver.scheduleTick(blockposition2, iblockdata2.getBlock(), j2);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        EnumDirection enumdirection;
        BlockPosition blockposition;
        World world = blockactioncontext.getLevel();
        EnumDirection enumdirection1 = PointedDripstoneBlock.calculateTipDirection(world, blockposition = blockactioncontext.getClickedPos(), enumdirection = blockactioncontext.getNearestLookingVerticalDirection().getOpposite());
        if (enumdirection1 == null) {
            return null;
        }
        boolean flag = !blockactioncontext.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.calculateDripstoneThickness(world, blockposition, enumdirection1, flag);
        return dripstonethickness == null ? null : (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(TIP_DIRECTION, enumdirection1)).setValue(THICKNESS, dripstonethickness)).setValue(WATERLOGGED, world.getFluidState(blockposition).getType() == FluidTypes.WATER);
    }

    @Override
    protected Fluid getFluidState(IBlockData iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? FluidTypes.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    protected VoxelShape getOcclusionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return VoxelShapes.empty();
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        DripstoneThickness dripstonethickness = iblockdata.getValue(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (iblockdata.getValue(TIP_DIRECTION) == EnumDirection.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3D vec3d = iblockdata.getOffset(iblockaccess, blockposition);
        return voxelshape.move(vec3d.x, 0.0, vec3d.z);
    }

    @Override
    protected boolean isCollisionShapeFullBlock(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return false;
    }

    @Override
    protected float getMaxHorizontalOffset() {
        return 0.125f;
    }

    @Override
    public void onBrokenAfterFall(World world, BlockPosition blockposition, EntityFallingBlock entityfallingblock) {
        if (!entityfallingblock.isSilent()) {
            world.levelEvent(1045, blockposition, 0);
        }
    }

    @Override
    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fallingStalactite(entity);
    }

    private static void spawnFallingStalactite(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable();
        IBlockData iblockdata1 = iblockdata;
        while (PointedDripstoneBlock.isStalactite(iblockdata1)) {
            EntityFallingBlock entityfallingblock = EntityFallingBlock.fall(worldserver, blockposition_mutableblockposition, iblockdata1);
            if (PointedDripstoneBlock.isTip(iblockdata1, true)) {
                int i2 = Math.max(1 + blockposition.getY() - blockposition_mutableblockposition.getY(), 6);
                float f2 = 1.0f * (float)i2;
                entityfallingblock.setHurtsEntities(f2, 40);
                break;
            }
            blockposition_mutableblockposition.move(EnumDirection.DOWN);
            iblockdata1 = worldserver.getBlockState(blockposition_mutableblockposition);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        IBlockData iblockdata3;
        BlockPosition blockposition1;
        IBlockData iblockdata2;
        IBlockData iblockdata1 = worldserver.getBlockState(blockposition.above(1));
        if (PointedDripstoneBlock.canGrow(iblockdata1, iblockdata2 = worldserver.getBlockState(blockposition.above(2))) && (blockposition1 = PointedDripstoneBlock.findTip(iblockdata, worldserver, blockposition, 7, false)) != null && PointedDripstoneBlock.canDrip(iblockdata3 = worldserver.getBlockState(blockposition1)) && PointedDripstoneBlock.canTipGrow(iblockdata3, worldserver, blockposition1)) {
            if (randomsource.nextBoolean()) {
                PointedDripstoneBlock.grow(worldserver, blockposition1, EnumDirection.DOWN);
            } else {
                PointedDripstoneBlock.growStalagmiteBelow(worldserver, blockposition1);
            }
        }
    }

    private static void growStalagmiteBelow(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable();
        for (int i2 = 0; i2 < 10; ++i2) {
            blockposition_mutableblockposition.move(EnumDirection.DOWN);
            IBlockData iblockdata = worldserver.getBlockState(blockposition_mutableblockposition);
            if (!iblockdata.getFluidState().isEmpty()) {
                return;
            }
            if (PointedDripstoneBlock.isUnmergedTipWithDirection(iblockdata, EnumDirection.UP) && PointedDripstoneBlock.canTipGrow(iblockdata, worldserver, blockposition_mutableblockposition)) {
                PointedDripstoneBlock.grow(worldserver, blockposition_mutableblockposition, EnumDirection.UP);
                return;
            }
            if (PointedDripstoneBlock.isValidPointedDripstonePlacement(worldserver, blockposition_mutableblockposition, EnumDirection.UP) && !worldserver.isWaterAt((BlockPosition)blockposition_mutableblockposition.below())) {
                PointedDripstoneBlock.grow(worldserver, (BlockPosition)blockposition_mutableblockposition.below(), EnumDirection.UP);
                return;
            }
            if (PointedDripstoneBlock.canDripThrough(worldserver, blockposition_mutableblockposition, iblockdata)) continue;
            return;
        }
    }

    private static void grow(WorldServer worldserver, BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.relative(enumdirection);
        IBlockData iblockdata = worldserver.getBlockState(blockposition1);
        if (PointedDripstoneBlock.isUnmergedTipWithDirection(iblockdata, enumdirection.getOpposite())) {
            PointedDripstoneBlock.createMergedTips(iblockdata, worldserver, blockposition1);
        } else if (iblockdata.isAir() || iblockdata.is(Blocks.WATER)) {
            PointedDripstoneBlock.createDripstone(worldserver, blockposition1, enumdirection, DripstoneThickness.TIP, blockposition);
        }
    }

    private static void createDripstone(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection enumdirection, DripstoneThickness dripstonethickness, BlockPosition source) {
        IBlockData iblockdata = (IBlockData)((IBlockData)((IBlockData)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue(TIP_DIRECTION, enumdirection)).setValue(THICKNESS, dripstonethickness)).setValue(WATERLOGGED, generatoraccess.getFluidState(blockposition).getType() == FluidTypes.WATER);
        CraftEventFactory.handleBlockSpreadEvent(generatoraccess, source, blockposition, iblockdata, 3);
    }

    private static void createMergedTips(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        BlockPosition blockposition2;
        BlockPosition blockposition1;
        if (iblockdata.getValue(TIP_DIRECTION) == EnumDirection.UP) {
            blockposition1 = blockposition;
            blockposition2 = blockposition.above();
        } else {
            blockposition2 = blockposition;
            blockposition1 = blockposition.below();
        }
        PointedDripstoneBlock.createDripstone(generatoraccess, blockposition2, EnumDirection.DOWN, DripstoneThickness.TIP_MERGE, blockposition);
        PointedDripstoneBlock.createDripstone(generatoraccess, blockposition1, EnumDirection.UP, DripstoneThickness.TIP_MERGE, blockposition);
    }

    public static void spawnDripParticle(World world, BlockPosition blockposition, IBlockData iblockdata) {
        PointedDripstoneBlock.getFluidAboveStalactite(world, blockposition, iblockdata).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.spawnDripParticle(world, blockposition, iblockdata, pointeddripstoneblock_a.fluid));
    }

    private static void spawnDripParticle(World world, BlockPosition blockposition, IBlockData iblockdata, FluidType fluidtype) {
        Vec3D vec3d = iblockdata.getOffset(world, blockposition);
        double d0 = 0.0625;
        double d1 = (double)blockposition.getX() + 0.5 + vec3d.x;
        double d2 = (double)((float)(blockposition.getY() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)blockposition.getZ() + 0.5 + vec3d.z;
        FluidType fluidtype1 = PointedDripstoneBlock.getDripFluid(world, fluidtype);
        ParticleType particletype = fluidtype1.is(TagsFluid.LAVA) ? Particles.DRIPPING_DRIPSTONE_LAVA : Particles.DRIPPING_DRIPSTONE_WATER;
        world.addParticle(particletype, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPosition findTip(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, boolean flag) {
        if (PointedDripstoneBlock.isTip(iblockdata, flag)) {
            return blockposition;
        }
        EnumDirection enumdirection = iblockdata.getValue(TIP_DIRECTION);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.is(Blocks.POINTED_DRIPSTONE) && iblockdata1.getValue(TIP_DIRECTION) == enumdirection;
        return PointedDripstoneBlock.findBlockVertical(generatoraccess, blockposition, enumdirection.getAxisDirection(), bipredicate, iblockdata1 -> PointedDripstoneBlock.isTip(iblockdata1, flag), i2).orElse(null);
    }

    @Nullable
    private static EnumDirection calculateTipDirection(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection) {
        EnumDirection enumdirection1;
        if (PointedDripstoneBlock.isValidPointedDripstonePlacement(iworldreader, blockposition, enumdirection)) {
            enumdirection1 = enumdirection;
        } else {
            if (!PointedDripstoneBlock.isValidPointedDripstonePlacement(iworldreader, blockposition, enumdirection.getOpposite())) {
                return null;
            }
            enumdirection1 = enumdirection.getOpposite();
        }
        return enumdirection1;
    }

    private static DripstoneThickness calculateDripstoneThickness(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection, boolean flag) {
        EnumDirection enumdirection1 = enumdirection.getOpposite();
        IBlockData iblockdata = iworldreader.getBlockState(blockposition.relative(enumdirection));
        if (PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, enumdirection1)) {
            return !flag && iblockdata.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, enumdirection)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = iblockdata.getValue(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            IBlockData iblockdata1 = iworldreader.getBlockState(blockposition.relative(enumdirection1));
            return !PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata1, enumdirection) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(IBlockData iblockdata) {
        return PointedDripstoneBlock.isStalactite(iblockdata) && iblockdata.getValue(THICKNESS) == DripstoneThickness.TIP && iblockdata.getValue(WATERLOGGED) == false;
    }

    private static boolean canTipGrow(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition) {
        EnumDirection enumdirection = iblockdata.getValue(TIP_DIRECTION);
        BlockPosition blockposition1 = blockposition.relative(enumdirection);
        IBlockData iblockdata1 = worldserver.getBlockState(blockposition1);
        return !iblockdata1.getFluidState().isEmpty() ? false : (iblockdata1.isAir() ? true : PointedDripstoneBlock.isUnmergedTipWithDirection(iblockdata1, enumdirection.getOpposite()));
    }

    private static Optional<BlockPosition> findRootBlock(World world, BlockPosition blockposition, IBlockData iblockdata, int i2) {
        EnumDirection enumdirection = iblockdata.getValue(TIP_DIRECTION);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.is(Blocks.POINTED_DRIPSTONE) && iblockdata1.getValue(TIP_DIRECTION) == enumdirection;
        return PointedDripstoneBlock.findBlockVertical(world, blockposition, enumdirection.getOpposite().getAxisDirection(), bipredicate, iblockdata1 -> !iblockdata1.is(Blocks.POINTED_DRIPSTONE), i2);
    }

    private static boolean isValidPointedDripstonePlacement(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.relative(enumdirection.getOpposite());
        IBlockData iblockdata = iworldreader.getBlockState(blockposition1);
        return iblockdata.isFaceSturdy(iworldreader, blockposition1, enumdirection) || PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, enumdirection);
    }

    private static boolean isTip(IBlockData iblockdata, boolean flag) {
        if (!iblockdata.is(Blocks.POINTED_DRIPSTONE)) {
            return false;
        }
        DripstoneThickness dripstonethickness = iblockdata.getValue(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || flag && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(IBlockData iblockdata, EnumDirection enumdirection) {
        return PointedDripstoneBlock.isTip(iblockdata, false) && iblockdata.getValue(TIP_DIRECTION) == enumdirection;
    }

    private static boolean isStalactite(IBlockData iblockdata) {
        return PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, EnumDirection.DOWN);
    }

    private static boolean isStalagmite(IBlockData iblockdata) {
        return PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, EnumDirection.UP);
    }

    private static boolean isStalactiteStartPos(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return PointedDripstoneBlock.isStalactite(iblockdata) && !iworldreader.getBlockState(blockposition.above()).is(Blocks.POINTED_DRIPSTONE);
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(IBlockData iblockdata, EnumDirection enumdirection) {
        return iblockdata.is(Blocks.POINTED_DRIPSTONE) && iblockdata.getValue(TIP_DIRECTION) == enumdirection;
    }

    @Nullable
    private static BlockPosition findFillableCauldronBelowStalactiteTip(World world, BlockPosition blockposition, FluidType fluidtype) {
        Predicate<IBlockData> predicate = iblockdata -> iblockdata.getBlock() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)iblockdata.getBlock()).canReceiveStalactiteDrip(fluidtype);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.canDripThrough(world, blockposition1, iblockdata);
        return PointedDripstoneBlock.findBlockVertical(world, blockposition, EnumDirection.DOWN.getAxisDirection(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPosition findStalactiteTipAboveCauldron(World world, BlockPosition blockposition) {
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.canDripThrough(world, blockposition1, iblockdata);
        return PointedDripstoneBlock.findBlockVertical(world, blockposition, EnumDirection.UP.getAxisDirection(), bipredicate, PointedDripstoneBlock::canDrip, 11).orElse(null);
    }

    public static FluidType getCauldronFillFluidType(WorldServer worldserver, BlockPosition blockposition) {
        return PointedDripstoneBlock.getFluidAboveStalactite(worldserver, blockposition, worldserver.getBlockState(blockposition)).map(pointeddripstoneblock_a -> pointeddripstoneblock_a.fluid).filter(PointedDripstoneBlock::canFillCauldron).orElse(FluidTypes.EMPTY);
    }

    private static Optional<a> getFluidAboveStalactite(World world, BlockPosition blockposition, IBlockData iblockdata) {
        return !PointedDripstoneBlock.isStalactite(iblockdata) ? Optional.empty() : PointedDripstoneBlock.findRootBlock(world, blockposition, iblockdata, 11).map(blockposition1 -> {
            BlockPosition blockposition2 = blockposition1.above();
            IBlockData iblockdata1 = world.getBlockState(blockposition2);
            FluidType object = iblockdata1.is(Blocks.MUD) && !world.dimensionType().ultraWarm() ? FluidTypes.WATER : world.getFluidState(blockposition2).getType();
            return new a(blockposition2, object, iblockdata1);
        });
    }

    private static boolean canFillCauldron(FluidType fluidtype) {
        return fluidtype == FluidTypes.LAVA || fluidtype == FluidTypes.WATER;
    }

    private static boolean canGrow(IBlockData iblockdata, IBlockData iblockdata1) {
        return iblockdata.is(Blocks.DRIPSTONE_BLOCK) && iblockdata1.is(Blocks.WATER) && iblockdata1.getFluidState().isSource();
    }

    private static FluidType getDripFluid(World world, FluidType fluidtype) {
        return fluidtype.isSame(FluidTypes.EMPTY) ? (world.dimensionType().ultraWarm() ? FluidTypes.LAVA : FluidTypes.WATER) : fluidtype;
    }

    private static Optional<BlockPosition> findBlockVertical(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection.EnumAxisDirection enumdirection_enumaxisdirection, BiPredicate<BlockPosition, IBlockData> bipredicate, Predicate<IBlockData> predicate, int i2) {
        EnumDirection enumdirection = EnumDirection.get(enumdirection_enumaxisdirection, EnumDirection.EnumAxis.Y);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable();
        for (int j2 = 1; j2 < i2; ++j2) {
            blockposition_mutableblockposition.move(enumdirection);
            IBlockData iblockdata = generatoraccess.getBlockState(blockposition_mutableblockposition);
            if (predicate.test(iblockdata)) {
                return Optional.of(blockposition_mutableblockposition.immutable());
            }
            if (!generatoraccess.isOutsideBuildHeight(blockposition_mutableblockposition.getY()) && bipredicate.test(blockposition_mutableblockposition, iblockdata)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata) {
        if (iblockdata.isAir()) {
            return true;
        }
        if (iblockdata.isSolidRender(iblockaccess, blockposition)) {
            return false;
        }
        if (!iblockdata.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape voxelshape = iblockdata.getCollisionShape(iblockaccess, blockposition);
        return !VoxelShapes.joinIsNotEmpty(REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, voxelshape, OperatorBoolean.AND);
    }

    record a(BlockPosition pos, FluidType fluid, IBlockData sourceState) {
    }
}

