/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class PowderSnowBlock
extends Block
implements IFluidSource {
    public static final MapCodec<PowderSnowBlock> CODEC = PowderSnowBlock.simpleCodec(PowderSnowBlock::new);
    private static final float HORIZONTAL_PARTICLE_MOMENTUM_FACTOR = 0.083333336f;
    private static final float IN_BLOCK_HORIZONTAL_SPEED_MULTIPLIER = 0.9f;
    private static final float IN_BLOCK_VERTICAL_SPEED_MULTIPLIER = 1.5f;
    private static final float NUM_BLOCKS_TO_FALL_INTO_BLOCK = 2.5f;
    private static final VoxelShape FALLING_COLLISION_SHAPE = VoxelShapes.box(0.0, 0.0, 0.0, 1.0, 0.9f, 1.0);
    private static final double MINIMUM_FALL_DISTANCE_FOR_SOUND = 4.0;
    private static final double MINIMUM_FALL_DISTANCE_FOR_BIG_SOUND = 7.0;

    public MapCodec<PowderSnowBlock> codec() {
        return CODEC;
    }

    public PowderSnowBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
    }

    @Override
    protected boolean skipRendering(IBlockData iblockdata, IBlockData iblockdata1, EnumDirection enumdirection) {
        return iblockdata1.is(this) ? true : super.skipRendering(iblockdata, iblockdata1, enumdirection);
    }

    @Override
    protected VoxelShape getOcclusionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return VoxelShapes.empty();
    }

    @Override
    protected void entityInside(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity) {
        if (!(entity instanceof EntityLiving) || entity.getInBlockState().is(this)) {
            entity.makeStuckInBlock(iblockdata, new Vec3D(0.9f, 1.5, 0.9f));
            if (world.isClientSide) {
                boolean flag;
                RandomSource randomsource = world.getRandom();
                boolean bl = flag = entity.xOld != entity.getX() || entity.zOld != entity.getZ();
                if (flag && randomsource.nextBoolean()) {
                    world.addParticle(Particles.SNOWFLAKE, entity.getX(), blockposition.getY() + 1, entity.getZ(), MathHelper.randomBetween(randomsource, -1.0f, 1.0f) * 0.083333336f, 0.05f, MathHelper.randomBetween(randomsource, -1.0f, 1.0f) * 0.083333336f);
                }
            }
        }
        entity.setIsInPowderSnow(true);
        if (!world.isClientSide) {
            if (entity.isOnFire() && entity.mayInteract(world, blockposition)) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, Blocks.AIR.defaultBlockState(), !world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && !(entity instanceof EntityHuman))) {
                    return;
                }
                world.destroyBlock(blockposition, false);
            }
            entity.setSharedFlagOnFire(false);
        }
    }

    @Override
    public void fallOn(World world, IBlockData iblockdata, BlockPosition blockposition, Entity entity, float f2) {
        if ((double)f2 >= 4.0 && entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            EntityLiving.a entityliving_a = entityliving.getFallSounds();
            SoundEffect soundeffect = (double)f2 < 7.0 ? entityliving_a.small() : entityliving_a.big();
            entity.playSound(soundeffect, 1.0f, 1.0f);
        }
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        VoxelShapeCollisionEntity voxelshapecollisionentity;
        Entity entity;
        if (voxelshapecollision instanceof VoxelShapeCollisionEntity && (entity = (voxelshapecollisionentity = (VoxelShapeCollisionEntity)voxelshapecollision).getEntity()) != null) {
            if (entity.fallDistance > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean flag = entity instanceof EntityFallingBlock;
            if (flag || PowderSnowBlock.canEntityWalkOnPowderSnow(entity) && voxelshapecollision.isAbove(VoxelShapes.block(), blockposition, false) && !voxelshapecollision.isDescending()) {
                return super.getCollisionShape(iblockdata, iblockaccess, blockposition, voxelshapecollision);
            }
        }
        return VoxelShapes.empty();
    }

    @Override
    protected VoxelShape getVisualShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return VoxelShapes.empty();
    }

    public static boolean canEntityWalkOnPowderSnow(Entity entity) {
        return entity.getType().is(TagsEntity.POWDER_SNOW_WALKABLE_MOBS) ? true : (entity instanceof EntityLiving ? ((EntityLiving)entity).getItemBySlot(EnumItemSlot.FEET).is(Items.LEATHER_BOOTS) : false);
    }

    @Override
    public ItemStack pickupBlock(@Nullable EntityHuman entityhuman, GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata) {
        generatoraccess.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 11);
        if (!generatoraccess.isClientSide()) {
            generatoraccess.levelEvent(2001, blockposition, Block.getId(iblockdata));
        }
        return new ItemStack(Items.POWDER_SNOW_BUCKET);
    }

    @Override
    public Optional<SoundEffect> getPickupSound() {
        return Optional.of(SoundEffects.BUCKET_FILL_POWDER_SNOW);
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return true;
    }
}

