/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class RodBlock
extends BlockDirectional {
    protected static final float AABB_MIN = 6.0f;
    protected static final float AABB_MAX = 10.0f;
    protected static final VoxelShape Y_AXIS_AABB = Block.box(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box(6.0, 6.0, 0.0, 10.0, 10.0, 16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.box(0.0, 6.0, 6.0, 16.0, 10.0, 10.0);

    protected RodBlock(BlockBase.Info var0) {
        super(var0);
    }

    protected abstract MapCodec<? extends RodBlock> codec();

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        switch (var0.getValue(FACING).getAxis()) {
            default: {
                return X_AXIS_AABB;
            }
            case Z: {
                return Z_AXIS_AABB;
            }
            case Y: 
        }
        return Y_AXIS_AABB;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return (IBlockData)var0.setValue(FACING, var1.mirror(var0.getValue(FACING)));
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

