/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class SculkBlock
extends DropExperienceBlock
implements SculkBehaviour {
    public static final MapCodec<SculkBlock> CODEC = SculkBlock.simpleCodec(SculkBlock::new);

    public MapCodec<SculkBlock> codec() {
        return CODEC;
    }

    public SculkBlock(BlockBase.Info blockbase_info) {
        super(ConstantInt.of(1), blockbase_info);
    }

    @Override
    public int attemptUseCharge(SculkSpreader.a sculkspreader_a, GeneratorAccess generatoraccess, BlockPosition blockposition, RandomSource randomsource, SculkSpreader sculkspreader, boolean flag) {
        int i2 = sculkspreader_a.getCharge();
        if (i2 != 0 && randomsource.nextInt(sculkspreader.chargeDecayRate()) == 0) {
            BlockPosition blockposition1 = sculkspreader_a.getPos();
            boolean flag1 = blockposition1.closerThan(blockposition, sculkspreader.noGrowthRadius());
            if (!flag1 && SculkBlock.canPlaceGrowth(generatoraccess, blockposition1)) {
                IBlockData iblockdata;
                BlockPosition blockposition2;
                int j2 = sculkspreader.growthSpawnCost();
                if (randomsource.nextInt(j2) < i2 && CraftEventFactory.handleBlockSpreadEvent(generatoraccess, blockposition, blockposition2 = blockposition1.above(), iblockdata = this.getRandomGrowthState(generatoraccess, blockposition2, randomsource, sculkspreader.isWorldGeneration()), 3)) {
                    generatoraccess.playSound(null, blockposition1, iblockdata.getSoundType().getPlaceSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return Math.max(0, i2 - j2);
            }
            return randomsource.nextInt(sculkspreader.additionalDecayRate()) != 0 ? i2 : i2 - (flag1 ? 1 : SculkBlock.getDecayPenalty(sculkspreader, blockposition1, blockposition, i2));
        }
        return i2;
    }

    private static int getDecayPenalty(SculkSpreader sculkspreader, BlockPosition blockposition, BlockPosition blockposition1, int i2) {
        int j2 = sculkspreader.noGrowthRadius();
        float f2 = MathHelper.square((float)Math.sqrt(blockposition.distSqr(blockposition1)) - (float)j2);
        int k2 = MathHelper.square(24 - j2);
        float f1 = Math.min(1.0f, f2 / (float)k2);
        return Math.max(1, (int)((float)i2 * f1 * 0.5f));
    }

    private IBlockData getRandomGrowthState(GeneratorAccess generatoraccess, BlockPosition blockposition, RandomSource randomsource, boolean flag) {
        IBlockData iblockdata = randomsource.nextInt(11) == 0 ? (IBlockData)Blocks.SCULK_SHRIEKER.defaultBlockState().setValue(SculkShriekerBlock.CAN_SUMMON, flag) : Blocks.SCULK_SENSOR.defaultBlockState();
        return iblockdata.hasProperty(BlockProperties.WATERLOGGED) && !generatoraccess.getFluidState(blockposition).isEmpty() ? (IBlockData)iblockdata.setValue(BlockProperties.WATERLOGGED, true) : iblockdata;
    }

    private static boolean canPlaceGrowth(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        IBlockData iblockdata = generatoraccess.getBlockState(blockposition.above());
        if (!(iblockdata.isAir() || iblockdata.is(Blocks.WATER) && iblockdata.getFluidState().is(FluidTypes.WATER))) {
            return false;
        }
        int i2 = 0;
        Iterator<BlockPosition> iterator = BlockPosition.betweenClosed(blockposition.offset(-4, 0, -4), blockposition.offset(4, 2, 4)).iterator();
        do {
            if (!iterator.hasNext()) {
                return true;
            }
            BlockPosition blockposition1 = iterator.next();
            IBlockData iblockdata1 = generatoraccess.getBlockState(blockposition1);
            if (!iblockdata1.is(Blocks.SCULK_SENSOR) && !iblockdata1.is(Blocks.SCULK_SHRIEKER)) continue;
            ++i2;
        } while (i2 <= 2);
        return false;
    }

    @Override
    public boolean canChangeBlockStateOnSpread() {
        return false;
    }
}

