/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.SculkBloomEvent;
import org.slf4j.Logger;

public class SculkSpreader {
    public static final int MAX_GROWTH_RATE_RADIUS = 24;
    public static final int MAX_CHARGE = 1000;
    public static final float MAX_DECAY_FACTOR = 0.5f;
    private static final int MAX_CURSORS = 32;
    public static final int SHRIEKER_PLACEMENT_RATE = 11;
    final boolean isWorldGeneration;
    private final TagKey<Block> replaceableBlocks;
    private final int growthSpawnCost;
    private final int noGrowthRadius;
    private final int chargeDecayRate;
    private final int additionalDecayRate;
    private List<a> cursors = new ArrayList<a>();
    private static final Logger LOGGER = LogUtils.getLogger();
    public World level;

    public SculkSpreader(boolean flag, TagKey<Block> tagkey, int i2, int j2, int k2, int l2) {
        this.isWorldGeneration = flag;
        this.replaceableBlocks = tagkey;
        this.growthSpawnCost = i2;
        this.noGrowthRadius = j2;
        this.chargeDecayRate = k2;
        this.additionalDecayRate = l2;
    }

    public static SculkSpreader createLevelSpreader() {
        return new SculkSpreader(false, TagsBlock.SCULK_REPLACEABLE, 10, 4, 10, 5);
    }

    public static SculkSpreader createWorldGenSpreader() {
        return new SculkSpreader(true, TagsBlock.SCULK_REPLACEABLE_WORLD_GEN, 50, 1, 5, 10);
    }

    public TagKey<Block> replaceableBlocks() {
        return this.replaceableBlocks;
    }

    public int growthSpawnCost() {
        return this.growthSpawnCost;
    }

    public int noGrowthRadius() {
        return this.noGrowthRadius;
    }

    public int chargeDecayRate() {
        return this.chargeDecayRate;
    }

    public int additionalDecayRate() {
        return this.additionalDecayRate;
    }

    public boolean isWorldGeneration() {
        return this.isWorldGeneration;
    }

    @VisibleForTesting
    public List<a> getCursors() {
        return this.cursors;
    }

    public void clear() {
        this.cursors.clear();
    }

    public void load(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.contains("cursors", 9)) {
            this.cursors.clear();
            DataResult dataresult = a.CODEC.listOf().parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.getList("cursors", 10)));
            Logger logger = LOGGER;
            Objects.requireNonNull(logger);
            List list = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElseGet(ArrayList::new);
            int i2 = Math.min(list.size(), 32);
            for (int j2 = 0; j2 < i2; ++j2) {
                this.addCursor((a)list.get(j2));
            }
        }
    }

    public void save(NBTTagCompound nbttagcompound) {
        DataResult dataresult = a.CODEC.listOf().encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, this.cursors);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("cursors", (NBTBase)nbtbase));
    }

    public void addCursors(BlockPosition blockposition, int i2) {
        while (i2 > 0) {
            int j2 = Math.min(i2, 1000);
            this.addCursor(new a(blockposition, j2));
            i2 -= j2;
        }
    }

    private void addCursor(a sculkspreader_a) {
        if (this.cursors.size() < 32) {
            if (!this.isWorldGeneration()) {
                CraftBlock bukkitBlock = CraftBlock.at(this.level, sculkspreader_a.pos);
                SculkBloomEvent event = new SculkBloomEvent((org.bukkit.block.Block)bukkitBlock, sculkspreader_a.getCharge());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                sculkspreader_a.charge = event.getCharge();
            }
            this.cursors.add(sculkspreader_a);
        }
    }

    public void updateCursors(GeneratorAccess generatoraccess, BlockPosition blockposition, RandomSource randomsource, boolean flag) {
        if (!this.cursors.isEmpty()) {
            BlockPosition blockposition1;
            ArrayList<a> list = new ArrayList<a>();
            HashMap<BlockPosition, a> map = new HashMap<BlockPosition, a>();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            for (a sculkspreader_a : this.cursors) {
                sculkspreader_a.update(generatoraccess, blockposition, randomsource, this, flag);
                if (sculkspreader_a.charge <= 0) {
                    generatoraccess.levelEvent(3006, sculkspreader_a.getPos(), 0);
                    continue;
                }
                blockposition1 = sculkspreader_a.getPos();
                object2intmap.computeInt((Object)blockposition1, (blockposition2, integer) -> (integer == null ? 0 : integer) + sculkspreader_a.charge);
                a sculkspreader_a1 = (a)map.get(blockposition1);
                if (sculkspreader_a1 == null) {
                    map.put(blockposition1, sculkspreader_a);
                    list.add(sculkspreader_a);
                    continue;
                }
                if (!this.isWorldGeneration() && sculkspreader_a.charge + sculkspreader_a1.charge <= 1000) {
                    sculkspreader_a1.mergeWith(sculkspreader_a);
                    continue;
                }
                list.add(sculkspreader_a);
                if (sculkspreader_a.charge >= sculkspreader_a1.charge) continue;
                map.put(blockposition1, sculkspreader_a);
            }
            for (Object2IntMap.Entry entry : object2intmap.object2IntEntrySet()) {
                Set<EnumDirection> collection;
                blockposition1 = (BlockPosition)entry.getKey();
                int i2 = entry.getIntValue();
                a sculkspreader_a2 = (a)map.get(blockposition1);
                Set<EnumDirection> set = collection = sculkspreader_a2 == null ? null : sculkspreader_a2.getFacingData();
                if (i2 <= 0 || collection == null) continue;
                int j2 = (int)(Math.log1p(i2) / (double)2.3f) + 1;
                int k2 = (j2 << 6) + MultifaceBlock.pack(collection);
                generatoraccess.levelEvent(3006, blockposition1, k2);
            }
            this.cursors = list;
        }
    }

    public static class a {
        private static final ObjectArrayList<BaseBlockPosition> NON_CORNER_NEIGHBOURS = SystemUtils.make(new ObjectArrayList(18), objectarraylist -> {
            Stream<BlockPosition> stream = BlockPosition.betweenClosedStream(new BlockPosition(-1, -1, -1), new BlockPosition(1, 1, 1)).filter(blockposition -> (blockposition.getX() == 0 || blockposition.getY() == 0 || blockposition.getZ() == 0) && !blockposition.equals(BlockPosition.ZERO)).map(BlockPosition::immutable);
            Objects.requireNonNull(objectarraylist);
            stream.forEach(arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        });
        public static final int MAX_CURSOR_DECAY_DELAY = 1;
        private BlockPosition pos;
        int charge;
        private int updateDelay;
        private int decayDelay;
        @Nullable
        private Set<EnumDirection> facings;
        private static final Codec<Set<EnumDirection>> DIRECTION_SET = EnumDirection.CODEC.listOf().xmap(list -> Sets.newEnumSet((Iterable)list, EnumDirection.class), Lists::newArrayList);
        public static final Codec<a> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPosition.CODEC.fieldOf("pos").forGetter(a::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(a::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(a::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(sculkspreader_a -> sculkspreader_a.updateDelay), (App)DIRECTION_SET.lenientOptionalFieldOf("facings").forGetter(sculkspreader_a -> Optional.ofNullable(sculkspreader_a.getFacingData()))).apply((Applicative)instance, a::new));

        private a(BlockPosition blockposition, int i2, int j2, int k2, Optional<Set<EnumDirection>> optional) {
            this.pos = blockposition;
            this.charge = i2;
            this.decayDelay = j2;
            this.updateDelay = k2;
            this.facings = optional.orElse(null);
        }

        public a(BlockPosition blockposition, int i2) {
            this(blockposition, i2, 1, 0, Optional.empty());
        }

        public BlockPosition getPos() {
            return this.pos;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecayDelay() {
            return this.decayDelay;
        }

        @Nullable
        public Set<EnumDirection> getFacingData() {
            return this.facings;
        }

        private boolean shouldUpdate(GeneratorAccess generatoraccess, BlockPosition blockposition, boolean flag) {
            if (this.charge <= 0) {
                return false;
            }
            if (flag) {
                return true;
            }
            if (generatoraccess instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)generatoraccess;
                return worldserver.shouldTickBlocksAt(blockposition);
            }
            return false;
        }

        public void update(GeneratorAccess generatoraccess, BlockPosition blockposition, RandomSource randomsource, SculkSpreader sculkspreader, boolean flag) {
            if (this.shouldUpdate(generatoraccess, blockposition, sculkspreader.isWorldGeneration)) {
                if (this.updateDelay > 0) {
                    --this.updateDelay;
                } else {
                    IBlockData iblockdata = generatoraccess.getBlockState(this.pos);
                    SculkBehaviour sculkbehaviour = a.getBlockBehaviour(iblockdata);
                    if (flag && sculkbehaviour.attemptSpreadVein(generatoraccess, this.pos, iblockdata, this.facings, sculkspreader.isWorldGeneration())) {
                        if (sculkbehaviour.canChangeBlockStateOnSpread()) {
                            iblockdata = generatoraccess.getBlockState(this.pos);
                            sculkbehaviour = a.getBlockBehaviour(iblockdata);
                        }
                        generatoraccess.playSound(null, this.pos, SoundEffects.SCULK_BLOCK_SPREAD, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    this.charge = sculkbehaviour.attemptUseCharge(this, generatoraccess, blockposition, randomsource, sculkspreader, flag);
                    if (this.charge <= 0) {
                        sculkbehaviour.onDischarged(generatoraccess, iblockdata, this.pos, randomsource);
                    } else {
                        BlockPosition blockposition1 = a.getValidMovementPos(generatoraccess, this.pos, randomsource);
                        if (blockposition1 != null) {
                            sculkbehaviour.onDischarged(generatoraccess, iblockdata, this.pos, randomsource);
                            this.pos = blockposition1.immutable();
                            if (sculkspreader.isWorldGeneration() && !this.pos.closerThan(new BaseBlockPosition(blockposition.getX(), this.pos.getY(), blockposition.getZ()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            iblockdata = generatoraccess.getBlockState(blockposition1);
                        }
                        if (iblockdata.getBlock() instanceof SculkBehaviour) {
                            this.facings = MultifaceBlock.availableFaces(iblockdata);
                        }
                        this.decayDelay = sculkbehaviour.updateDecayDelay(this.decayDelay);
                        this.updateDelay = sculkbehaviour.getSculkSpreadDelay();
                    }
                }
            }
        }

        void mergeWith(a sculkspreader_a) {
            this.charge += sculkspreader_a.charge;
            sculkspreader_a.charge = 0;
            this.updateDelay = Math.min(this.updateDelay, sculkspreader_a.updateDelay);
        }

        private static SculkBehaviour getBlockBehaviour(IBlockData iblockdata) {
            SculkBehaviour sculkbehaviour1;
            Block block = iblockdata.getBlock();
            SculkBehaviour sculkbehaviour = block instanceof SculkBehaviour ? (sculkbehaviour1 = (SculkBehaviour)((Object)block)) : SculkBehaviour.DEFAULT;
            return sculkbehaviour;
        }

        private static List<BaseBlockPosition> getRandomizedNonCornerNeighbourOffsets(RandomSource randomsource) {
            return SystemUtils.shuffledCopy(NON_CORNER_NEIGHBOURS, randomsource);
        }

        @Nullable
        private static BlockPosition getValidMovementPos(GeneratorAccess generatoraccess, BlockPosition blockposition, RandomSource randomsource) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = blockposition.mutable();
            for (BaseBlockPosition baseblockposition : a.getRandomizedNonCornerNeighbourOffsets(randomsource)) {
                blockposition_mutableblockposition1.setWithOffset((BaseBlockPosition)blockposition, baseblockposition);
                IBlockData iblockdata = generatoraccess.getBlockState(blockposition_mutableblockposition1);
                if (!(iblockdata.getBlock() instanceof SculkBehaviour) || !a.isMovementUnobstructed(generatoraccess, blockposition, blockposition_mutableblockposition1)) continue;
                blockposition_mutableblockposition.set(blockposition_mutableblockposition1);
                if (!SculkVeinBlock.hasSubstrateAccess(generatoraccess, iblockdata, blockposition_mutableblockposition1)) continue;
                break;
            }
            return blockposition_mutableblockposition.equals(blockposition) ? null : blockposition_mutableblockposition;
        }

        private static boolean isMovementUnobstructed(GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
            if (blockposition.distManhattan(blockposition1) == 1) {
                return true;
            }
            BlockPosition blockposition2 = blockposition1.subtract(blockposition);
            EnumDirection enumdirection = EnumDirection.fromAxisAndDirection(EnumDirection.EnumAxis.X, blockposition2.getX() < 0 ? EnumDirection.EnumAxisDirection.NEGATIVE : EnumDirection.EnumAxisDirection.POSITIVE);
            EnumDirection enumdirection1 = EnumDirection.fromAxisAndDirection(EnumDirection.EnumAxis.Y, blockposition2.getY() < 0 ? EnumDirection.EnumAxisDirection.NEGATIVE : EnumDirection.EnumAxisDirection.POSITIVE);
            EnumDirection enumdirection2 = EnumDirection.fromAxisAndDirection(EnumDirection.EnumAxis.Z, blockposition2.getZ() < 0 ? EnumDirection.EnumAxisDirection.NEGATIVE : EnumDirection.EnumAxisDirection.POSITIVE);
            return blockposition2.getX() == 0 ? a.isUnobstructed(generatoraccess, blockposition, enumdirection1) || a.isUnobstructed(generatoraccess, blockposition, enumdirection2) : (blockposition2.getY() == 0 ? a.isUnobstructed(generatoraccess, blockposition, enumdirection) || a.isUnobstructed(generatoraccess, blockposition, enumdirection2) : a.isUnobstructed(generatoraccess, blockposition, enumdirection) || a.isUnobstructed(generatoraccess, blockposition, enumdirection1));
        }

        private static boolean isUnobstructed(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection enumdirection) {
            BlockPosition blockposition1 = blockposition.relative(enumdirection);
            return !generatoraccess.getBlockState(blockposition1).isFaceSturdy(generatoraccess, blockposition1, enumdirection.getOpposite());
        }
    }
}

