/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Collection;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class SculkVeinBlock
extends MultifaceBlock
implements SculkBehaviour,
IBlockWaterlogged {
    public static final MapCodec<SculkVeinBlock> CODEC = SculkVeinBlock.simpleCodec(SculkVeinBlock::new);
    private static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private final MultifaceSpreader veinSpreader = new MultifaceSpreader(new a(this, this, MultifaceSpreader.DEFAULT_SPREAD_ORDER));
    private final MultifaceSpreader sameSpaceSpreader = new MultifaceSpreader(new a(this, this, MultifaceSpreader.e.SAME_POSITION));

    public MapCodec<SculkVeinBlock> codec() {
        return CODEC;
    }

    public SculkVeinBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, false));
    }

    @Override
    public MultifaceSpreader getSpreader() {
        return this.veinSpreader;
    }

    public MultifaceSpreader getSameSpaceSpreader() {
        return this.sameSpaceSpreader;
    }

    public static boolean regrow(GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata, Collection<EnumDirection> collection) {
        boolean flag = false;
        IBlockData iblockdata1 = Blocks.SCULK_VEIN.defaultBlockState();
        for (EnumDirection enumdirection : collection) {
            BlockPosition blockposition1;
            if (!SculkVeinBlock.canAttachTo(generatoraccess, enumdirection, blockposition1 = blockposition.relative(enumdirection), generatoraccess.getBlockState(blockposition1))) continue;
            iblockdata1 = (IBlockData)iblockdata1.setValue(SculkVeinBlock.getFaceProperty(enumdirection), true);
            flag = true;
        }
        if (!flag) {
            return false;
        }
        if (!iblockdata.getFluidState().isEmpty()) {
            iblockdata1 = (IBlockData)iblockdata1.setValue(WATERLOGGED, true);
        }
        generatoraccess.setBlock(blockposition, iblockdata1, 3);
        return true;
    }

    @Override
    public void onDischarged(GeneratorAccess generatoraccess, IBlockData iblockdata, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.is(this)) {
            for (EnumDirection enumdirection : DIRECTIONS) {
                BlockStateBoolean blockstateboolean = SculkVeinBlock.getFaceProperty(enumdirection);
                if (!iblockdata.getValue(blockstateboolean).booleanValue() || !generatoraccess.getBlockState(blockposition.relative(enumdirection)).is(Blocks.SCULK)) continue;
                iblockdata = (IBlockData)iblockdata.setValue(blockstateboolean, false);
            }
            if (!SculkVeinBlock.hasAnyFace(iblockdata)) {
                Fluid fluid = generatoraccess.getFluidState(blockposition);
                iblockdata = (fluid.isEmpty() ? Blocks.AIR : Blocks.WATER).defaultBlockState();
            }
            generatoraccess.setBlock(blockposition, iblockdata, 3);
            SculkBehaviour.super.onDischarged(generatoraccess, iblockdata, blockposition, randomsource);
        }
    }

    @Override
    public int attemptUseCharge(SculkSpreader.a sculkspreader_a, GeneratorAccess generatoraccess, BlockPosition blockposition, RandomSource randomsource, SculkSpreader sculkspreader, boolean flag) {
        return flag && this.attemptPlaceSculk(sculkspreader, generatoraccess, sculkspreader_a.getPos(), randomsource, blockposition) ? sculkspreader_a.getCharge() - 1 : (randomsource.nextInt(sculkspreader.chargeDecayRate()) == 0 ? MathHelper.floor((float)sculkspreader_a.getCharge() * 0.5f) : sculkspreader_a.getCharge());
    }

    private boolean attemptPlaceSculk(SculkSpreader sculkspreader, GeneratorAccess generatoraccess, BlockPosition blockposition, RandomSource randomsource, BlockPosition sourceBlock) {
        IBlockData iblockdata = generatoraccess.getBlockState(blockposition);
        TagKey<Block> tagkey = sculkspreader.replaceableBlocks();
        for (EnumDirection enumdirection : EnumDirection.allShuffled(randomsource)) {
            BlockPosition blockposition1;
            IBlockData iblockdata1;
            if (!SculkVeinBlock.hasFace(iblockdata, enumdirection) || !(iblockdata1 = generatoraccess.getBlockState(blockposition1 = blockposition.relative(enumdirection))).is(tagkey)) continue;
            IBlockData iblockdata2 = Blocks.SCULK.defaultBlockState();
            if (!CraftEventFactory.handleBlockSpreadEvent(generatoraccess, sourceBlock, blockposition1, iblockdata2, 3)) {
                return false;
            }
            Block.pushEntitiesUp(iblockdata1, iblockdata2, generatoraccess, blockposition1);
            generatoraccess.playSound(null, blockposition1, SoundEffects.SCULK_BLOCK_SPREAD, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.veinSpreader.spreadAll(iblockdata2, generatoraccess, blockposition1, sculkspreader.isWorldGeneration());
            EnumDirection enumdirection1 = enumdirection.getOpposite();
            for (EnumDirection enumdirection2 : DIRECTIONS) {
                BlockPosition blockposition2;
                IBlockData iblockdata3;
                if (enumdirection2 == enumdirection1 || !(iblockdata3 = generatoraccess.getBlockState(blockposition2 = blockposition1.relative(enumdirection2))).is(this)) continue;
                this.onDischarged(generatoraccess, iblockdata3, blockposition2, randomsource);
            }
            return true;
        }
        return false;
    }

    public static boolean hasSubstrateAccess(GeneratorAccess generatoraccess, IBlockData iblockdata, BlockPosition blockposition) {
        if (!iblockdata.is(Blocks.SCULK_VEIN)) {
            return false;
        }
        for (EnumDirection enumdirection : DIRECTIONS) {
            if (!SculkVeinBlock.hasFace(iblockdata, enumdirection) || !generatoraccess.getBlockState(blockposition.relative(enumdirection)).is(TagsBlock.SCULK_REPLACEABLE)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        super.createBlockStateDefinition(blockstatelist_a);
        blockstatelist_a.add(WATERLOGGED);
    }

    @Override
    protected boolean canBeReplaced(IBlockData iblockdata, BlockActionContext blockactioncontext) {
        return !blockactioncontext.getItemInHand().is(Items.SCULK_VEIN) || super.canBeReplaced(iblockdata, blockactioncontext);
    }

    @Override
    protected Fluid getFluidState(IBlockData iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? FluidTypes.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    private class a
    extends MultifaceSpreader.a {
        private final MultifaceSpreader.e[] spreadTypes;

        public a(SculkVeinBlock sculkVeinBlock, SculkVeinBlock sculkveinblock, MultifaceSpreader.e ... amultifacespreader_e) {
            super(sculkveinblock);
            this.spreadTypes = amultifacespreader_e;
        }

        @Override
        public boolean stateCanBeReplaced(IBlockAccess iblockaccess, BlockPosition blockposition, BlockPosition blockposition1, EnumDirection enumdirection, IBlockData iblockdata) {
            IBlockData iblockdata1 = iblockaccess.getBlockState(blockposition1.relative(enumdirection));
            if (!(iblockdata1.is(Blocks.SCULK) || iblockdata1.is(Blocks.SCULK_CATALYST) || iblockdata1.is(Blocks.MOVING_PISTON))) {
                BlockPosition blockposition2;
                if (blockposition.distManhattan(blockposition1) == 2 && iblockaccess.getBlockState(blockposition2 = blockposition.relative(enumdirection.getOpposite())).isFaceSturdy(iblockaccess, blockposition2, enumdirection)) {
                    return false;
                }
                Fluid fluid = iblockdata.getFluidState();
                return !fluid.isEmpty() && !fluid.is(FluidTypes.WATER) ? false : (iblockdata.is(TagsBlock.FIRE) ? false : iblockdata.canBeReplaced() || super.stateCanBeReplaced(iblockaccess, blockposition, blockposition1, enumdirection, iblockdata));
            }
            return false;
        }

        @Override
        public MultifaceSpreader.e[] getSpreadTypes() {
            return this.spreadTypes;
        }

        @Override
        public boolean isOtherBlockValidAsSource(IBlockData iblockdata) {
            return !iblockdata.is(Blocks.SCULK_VEIN);
        }
    }
}

