/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public abstract class ContainerOpenersCounter {
    private static final int CHECK_TICK_DELAY = 5;
    private int openCount;
    private double maxInteractionRange;
    public boolean opened;

    protected abstract void onOpen(World var1, BlockPosition var2, IBlockData var3);

    protected abstract void onClose(World var1, BlockPosition var2, IBlockData var3);

    protected abstract void openerCountChanged(World var1, BlockPosition var2, IBlockData var3, int var4, int var5);

    public void onAPIOpen(World world, BlockPosition blockposition, IBlockData iblockdata) {
        this.onOpen(world, blockposition, iblockdata);
    }

    public void onAPIClose(World world, BlockPosition blockposition, IBlockData iblockdata) {
        this.onClose(world, blockposition, iblockdata);
    }

    public void openerAPICountChanged(World world, BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        this.openerCountChanged(world, blockposition, iblockdata, i2, j2);
    }

    protected abstract boolean isOwnContainer(EntityHuman var1);

    public void incrementOpeners(EntityHuman entityhuman, World world, BlockPosition blockposition, IBlockData iblockdata) {
        int newPower;
        int oldPower = Math.max(0, Math.min(15, this.openCount));
        int i2 = this.openCount++;
        if (world.getBlockState(blockposition).is(Blocks.TRAPPED_CHEST) && oldPower != (newPower = Math.max(0, Math.min(15, this.openCount)))) {
            CraftEventFactory.callRedstoneChange(world, blockposition, oldPower, newPower);
        }
        if (i2 == 0) {
            this.onOpen(world, blockposition, iblockdata);
            world.gameEvent((Entity)entityhuman, GameEvent.CONTAINER_OPEN, blockposition);
            ContainerOpenersCounter.scheduleRecheck(world, blockposition, iblockdata);
        }
        this.openerCountChanged(world, blockposition, iblockdata, i2, this.openCount);
        this.maxInteractionRange = Math.max(entityhuman.blockInteractionRange(), this.maxInteractionRange);
    }

    public void decrementOpeners(EntityHuman entityhuman, World world, BlockPosition blockposition, IBlockData iblockdata) {
        int newPower;
        int oldPower = Math.max(0, Math.min(15, this.openCount));
        int i2 = this.openCount--;
        if (world.getBlockState(blockposition).is(Blocks.TRAPPED_CHEST) && oldPower != (newPower = Math.max(0, Math.min(15, this.openCount)))) {
            CraftEventFactory.callRedstoneChange(world, blockposition, oldPower, newPower);
        }
        if (this.openCount == 0) {
            this.onClose(world, blockposition, iblockdata);
            world.gameEvent((Entity)entityhuman, GameEvent.CONTAINER_CLOSE, blockposition);
            this.maxInteractionRange = 0.0;
        }
        this.openerCountChanged(world, blockposition, iblockdata, i2, this.openCount);
    }

    private List<EntityHuman> getPlayersWithContainerOpen(World world, BlockPosition blockposition) {
        double d0 = this.maxInteractionRange + 4.0;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockposition).inflate(d0);
        return world.getEntities(EntityTypeTest.forClass(EntityHuman.class), axisalignedbb, this::isOwnContainer);
    }

    public void recheckOpeners(World world, BlockPosition blockposition, IBlockData iblockdata) {
        int j2;
        List<EntityHuman> list = this.getPlayersWithContainerOpen(world, blockposition);
        this.maxInteractionRange = 0.0;
        for (EntityHuman entityhuman : list) {
            this.maxInteractionRange = Math.max(entityhuman.blockInteractionRange(), this.maxInteractionRange);
        }
        int i2 = list.size();
        if (this.opened) {
            ++i2;
        }
        if ((j2 = this.openCount) != i2) {
            boolean flag1;
            boolean flag = i2 != 0;
            boolean bl = flag1 = j2 != 0;
            if (flag && !flag1) {
                this.onOpen(world, blockposition, iblockdata);
                world.gameEvent((Entity)null, GameEvent.CONTAINER_OPEN, blockposition);
            } else if (!flag) {
                this.onClose(world, blockposition, iblockdata);
                world.gameEvent((Entity)null, GameEvent.CONTAINER_CLOSE, blockposition);
            }
            this.openCount = i2;
        }
        this.openerCountChanged(world, blockposition, iblockdata, j2, i2);
        if (i2 > 0) {
            ContainerOpenersCounter.scheduleRecheck(world, blockposition, iblockdata);
        }
    }

    public int getOpenerCount() {
        return this.openCount;
    }

    private static void scheduleRecheck(World world, BlockPosition blockposition, IBlockData iblockdata) {
        world.scheduleTick(blockposition, iblockdata.getBlock(), 5);
    }
}

