/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;

public class CrafterBlockEntity
extends TileEntityLootable
implements InventoryCrafting {
    public static final int CONTAINER_WIDTH = 3;
    public static final int CONTAINER_HEIGHT = 3;
    public static final int CONTAINER_SIZE = 9;
    public static final int SLOT_DISABLED = 1;
    public static final int SLOT_ENABLED = 0;
    public static final int DATA_TRIGGERED = 9;
    public static final int NUM_DATA = 10;
    private NonNullList<ItemStack> items;
    public int craftingTicksRemaining = 0;
    protected final IContainerProperties containerData;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        if (this.level == null) {
            return null;
        }
        return new Location((org.bukkit.World)this.level.getWorld(), (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
    }

    public CrafterBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.CRAFTER, blockposition, iblockdata);
        this.items = NonNullList.withSize(9, ItemStack.EMPTY);
        this.containerData = new IContainerProperties(this){
            private final int[] slotStates = new int[9];
            private int triggered = 0;

            @Override
            public int get(int i2) {
                return i2 == 9 ? this.triggered : this.slotStates[i2];
            }

            @Override
            public void set(int i2, int j2) {
                if (i2 == 9) {
                    this.triggered = j2;
                } else {
                    this.slotStates[i2] = j2;
                }
            }

            @Override
            public int getCount() {
                return 10;
            }
        };
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.crafter");
    }

    @Override
    protected Container createMenu(int i2, PlayerInventory playerinventory) {
        return new CrafterMenu(i2, playerinventory, this, this.containerData);
    }

    public void setSlotState(int i2, boolean flag) {
        if (this.slotCanBeDisabled(i2)) {
            this.containerData.set(i2, flag ? 0 : 1);
            this.setChanged();
        }
    }

    public boolean isSlotDisabled(int i2) {
        return i2 >= 0 && i2 < 9 ? this.containerData.get(i2) == 1 : false;
    }

    @Override
    public boolean canPlaceItem(int i2, ItemStack itemstack) {
        if (this.containerData.get(i2) == 1) {
            return false;
        }
        ItemStack itemstack1 = this.items.get(i2);
        int j2 = itemstack1.getCount();
        return j2 >= itemstack1.getMaxStackSize() ? false : (itemstack1.isEmpty() ? true : !this.smallerStackExist(j2, itemstack1, i2));
    }

    private boolean smallerStackExist(int i2, ItemStack itemstack, int j2) {
        for (int k2 = j2 + 1; k2 < 9; ++k2) {
            ItemStack itemstack1;
            if (this.isSlotDisabled(k2) || !(itemstack1 = this.getItem(k2)).isEmpty() && (itemstack1.getCount() >= i2 || !ItemStack.isSameItemSameComponents(itemstack1, itemstack))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.craftingTicksRemaining = nbttagcompound.getInt("crafting_ticks_remaining");
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(nbttagcompound)) {
            ContainerUtil.loadAllItems(nbttagcompound, this.items, holderlookup_a);
        }
        int[] aint = nbttagcompound.getIntArray("disabled_slots");
        for (int i2 = 0; i2 < 9; ++i2) {
            this.containerData.set(i2, 0);
        }
        int[] aint1 = aint;
        int j2 = aint.length;
        for (int k2 = 0; k2 < j2; ++k2) {
            int l2 = aint1[k2];
            if (!this.slotCanBeDisabled(l2)) continue;
            this.containerData.set(l2, 1);
        }
        this.containerData.set(9, nbttagcompound.getInt("triggered"));
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        nbttagcompound.putInt("crafting_ticks_remaining", this.craftingTicksRemaining);
        if (!this.trySaveLootTable(nbttagcompound)) {
            ContainerUtil.saveAllItems(nbttagcompound, this.items, holderlookup_a);
        }
        this.addDisabledSlots(nbttagcompound);
        this.addTriggered(nbttagcompound);
    }

    @Override
    public int getContainerSize() {
        return 9;
    }

    @Override
    public boolean isEmpty() {
        ItemStack itemstack;
        Iterator iterator = this.items.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
        return false;
    }

    @Override
    public ItemStack getItem(int i2) {
        return this.items.get(i2);
    }

    @Override
    public void setItem(int i2, ItemStack itemstack) {
        if (this.isSlotDisabled(i2)) {
            this.setSlotState(i2, true);
        }
        super.setItem(i2, itemstack);
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return IInventory.stillValidBlockEntity(this, entityhuman);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    @Override
    public int getWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return 3;
    }

    @Override
    public void fillStackedContents(AutoRecipeStackManager autorecipestackmanager) {
        for (ItemStack itemstack : this.items) {
            autorecipestackmanager.accountSimpleStack(itemstack);
        }
    }

    private void addDisabledSlots(NBTTagCompound nbttagcompound) {
        IntArrayList intarraylist = new IntArrayList();
        for (int i2 = 0; i2 < 9; ++i2) {
            if (!this.isSlotDisabled(i2)) continue;
            intarraylist.add(i2);
        }
        nbttagcompound.putIntArray("disabled_slots", (List<Integer>)intarraylist);
    }

    private void addTriggered(NBTTagCompound nbttagcompound) {
        nbttagcompound.putInt("triggered", this.containerData.get(9));
    }

    public void setTriggered(boolean flag) {
        this.containerData.set(9, flag ? 1 : 0);
    }

    @VisibleForTesting
    public boolean isTriggered() {
        return this.containerData.get(9) == 1;
    }

    public static void serverTick(World world, BlockPosition blockposition, IBlockData iblockdata, CrafterBlockEntity crafterblockentity) {
        int i2 = crafterblockentity.craftingTicksRemaining - 1;
        if (i2 >= 0) {
            crafterblockentity.craftingTicksRemaining = i2;
            if (i2 == 0) {
                world.setBlock(blockposition, (IBlockData)iblockdata.setValue(CrafterBlock.CRAFTING, false), 3);
            }
        }
    }

    public void setCraftingTicksRemaining(int i2) {
        this.craftingTicksRemaining = i2;
    }

    public int getRedstoneSignal() {
        int i2 = 0;
        for (int j2 = 0; j2 < this.getContainerSize(); ++j2) {
            ItemStack itemstack = this.getItem(j2);
            if (itemstack.isEmpty() && !this.isSlotDisabled(j2)) continue;
            ++i2;
        }
        return i2;
    }

    private boolean slotCanBeDisabled(int i2) {
        return i2 > -1 && i2 < 9 && this.items.get(i2).isEmpty();
    }
}

