/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.FormattedString;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;

public class SignText {
    private static final Codec<IChatBaseComponent[]> LINES_CODEC = ComponentSerialization.FLAT_CODEC.listOf().comapFlatMap(var0 -> {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }, var0 -> List.of(var0[0], var0[1], var0[2], var0[3]));
    public static final Codec<SignText> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)LINES_CODEC.fieldOf("messages").forGetter(var0 -> var0.messages), (App)LINES_CODEC.lenientOptionalFieldOf("filtered_messages").forGetter(SignText::filteredMessages), (App)EnumColor.CODEC.fieldOf("color").orElse((Object)EnumColor.BLACK).forGetter(var0 -> var0.color), (App)Codec.BOOL.fieldOf("has_glowing_text").orElse((Object)false).forGetter(var0 -> var0.hasGlowingText)).apply((Applicative)var02, SignText::load));
    public static final int LINES = 4;
    private final IChatBaseComponent[] messages;
    private final IChatBaseComponent[] filteredMessages;
    private final EnumColor color;
    private final boolean hasGlowingText;
    @Nullable
    private FormattedString[] renderMessages;
    private boolean renderMessagedFiltered;

    public SignText() {
        this(SignText.emptyMessages(), SignText.emptyMessages(), EnumColor.BLACK, false);
    }

    public SignText(IChatBaseComponent[] var0, IChatBaseComponent[] var1, EnumColor var2, boolean var3) {
        this.messages = var0;
        this.filteredMessages = var1;
        this.color = var2;
        this.hasGlowingText = var3;
    }

    private static IChatBaseComponent[] emptyMessages() {
        return new IChatBaseComponent[]{CommonComponents.EMPTY, CommonComponents.EMPTY, CommonComponents.EMPTY, CommonComponents.EMPTY};
    }

    private static SignText load(IChatBaseComponent[] var0, Optional<IChatBaseComponent[]> var1, EnumColor var2, boolean var3) {
        return new SignText(var0, var1.orElse(Arrays.copyOf(var0, var0.length)), var2, var3);
    }

    public boolean hasGlowingText() {
        return this.hasGlowingText;
    }

    public SignText setHasGlowingText(boolean var0) {
        if (var0 == this.hasGlowingText) {
            return this;
        }
        return new SignText(this.messages, this.filteredMessages, this.color, var0);
    }

    public EnumColor getColor() {
        return this.color;
    }

    public SignText setColor(EnumColor var0) {
        if (var0 == this.getColor()) {
            return this;
        }
        return new SignText(this.messages, this.filteredMessages, var0, this.hasGlowingText);
    }

    public IChatBaseComponent getMessage(int var0, boolean var1) {
        return this.getMessages(var1)[var0];
    }

    public SignText setMessage(int var0, IChatBaseComponent var1) {
        return this.setMessage(var0, var1, var1);
    }

    public SignText setMessage(int var0, IChatBaseComponent var1, IChatBaseComponent var2) {
        IChatBaseComponent[] var3 = Arrays.copyOf(this.messages, this.messages.length);
        IChatBaseComponent[] var4 = Arrays.copyOf(this.filteredMessages, this.filteredMessages.length);
        var3[var0] = var1;
        var4[var0] = var2;
        return new SignText(var3, var4, this.color, this.hasGlowingText);
    }

    public boolean hasMessage(EntityHuman var02) {
        return Arrays.stream(this.getMessages(var02.isTextFilteringEnabled())).anyMatch(var0 -> !var0.getString().isEmpty());
    }

    public IChatBaseComponent[] getMessages(boolean var0) {
        return var0 ? this.filteredMessages : this.messages;
    }

    public FormattedString[] getRenderMessages(boolean var0, Function<IChatBaseComponent, FormattedString> var1) {
        if (this.renderMessages == null || this.renderMessagedFiltered != var0) {
            this.renderMessagedFiltered = var0;
            this.renderMessages = new FormattedString[4];
            for (int var2 = 0; var2 < 4; ++var2) {
                this.renderMessages[var2] = var1.apply(this.getMessage(var2, var0));
            }
        }
        return this.renderMessages;
    }

    private Optional<IChatBaseComponent[]> filteredMessages() {
        for (int var0 = 0; var0 < 4; ++var0) {
            if (this.filteredMessages[var0].equals(this.messages[var0])) continue;
            return Optional.of(this.filteredMessages);
        }
        return Optional.empty();
    }

    public boolean hasAnyClickCommands(EntityHuman var0) {
        for (IChatBaseComponent var4 : this.getMessages(var0.isTextFilteringEnabled())) {
            ChatModifier var5 = var4.getStyle();
            ChatClickable var6 = var5.getClickEvent();
            if (var6 == null || var6.getAction() != ChatClickable.EnumClickAction.RUN_COMMAND) continue;
            return true;
        }
        return false;
    }
}

