/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;
import org.spigotmc.CustomTimingsHandler;

public abstract class TileEntity {
    public CustomTimingsHandler tickTimer = SpigotTimings.getTileEntityTimings(this);
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final TileEntityTypes<?> type;
    @Nullable
    protected World level;
    protected final BlockPosition worldPosition;
    protected boolean remove;
    private IBlockData blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public TileEntity(TileEntityTypes<?> tileentitytypes, BlockPosition blockposition, IBlockData iblockdata) {
        this.type = tileentitytypes;
        this.worldPosition = blockposition.immutable();
        this.validateBlockState(iblockdata);
        this.blockState = iblockdata;
    }

    private void validateBlockState(IBlockData iblockdata) {
        if (!this.isValidBlockState(iblockdata)) {
            String s2 = this.getNameForReporting();
            throw new IllegalStateException("Invalid block entity " + s2 + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf(iblockdata));
        }
    }

    public boolean isValidBlockState(IBlockData iblockdata) {
        return this.type.isValid(iblockdata);
    }

    public static BlockPosition getPosFromTag(NBTTagCompound nbttagcompound) {
        return new BlockPosition(nbttagcompound.getInt("x"), nbttagcompound.getInt("y"), nbttagcompound.getInt("z"));
    }

    @Nullable
    public World getLevel() {
        return this.level;
    }

    public void setLevel(World world) {
        this.level = world;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
        NBTBase persistentDataTag = nbttagcompound.get("PublicBukkitValues");
        if (persistentDataTag instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)persistentDataTag);
        }
    }

    public final void loadWithComponents(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        this.loadAdditional(nbttagcompound, holderlookup_a);
        a.COMPONENTS_CODEC.parse(holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)nbttagcompound).resultOrPartial(s2 -> LOGGER.warn("Failed to load components: {}", s2)).ifPresent(datacomponentmap -> {
            this.components = datacomponentmap;
        });
    }

    public final void loadCustomOnly(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        this.loadAdditional(nbttagcompound, holderlookup_a);
    }

    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
    }

    public final NBTTagCompound saveWithFullMetadata(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.saveWithoutMetadata(holderlookup_a);
        this.saveMetadata(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound saveWithId(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.saveWithoutMetadata(holderlookup_a);
        this.saveId(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound saveWithoutMetadata(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.saveAdditional(nbttagcompound, holderlookup_a);
        a.COMPONENTS_CODEC.encodeStart(holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)this.components).resultOrPartial(s2 -> LOGGER.warn("Failed to save components: {}", s2)).ifPresent(nbtbase -> nbttagcompound.merge((NBTTagCompound)nbtbase));
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.put("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    public final NBTTagCompound saveCustomOnly(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.saveAdditional(nbttagcompound, holderlookup_a);
        return nbttagcompound;
    }

    public final NBTTagCompound saveCustomAndMetadata(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.saveCustomOnly(holderlookup_a);
        this.saveMetadata(nbttagcompound);
        return nbttagcompound;
    }

    private void saveId(NBTTagCompound nbttagcompound) {
        MinecraftKey minecraftkey = TileEntityTypes.getKey(this.getType());
        if (minecraftkey == null) {
            throw new RuntimeException(String.valueOf(this.getClass()) + " is missing a mapping! This is a bug!");
        }
        nbttagcompound.putString("id", minecraftkey.toString());
    }

    public static void addEntityType(NBTTagCompound nbttagcompound, TileEntityTypes<?> tileentitytypes) {
        nbttagcompound.putString("id", TileEntityTypes.getKey(tileentitytypes).toString());
    }

    public void saveToItem(ItemStack itemstack, HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.saveCustomOnly(holderlookup_a);
        this.removeComponentsFromTag(nbttagcompound);
        ItemBlock.setBlockEntityData(itemstack, this.getType(), nbttagcompound);
        itemstack.applyComponents(this.collectComponents());
    }

    private void saveMetadata(NBTTagCompound nbttagcompound) {
        this.saveId(nbttagcompound);
        nbttagcompound.putInt("x", this.worldPosition.getX());
        nbttagcompound.putInt("y", this.worldPosition.getY());
        nbttagcompound.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static TileEntity loadStatic(BlockPosition blockposition, IBlockData iblockdata, NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        String s2 = nbttagcompound.getString("id");
        MinecraftKey minecraftkey = MinecraftKey.tryParse(s2);
        if (minecraftkey == null) {
            LOGGER.error("Block entity has invalid type: {}", (Object)s2);
            return null;
        }
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(minecraftkey).map(tileentitytypes -> {
            try {
                return tileentitytypes.create(blockposition, iblockdata);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to create block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).map(tileentity -> {
            try {
                tileentity.loadWithComponents(nbttagcompound, holderlookup_a);
                return tileentity;
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to load data for block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).orElseGet(() -> {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)s2);
            return null;
        });
    }

    public void setChanged() {
        if (this.level != null) {
            TileEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(World world, BlockPosition blockposition, IBlockData iblockdata) {
        world.blockEntityChanged(blockposition);
        if (!iblockdata.isAir()) {
            world.updateNeighbourForOutputSignal(blockposition, iblockdata.getBlock());
        }
    }

    public BlockPosition getBlockPos() {
        return this.worldPosition;
    }

    public IBlockData getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> getUpdatePacket() {
        return null;
    }

    public NBTTagCompound getUpdateTag(HolderLookup.a holderlookup_a) {
        return new NBTTagCompound();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public boolean triggerEvent(int i2, int j2) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.setDetail("Name", this::getNameForReporting);
        if (this.level != null) {
            CrashReportSystemDetails.populateBlockDetails(crashreportsystemdetails, this.level, this.worldPosition, this.getBlockState());
            CrashReportSystemDetails.populateBlockDetails(crashreportsystemdetails, this.level, this.worldPosition, this.level.getBlockState(this.worldPosition));
        }
    }

    private String getNameForReporting() {
        String s2 = String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType()));
        return s2 + " // " + this.getClass().getCanonicalName();
    }

    public boolean onlyOpCanSetNbt() {
        return false;
    }

    public TileEntityTypes<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(IBlockData iblockdata) {
        this.validateBlockState(iblockdata);
        this.blockState = iblockdata;
    }

    protected void applyImplicitComponents(b tileentity_b) {
    }

    public final void applyComponentsFromItemStack(ItemStack itemstack) {
        this.applyComponents(itemstack.getPrototype(), itemstack.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        this.applyComponentsSet(datacomponentmap, datacomponentpatch);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.BLOCK_ENTITY_DATA);
        final PatchedDataComponentMap patcheddatacomponentmap = PatchedDataComponentMap.fromPatch(datacomponentmap, datacomponentpatch);
        this.applyImplicitComponents(new b(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<T> datacomponenttype) {
                set.add(datacomponenttype);
                return patcheddatacomponentmap.get(datacomponenttype);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> datacomponenttype, T t0) {
                set.add(datacomponenttype);
                return patcheddatacomponentmap.getOrDefault(datacomponenttype, t0);
            }
        });
        Objects.requireNonNull(set);
        DataComponentPatch datacomponentpatch1 = datacomponentpatch.forget(set::contains);
        this.components = datacomponentpatch1.split().added();
        set.remove(DataComponents.BLOCK_ENTITY_DATA);
        return set;
    }

    protected void collectImplicitComponents(DataComponentMap.a datacomponentmap_a) {
    }

    @Deprecated
    public void removeComponentsFromTag(NBTTagCompound nbttagcompound) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.a datacomponentmap_a = DataComponentMap.builder();
        datacomponentmap_a.addAll(this.components);
        this.collectImplicitComponents(datacomponentmap_a);
        return datacomponentmap_a.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap datacomponentmap) {
        this.components = datacomponentmap;
    }

    @Nullable
    public static IChatBaseComponent parseCustomNameSafe(String s2, HolderLookup.a holderlookup_a) {
        try {
            return IChatBaseComponent.ChatSerializer.fromJson(s2, holderlookup_a);
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to parse custom name from string '{}', discarding", (Object)s2, (Object)exception);
            return null;
        }
    }

    public InventoryHolder getOwner() {
        if (this.level == null) {
            return null;
        }
        BlockState state = this.level.getWorld().getBlockAt(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ()).getState();
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    private static class a {
        public static final Codec<DataComponentMap> COMPONENTS_CODEC = DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY).codec();

        private a() {
        }
    }

    protected static interface b {
        @Nullable
        public <T> T get(DataComponentType<T> var1);

        public <T> T getOrDefault(DataComponentType<? extends T> var1, T var2);
    }
}

