/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBarrel;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;

public class TileEntityBarrel
extends TileEntityLootable {
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    private NonNullList<ItemStack> items = NonNullList.withSize(27, ItemStack.EMPTY);
    public final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        @Override
        protected void onOpen(World world, BlockPosition blockposition1, IBlockData iblockdata1) {
            TileEntityBarrel.this.playSound(iblockdata1, SoundEffects.BARREL_OPEN);
            TileEntityBarrel.this.updateBlockState(iblockdata1, true);
        }

        @Override
        protected void onClose(World world, BlockPosition blockposition1, IBlockData iblockdata1) {
            TileEntityBarrel.this.playSound(iblockdata1, SoundEffects.BARREL_CLOSE);
            TileEntityBarrel.this.updateBlockState(iblockdata1, false);
        }

        @Override
        protected void openerCountChanged(World world, BlockPosition blockposition1, IBlockData iblockdata1, int i2, int j2) {
        }

        @Override
        protected boolean isOwnContainer(EntityHuman entityhuman) {
            if (entityhuman.containerMenu instanceof ContainerChest) {
                IInventory iinventory = ((ContainerChest)entityhuman.containerMenu).getContainer();
                return iinventory == TileEntityBarrel.this;
            }
            return false;
        }
    };

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int i2) {
        this.maxStack = i2;
    }

    public TileEntityBarrel(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.BARREL, blockposition, iblockdata);
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        if (!this.trySaveLootTable(nbttagcompound)) {
            ContainerUtil.saveAllItems(nbttagcompound, this.items, holderlookup_a);
        }
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(nbttagcompound)) {
            ContainerUtil.loadAllItems(nbttagcompound, this.items, holderlookup_a);
        }
    }

    @Override
    public int getContainerSize() {
        return 27;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.barrel");
    }

    @Override
    protected Container createMenu(int i2, PlayerInventory playerinventory) {
        return ContainerChest.threeRows(i2, playerinventory, this);
    }

    @Override
    public void startOpen(EntityHuman entityhuman) {
        if (!this.remove && !entityhuman.isSpectator()) {
            this.openersCounter.incrementOpeners(entityhuman, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    public void stopOpen(EntityHuman entityhuman) {
        if (!this.remove && !entityhuman.isSpectator()) {
            this.openersCounter.decrementOpeners(entityhuman, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void updateBlockState(IBlockData iblockdata, boolean flag) {
        this.level.setBlock(this.getBlockPos(), (IBlockData)iblockdata.setValue(BlockBarrel.OPEN, flag), 3);
    }

    public void playSound(IBlockData iblockdata, SoundEffect soundeffect) {
        BaseBlockPosition baseblockposition = iblockdata.getValue(BlockBarrel.FACING).getNormal();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)baseblockposition.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)baseblockposition.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)baseblockposition.getZ() / 2.0;
        this.level.playSound((EntityHuman)null, d0, d1, d2, soundeffect, SoundCategory.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }
}

