/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ColorUtil;
import net.minecraft.world.ChestLock;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBeaconBeam;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionUtil;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffect;

public class TileEntityBeacon
extends TileEntity
implements ITileInventory,
INamableTileEntity {
    private static final int MAX_LEVELS = 4;
    public static final List<List<Holder<MobEffectList>>> BEACON_EFFECTS = List.of(List.of(MobEffects.MOVEMENT_SPEED, MobEffects.DIG_SPEED), List.of(MobEffects.DAMAGE_RESISTANCE, MobEffects.JUMP), List.of(MobEffects.DAMAGE_BOOST), List.of(MobEffects.REGENERATION));
    private static final Set<Holder<MobEffectList>> VALID_EFFECTS = BEACON_EFFECTS.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    public static final int DATA_LEVELS = 0;
    public static final int DATA_PRIMARY = 1;
    public static final int DATA_SECONDARY = 2;
    public static final int NUM_DATA_VALUES = 3;
    private static final int BLOCKS_CHECK_PER_TICK = 10;
    private static final IChatBaseComponent DEFAULT_NAME = IChatBaseComponent.translatable("container.beacon");
    private static final String TAG_PRIMARY = "primary_effect";
    private static final String TAG_SECONDARY = "secondary_effect";
    List<BeaconColorTracker> beamSections = Lists.newArrayList();
    private List<BeaconColorTracker> checkingBeamSections = Lists.newArrayList();
    public int levels;
    private int lastCheckY;
    @Nullable
    public Holder<MobEffectList> primaryPower;
    @Nullable
    public Holder<MobEffectList> secondaryPower;
    @Nullable
    public IChatBaseComponent name;
    public ChestLock lockKey = ChestLock.NO_LOCK;
    private final IContainerProperties dataAccess = new IContainerProperties(){

        @Override
        public int get(int i2) {
            return switch (i2) {
                case 0 -> TileEntityBeacon.this.levels;
                case 1 -> ContainerBeacon.encodeEffect(TileEntityBeacon.this.primaryPower);
                case 2 -> ContainerBeacon.encodeEffect(TileEntityBeacon.this.secondaryPower);
                default -> 0;
            };
        }

        @Override
        public void set(int i2, int j2) {
            switch (i2) {
                case 0: {
                    TileEntityBeacon.this.levels = j2;
                    break;
                }
                case 1: {
                    if (!TileEntityBeacon.this.level.isClientSide && !TileEntityBeacon.this.beamSections.isEmpty()) {
                        TileEntityBeacon.playSound(TileEntityBeacon.this.level, TileEntityBeacon.this.worldPosition, SoundEffects.BEACON_POWER_SELECT);
                    }
                    TileEntityBeacon.this.primaryPower = TileEntityBeacon.filterEffect(ContainerBeacon.decodeEffect(j2));
                    break;
                }
                case 2: {
                    TileEntityBeacon.this.secondaryPower = TileEntityBeacon.filterEffect(ContainerBeacon.decodeEffect(j2));
                }
            }
        }

        @Override
        public int getCount() {
            return 3;
        }
    };

    public PotionEffect getPrimaryEffect() {
        return this.primaryPower != null ? CraftPotionUtil.toBukkit(new MobEffect(this.primaryPower, TileEntityBeacon.getLevel(this.levels), TileEntityBeacon.getAmplification(this.levels, this.primaryPower, this.secondaryPower), true, true)) : null;
    }

    public PotionEffect getSecondaryEffect() {
        return TileEntityBeacon.hasSecondaryEffect(this.levels, this.primaryPower, this.secondaryPower) ? CraftPotionUtil.toBukkit(new MobEffect(this.secondaryPower, TileEntityBeacon.getLevel(this.levels), TileEntityBeacon.getAmplification(this.levels, this.primaryPower, this.secondaryPower), true, true)) : null;
    }

    @Nullable
    static Holder<MobEffectList> filterEffect(@Nullable Holder<MobEffectList> holder) {
        return VALID_EFFECTS.contains(holder) ? holder : null;
    }

    public TileEntityBeacon(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.BEACON, blockposition, iblockdata);
    }

    public static void tick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityBeacon tileentitybeacon) {
        int i1;
        BlockPosition blockposition1;
        int i2 = blockposition.getX();
        int j2 = blockposition.getY();
        int k2 = blockposition.getZ();
        if (tileentitybeacon.lastCheckY < j2) {
            blockposition1 = blockposition;
            tileentitybeacon.checkingBeamSections = Lists.newArrayList();
            tileentitybeacon.lastCheckY = blockposition.getY() - 1;
        } else {
            blockposition1 = new BlockPosition(i2, tileentitybeacon.lastCheckY + 1, k2);
        }
        BeaconColorTracker tileentitybeacon_beaconcolortracker = tileentitybeacon.checkingBeamSections.isEmpty() ? null : tileentitybeacon.checkingBeamSections.get(tileentitybeacon.checkingBeamSections.size() - 1);
        int l2 = world.getHeight(HeightMap.Type.WORLD_SURFACE, i2, k2);
        for (i1 = 0; i1 < 10 && blockposition1.getY() <= l2; ++i1) {
            IBlockData iblockdata1 = world.getBlockState(blockposition1);
            Block block = iblockdata1.getBlock();
            if (block instanceof IBeaconBeam) {
                IBeaconBeam ibeaconbeam = (IBeaconBeam)((Object)block);
                int j1 = ibeaconbeam.getColor().getTextureDiffuseColor();
                if (tileentitybeacon.checkingBeamSections.size() <= 1) {
                    tileentitybeacon_beaconcolortracker = new BeaconColorTracker(j1);
                    tileentitybeacon.checkingBeamSections.add(tileentitybeacon_beaconcolortracker);
                } else if (tileentitybeacon_beaconcolortracker != null) {
                    if (j1 == tileentitybeacon_beaconcolortracker.color) {
                        tileentitybeacon_beaconcolortracker.increaseHeight();
                    } else {
                        tileentitybeacon_beaconcolortracker = new BeaconColorTracker(ColorUtil.b.average(tileentitybeacon_beaconcolortracker.color, j1));
                        tileentitybeacon.checkingBeamSections.add(tileentitybeacon_beaconcolortracker);
                    }
                }
            } else {
                if (tileentitybeacon_beaconcolortracker == null || iblockdata1.getLightBlock(world, blockposition1) >= 15 && !iblockdata1.is(Blocks.BEDROCK)) {
                    tileentitybeacon.checkingBeamSections.clear();
                    tileentitybeacon.lastCheckY = l2;
                    break;
                }
                tileentitybeacon_beaconcolortracker.increaseHeight();
            }
            blockposition1 = blockposition1.above();
            ++tileentitybeacon.lastCheckY;
        }
        i1 = tileentitybeacon.levels;
        if (world.getGameTime() % 80L == 0L) {
            if (!tileentitybeacon.beamSections.isEmpty()) {
                tileentitybeacon.levels = TileEntityBeacon.updateBase(world, i2, j2, k2);
            }
            if (tileentitybeacon.levels > 0 && !tileentitybeacon.beamSections.isEmpty()) {
                TileEntityBeacon.applyEffects(world, blockposition, tileentitybeacon.levels, tileentitybeacon.primaryPower, tileentitybeacon.secondaryPower);
                TileEntityBeacon.playSound(world, blockposition, SoundEffects.BEACON_AMBIENT);
            }
        }
        if (tileentitybeacon.lastCheckY >= l2) {
            tileentitybeacon.lastCheckY = world.getMinBuildHeight() - 1;
            boolean flag = i1 > 0;
            tileentitybeacon.beamSections = tileentitybeacon.checkingBeamSections;
            if (!world.isClientSide) {
                boolean flag1;
                boolean bl = flag1 = tileentitybeacon.levels > 0;
                if (!flag && flag1) {
                    TileEntityBeacon.playSound(world, blockposition, SoundEffects.BEACON_ACTIVATE);
                    for (EntityPlayer entityplayer : world.getEntitiesOfClass(EntityPlayer.class, new AxisAlignedBB(i2, j2, k2, i2, j2 - 4, k2).inflate(10.0, 5.0, 10.0))) {
                        CriterionTriggers.CONSTRUCT_BEACON.trigger(entityplayer, tileentitybeacon.levels);
                    }
                } else if (flag && !flag1) {
                    TileEntityBeacon.playSound(world, blockposition, SoundEffects.BEACON_DEACTIVATE);
                }
            }
        }
    }

    private static int updateBase(World world, int i2, int j2, int k2) {
        int j1;
        int l2 = 0;
        int i1 = 1;
        while (i1 <= 4 && (j1 = j2 - i1) >= world.getMinBuildHeight()) {
            boolean flag = true;
            block1: for (int k1 = i2 - i1; k1 <= i2 + i1 && flag; ++k1) {
                for (int l1 = k2 - i1; l1 <= k2 + i1; ++l1) {
                    if (world.getBlockState(new BlockPosition(k1, j1, l1)).is(TagsBlock.BEACON_BASE_BLOCKS)) continue;
                    flag = false;
                    continue block1;
                }
            }
            if (!flag) break;
            l2 = i1++;
        }
        return l2;
    }

    @Override
    public void setRemoved() {
        TileEntityBeacon.playSound(this.level, this.worldPosition, SoundEffects.BEACON_DEACTIVATE);
        super.setRemoved();
    }

    private static byte getAmplification(int i2, @Nullable Holder<MobEffectList> holder, @Nullable Holder<MobEffectList> holder1) {
        byte b0 = 0;
        if (i2 >= 4 && Objects.equals(holder, holder1)) {
            b0 = 1;
        }
        return b0;
    }

    private static int getLevel(int i2) {
        int j2 = (9 + i2 * 2) * 20;
        return j2;
    }

    public static List getHumansInRange(World world, BlockPosition blockposition, int i2) {
        double d0 = i2 * 10 + 10;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockposition).inflate(d0).expandTowards(0.0, world.getHeight(), 0.0);
        List<EntityHuman> list = world.getEntitiesOfClass(EntityHuman.class, axisalignedbb);
        return list;
    }

    private static void applyEffect(List list, @Nullable Holder<MobEffectList> holder, int j2, int b0) {
        for (EntityHuman entityhuman : list) {
            entityhuman.addEffect(new MobEffect(holder, j2, b0, true, true), EntityPotionEffectEvent.Cause.BEACON);
        }
    }

    private static boolean hasSecondaryEffect(int i2, @Nullable Holder<MobEffectList> holder, @Nullable Holder<MobEffectList> holder1) {
        return i2 >= 4 && !Objects.equals(holder, holder1) && holder1 != null;
    }

    private static void applyEffects(World world, BlockPosition blockposition, int i2, @Nullable Holder<MobEffectList> holder, @Nullable Holder<MobEffectList> holder1) {
        if (!world.isClientSide && holder != null) {
            double d0 = i2 * 10 + 10;
            byte b0 = TileEntityBeacon.getAmplification(i2, holder, holder1);
            int j2 = TileEntityBeacon.getLevel(i2);
            List list = TileEntityBeacon.getHumansInRange(world, blockposition, i2);
            TileEntityBeacon.applyEffect(list, holder, j2, b0);
            if (TileEntityBeacon.hasSecondaryEffect(i2, holder, holder1)) {
                TileEntityBeacon.applyEffect(list, holder1, j2, 0);
            }
        }
    }

    public static void playSound(World world, BlockPosition blockposition, SoundEffect soundeffect) {
        world.playSound((EntityHuman)null, blockposition, soundeffect, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public List<BeaconColorTracker> getBeamSections() {
        return this.levels == 0 ? ImmutableList.of() : this.beamSections;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a holderlookup_a) {
        return this.saveCustomOnly(holderlookup_a);
    }

    private static void storeEffect(NBTTagCompound nbttagcompound, String s2, @Nullable Holder<MobEffectList> holder) {
        if (holder != null) {
            holder.unwrapKey().ifPresent(resourcekey -> nbttagcompound.putString(s2, resourcekey.location().toString()));
        }
    }

    @Nullable
    private static Holder<MobEffectList> loadEffect(NBTTagCompound nbttagcompound, String s2) {
        if (nbttagcompound.contains(s2, 8)) {
            MinecraftKey minecraftkey = MinecraftKey.tryParse(nbttagcompound.getString(s2));
            return minecraftkey == null ? null : (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(minecraftkey).orElse(null);
        }
        return null;
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.primaryPower = TileEntityBeacon.loadEffect(nbttagcompound, TAG_PRIMARY);
        this.secondaryPower = TileEntityBeacon.loadEffect(nbttagcompound, TAG_SECONDARY);
        this.levels = nbttagcompound.getInt("Levels");
        if (nbttagcompound.contains("CustomName", 8)) {
            this.name = TileEntityBeacon.parseCustomNameSafe(nbttagcompound.getString("CustomName"), holderlookup_a);
        }
        this.lockKey = ChestLock.fromTag(nbttagcompound);
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        TileEntityBeacon.storeEffect(nbttagcompound, TAG_PRIMARY, this.primaryPower);
        TileEntityBeacon.storeEffect(nbttagcompound, TAG_SECONDARY, this.secondaryPower);
        nbttagcompound.putInt("Levels", this.levels);
        if (this.name != null) {
            nbttagcompound.putString("CustomName", IChatBaseComponent.ChatSerializer.toJson(this.name, holderlookup_a));
        }
        this.lockKey.addToTag(nbttagcompound);
    }

    public void setCustomName(@Nullable IChatBaseComponent ichatbasecomponent) {
        this.name = ichatbasecomponent;
    }

    @Override
    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.name;
    }

    @Override
    @Nullable
    public Container createMenu(int i2, PlayerInventory playerinventory, EntityHuman entityhuman) {
        return TileEntityContainer.canUnlock(entityhuman, this.lockKey, this.getDisplayName()) ? new ContainerBeacon(i2, playerinventory, this.dataAccess, ContainerAccess.create(this.level, this.getBlockPos())) : null;
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        return this.getName();
    }

    @Override
    public IChatBaseComponent getName() {
        return this.name != null ? this.name : DEFAULT_NAME;
    }

    @Override
    protected void applyImplicitComponents(TileEntity.b tileentity_b) {
        super.applyImplicitComponents(tileentity_b);
        this.name = tileentity_b.get(DataComponents.CUSTOM_NAME);
        this.lockKey = tileentity_b.getOrDefault(DataComponents.LOCK, ChestLock.NO_LOCK);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a datacomponentmap_a) {
        super.collectImplicitComponents(datacomponentmap_a);
        datacomponentmap_a.set(DataComponents.CUSTOM_NAME, this.name);
        if (!this.lockKey.equals(ChestLock.NO_LOCK)) {
            datacomponentmap_a.set(DataComponents.LOCK, this.lockKey);
        }
    }

    @Override
    public void removeComponentsFromTag(NBTTagCompound nbttagcompound) {
        nbttagcompound.remove("CustomName");
        nbttagcompound.remove("Lock");
    }

    @Override
    public void setLevel(World world) {
        super.setLevel(world);
        this.lastCheckY = world.getMinBuildHeight() - 1;
    }

    public static class BeaconColorTracker {
        final int color;
        private int height;

        public BeaconColorTracker(int i2) {
            this.color = i2;
            this.height = 1;
        }

        protected void increaseHeight() {
            ++this.height;
        }

        public int getColor() {
            return this.color;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

