/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.slf4j.Logger;

public class TileEntityBeehive
extends TileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_FLOWER_POS = "flower_pos";
    private static final String BEES = "bees";
    static final List<String> IGNORED_BEE_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "hive_pos", "Passengers", "leash", "UUID");
    public static final int MAX_OCCUPANTS = 3;
    private static final int MIN_TICKS_BEFORE_REENTERING_HIVE = 400;
    private static final int MIN_OCCUPATION_TICKS_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_NECTARLESS = 600;
    private List<HiveBee> stored = Lists.newArrayList();
    @Nullable
    public BlockPosition savedFlowerPos;
    public int maxBees = 3;

    public TileEntityBeehive(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.BEEHIVE, blockposition, iblockdata);
    }

    @Override
    public void setChanged() {
        if (this.isFireNearby()) {
            this.emptyAllLivingFromHive(null, this.level.getBlockState(this.getBlockPos()), ReleaseStatus.EMERGENCY);
        }
        super.setChanged();
    }

    public boolean isFireNearby() {
        BlockPosition blockposition;
        if (this.level == null) {
            return false;
        }
        Iterator<BlockPosition> iterator = BlockPosition.betweenClosed(this.worldPosition.offset(-1, -1, -1), this.worldPosition.offset(1, 1, 1)).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(this.level.getBlockState(blockposition = iterator.next()).getBlock() instanceof BlockFire));
        return true;
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == this.maxBees;
    }

    public void emptyAllLivingFromHive(@Nullable EntityHuman entityhuman, IBlockData iblockdata, ReleaseStatus tileentitybeehive_releasestatus) {
        List<net.minecraft.world.entity.Entity> list = this.releaseAllOccupants(iblockdata, tileentitybeehive_releasestatus);
        if (entityhuman != null) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (!(entity instanceof EntityBee)) continue;
                EntityBee entitybee = (EntityBee)entity;
                if (!(entityhuman.position().distanceToSqr(entity.position()) <= 16.0)) continue;
                if (!this.isSedated()) {
                    entitybee.setTarget(entityhuman, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
                    continue;
                }
                entitybee.setStayOutOfHiveCountdown(400);
            }
        }
    }

    private List<net.minecraft.world.entity.Entity> releaseAllOccupants(IBlockData iblockdata, ReleaseStatus tileentitybeehive_releasestatus) {
        return this.releaseBees(iblockdata, tileentitybeehive_releasestatus, false);
    }

    public List<net.minecraft.world.entity.Entity> releaseBees(IBlockData iblockdata, ReleaseStatus tileentitybeehive_releasestatus, boolean force) {
        ArrayList list = Lists.newArrayList();
        this.stored.removeIf(tileentitybeehive_hivebee -> TileEntityBeehive.releaseOccupant(this.level, this.worldPosition, iblockdata, tileentitybeehive_hivebee.toOccupant(), list, tileentitybeehive_releasestatus, this.savedFlowerPos, force));
        if (!list.isEmpty()) {
            super.setChanged();
        }
        return list;
    }

    @VisibleForDebug
    public int getOccupantCount() {
        return this.stored.size();
    }

    public static int getHoneyLevel(IBlockData iblockdata) {
        return iblockdata.getValue(BlockBeehive.HONEY_LEVEL);
    }

    @VisibleForDebug
    public boolean isSedated() {
        return BlockCampfire.isSmokeyPos(this.level, this.getBlockPos());
    }

    public void addOccupant(net.minecraft.world.entity.Entity entity) {
        if (this.stored.size() < this.maxBees) {
            if (this.level != null) {
                EntityEnterBlockEvent event = new EntityEnterBlockEvent((Entity)entity.getBukkitEntity(), (Block)CraftBlock.at(this.level, this.getBlockPos()));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    if (entity instanceof EntityBee) {
                        ((EntityBee)entity).setStayOutOfHiveCountdown(400);
                    }
                    return;
                }
            }
            entity.stopRiding();
            entity.ejectPassengers();
            this.storeBee(c.of(entity));
            if (this.level != null) {
                EntityBee entitybee;
                if (entity instanceof EntityBee && (entitybee = (EntityBee)entity).hasSavedFlowerPos() && (!this.hasSavedFlowerPos() || this.level.random.nextBoolean())) {
                    this.savedFlowerPos = entitybee.getSavedFlowerPos();
                }
                BlockPosition blockposition = this.getBlockPos();
                this.level.playSound((EntityHuman)null, (double)blockposition.getX(), (double)blockposition.getY(), (double)blockposition.getZ(), SoundEffects.BEEHIVE_ENTER, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.level.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.a.of(entity, this.getBlockState()));
            }
            entity.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
            super.setChanged();
        }
    }

    public void storeBee(c tileentitybeehive_c) {
        this.stored.add(new HiveBee(tileentitybeehive_c));
    }

    private static boolean releaseOccupant(World world, BlockPosition blockposition, IBlockData iblockdata, c tileentitybeehive_c, @Nullable List<net.minecraft.world.entity.Entity> list, ReleaseStatus tileentitybeehive_releasestatus, @Nullable BlockPosition blockposition1) {
        return TileEntityBeehive.releaseOccupant(world, blockposition, iblockdata, tileentitybeehive_c, list, tileentitybeehive_releasestatus, blockposition1, false);
    }

    private static boolean releaseOccupant(World world, BlockPosition blockposition, IBlockData iblockdata, c tileentitybeehive_c, @Nullable List<net.minecraft.world.entity.Entity> list, ReleaseStatus tileentitybeehive_releasestatus, @Nullable BlockPosition blockposition1, boolean force) {
        boolean flag;
        if (!force && (world.isNight() || world.isRaining()) && tileentitybeehive_releasestatus != ReleaseStatus.EMERGENCY) {
            return false;
        }
        EnumDirection enumdirection = iblockdata.getValue(BlockBeehive.FACING);
        BlockPosition blockposition2 = blockposition.relative(enumdirection);
        boolean bl = flag = !world.getBlockState(blockposition2).getCollisionShape(world, blockposition2).isEmpty();
        if (flag && tileentitybeehive_releasestatus != ReleaseStatus.EMERGENCY) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = tileentitybeehive_c.createEntity(world, blockposition);
        if (entity != null) {
            if (entity instanceof EntityBee) {
                float f2 = entity.getBbWidth();
                double d0 = flag ? 0.0 : 0.55 + (double)(f2 / 2.0f);
                double d1 = (double)blockposition.getX() + 0.5 + d0 * (double)enumdirection.getStepX();
                double d2 = (double)blockposition.getY() + 0.5 - (double)(entity.getBbHeight() / 2.0f);
                double d3 = (double)blockposition.getZ() + 0.5 + d0 * (double)enumdirection.getStepZ();
                entity.moveTo(d1, d2, d3, entity.getYRot(), entity.getXRot());
            }
            if (!world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.BEEHIVE)) {
                return false;
            }
            if (entity instanceof EntityBee) {
                EntityBee entitybee = (EntityBee)entity;
                if (blockposition1 != null && !entitybee.hasSavedFlowerPos() && world.random.nextFloat() < 0.9f) {
                    entitybee.setSavedFlowerPos(blockposition1);
                }
                if (tileentitybeehive_releasestatus == ReleaseStatus.HONEY_DELIVERED) {
                    int i2;
                    entitybee.dropOffNectar();
                    if (iblockdata.is(TagsBlock.BEEHIVES, blockbase_blockdata -> blockbase_blockdata.hasProperty(BlockBeehive.HONEY_LEVEL)) && (i2 = TileEntityBeehive.getHoneyLevel(iblockdata)) < 5) {
                        int j2;
                        int n2 = j2 = world.random.nextInt(100) == 0 ? 2 : 1;
                        if (i2 + j2 > 5) {
                            --j2;
                        }
                        world.setBlockAndUpdate(blockposition, (IBlockData)iblockdata.setValue(BlockBeehive.HONEY_LEVEL, i2 + j2));
                    }
                }
                if (list != null) {
                    list.add(entitybee);
                }
            }
            world.playSound((EntityHuman)null, blockposition, SoundEffects.BEEHIVE_EXIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.a.of(entity, world.getBlockState(blockposition)));
            return true;
        }
        return false;
    }

    private boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    private static void tickOccupants(World world, BlockPosition blockposition, IBlockData iblockdata, List<HiveBee> list, @Nullable BlockPosition blockposition1) {
        boolean flag = false;
        Iterator<HiveBee> iterator = list.iterator();
        while (iterator.hasNext()) {
            ReleaseStatus tileentitybeehive_releasestatus;
            HiveBee tileentitybeehive_hivebee = iterator.next();
            if (!tileentitybeehive_hivebee.tick()) continue;
            ReleaseStatus releaseStatus = tileentitybeehive_releasestatus = tileentitybeehive_hivebee.hasNectar() ? ReleaseStatus.HONEY_DELIVERED : ReleaseStatus.BEE_RELEASED;
            if (TileEntityBeehive.releaseOccupant(world, blockposition, iblockdata, tileentitybeehive_hivebee.toOccupant(), null, tileentitybeehive_releasestatus, blockposition1)) {
                flag = true;
                iterator.remove();
                continue;
            }
            tileentitybeehive_hivebee.ticksInHive = tileentitybeehive_hivebee.occupant.minTicksInHive / 2;
        }
        if (flag) {
            TileEntityBeehive.setChanged(world, blockposition, iblockdata);
        }
    }

    public static void serverTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityBeehive tileentitybeehive) {
        TileEntityBeehive.tickOccupants(world, blockposition, iblockdata, tileentitybeehive.stored, tileentitybeehive.savedFlowerPos);
        if (!tileentitybeehive.stored.isEmpty() && world.getRandom().nextDouble() < 0.005) {
            double d0 = (double)blockposition.getX() + 0.5;
            double d1 = blockposition.getY();
            double d2 = (double)blockposition.getZ() + 0.5;
            world.playSound((EntityHuman)null, d0, d1, d2, SoundEffects.BEEHIVE_WORK, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        PacketDebug.sendHiveInfo(world, blockposition, iblockdata, tileentitybeehive);
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.stored = Lists.newArrayList();
        if (nbttagcompound.contains(BEES)) {
            c.LIST_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.get(BEES)).resultOrPartial(s2 -> LOGGER.error("Failed to parse bees: '{}'", s2)).ifPresent(list -> list.forEach(this::storeBee));
        }
        this.savedFlowerPos = GameProfileSerializer.readBlockPos(nbttagcompound, TAG_FLOWER_POS).orElse(null);
        if (nbttagcompound.contains("Bukkit.MaxEntities")) {
            this.maxBees = nbttagcompound.getInt("Bukkit.MaxEntities");
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        nbttagcompound.put(BEES, (NBTBase)c.LIST_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, this.getBees()).getOrThrow());
        if (this.hasSavedFlowerPos()) {
            nbttagcompound.put(TAG_FLOWER_POS, GameProfileSerializer.writeBlockPos(this.savedFlowerPos));
        }
        nbttagcompound.putInt("Bukkit.MaxEntities", this.maxBees);
    }

    @Override
    protected void applyImplicitComponents(TileEntity.b tileentity_b) {
        super.applyImplicitComponents(tileentity_b);
        this.stored = Lists.newArrayList();
        List list = tileentity_b.getOrDefault(DataComponents.BEES, List.of());
        list.forEach(this::storeBee);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a datacomponentmap_a) {
        super.collectImplicitComponents(datacomponentmap_a);
        datacomponentmap_a.set(DataComponents.BEES, this.getBees());
    }

    @Override
    public void removeComponentsFromTag(NBTTagCompound nbttagcompound) {
        super.removeComponentsFromTag(nbttagcompound);
        nbttagcompound.remove(BEES);
    }

    private List<c> getBees() {
        return this.stored.stream().map(HiveBee::toOccupant).toList();
    }

    public static enum ReleaseStatus {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY;

    }

    public record c(CustomData entityData, int ticksInHive, int minTicksInHive) {
        public static final Codec<c> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomData.CODEC.optionalFieldOf("entity_data", (Object)CustomData.EMPTY).forGetter(c::entityData), (App)Codec.INT.fieldOf("ticks_in_hive").forGetter(c::ticksInHive), (App)Codec.INT.fieldOf("min_ticks_in_hive").forGetter(c::minTicksInHive)).apply((Applicative)instance, c::new));
        public static final Codec<List<c>> LIST_CODEC = CODEC.listOf();
        public static final StreamCodec<ByteBuf, c> STREAM_CODEC = StreamCodec.composite(CustomData.STREAM_CODEC, c::entityData, ByteBufCodecs.VAR_INT, c::ticksInHive, ByteBufCodecs.VAR_INT, c::minTicksInHive, c::new);

        public static c of(net.minecraft.world.entity.Entity entity) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entity.save(nbttagcompound);
            List<String> list = IGNORED_BEE_TAGS;
            Objects.requireNonNull(nbttagcompound);
            list.forEach(nbttagcompound::remove);
            boolean flag = nbttagcompound.getBoolean("HasNectar");
            return new c(CustomData.of(nbttagcompound), 0, flag ? 2400 : 600);
        }

        public static c create(int i2) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(EntityTypes.BEE).toString());
            return new c(CustomData.of(nbttagcompound), i2, 600);
        }

        @Nullable
        public net.minecraft.world.entity.Entity createEntity(World world, BlockPosition blockposition) {
            NBTTagCompound nbttagcompound = this.entityData.copyTag();
            List<String> list = IGNORED_BEE_TAGS;
            Objects.requireNonNull(nbttagcompound);
            list.forEach(nbttagcompound::remove);
            net.minecraft.world.entity.Entity entity = EntityTypes.loadEntityRecursive(nbttagcompound, world, entity1 -> entity1);
            if (entity != null && entity.getType().is(TagsEntity.BEEHIVE_INHABITORS)) {
                entity.setNoGravity(true);
                if (entity instanceof EntityBee) {
                    EntityBee entitybee = (EntityBee)entity;
                    entitybee.setHivePos(blockposition);
                    c.setBeeReleaseData(this.ticksInHive, entitybee);
                }
                return entity;
            }
            return null;
        }

        private static void setBeeReleaseData(int i2, EntityBee entitybee) {
            int j2 = entitybee.getAge();
            if (j2 < 0) {
                entitybee.setAge(Math.min(0, j2 + i2));
            } else if (j2 > 0) {
                entitybee.setAge(Math.max(0, j2 - i2));
            }
            entitybee.setInLoveTime(Math.max(0, entitybee.getInLoveTime() - i2));
        }
    }

    private static class HiveBee {
        private final c occupant;
        private int ticksInHive;

        HiveBee(c tileentitybeehive_c) {
            this.occupant = tileentitybeehive_c;
            this.ticksInHive = tileentitybeehive_c.ticksInHive();
        }

        public boolean tick() {
            return this.ticksInHive++ > this.occupant.minTicksInHive;
        }

        public c toOccupant() {
            return new c(this.occupant.entityData, this.ticksInHive, this.occupant.minTicksInHive);
        }

        public boolean hasNectar() {
            return this.occupant.entityData.getUnsafe().getBoolean("HasNectar");
        }
    }
}

