/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;

public class TileEntityBell
extends TileEntity {
    private static final int DURATION = 50;
    private static final int GLOW_DURATION = 60;
    private static final int MIN_TICKS_BETWEEN_SEARCHES = 60;
    private static final int MAX_RESONATION_TICKS = 40;
    private static final int TICKS_BEFORE_RESONATION = 5;
    private static final int SEARCH_RADIUS = 48;
    private static final int HEAR_BELL_RADIUS = 32;
    private static final int HIGHLIGHT_RAIDERS_RADIUS = 48;
    private long lastRingTimestamp;
    public int ticks;
    public boolean shaking;
    public EnumDirection clickDirection;
    private List<EntityLiving> nearbyEntities;
    public boolean resonating;
    public int resonationTicks;

    public TileEntityBell(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.BELL, blockposition, iblockdata);
    }

    @Override
    public boolean triggerEvent(int i2, int j2) {
        if (i2 == 1) {
            this.updateEntities();
            this.resonationTicks = 0;
            this.clickDirection = EnumDirection.from3DDataValue(j2);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        return super.triggerEvent(i2, j2);
    }

    private static void tick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityBell tileentitybell, a tileentitybell_a) {
        if (tileentitybell.shaking) {
            ++tileentitybell.ticks;
        }
        if (tileentitybell.ticks >= 50) {
            tileentitybell.shaking = false;
            tileentitybell.ticks = 0;
        }
        if (tileentitybell.ticks >= 5 && tileentitybell.resonationTicks == 0 && TileEntityBell.areRaidersNearby(blockposition, tileentitybell.nearbyEntities)) {
            tileentitybell.resonating = true;
            world.playSound((EntityHuman)null, blockposition, SoundEffects.BELL_RESONATE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (tileentitybell.resonating) {
            if (tileentitybell.resonationTicks < 40) {
                ++tileentitybell.resonationTicks;
            } else {
                tileentitybell_a.run(world, blockposition, tileentitybell.nearbyEntities);
                tileentitybell.resonating = false;
            }
        }
    }

    public static void clientTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityBell tileentitybell) {
        TileEntityBell.tick(world, blockposition, iblockdata, tileentitybell, TileEntityBell::showBellParticles);
    }

    public static void serverTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityBell tileentitybell) {
        TileEntityBell.tick(world, blockposition, iblockdata, tileentitybell, TileEntityBell::makeRaidersGlow);
    }

    public void onHit(EnumDirection enumdirection) {
        BlockPosition blockposition = this.getBlockPos();
        this.clickDirection = enumdirection;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        this.level.blockEvent(blockposition, this.getBlockState().getBlock(), 1, enumdirection.get3DDataValue());
    }

    private void updateEntities() {
        BlockPosition blockposition = this.getBlockPos();
        if (this.level.getGameTime() > this.lastRingTimestamp + 60L || this.nearbyEntities == null) {
            this.lastRingTimestamp = this.level.getGameTime();
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockposition).inflate(48.0);
            this.nearbyEntities = this.level.getEntitiesOfClass(EntityLiving.class, axisalignedbb);
        }
        if (!this.level.isClientSide) {
            for (EntityLiving entityliving : this.nearbyEntities) {
                if (!entityliving.isAlive() || entityliving.isRemoved() || !blockposition.closerToCenterThan(entityliving.position(), 32.0)) continue;
                entityliving.getBrain().setMemory(MemoryModuleType.HEARD_BELL_TIME, this.level.getGameTime());
            }
        }
    }

    private static boolean areRaidersNearby(BlockPosition blockposition, List<EntityLiving> list) {
        EntityLiving entityliving;
        Iterator<EntityLiving> iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(entityliving = iterator.next()).isAlive() || entityliving.isRemoved() || !blockposition.closerToCenterThan(entityliving.position(), 32.0) || !entityliving.getType().is(TagsEntity.RAIDERS));
        return true;
    }

    private static void makeRaidersGlow(World world, BlockPosition blockposition, List<EntityLiving> list) {
        List entities = list.stream().filter(entityliving -> TileEntityBell.isRaiderWithinRange(blockposition, entityliving)).map(entity -> (LivingEntity)entity.getBukkitEntity()).collect(Collectors.toCollection(ArrayList::new));
        CraftEventFactory.handleBellResonateEvent(world, blockposition, entities).forEach(TileEntityBell::glow);
    }

    private static void showBellParticles(World world, BlockPosition blockposition, List<EntityLiving> list) {
        MutableInt mutableint = new MutableInt(16700985);
        int i2 = (int)list.stream().filter(entityliving -> blockposition.closerToCenterThan(entityliving.position(), 48.0)).count();
        list.stream().filter(entityliving -> TileEntityBell.isRaiderWithinRange(blockposition, entityliving)).forEach(entityliving -> {
            float f2 = 1.0f;
            double d0 = Math.sqrt((entityliving.getX() - (double)blockposition.getX()) * (entityliving.getX() - (double)blockposition.getX()) + (entityliving.getZ() - (double)blockposition.getZ()) * (entityliving.getZ() - (double)blockposition.getZ()));
            double d1 = (double)((float)blockposition.getX() + 0.5f) + 1.0 / d0 * (entityliving.getX() - (double)blockposition.getX());
            double d2 = (double)((float)blockposition.getZ() + 0.5f) + 1.0 / d0 * (entityliving.getZ() - (double)blockposition.getZ());
            int j2 = MathHelper.clamp((i2 - 21) / -2, 3, 15);
            for (int k2 = 0; k2 < j2; ++k2) {
                int l2 = mutableint.addAndGet(5);
                world.addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, l2), d1, (float)blockposition.getY() + 0.5f, d2, 0.0, 0.0, 0.0);
            }
        });
    }

    private static boolean isRaiderWithinRange(BlockPosition blockposition, EntityLiving entityliving) {
        return entityliving.isAlive() && !entityliving.isRemoved() && blockposition.closerToCenterThan(entityliving.position(), 48.0) && entityliving.getType().is(TagsEntity.RAIDERS);
    }

    private static void glow(EntityLiving entityliving) {
        entityliving.addEffect(new MobEffect(MobEffects.GLOWING, 60));
    }

    @FunctionalInterface
    private static interface a {
        public void run(World var1, BlockPosition var2, List<EntityLiving> var3);
    }
}

