/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerBrewingStand;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BrewingStartEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class TileEntityBrewingStand
extends TileEntityContainer
implements IWorldInventory {
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
    public static final int FUEL_USES = 20;
    public static final int DATA_BREW_TIME = 0;
    public static final int DATA_FUEL_USES = 1;
    public static final int NUM_DATA_VALUES = 2;
    private NonNullList<net.minecraft.world.item.ItemStack> items;
    public int brewTime;
    private boolean[] lastPotionCount;
    private Item ingredient;
    public int fuel;
    protected final IContainerProperties dataAccess;
    private int lastTick = MinecraftServer.currentTick;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.items;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public TileEntityBrewingStand(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.BREWING_STAND, blockposition, iblockdata);
        this.items = NonNullList.withSize(5, net.minecraft.world.item.ItemStack.EMPTY);
        this.dataAccess = new IContainerProperties(){

            @Override
            public int get(int i2) {
                return switch (i2) {
                    case 0 -> TileEntityBrewingStand.this.brewTime;
                    case 1 -> TileEntityBrewingStand.this.fuel;
                    default -> 0;
                };
            }

            @Override
            public void set(int i2, int j2) {
                switch (i2) {
                    case 0: {
                        TileEntityBrewingStand.this.brewTime = j2;
                        break;
                    }
                    case 1: {
                        TileEntityBrewingStand.this.fuel = j2;
                    }
                }
            }

            @Override
            public int getCount() {
                return 2;
            }
        };
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.brewing");
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    public static void serverTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityBrewingStand tileentitybrewingstand) {
        net.minecraft.world.item.ItemStack itemstack = tileentitybrewingstand.items.get(4);
        if (tileentitybrewingstand.fuel <= 0 && itemstack.is(Items.BLAZE_POWDER)) {
            BrewingStandFuelEvent event = new BrewingStandFuelEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)CraftItemStack.asCraftMirror(itemstack), 20);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            tileentitybrewingstand.fuel = event.getFuelPower();
            if (tileentitybrewingstand.fuel > 0 && event.isConsuming()) {
                itemstack.shrink(1);
            }
            TileEntityBrewingStand.setChanged(world, blockposition, iblockdata);
        }
        boolean flag = TileEntityBrewingStand.isBrewable(world.potionBrewing(), tileentitybrewingstand.items);
        boolean flag1 = tileentitybrewingstand.brewTime > 0;
        net.minecraft.world.item.ItemStack itemstack1 = tileentitybrewingstand.items.get(3);
        int elapsedTicks = MinecraftServer.currentTick - tileentitybrewingstand.lastTick;
        tileentitybrewingstand.lastTick = MinecraftServer.currentTick;
        if (flag1) {
            boolean flag2;
            tileentitybrewingstand.brewTime -= elapsedTicks;
            boolean bl = flag2 = tileentitybrewingstand.brewTime <= 0;
            if (flag2 && flag) {
                TileEntityBrewingStand.doBrew(world, blockposition, tileentitybrewingstand.items, tileentitybrewingstand);
            } else if (!flag || !itemstack1.is(tileentitybrewingstand.ingredient)) {
                tileentitybrewingstand.brewTime = 0;
            }
            TileEntityBrewingStand.setChanged(world, blockposition, iblockdata);
        } else if (flag && tileentitybrewingstand.fuel > 0) {
            --tileentitybrewingstand.fuel;
            BrewingStartEvent event = new BrewingStartEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)CraftItemStack.asCraftMirror(itemstack1), 400);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            tileentitybrewingstand.brewTime = event.getTotalBrewTime();
            tileentitybrewingstand.ingredient = itemstack1.getItem();
            TileEntityBrewingStand.setChanged(world, blockposition, iblockdata);
        }
        boolean[] aboolean = tileentitybrewingstand.getPotionBits();
        if (!Arrays.equals(aboolean, tileentitybrewingstand.lastPotionCount)) {
            tileentitybrewingstand.lastPotionCount = aboolean;
            IBlockData iblockdata1 = iblockdata;
            if (!(iblockdata.getBlock() instanceof BlockBrewingStand)) {
                return;
            }
            for (int i2 = 0; i2 < BlockBrewingStand.HAS_BOTTLE.length; ++i2) {
                iblockdata1 = (IBlockData)iblockdata1.setValue(BlockBrewingStand.HAS_BOTTLE[i2], aboolean[i2]);
            }
            world.setBlock(blockposition, iblockdata1, 2);
        }
    }

    private boolean[] getPotionBits() {
        boolean[] aboolean = new boolean[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.items.get(i2).isEmpty()) continue;
            aboolean[i2] = true;
        }
        return aboolean;
    }

    private static boolean isBrewable(PotionBrewer potionbrewer, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(3);
        if (itemstack.isEmpty()) {
            return false;
        }
        if (!potionbrewer.isIngredient(itemstack)) {
            return false;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            net.minecraft.world.item.ItemStack itemstack1 = nonnulllist.get(i2);
            if (itemstack1.isEmpty() || !potionbrewer.hasMix(itemstack1, itemstack)) continue;
            return true;
        }
        return false;
    }

    private static void doBrew(World world, BlockPosition blockposition, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, TileEntityBrewingStand tileentitybrewingstand) {
        int i2;
        net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(3);
        PotionBrewer potionbrewer = world.potionBrewing();
        InventoryHolder owner = tileentitybrewingstand.getOwner();
        ArrayList<CraftItemStack> brewResults = new ArrayList<CraftItemStack>(3);
        for (i2 = 0; i2 < 3; ++i2) {
            brewResults.add(i2, CraftItemStack.asCraftMirror(potionbrewer.mix(itemstack, nonnulllist.get(i2))));
        }
        if (owner != null) {
            BrewEvent event = new BrewEvent((Block)CraftBlock.at(world, blockposition), (BrewerInventory)owner.getInventory(), brewResults, tileentitybrewingstand.fuel);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        for (i2 = 0; i2 < 3; ++i2) {
            if (i2 < brewResults.size()) {
                nonnulllist.set(i2, CraftItemStack.asNMSCopy((ItemStack)brewResults.get(i2)));
                continue;
            }
            nonnulllist.set(i2, net.minecraft.world.item.ItemStack.EMPTY);
        }
        itemstack.shrink(1);
        if (itemstack.getItem().hasCraftingRemainingItem()) {
            net.minecraft.world.item.ItemStack itemstack1 = new net.minecraft.world.item.ItemStack(itemstack.getItem().getCraftingRemainingItem());
            if (itemstack.isEmpty()) {
                itemstack = itemstack1;
            } else {
                InventoryUtils.dropItemStack(world, blockposition.getX(), blockposition.getY(), blockposition.getZ(), itemstack1);
            }
        }
        nonnulllist.set(3, itemstack);
        world.levelEvent(1035, blockposition, 0);
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.items = NonNullList.withSize(this.getContainerSize(), net.minecraft.world.item.ItemStack.EMPTY);
        ContainerUtil.loadAllItems(nbttagcompound, this.items, holderlookup_a);
        this.brewTime = nbttagcompound.getShort("BrewTime");
        if (this.brewTime > 0) {
            this.ingredient = this.items.get(3).getItem();
        }
        this.fuel = nbttagcompound.getByte("Fuel");
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        nbttagcompound.putShort("BrewTime", (short)this.brewTime);
        ContainerUtil.saveAllItems(nbttagcompound, this.items, holderlookup_a);
        nbttagcompound.putByte("Fuel", (byte)this.fuel);
    }

    @Override
    public boolean canPlaceItem(int i2, net.minecraft.world.item.ItemStack itemstack) {
        if (i2 == 3) {
            PotionBrewer potionbrewer = this.level != null ? this.level.potionBrewing() : PotionBrewer.EMPTY;
            return potionbrewer.isIngredient(itemstack);
        }
        return i2 == 4 ? itemstack.is(Items.BLAZE_POWDER) : (itemstack.is(Items.POTION) || itemstack.is(Items.SPLASH_POTION) || itemstack.is(Items.LINGERING_POTION) || itemstack.is(Items.GLASS_BOTTLE)) && this.getItem(i2).isEmpty();
    }

    @Override
    public int[] getSlotsForFace(EnumDirection enumdirection) {
        return enumdirection == EnumDirection.UP ? SLOTS_FOR_UP : (enumdirection == EnumDirection.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_SIDES);
    }

    @Override
    public boolean canPlaceItemThroughFace(int i2, net.minecraft.world.item.ItemStack itemstack, @Nullable EnumDirection enumdirection) {
        return this.canPlaceItem(i2, itemstack);
    }

    @Override
    public boolean canTakeItemThroughFace(int i2, net.minecraft.world.item.ItemStack itemstack, EnumDirection enumdirection) {
        return i2 == 3 ? itemstack.is(Items.GLASS_BOTTLE) : true;
    }

    @Override
    protected Container createMenu(int i2, PlayerInventory playerinventory) {
        return new ContainerBrewingStand(i2, playerinventory, this, this.dataAccess);
    }
}

