/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ItemStack;

public class TileEntityCampfire
extends TileEntity
implements Clearable {
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final NonNullList<net.minecraft.world.item.ItemStack> items = NonNullList.withSize(4, net.minecraft.world.item.ItemStack.EMPTY);
    public final int[] cookingProgress = new int[4];
    public final int[] cookingTime = new int[4];
    private final CraftingManager.a<SingleRecipeInput, RecipeCampfire> quickCheck = CraftingManager.createCheck(Recipes.CAMPFIRE_COOKING);

    public TileEntityCampfire(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.CAMPFIRE, blockposition, iblockdata);
    }

    public static void cookTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityCampfire tileentitycampfire) {
        boolean flag = false;
        for (int i2 = 0; i2 < tileentitycampfire.items.size(); ++i2) {
            SingleRecipeInput singlerecipeinput;
            net.minecraft.world.item.ItemStack itemstack1;
            net.minecraft.world.item.ItemStack itemstack = tileentitycampfire.items.get(i2);
            if (itemstack.isEmpty()) continue;
            flag = true;
            int n2 = i2;
            tileentitycampfire.cookingProgress[n2] = tileentitycampfire.cookingProgress[n2] + 1;
            if (tileentitycampfire.cookingProgress[i2] < tileentitycampfire.cookingTime[i2] || !(itemstack1 = tileentitycampfire.quickCheck.getRecipeFor(singlerecipeinput = new SingleRecipeInput(itemstack), world).map(recipeholder -> ((RecipeCampfire)recipeholder.value()).assemble(singlerecipeinput, (HolderLookup.a)world.registryAccess())).orElse(itemstack)).isItemEnabled(world.enabledFeatures())) continue;
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            BlockCookEvent blockCookEvent = new BlockCookEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result);
            world.getCraftServer().getPluginManager().callEvent((Event)blockCookEvent);
            if (blockCookEvent.isCancelled()) {
                return;
            }
            result = blockCookEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            InventoryUtils.dropItemStack(world, blockposition.getX(), blockposition.getY(), blockposition.getZ(), itemstack1);
            tileentitycampfire.items.set(i2, net.minecraft.world.item.ItemStack.EMPTY);
            world.sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.a.of(iblockdata));
        }
        if (flag) {
            TileEntityCampfire.setChanged(world, blockposition, iblockdata);
        }
    }

    public static void cooldownTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityCampfire tileentitycampfire) {
        boolean flag = false;
        for (int i2 = 0; i2 < tileentitycampfire.items.size(); ++i2) {
            if (tileentitycampfire.cookingProgress[i2] <= 0) continue;
            flag = true;
            tileentitycampfire.cookingProgress[i2] = MathHelper.clamp(tileentitycampfire.cookingProgress[i2] - 2, 0, tileentitycampfire.cookingTime[i2]);
        }
        if (flag) {
            TileEntityCampfire.setChanged(world, blockposition, iblockdata);
        }
    }

    public static void particleTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityCampfire tileentitycampfire) {
        int i2;
        RandomSource randomsource = world.random;
        if (randomsource.nextFloat() < 0.11f) {
            for (i2 = 0; i2 < randomsource.nextInt(2) + 2; ++i2) {
                BlockCampfire.makeParticles(world, blockposition, iblockdata.getValue(BlockCampfire.SIGNAL_FIRE), false);
            }
        }
        i2 = iblockdata.getValue(BlockCampfire.FACING).get2DDataValue();
        for (int j2 = 0; j2 < tileentitycampfire.items.size(); ++j2) {
            if (tileentitycampfire.items.get(j2).isEmpty() || !(randomsource.nextFloat() < 0.2f)) continue;
            EnumDirection enumdirection = EnumDirection.from2DDataValue(Math.floorMod(j2 + i2, 4));
            float f2 = 0.3125f;
            double d0 = (double)blockposition.getX() + 0.5 - (double)((float)enumdirection.getStepX() * 0.3125f) + (double)((float)enumdirection.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)blockposition.getY() + 0.5;
            double d2 = (double)blockposition.getZ() + 0.5 - (double)((float)enumdirection.getStepZ() * 0.3125f) + (double)((float)enumdirection.getClockWise().getStepZ() * 0.3125f);
            for (int k2 = 0; k2 < 4; ++k2) {
                world.addParticle(Particles.SMOKE, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        int[] aint;
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.items.clear();
        ContainerUtil.loadAllItems(nbttagcompound, this.items, holderlookup_a);
        if (nbttagcompound.contains("CookingTimes", 11)) {
            aint = nbttagcompound.getIntArray("CookingTimes");
            System.arraycopy(aint, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, aint.length));
        }
        if (nbttagcompound.contains("CookingTotalTimes", 11)) {
            aint = nbttagcompound.getIntArray("CookingTotalTimes");
            System.arraycopy(aint, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, aint.length));
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        ContainerUtil.saveAllItems(nbttagcompound, this.items, true, holderlookup_a);
        nbttagcompound.putIntArray("CookingTimes", this.cookingProgress);
        nbttagcompound.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        ContainerUtil.saveAllItems(nbttagcompound, this.items, true, holderlookup_a);
        return nbttagcompound;
    }

    public Optional<RecipeHolder<RecipeCampfire>> getCookableRecipe(net.minecraft.world.item.ItemStack itemstack) {
        return this.items.stream().noneMatch(net.minecraft.world.item.ItemStack::isEmpty) ? Optional.empty() : this.quickCheck.getRecipeFor(new SingleRecipeInput(itemstack), this.level);
    }

    public boolean placeFood(@Nullable EntityLiving entityliving, net.minecraft.world.item.ItemStack itemstack, int i2) {
        for (int j2 = 0; j2 < this.items.size(); ++j2) {
            net.minecraft.world.item.ItemStack itemstack1 = this.items.get(j2);
            if (!itemstack1.isEmpty()) continue;
            CampfireStartEvent event = new CampfireStartEvent((Block)CraftBlock.at(this.level, this.worldPosition), (ItemStack)CraftItemStack.asCraftMirror(itemstack), (CampfireRecipe)this.getCookableRecipe(itemstack).get().toBukkitRecipe());
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            this.cookingTime[j2] = event.getTotalCookTime();
            this.cookingProgress[j2] = 0;
            this.items.set(j2, itemstack.consumeAndReturn(1, entityliving));
            this.level.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.a.of(entityliving, this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    public void dowse() {
        if (this.level != null) {
            this.markUpdated();
        }
    }

    @Override
    protected void applyImplicitComponents(TileEntity.b tileentity_b) {
        super.applyImplicitComponents(tileentity_b);
        tileentity_b.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).copyInto(this.getItems());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a datacomponentmap_a) {
        super.collectImplicitComponents(datacomponentmap_a);
        datacomponentmap_a.set(DataComponents.CONTAINER, ItemContainerContents.fromItems(this.getItems()));
    }

    @Override
    public void removeComponentsFromTag(NBTTagCompound nbttagcompound) {
        nbttagcompound.remove("Items");
    }
}

