/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class TileEntityConduit
extends TileEntity {
    private static final int BLOCK_REFRESH_RATE = 2;
    private static final int EFFECT_DURATION = 13;
    private static final float ROTATION_SPEED = -0.0375f;
    private static final int MIN_ACTIVE_SIZE = 16;
    private static final int MIN_KILL_SIZE = 42;
    private static final int KILL_RANGE = 8;
    private static final Block[] VALID_BLOCKS = new Block[]{Blocks.PRISMARINE, Blocks.PRISMARINE_BRICKS, Blocks.SEA_LANTERN, Blocks.DARK_PRISMARINE};
    public int tickCount;
    private float activeRotation;
    private boolean isActive;
    private boolean isHunting;
    public final List<BlockPosition> effectBlocks = Lists.newArrayList();
    @Nullable
    public EntityLiving destroyTarget;
    @Nullable
    public UUID destroyTargetUUID;
    private long nextAmbientSoundActivation;

    public TileEntityConduit(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.CONDUIT, blockposition, iblockdata);
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.destroyTargetUUID = nbttagcompound.hasUUID("Target") ? nbttagcompound.getUUID("Target") : null;
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        if (this.destroyTarget != null) {
            nbttagcompound.putUUID("Target", this.destroyTarget.getUUID());
        }
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a holderlookup_a) {
        return this.saveCustomOnly(holderlookup_a);
    }

    public static void clientTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityConduit tileentityconduit) {
        ++tileentityconduit.tickCount;
        long i2 = world.getGameTime();
        List<BlockPosition> list = tileentityconduit.effectBlocks;
        if (i2 % 40L == 0L) {
            tileentityconduit.isActive = TileEntityConduit.updateShape(world, blockposition, list);
            TileEntityConduit.updateHunting(tileentityconduit, list);
        }
        TileEntityConduit.updateClientTarget(world, blockposition, tileentityconduit);
        TileEntityConduit.animationTick(world, blockposition, list, tileentityconduit.destroyTarget, tileentityconduit.tickCount);
        if (tileentityconduit.isActive()) {
            tileentityconduit.activeRotation += 1.0f;
        }
    }

    public static void serverTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityConduit tileentityconduit) {
        ++tileentityconduit.tickCount;
        long i2 = world.getGameTime();
        List<BlockPosition> list = tileentityconduit.effectBlocks;
        if (i2 % 40L == 0L) {
            boolean flag = TileEntityConduit.updateShape(world, blockposition, list);
            if (flag != tileentityconduit.isActive) {
                SoundEffect soundeffect = flag ? SoundEffects.CONDUIT_ACTIVATE : SoundEffects.CONDUIT_DEACTIVATE;
                world.playSound((EntityHuman)null, blockposition, soundeffect, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            tileentityconduit.isActive = flag;
            TileEntityConduit.updateHunting(tileentityconduit, list);
            if (flag) {
                TileEntityConduit.applyEffects(world, blockposition, list);
                TileEntityConduit.updateDestroyTarget(world, blockposition, iblockdata, list, tileentityconduit);
            }
        }
        if (tileentityconduit.isActive()) {
            if (i2 % 80L == 0L) {
                world.playSound((EntityHuman)null, blockposition, SoundEffects.CONDUIT_AMBIENT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (i2 > tileentityconduit.nextAmbientSoundActivation) {
                tileentityconduit.nextAmbientSoundActivation = i2 + 60L + (long)world.getRandom().nextInt(40);
                world.playSound((EntityHuman)null, blockposition, SoundEffects.CONDUIT_AMBIENT_SHORT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void updateHunting(TileEntityConduit tileentityconduit, List<BlockPosition> list) {
        tileentityconduit.setHunting(list.size() >= 42);
    }

    private static boolean updateShape(World world, BlockPosition blockposition, List<BlockPosition> list) {
        int k2;
        int j2;
        int i2;
        list.clear();
        for (i2 = -1; i2 <= 1; ++i2) {
            for (j2 = -1; j2 <= 1; ++j2) {
                for (k2 = -1; k2 <= 1; ++k2) {
                    BlockPosition blockposition1 = blockposition.offset(i2, j2, k2);
                    if (world.isWaterAt(blockposition1)) continue;
                    return false;
                }
            }
        }
        for (i2 = -2; i2 <= 2; ++i2) {
            for (j2 = -2; j2 <= 2; ++j2) {
                for (k2 = -2; k2 <= 2; ++k2) {
                    int l2 = Math.abs(i2);
                    int i1 = Math.abs(j2);
                    int j1 = Math.abs(k2);
                    if (l2 <= 1 && i1 <= 1 && j1 <= 1 || (i2 != 0 || i1 != 2 && j1 != 2) && (j2 != 0 || l2 != 2 && j1 != 2) && (k2 != 0 || l2 != 2 && i1 != 2)) continue;
                    BlockPosition blockposition2 = blockposition.offset(i2, j2, k2);
                    IBlockData iblockdata = world.getBlockState(blockposition2);
                    for (Block block : VALID_BLOCKS) {
                        if (!iblockdata.is(block)) continue;
                        list.add(blockposition2);
                    }
                }
            }
        }
        return list.size() >= 16;
    }

    private static void applyEffects(World world, BlockPosition blockposition, List<BlockPosition> list) {
        TileEntityConduit.applyEffects(world, blockposition, TileEntityConduit.getRange(list));
    }

    public static int getRange(List<BlockPosition> list) {
        int i2 = list.size();
        int j2 = i2 / 7 * 16;
        return j2;
    }

    private static void applyEffects(World world, BlockPosition blockposition, int j2) {
        int i1;
        int l2;
        int k2 = blockposition.getX();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(k2, l2 = blockposition.getY(), i1 = blockposition.getZ(), k2 + 1, l2 + 1, i1 + 1).inflate(j2).expandTowards(0.0, world.getHeight(), 0.0);
        List<EntityHuman> list1 = world.getEntitiesOfClass(EntityHuman.class, axisalignedbb);
        if (!list1.isEmpty()) {
            for (EntityHuman entityhuman : list1) {
                if (!blockposition.closerThan(entityhuman.blockPosition(), j2) || !entityhuman.isInWaterOrRain()) continue;
                entityhuman.addEffect(new MobEffect(MobEffects.CONDUIT_POWER, 260, 0, true, true), EntityPotionEffectEvent.Cause.CONDUIT);
            }
        }
    }

    private static void updateDestroyTarget(World world, BlockPosition blockposition, IBlockData iblockdata, List<BlockPosition> list, TileEntityConduit tileentityconduit) {
        TileEntityConduit.updateDestroyTarget(world, blockposition, iblockdata, list, tileentityconduit, true);
    }

    public static void updateDestroyTarget(World world, BlockPosition blockposition, IBlockData iblockdata, List<BlockPosition> list, TileEntityConduit tileentityconduit, boolean damageTarget) {
        EntityLiving entityliving = tileentityconduit.destroyTarget;
        int i2 = list.size();
        if (i2 < 42) {
            tileentityconduit.destroyTarget = null;
        } else if (tileentityconduit.destroyTarget == null && tileentityconduit.destroyTargetUUID != null) {
            tileentityconduit.destroyTarget = TileEntityConduit.findDestroyTarget(world, blockposition, tileentityconduit.destroyTargetUUID);
            tileentityconduit.destroyTargetUUID = null;
        } else if (tileentityconduit.destroyTarget == null) {
            List<EntityLiving> list1 = world.getEntitiesOfClass(EntityLiving.class, TileEntityConduit.getDestroyRangeAABB(blockposition), entityliving1 -> entityliving1 instanceof IMonster && entityliving1.isInWaterOrRain());
            if (!list1.isEmpty()) {
                tileentityconduit.destroyTarget = list1.get(world.random.nextInt(list1.size()));
            }
        } else if (!tileentityconduit.destroyTarget.isAlive() || !blockposition.closerThan(tileentityconduit.destroyTarget.blockPosition(), 8.0)) {
            tileentityconduit.destroyTarget = null;
        }
        if (damageTarget && tileentityconduit.destroyTarget != null && tileentityconduit.destroyTarget.hurt(world.damageSources().magic().directBlock(world, blockposition), 4.0f)) {
            world.playSound(null, tileentityconduit.destroyTarget.getX(), tileentityconduit.destroyTarget.getY(), tileentityconduit.destroyTarget.getZ(), SoundEffects.CONDUIT_ATTACK_TARGET, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (entityliving != tileentityconduit.destroyTarget) {
            world.sendBlockUpdated(blockposition, iblockdata, iblockdata, 2);
        }
    }

    private static void updateClientTarget(World world, BlockPosition blockposition, TileEntityConduit tileentityconduit) {
        if (tileentityconduit.destroyTargetUUID == null) {
            tileentityconduit.destroyTarget = null;
        } else if (tileentityconduit.destroyTarget == null || !tileentityconduit.destroyTarget.getUUID().equals(tileentityconduit.destroyTargetUUID)) {
            tileentityconduit.destroyTarget = TileEntityConduit.findDestroyTarget(world, blockposition, tileentityconduit.destroyTargetUUID);
            if (tileentityconduit.destroyTarget == null) {
                tileentityconduit.destroyTargetUUID = null;
            }
        }
    }

    public static AxisAlignedBB getDestroyRangeAABB(BlockPosition blockposition) {
        int i2 = blockposition.getX();
        int j2 = blockposition.getY();
        int k2 = blockposition.getZ();
        return new AxisAlignedBB(i2, j2, k2, i2 + 1, j2 + 1, k2 + 1).inflate(8.0);
    }

    @Nullable
    private static EntityLiving findDestroyTarget(World world, BlockPosition blockposition, UUID uuid) {
        List<EntityLiving> list = world.getEntitiesOfClass(EntityLiving.class, TileEntityConduit.getDestroyRangeAABB(blockposition), entityliving -> entityliving.getUUID().equals(uuid));
        return list.size() == 1 ? list.get(0) : null;
    }

    private static void animationTick(World world, BlockPosition blockposition, List<BlockPosition> list, @Nullable Entity entity, int i2) {
        float f2;
        RandomSource randomsource = world.random;
        double d0 = MathHelper.sin((float)(i2 + 35) * 0.1f) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vec3D vec3d = new Vec3D((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 1.5 + d0, (double)blockposition.getZ() + 0.5);
        for (BlockPosition blockposition1 : list) {
            if (randomsource.nextInt(50) != 0) continue;
            BlockPosition blockposition2 = blockposition1.subtract(blockposition);
            f2 = -0.5f + randomsource.nextFloat() + (float)blockposition2.getX();
            float f1 = -2.0f + randomsource.nextFloat() + (float)blockposition2.getY();
            float f22 = -0.5f + randomsource.nextFloat() + (float)blockposition2.getZ();
            world.addParticle(Particles.NAUTILUS, vec3d.x, vec3d.y, vec3d.z, f2, f1, f22);
        }
        if (entity != null) {
            Vec3D vec3d1 = new Vec3D(entity.getX(), entity.getEyeY(), entity.getZ());
            float f3 = (-0.5f + randomsource.nextFloat()) * (3.0f + entity.getBbWidth());
            float f4 = -1.0f + randomsource.nextFloat() * entity.getBbHeight();
            f2 = (-0.5f + randomsource.nextFloat()) * (3.0f + entity.getBbWidth());
            Vec3D vec3d2 = new Vec3D(f3, f4, f2);
            world.addParticle(Particles.NAUTILUS, vec3d1.x, vec3d1.y, vec3d1.z, vec3d2.x, vec3d2.y, vec3d2.z);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isHunting() {
        return this.isHunting;
    }

    private void setHunting(boolean flag) {
        this.isHunting = flag;
    }

    public float getActiveRotation(float f2) {
        return (this.activeRotation + f2) * -0.0375f;
    }
}

