/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenEndGatewayConfiguration;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class TileEntityEndGateway
extends TileEntityEnderPortal {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SPAWN_TIME = 200;
    private static final int COOLDOWN_TIME = 40;
    private static final int ATTENTION_INTERVAL = 2400;
    private static final int EVENT_COOLDOWN = 1;
    private static final int GATEWAY_HEIGHT_ABOVE_SURFACE = 10;
    public long age;
    private int teleportCooldown;
    @Nullable
    public BlockPosition exitPortal;
    public boolean exactTeleport;

    public TileEntityEndGateway(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.END_GATEWAY, blockposition, iblockdata);
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        nbttagcompound.putLong("Age", this.age);
        if (this.exitPortal != null) {
            nbttagcompound.put("exit_portal", GameProfileSerializer.writeBlockPos(this.exitPortal));
        }
        if (this.exactTeleport) {
            nbttagcompound.putBoolean("ExactTeleport", true);
        }
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.age = nbttagcompound.getLong("Age");
        GameProfileSerializer.readBlockPos(nbttagcompound, "exit_portal").filter(World::isInSpawnableBounds).ifPresent(blockposition -> {
            this.exitPortal = blockposition;
        });
        this.exactTeleport = nbttagcompound.getBoolean("ExactTeleport");
    }

    public static void beamAnimationTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        ++tileentityendgateway.age;
        if (tileentityendgateway.isCoolingDown()) {
            --tileentityendgateway.teleportCooldown;
        }
    }

    public static void portalTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        boolean flag = tileentityendgateway.isSpawning();
        boolean flag1 = tileentityendgateway.isCoolingDown();
        ++tileentityendgateway.age;
        if (flag1) {
            --tileentityendgateway.teleportCooldown;
        } else if (tileentityendgateway.age % 2400L == 0L) {
            TileEntityEndGateway.triggerCooldown(world, blockposition, iblockdata, tileentityendgateway);
        }
        if (flag != tileentityendgateway.isSpawning() || flag1 != tileentityendgateway.isCoolingDown()) {
            TileEntityEndGateway.setChanged(world, blockposition, iblockdata);
        }
    }

    public boolean isSpawning() {
        return this.age < 200L;
    }

    public boolean isCoolingDown() {
        return this.teleportCooldown > 0;
    }

    public float getSpawnPercent(float f2) {
        return MathHelper.clamp(((float)this.age + f2) / 200.0f, 0.0f, 1.0f);
    }

    public float getCooldownPercent(float f2) {
        return 1.0f - MathHelper.clamp(((float)this.teleportCooldown - f2) / 40.0f, 0.0f, 1.0f);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a holderlookup_a) {
        return this.saveCustomOnly(holderlookup_a);
    }

    public static void triggerCooldown(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        if (!world.isClientSide) {
            tileentityendgateway.teleportCooldown = 40;
            world.blockEvent(blockposition, iblockdata.getBlock(), 1, 0);
            TileEntityEndGateway.setChanged(world, blockposition, iblockdata);
        }
    }

    @Override
    public boolean triggerEvent(int i2, int j2) {
        if (i2 == 1) {
            this.teleportCooldown = 40;
            return true;
        }
        return super.triggerEvent(i2, j2);
    }

    @Nullable
    public Vec3D getPortalPosition(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition blockposition1;
        if (this.exitPortal == null && worldserver.getTypeKey() == WorldDimension.END) {
            blockposition1 = TileEntityEndGateway.findOrCreateValidTeleportPos(worldserver, blockposition);
            blockposition1 = blockposition1.above(10);
            LOGGER.debug("Creating portal at {}", (Object)blockposition1);
            TileEntityEndGateway.spawnGatewayPortal(worldserver, blockposition1, WorldGenEndGatewayConfiguration.knownExit(blockposition, false));
            this.setExitPosition(blockposition1, this.exactTeleport);
        }
        if (this.exitPortal != null) {
            blockposition1 = this.exactTeleport ? this.exitPortal : TileEntityEndGateway.findExitPosition(worldserver, this.exitPortal);
            return blockposition1.getBottomCenter();
        }
        return null;
    }

    private static BlockPosition findExitPosition(World world, BlockPosition blockposition) {
        BlockPosition blockposition1 = TileEntityEndGateway.findTallestBlock(world, blockposition.offset(0, 2, 0), 5, false);
        LOGGER.debug("Best exit position for portal at {} is {}", (Object)blockposition, (Object)blockposition1);
        return blockposition1.above();
    }

    private static BlockPosition findOrCreateValidTeleportPos(WorldServer worldserver, BlockPosition blockposition) {
        Vec3D vec3d = TileEntityEndGateway.findExitPortalXZPosTentative(worldserver, blockposition);
        Chunk chunk = TileEntityEndGateway.getChunk(worldserver, vec3d);
        BlockPosition blockposition1 = TileEntityEndGateway.findValidSpawnInChunk(chunk);
        if (blockposition1 == null) {
            BlockPosition blockposition2 = BlockPosition.containing(vec3d.x + 0.5, 75.0, vec3d.z + 0.5);
            LOGGER.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)blockposition2);
            worldserver.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(iregistry -> iregistry.getHolder(EndFeatures.END_ISLAND)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.value()).place(worldserver, worldserver.getChunkSource().getGenerator(), RandomSource.create(blockposition2.asLong()), blockposition2));
            blockposition1 = blockposition2;
        } else {
            LOGGER.debug("Found suitable block to teleport to: {}", (Object)blockposition1);
        }
        return TileEntityEndGateway.findTallestBlock(worldserver, blockposition1, 16, true);
    }

    private static Vec3D findExitPortalXZPosTentative(WorldServer worldserver, BlockPosition blockposition) {
        Vec3D vec3d = new Vec3D(blockposition.getX(), 0.0, blockposition.getZ()).normalize();
        boolean flag = true;
        Vec3D vec3d1 = vec3d.scale(1024.0);
        int i2 = 16;
        while (!TileEntityEndGateway.isChunkEmpty(worldserver, vec3d1) && i2-- > 0) {
            LOGGER.debug("Skipping backwards past nonempty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.add(vec3d.scale(-16.0));
        }
        i2 = 16;
        while (TileEntityEndGateway.isChunkEmpty(worldserver, vec3d1) && i2-- > 0) {
            LOGGER.debug("Skipping forward past empty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.add(vec3d.scale(16.0));
        }
        LOGGER.debug("Found chunk at {}", (Object)vec3d1);
        return vec3d1;
    }

    private static boolean isChunkEmpty(WorldServer worldserver, Vec3D vec3d) {
        return TileEntityEndGateway.getChunk(worldserver, vec3d).getHighestFilledSectionIndex() == -1;
    }

    private static BlockPosition findTallestBlock(IBlockAccess iblockaccess, BlockPosition blockposition, int i2, boolean flag) {
        BaseBlockPosition blockposition1 = null;
        for (int j2 = -i2; j2 <= i2; ++j2) {
            block1: for (int k2 = -i2; k2 <= i2; ++k2) {
                if (j2 == 0 && k2 == 0 && !flag) continue;
                for (int l2 = iblockaccess.getMaxBuildHeight() - 1; l2 > (blockposition1 == null ? iblockaccess.getMinBuildHeight() : blockposition1.getY()); --l2) {
                    BlockPosition blockposition2 = new BlockPosition(blockposition.getX() + j2, l2, blockposition.getZ() + k2);
                    IBlockData iblockdata = iblockaccess.getBlockState(blockposition2);
                    if (!iblockdata.isCollisionShapeFullBlock(iblockaccess, blockposition2) || !flag && iblockdata.is(Blocks.BEDROCK)) continue;
                    blockposition1 = blockposition2;
                    continue block1;
                }
            }
        }
        return blockposition1 == null ? blockposition : blockposition1;
    }

    private static Chunk getChunk(World world, Vec3D vec3d) {
        return world.getChunk(MathHelper.floor(vec3d.x / 16.0), MathHelper.floor(vec3d.z / 16.0));
    }

    @Nullable
    private static BlockPosition findValidSpawnInChunk(Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.getPos();
        BlockPosition blockposition = new BlockPosition(chunkcoordintpair.getMinBlockX(), 30, chunkcoordintpair.getMinBlockZ());
        int i2 = chunk.getHighestSectionPosition() + 16 - 1;
        BlockPosition blockposition1 = new BlockPosition(chunkcoordintpair.getMaxBlockX(), i2, chunkcoordintpair.getMaxBlockZ());
        BlockPosition blockposition2 = null;
        double d0 = 0.0;
        for (BlockPosition blockposition3 : BlockPosition.betweenClosed(blockposition, blockposition1)) {
            IBlockData iblockdata = chunk.getBlockState(blockposition3);
            BlockPosition blockposition4 = blockposition3.above();
            BlockPosition blockposition5 = blockposition3.above(2);
            if (!iblockdata.is(Blocks.END_STONE) || chunk.getBlockState(blockposition4).isCollisionShapeFullBlock(chunk, blockposition4) || chunk.getBlockState(blockposition5).isCollisionShapeFullBlock(chunk, blockposition5)) continue;
            double d1 = blockposition3.distToCenterSqr(0.0, 0.0, 0.0);
            if (blockposition2 != null && !(d1 < d0)) continue;
            blockposition2 = blockposition3;
            d0 = d1;
        }
        return blockposition2;
    }

    private static void spawnGatewayPortal(WorldServer worldserver, BlockPosition blockposition, WorldGenEndGatewayConfiguration worldgenendgatewayconfiguration) {
        WorldGenerator.END_GATEWAY.place(worldgenendgatewayconfiguration, worldserver, worldserver.getChunkSource().getGenerator(), RandomSource.create(), blockposition);
    }

    @Override
    public boolean shouldRenderFace(EnumDirection enumdirection) {
        return Block.shouldRenderFace(this.getBlockState(), this.level, this.getBlockPos(), enumdirection, this.getBlockPos().relative(enumdirection));
    }

    public int getParticleAmount() {
        int i2 = 0;
        for (EnumDirection enumdirection : EnumDirection.values()) {
            i2 += this.shouldRenderFace(enumdirection) ? 1 : 0;
        }
        return i2;
    }

    public void setExitPosition(BlockPosition blockposition, boolean flag) {
        this.exactTeleport = flag;
        this.exitPortal = blockposition;
        this.setChanged();
    }
}

