/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeCraftingHolder,
AutoRecipeOutput {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    protected NonNullList<net.minecraft.world.item.ItemStack> items;
    public int litTime;
    int litDuration;
    public int cookingProgress;
    public int cookingTotalTime;
    @Nullable
    private static volatile Map<Item, Integer> fuelCache;
    protected final IContainerProperties dataAccess;
    public final Object2IntOpenHashMap<MinecraftKey> recipesUsed;
    private final CraftingManager.a<SingleRecipeInput, ? extends RecipeCooking> quickCheck;
    private int maxStack = 99;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected TileEntityFurnace(TileEntityTypes<?> tileentitytypes, BlockPosition blockposition, IBlockData iblockdata, Recipes<? extends RecipeCooking> recipes) {
        super(tileentitytypes, blockposition, iblockdata);
        this.items = NonNullList.withSize(3, net.minecraft.world.item.ItemStack.EMPTY);
        this.dataAccess = new IContainerProperties(){

            @Override
            public int get(int i2) {
                switch (i2) {
                    case 0: {
                        return TileEntityFurnace.this.litTime;
                    }
                    case 1: {
                        return TileEntityFurnace.this.litDuration;
                    }
                    case 2: {
                        return TileEntityFurnace.this.cookingProgress;
                    }
                    case 3: {
                        return TileEntityFurnace.this.cookingTotalTime;
                    }
                }
                return 0;
            }

            @Override
            public void set(int i2, int j2) {
                switch (i2) {
                    case 0: {
                        TileEntityFurnace.this.litTime = j2;
                        break;
                    }
                    case 1: {
                        TileEntityFurnace.this.litDuration = j2;
                        break;
                    }
                    case 2: {
                        TileEntityFurnace.this.cookingProgress = j2;
                        break;
                    }
                    case 3: {
                        TileEntityFurnace.this.cookingTotalTime = j2;
                    }
                }
            }

            @Override
            public int getCount() {
                return 4;
            }
        };
        this.recipesUsed = new Object2IntOpenHashMap();
        this.quickCheck = CraftingManager.createCheck(recipes);
    }

    public static void invalidateCache() {
        fuelCache = null;
    }

    public static Map<Item, Integer> getFuel() {
        Map<Item, Integer> map = fuelCache;
        if (map != null) {
            return map;
        }
        LinkedHashMap map1 = Maps.newLinkedHashMap();
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.LAVA_BUCKET, 20000);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.COAL_BLOCK, 16000);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.BLAZE_ROD, 2400);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.COAL, 1600);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.CHARCOAL, 1600);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.LOGS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.BAMBOO_BLOCKS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.PLANKS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.BAMBOO_MOSAIC, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.WOODEN_STAIRS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.BAMBOO_MOSAIC_STAIRS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.WOODEN_SLABS, 150);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.BAMBOO_MOSAIC_SLAB, 150);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.WOODEN_TRAPDOORS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.WOODEN_PRESSURE_PLATES, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.WOODEN_FENCES, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.FENCE_GATES, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.NOTE_BLOCK, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.BOOKSHELF, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.CHISELED_BOOKSHELF, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.LECTERN, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.JUKEBOX, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.CHEST, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.TRAPPED_CHEST, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.CRAFTING_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.DAYLIGHT_DETECTOR, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.BANNERS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.BOW, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.FISHING_ROD, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.LADDER, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.SIGNS, 200);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.HANGING_SIGNS, 800);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.WOODEN_SHOVEL, 200);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.WOODEN_SWORD, 200);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.WOODEN_HOE, 200);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.WOODEN_AXE, 200);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.WOODEN_PICKAXE, 200);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.WOODEN_DOORS, 200);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.BOATS, 1200);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.WOOL, 100);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.WOODEN_BUTTONS, 100);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.STICK, 100);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.SAPLINGS, 100);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.BOWL, 100);
        TileEntityFurnace.add((Map<Item, Integer>)map1, TagsItem.WOOL_CARPETS, 67);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.DRIED_KELP_BLOCK, 4001);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Items.CROSSBOW, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.BAMBOO, 50);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.DEAD_BUSH, 100);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.SCAFFOLDING, 50);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.LOOM, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.BARREL, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.CARTOGRAPHY_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.FLETCHING_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.SMITHING_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.COMPOSTER, 300);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.AZALEA, 100);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.FLOWERING_AZALEA, 100);
        TileEntityFurnace.add((Map<Item, Integer>)map1, Blocks.MANGROVE_ROOTS, 300);
        fuelCache = map1;
        return map1;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public Object2IntOpenHashMap<MinecraftKey> getRecipesUsed() {
        return this.recipesUsed;
    }

    private static boolean isNeverAFurnaceFuel(Item item) {
        return item.builtInRegistryHolder().is(TagsItem.NON_FLAMMABLE_WOOD);
    }

    private static void add(Map<Item, Integer> map, TagKey<Item> tagkey, int i2) {
        for (Holder<Item> holder : BuiltInRegistries.ITEM.getTagOrEmpty(tagkey)) {
            if (TileEntityFurnace.isNeverAFurnaceFuel(holder.value())) continue;
            map.put(holder.value(), i2);
        }
    }

    private static void add(Map<Item, Integer> map, IMaterial imaterial, int i2) {
        Item item = imaterial.asItem();
        if (TileEntityFurnace.isNeverAFurnaceFuel(item)) {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                throw SystemUtils.pauseInIde(new IllegalStateException("A developer tried to explicitly make fire resistant item " + item.getName(null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            map.put(item, i2);
        }
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.items = NonNullList.withSize(this.getContainerSize(), net.minecraft.world.item.ItemStack.EMPTY);
        ContainerUtil.loadAllItems(nbttagcompound, this.items, holderlookup_a);
        this.litTime = nbttagcompound.getShort("BurnTime");
        this.cookingProgress = nbttagcompound.getShort("CookTime");
        this.cookingTotalTime = nbttagcompound.getShort("CookTimeTotal");
        this.litDuration = this.getBurnDuration(this.items.get(1));
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("RecipesUsed");
        for (String s2 : nbttagcompound1.getAllKeys()) {
            this.recipesUsed.put((Object)MinecraftKey.parse(s2), nbttagcompound1.getInt(s2));
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        nbttagcompound.putShort("BurnTime", (short)this.litTime);
        nbttagcompound.putShort("CookTime", (short)this.cookingProgress);
        nbttagcompound.putShort("CookTimeTotal", (short)this.cookingTotalTime);
        ContainerUtil.saveAllItems(nbttagcompound, this.items, holderlookup_a);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.recipesUsed.forEach((minecraftkey, integer) -> nbttagcompound1.putInt(minecraftkey.toString(), (int)integer));
        nbttagcompound.put("RecipesUsed", nbttagcompound1);
    }

    public static void serverTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityFurnace tileentityfurnace) {
        boolean flag3;
        boolean flag = tileentityfurnace.isLit();
        boolean flag1 = false;
        if (tileentityfurnace.isLit()) {
            --tileentityfurnace.litTime;
        }
        net.minecraft.world.item.ItemStack itemstack = tileentityfurnace.items.get(1);
        net.minecraft.world.item.ItemStack itemstack1 = tileentityfurnace.items.get(0);
        boolean flag2 = !itemstack1.isEmpty();
        boolean bl = flag3 = !itemstack.isEmpty();
        if (!(tileentityfurnace.isLit() || flag3 && flag2)) {
            if (!tileentityfurnace.isLit() && tileentityfurnace.cookingProgress > 0) {
                tileentityfurnace.cookingProgress = MathHelper.clamp(tileentityfurnace.cookingProgress - 2, 0, tileentityfurnace.cookingTotalTime);
            }
        } else {
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)tileentityfurnace.quickCheck.getRecipeFor(new SingleRecipeInput(itemstack1), world).orElse(null) : null;
            int i2 = tileentityfurnace.getMaxStackSize();
            if (!tileentityfurnace.isLit() && TileEntityFurnace.canBurn(world.registryAccess(), recipeholder, tileentityfurnace.items, i2)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)fuel, tileentityfurnace.getBurnDuration(itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                tileentityfurnace.litDuration = tileentityfurnace.litTime = furnaceBurnEvent.getBurnTime();
                if (tileentityfurnace.isLit() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (flag3) {
                        Item item = itemstack.getItem();
                        itemstack.shrink(1);
                        if (itemstack.isEmpty()) {
                            Item item1 = item.getCraftingRemainingItem();
                            tileentityfurnace.items.set(1, item1 == null ? net.minecraft.world.item.ItemStack.EMPTY : new net.minecraft.world.item.ItemStack(item1));
                        }
                    }
                }
            }
            if (tileentityfurnace.isLit() && TileEntityFurnace.canBurn(world.registryAccess(), recipeholder, tileentityfurnace.items, i2)) {
                if (recipeholder != null && tileentityfurnace.cookingProgress == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(tileentityfurnace.items.get(0));
                    CookingRecipe recipe = (CookingRecipe)recipeholder.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, recipe);
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    tileentityfurnace.cookingTotalTime = event.getTotalCookTime();
                }
                ++tileentityfurnace.cookingProgress;
                if (tileentityfurnace.cookingProgress == tileentityfurnace.cookingTotalTime) {
                    tileentityfurnace.cookingProgress = 0;
                    tileentityfurnace.cookingTotalTime = TileEntityFurnace.getTotalCookTime(world, tileentityfurnace);
                    if (TileEntityFurnace.burn(tileentityfurnace.level, tileentityfurnace.worldPosition, world.registryAccess(), recipeholder, tileentityfurnace.items, i2)) {
                        tileentityfurnace.setRecipeUsed(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                tileentityfurnace.cookingProgress = 0;
            }
        }
        if (flag != tileentityfurnace.isLit()) {
            flag1 = true;
            iblockdata = (IBlockData)iblockdata.setValue(BlockFurnace.LIT, tileentityfurnace.isLit());
            world.setBlock(blockposition, iblockdata, 3);
        }
        if (flag1) {
            TileEntityFurnace.setChanged(world, blockposition, iblockdata);
        }
    }

    private static boolean canBurn(IRegistryCustom iregistrycustom, @Nullable RecipeHolder<?> recipeholder, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (!nonnulllist.get(0).isEmpty() && recipeholder != null) {
            net.minecraft.world.item.ItemStack itemstack = recipeholder.value().getResultItem(iregistrycustom);
            if (itemstack.isEmpty()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = nonnulllist.get(2);
            return itemstack1.isEmpty() ? true : (!net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack1, itemstack) ? false : (itemstack1.getCount() < i2 && itemstack1.getCount() < itemstack1.getMaxStackSize() ? true : itemstack1.getCount() < itemstack.getMaxStackSize()));
        }
        return false;
    }

    private static boolean burn(World world, BlockPosition blockposition, IRegistryCustom iregistrycustom, @Nullable RecipeHolder<?> recipeholder, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (recipeholder != null && TileEntityFurnace.canBurn(iregistrycustom, recipeholder, nonnulllist, i2)) {
            net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(0);
            net.minecraft.world.item.ItemStack itemstack1 = recipeholder.value().getResultItem(iregistrycustom);
            net.minecraft.world.item.ItemStack itemstack2 = nonnulllist.get(2);
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result);
            world.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return false;
            }
            result = furnaceSmeltEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            if (!itemstack1.isEmpty()) {
                if (itemstack2.isEmpty()) {
                    nonnulllist.set(2, itemstack1.copy());
                } else if (CraftItemStack.asCraftMirror(itemstack2).isSimilar(result)) {
                    itemstack2.grow(itemstack1.getCount());
                } else {
                    return false;
                }
            }
            if (itemstack.is(Blocks.WET_SPONGE.asItem()) && !nonnulllist.get(1).isEmpty() && nonnulllist.get(1).is(Items.BUCKET)) {
                nonnulllist.set(1, new net.minecraft.world.item.ItemStack(Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(net.minecraft.world.item.ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            return 0;
        }
        Item item = itemstack.getItem();
        return TileEntityFurnace.getFuel().getOrDefault(item, 0);
    }

    private static int getTotalCookTime(World world, TileEntityFurnace tileentityfurnace) {
        if (world == null) {
            return 200;
        }
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(tileentityfurnace.getItem(0));
        return tileentityfurnace.quickCheck.getRecipeFor(singlerecipeinput, world).map(recipeholder -> ((RecipeCooking)recipeholder.value()).getCookingTime()).orElse(200);
    }

    public static boolean isFuel(net.minecraft.world.item.ItemStack itemstack) {
        return TileEntityFurnace.getFuel().containsKey(itemstack.getItem());
    }

    @Override
    public int[] getSlotsForFace(EnumDirection enumdirection) {
        return enumdirection == EnumDirection.DOWN ? SLOTS_FOR_DOWN : (enumdirection == EnumDirection.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES);
    }

    @Override
    public boolean canPlaceItemThroughFace(int i2, net.minecraft.world.item.ItemStack itemstack, @Nullable EnumDirection enumdirection) {
        return this.canPlaceItem(i2, itemstack);
    }

    @Override
    public boolean canTakeItemThroughFace(int i2, net.minecraft.world.item.ItemStack itemstack, EnumDirection enumdirection) {
        return enumdirection == EnumDirection.DOWN && i2 == 1 ? itemstack.is(Items.WATER_BUCKET) || itemstack.is(Items.BUCKET) : true;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    @Override
    public void setItem(int i2, net.minecraft.world.item.ItemStack itemstack) {
        net.minecraft.world.item.ItemStack itemstack1 = this.items.get(i2);
        boolean flag = !itemstack.isEmpty() && net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack1, itemstack);
        this.items.set(i2, itemstack);
        itemstack.limitSize(this.getMaxStackSize(itemstack));
        if (i2 == 0 && !flag) {
            this.cookingTotalTime = TileEntityFurnace.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean canPlaceItem(int i2, net.minecraft.world.item.ItemStack itemstack) {
        if (i2 == 2) {
            return false;
        }
        if (i2 != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.items.get(1);
        return TileEntityFurnace.isFuel(itemstack) || itemstack.is(Items.BUCKET) && !itemstack1.is(Items.BUCKET);
    }

    @Override
    public void setRecipeUsed(@Nullable RecipeHolder<?> recipeholder) {
        if (recipeholder != null) {
            MinecraftKey minecraftkey = recipeholder.id();
            this.recipesUsed.addTo((Object)minecraftkey, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void awardUsedRecipes(EntityHuman entityhuman, List<net.minecraft.world.item.ItemStack> list) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(entityplayer.serverLevel(), entityplayer.position(), this.worldPosition, entityplayer, itemstack, amount);
        entityplayer.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            entityplayer.triggerRecipeCrafted(recipeholder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(WorldServer worldserver, Vec3D vec3d) {
        return this.getRecipesToAwardAndPopExperience(worldserver, vec3d, this.worldPosition, null, null, 0);
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(WorldServer worldserver, Vec3D vec3d, BlockPosition blockposition, EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            worldserver.getRecipeManager().byKey((MinecraftKey)entry.getKey()).ifPresent(recipeholder -> {
                list.add(recipeholder);
                TileEntityFurnace.createExperience(worldserver, vec3d, entry.getIntValue(), ((RecipeCooking)recipeholder.value()).getExperience(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void createExperience(WorldServer worldserver, Vec3D vec3d, int i2, float f2, BlockPosition blockposition, EntityHuman entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        int j2 = MathHelper.floor((float)i2 * f2);
        float f1 = MathHelper.frac((float)i2 * f2);
        if (f1 != 0.0f && Math.random() < (double)f1) {
            ++j2;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((Player)entityhuman.getBukkitEntity(), (Block)CraftBlock.at(worldserver, blockposition), CraftItemType.minecraftToBukkit(itemstack.getItem()), amount, j2) : new BlockExpEvent((Block)CraftBlock.at(worldserver, blockposition), j2);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        j2 = event.getExpToDrop();
        EntityExperienceOrb.award(worldserver, vec3d, j2);
    }

    @Override
    public void fillStackedContents(AutoRecipeStackManager autorecipestackmanager) {
        for (net.minecraft.world.item.ItemStack itemstack : this.items) {
            autorecipestackmanager.accountStack(itemstack);
        }
    }
}

