/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.entity.IHopper;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TileEntityHopper
extends TileEntityLootable
implements IHopper {
    public static final int MOVE_ITEM_SPEED = 8;
    public static final int HOPPER_CONTAINER_SIZE = 5;
    private static final int[][] CACHED_SLOTS = new int[54][];
    private NonNullList<net.minecraft.world.item.ItemStack> items;
    private int cooldownTime = -1;
    private long tickedGameTime;
    private EnumDirection facing;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public TileEntityHopper(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.HOPPER, blockposition, iblockdata);
        this.items = NonNullList.withSize(5, net.minecraft.world.item.ItemStack.EMPTY);
        this.facing = iblockdata.getValue(BlockHopper.FACING);
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.items = NonNullList.withSize(this.getContainerSize(), net.minecraft.world.item.ItemStack.EMPTY);
        if (!this.tryLoadLootTable(nbttagcompound)) {
            ContainerUtil.loadAllItems(nbttagcompound, this.items, holderlookup_a);
        }
        this.cooldownTime = nbttagcompound.getInt("TransferCooldown");
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        if (!this.trySaveLootTable(nbttagcompound)) {
            ContainerUtil.saveAllItems(nbttagcompound, this.items, holderlookup_a);
        }
        nbttagcompound.putInt("TransferCooldown", this.cooldownTime);
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public net.minecraft.world.item.ItemStack removeItem(int i2, int j2) {
        this.unpackLootTable(null);
        return ContainerUtil.removeItem(this.getItems(), i2, j2);
    }

    @Override
    public void setItem(int i2, net.minecraft.world.item.ItemStack itemstack) {
        this.unpackLootTable(null);
        this.getItems().set(i2, itemstack);
        itemstack.limitSize(this.getMaxStackSize(itemstack));
    }

    @Override
    public void setBlockState(IBlockData iblockdata) {
        super.setBlockState(iblockdata);
        this.facing = iblockdata.getValue(BlockHopper.FACING);
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.hopper");
    }

    public static void pushItemsTick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityHopper tileentityhopper) {
        --tileentityhopper.cooldownTime;
        tileentityhopper.tickedGameTime = world.getGameTime();
        if (!tileentityhopper.isOnCooldown()) {
            tileentityhopper.setCooldown(0);
            boolean result = TileEntityHopper.tryMoveItems(world, blockposition, iblockdata, tileentityhopper, () -> TileEntityHopper.suckInItems(world, tileentityhopper));
            if (!result && tileentityhopper.level.spigotConfig.hopperCheck > 1) {
                tileentityhopper.setCooldown(tileentityhopper.level.spigotConfig.hopperCheck);
            }
        }
    }

    private static boolean tryMoveItems(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityHopper tileentityhopper, BooleanSupplier booleansupplier) {
        if (world.isClientSide) {
            return false;
        }
        if (!tileentityhopper.isOnCooldown() && iblockdata.getValue(BlockHopper.ENABLED).booleanValue()) {
            boolean flag = false;
            if (!tileentityhopper.isEmpty()) {
                flag = TileEntityHopper.ejectItems(world, blockposition, tileentityhopper);
            }
            if (!tileentityhopper.inventoryFull()) {
                flag |= booleansupplier.getAsBoolean();
            }
            if (flag) {
                tileentityhopper.setCooldown(world.spigotConfig.hopperTransfer);
                TileEntityHopper.setChanged(world, blockposition, iblockdata);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        net.minecraft.world.item.ItemStack itemstack;
        Iterator iterator = this.items.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(itemstack = (net.minecraft.world.item.ItemStack)iterator.next()).isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize());
        return false;
    }

    private static boolean ejectItems(World world, BlockPosition blockposition, TileEntityHopper tileentityhopper) {
        IInventory iinventory = TileEntityHopper.getAttachedContainer(world, blockposition, tileentityhopper);
        if (iinventory == null) {
            return false;
        }
        EnumDirection enumdirection = tileentityhopper.facing.getOpposite();
        if (TileEntityHopper.isFullContainer(iinventory, enumdirection)) {
            return false;
        }
        for (int i2 = 0; i2 < tileentityhopper.getContainerSize(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = tileentityhopper.getItem(i2);
            if (itemstack.isEmpty()) continue;
            int j2 = itemstack.getCount();
            net.minecraft.world.item.ItemStack original = itemstack.copy();
            CraftItemStack oitemstack = CraftItemStack.asCraftMirror(tileentityhopper.removeItem(i2, world.spigotConfig.hopperAmount));
            Object destinationInventory = iinventory instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)iinventory) : (iinventory.getOwner() != null ? iinventory.getOwner().getInventory() : new CraftInventory(iinventory));
            InventoryMoveItemEvent event = new InventoryMoveItemEvent(tileentityhopper.getOwner().getInventory(), (ItemStack)oitemstack, (Inventory)destinationInventory, true);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                tileentityhopper.setItem(i2, original);
                tileentityhopper.setCooldown(world.spigotConfig.hopperTransfer);
                return false;
            }
            int origCount = event.getItem().getAmount();
            net.minecraft.world.item.ItemStack itemstack1 = TileEntityHopper.addItem(tileentityhopper, iinventory, CraftItemStack.asNMSCopy(event.getItem()), enumdirection);
            if (itemstack1.isEmpty()) {
                iinventory.setChanged();
                return true;
            }
            itemstack.setCount(j2);
            itemstack.shrink(origCount - itemstack1.getCount());
            if (j2 > world.spigotConfig.hopperAmount) continue;
            tileentityhopper.setItem(i2, itemstack);
        }
        return false;
    }

    private static int[] getSlots(IInventory iinventory, EnumDirection enumdirection) {
        if (iinventory instanceof IWorldInventory) {
            IWorldInventory iworldinventory = (IWorldInventory)iinventory;
            return iworldinventory.getSlotsForFace(enumdirection);
        }
        int i2 = iinventory.getContainerSize();
        if (i2 < CACHED_SLOTS.length) {
            int[] aint = CACHED_SLOTS[i2];
            if (aint != null) {
                return aint;
            }
            int[] aint1 = TileEntityHopper.createFlatSlots(i2);
            TileEntityHopper.CACHED_SLOTS[i2] = aint1;
            return aint1;
        }
        return TileEntityHopper.createFlatSlots(i2);
    }

    private static int[] createFlatSlots(int i2) {
        int[] aint = new int[i2];
        int j2 = 0;
        while (j2 < aint.length) {
            aint[j2] = j2++;
        }
        return aint;
    }

    private static boolean isFullContainer(IInventory iinventory, EnumDirection enumdirection) {
        int[] aint;
        int[] aint1 = aint = TileEntityHopper.getSlots(iinventory, enumdirection);
        int i2 = aint.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = aint1[j2];
            net.minecraft.world.item.ItemStack itemstack = iinventory.getItem(k2);
            if (itemstack.getCount() >= itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public static boolean suckInItems(World world, IHopper ihopper) {
        boolean flag;
        IBlockData iblockdata;
        BlockPosition blockposition = BlockPosition.containing(ihopper.getLevelX(), ihopper.getLevelY() + 1.0, ihopper.getLevelZ());
        IInventory iinventory = TileEntityHopper.getSourceContainer(world, ihopper, blockposition, iblockdata = world.getBlockState(blockposition));
        if (iinventory != null) {
            EnumDirection enumdirection = EnumDirection.DOWN;
            for (int k2 : TileEntityHopper.getSlots(iinventory, enumdirection)) {
                if (!TileEntityHopper.tryTakeInItemFromSlot(ihopper, iinventory, k2, enumdirection, world)) continue;
                return true;
            }
            return false;
        }
        boolean bl = flag = ihopper.isGridAligned() && iblockdata.isCollisionShapeFullBlock(world, blockposition) && !iblockdata.is(TagsBlock.DOES_NOT_BLOCK_HOPPERS);
        if (!flag) {
            for (EntityItem entityitem : TileEntityHopper.getItemsAtAndAbove(world, ihopper)) {
                if (!TileEntityHopper.addItem(ihopper, entityitem)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(IHopper ihopper, IInventory iinventory, int i2, EnumDirection enumdirection, World world) {
        net.minecraft.world.item.ItemStack itemstack = iinventory.getItem(i2);
        if (!itemstack.isEmpty() && TileEntityHopper.canTakeItemFromContainer(ihopper, iinventory, itemstack, i2, enumdirection)) {
            int j2 = itemstack.getCount();
            net.minecraft.world.item.ItemStack original = itemstack.copy();
            CraftItemStack oitemstack = CraftItemStack.asCraftMirror(iinventory.removeItem(i2, world.spigotConfig.hopperAmount));
            Object sourceInventory = iinventory instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)iinventory) : (iinventory.getOwner() != null ? iinventory.getOwner().getInventory() : new CraftInventory(iinventory));
            InventoryMoveItemEvent event = new InventoryMoveItemEvent((Inventory)sourceInventory, (ItemStack)oitemstack, ihopper.getOwner().getInventory(), false);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                iinventory.setItem(i2, original);
                if (ihopper instanceof TileEntityHopper) {
                    ((TileEntityHopper)ihopper).setCooldown(world.spigotConfig.hopperTransfer);
                }
                return false;
            }
            int origCount = event.getItem().getAmount();
            net.minecraft.world.item.ItemStack itemstack1 = TileEntityHopper.addItem(iinventory, ihopper, CraftItemStack.asNMSCopy(event.getItem()), null);
            if (itemstack1.isEmpty()) {
                iinventory.setChanged();
                return true;
            }
            itemstack.setCount(j2);
            itemstack.shrink(origCount - itemstack1.getCount());
            if (j2 <= world.spigotConfig.hopperAmount) {
                iinventory.setItem(i2, itemstack);
            }
        }
        return false;
    }

    public static boolean addItem(IInventory iinventory, EntityItem entityitem) {
        boolean flag = false;
        InventoryPickupItemEvent event = new InventoryPickupItemEvent(iinventory.getOwner().getInventory(), (Item)entityitem.getBukkitEntity());
        entityitem.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = entityitem.getItem().copy();
        net.minecraft.world.item.ItemStack itemstack1 = TileEntityHopper.addItem(null, iinventory, itemstack, null);
        if (itemstack1.isEmpty()) {
            flag = true;
            entityitem.setItem(net.minecraft.world.item.ItemStack.EMPTY);
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
        } else {
            entityitem.setItem(itemstack1);
        }
        return flag;
    }

    public static net.minecraft.world.item.ItemStack addItem(@Nullable IInventory iinventory, IInventory iinventory1, net.minecraft.world.item.ItemStack itemstack, @Nullable EnumDirection enumdirection) {
        if (iinventory1 instanceof IWorldInventory) {
            IWorldInventory iworldinventory = (IWorldInventory)iinventory1;
            if (enumdirection != null) {
                int[] aint = iworldinventory.getSlotsForFace(enumdirection);
                for (int i2 = 0; i2 < aint.length && !itemstack.isEmpty(); ++i2) {
                    itemstack = TileEntityHopper.tryMoveInItem(iinventory, iinventory1, itemstack, aint[i2], enumdirection);
                }
                return itemstack;
            }
        }
        int j2 = iinventory1.getContainerSize();
        for (int i3 = 0; i3 < j2 && !itemstack.isEmpty(); ++i3) {
            itemstack = TileEntityHopper.tryMoveInItem(iinventory, iinventory1, itemstack, i3, enumdirection);
        }
        return itemstack;
    }

    private static boolean canPlaceItemInContainer(IInventory iinventory, net.minecraft.world.item.ItemStack itemstack, int i2, @Nullable EnumDirection enumdirection) {
        IWorldInventory iworldinventory;
        if (!iinventory.canPlaceItem(i2, itemstack)) {
            return false;
        }
        if (iinventory instanceof IWorldInventory && !(iworldinventory = (IWorldInventory)iinventory).canPlaceItemThroughFace(i2, itemstack, enumdirection)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static boolean canTakeItemFromContainer(IInventory iinventory, IInventory iinventory1, net.minecraft.world.item.ItemStack itemstack, int i2, EnumDirection enumdirection) {
        IWorldInventory iworldinventory;
        if (!iinventory1.canTakeItem(iinventory, i2, itemstack)) {
            return false;
        }
        if (iinventory1 instanceof IWorldInventory && !(iworldinventory = (IWorldInventory)iinventory1).canTakeItemThroughFace(i2, itemstack, enumdirection)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static net.minecraft.world.item.ItemStack tryMoveInItem(@Nullable IInventory iinventory, IInventory iinventory1, net.minecraft.world.item.ItemStack itemstack, int i2, @Nullable EnumDirection enumdirection) {
        net.minecraft.world.item.ItemStack itemstack1 = iinventory1.getItem(i2);
        if (TileEntityHopper.canPlaceItemInContainer(iinventory1, itemstack, i2, enumdirection)) {
            boolean flag = false;
            boolean flag1 = iinventory1.isEmpty();
            if (itemstack1.isEmpty()) {
                if (!itemstack.isEmpty() && itemstack.getCount() > iinventory1.getMaxStackSize()) {
                    itemstack = itemstack.split(iinventory1.getMaxStackSize());
                }
                iinventory1.setItem(i2, itemstack);
                itemstack = net.minecraft.world.item.ItemStack.EMPTY;
                flag = true;
            } else if (TileEntityHopper.canMergeItems(itemstack1, itemstack)) {
                int j2 = itemstack.getMaxStackSize() - itemstack1.getCount();
                int k2 = Math.min(itemstack.getCount(), j2);
                itemstack.shrink(k2);
                itemstack1.grow(k2);
                boolean bl = flag = k2 > 0;
            }
            if (flag) {
                TileEntityHopper tileentityhopper;
                if (flag1 && iinventory1 instanceof TileEntityHopper && !(tileentityhopper = (TileEntityHopper)iinventory1).isOnCustomCooldown()) {
                    int b0 = 0;
                    if (iinventory instanceof TileEntityHopper) {
                        TileEntityHopper tileentityhopper1 = (TileEntityHopper)iinventory;
                        if (tileentityhopper.tickedGameTime >= tileentityhopper1.tickedGameTime) {
                            b0 = 1;
                        }
                    }
                    tileentityhopper.setCooldown(tileentityhopper.level.spigotConfig.hopperTransfer - b0);
                }
                iinventory1.setChanged();
            }
        }
        return itemstack;
    }

    @Nullable
    private static IInventory runHopperInventorySearchEvent(IInventory inventory, CraftBlock hopper, CraftBlock searchLocation, HopperInventorySearchEvent.ContainerType containerType) {
        HopperInventorySearchEvent event = new HopperInventorySearchEvent((Inventory)(inventory != null ? new CraftInventory(inventory) : null), containerType, (org.bukkit.block.Block)hopper, (org.bukkit.block.Block)searchLocation);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        CraftInventory craftInventory = (CraftInventory)event.getInventory();
        return craftInventory != null ? craftInventory.getInventory() : null;
    }

    @Nullable
    private static IInventory getAttachedContainer(World world, BlockPosition blockposition, TileEntityHopper tileentityhopper) {
        BlockPosition searchPosition = blockposition.relative(tileentityhopper.facing);
        IInventory inventory = TileEntityHopper.getContainerAt(world, searchPosition);
        CraftBlock hopper = CraftBlock.at(world, blockposition);
        CraftBlock searchBlock = CraftBlock.at(world, searchPosition);
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper, searchBlock, HopperInventorySearchEvent.ContainerType.DESTINATION);
    }

    @Nullable
    private static IInventory getSourceContainer(World world, IHopper ihopper, BlockPosition blockposition, IBlockData iblockdata) {
        IInventory inventory = TileEntityHopper.getContainerAt(world, blockposition, iblockdata, ihopper.getLevelX(), ihopper.getLevelY() + 1.0, ihopper.getLevelZ());
        BlockPosition blockPosition = BlockPosition.containing(ihopper.getLevelX(), ihopper.getLevelY(), ihopper.getLevelZ());
        CraftBlock hopper = CraftBlock.at(world, blockPosition);
        CraftBlock container = CraftBlock.at(world, blockPosition.above());
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper, container, HopperInventorySearchEvent.ContainerType.SOURCE);
    }

    public static List<EntityItem> getItemsAtAndAbove(World world, IHopper ihopper) {
        AxisAlignedBB axisalignedbb = ihopper.getSuckAabb().move(ihopper.getLevelX() - 0.5, ihopper.getLevelY() - 0.5, ihopper.getLevelZ() - 0.5);
        return world.getEntitiesOfClass(EntityItem.class, axisalignedbb, IEntitySelector.ENTITY_STILL_ALIVE);
    }

    @Nullable
    public static IInventory getContainerAt(World world, BlockPosition blockposition) {
        return TileEntityHopper.getContainerAt(world, blockposition, world.getBlockState(blockposition), (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5);
    }

    @Nullable
    private static IInventory getContainerAt(World world, BlockPosition blockposition, IBlockData iblockdata, double d0, double d1, double d2) {
        IInventory iinventory = TileEntityHopper.getBlockContainer(world, blockposition, iblockdata);
        if (iinventory == null) {
            iinventory = TileEntityHopper.getEntityContainer(world, d0, d1, d2);
        }
        return iinventory;
    }

    @Nullable
    private static IInventory getBlockContainer(World world, BlockPosition blockposition, IBlockData iblockdata) {
        TileEntity tileentity;
        if (!world.spigotConfig.hopperCanLoadChunks && !world.hasChunkAt(blockposition)) {
            return null;
        }
        Block block = iblockdata.getBlock();
        if (block instanceof IInventoryHolder) {
            return ((IInventoryHolder)((Object)block)).getContainer(iblockdata, world, blockposition);
        }
        if (iblockdata.hasBlockEntity() && (tileentity = world.getBlockEntity(blockposition)) instanceof IInventory) {
            IInventory iinventory = (IInventory)((Object)tileentity);
            if (iinventory instanceof TileEntityChest && block instanceof BlockChest) {
                iinventory = BlockChest.getContainer((BlockChest)block, iblockdata, world, blockposition, true);
            }
            return iinventory;
        }
        return null;
    }

    @Nullable
    private static IInventory getEntityContainer(World world, double d0, double d1, double d2) {
        List<Entity> list = world.getEntities((Entity)null, new AxisAlignedBB(d0 - 0.5, d1 - 0.5, d2 - 0.5, d0 + 0.5, d1 + 0.5, d2 + 0.5), IEntitySelector.CONTAINER_ENTITY_SELECTOR);
        return !list.isEmpty() ? (IInventory)((Object)list.get(world.random.nextInt(list.size()))) : null;
    }

    private static boolean canMergeItems(net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
        return itemstack.getCount() <= itemstack.getMaxStackSize() && net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack, itemstack1);
    }

    @Override
    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    @Override
    public boolean isGridAligned() {
        return true;
    }

    private void setCooldown(int i2) {
        this.cooldownTime = i2;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    private boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    public static void entityInside(World world, BlockPosition blockposition, IBlockData iblockdata, Entity entity, TileEntityHopper tileentityhopper) {
        EntityItem entityitem;
        if (entity instanceof EntityItem && !(entityitem = (EntityItem)entity).getItem().isEmpty() && entity.getBoundingBox().move(-blockposition.getX(), -blockposition.getY(), -blockposition.getZ()).intersects(tileentityhopper.getSuckAabb())) {
            TileEntityHopper.tryMoveItems(world, blockposition, iblockdata, tileentityhopper, () -> TileEntityHopper.addItem(tileentityhopper, entityitem));
        }
    }

    @Override
    protected Container createMenu(int i2, PlayerInventory playerinventory) {
        return new ContainerHopper(i2, playerinventory, this);
    }
}

