/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Clearable;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerLectern;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Lectern;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R1.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class TileEntityLectern
extends TileEntity
implements Clearable,
ITileInventory,
ICommandListener {
    public static final int DATA_PAGE = 0;
    public static final int NUM_DATA = 1;
    public static final int SLOT_BOOK = 0;
    public static final int NUM_SLOTS = 1;
    public final IInventory bookAccess = new LecternInventory();
    private final IContainerProperties dataAccess = new IContainerProperties(){

        @Override
        public int get(int i2) {
            return i2 == 0 ? TileEntityLectern.this.page : 0;
        }

        @Override
        public void set(int i2, int j2) {
            if (i2 == 0) {
                TileEntityLectern.this.setPage(j2);
            }
        }

        @Override
        public int getCount() {
            return 1;
        }
    };
    ItemStack book = ItemStack.EMPTY;
    int page;
    private int pageCount;

    public TileEntityLectern(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.LECTERN, blockposition, iblockdata);
    }

    public ItemStack getBook() {
        return this.book;
    }

    public boolean hasBook() {
        return this.book.is(Items.WRITABLE_BOOK) || this.book.is(Items.WRITTEN_BOOK);
    }

    public void setBook(ItemStack itemstack) {
        this.setBook(itemstack, null);
    }

    void onBookItemRemove() {
        this.page = 0;
        this.pageCount = 0;
        BlockLectern.resetBookState(null, this.getLevel(), this.getBlockPos(), this.getBlockState(), false);
    }

    public void setBook(ItemStack itemstack, @Nullable EntityHuman entityhuman) {
        this.book = this.resolveBook(itemstack, entityhuman);
        this.page = 0;
        this.pageCount = TileEntityLectern.getPageCount(this.book);
        this.setChanged();
    }

    public void setPage(int i2) {
        int j2 = MathHelper.clamp(i2, 0, this.pageCount - 1);
        if (j2 != this.page) {
            this.page = j2;
            this.setChanged();
            if (this.level != null) {
                BlockLectern.signalPageChange(this.getLevel(), this.getBlockPos(), this.getBlockState());
            }
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getRedstoneSignal() {
        float f2 = this.pageCount > 1 ? (float)this.getPage() / ((float)this.pageCount - 1.0f) : 1.0f;
        return MathHelper.floor(f2 * 14.0f) + (this.hasBook() ? 1 : 0);
    }

    private ItemStack resolveBook(ItemStack itemstack, @Nullable EntityHuman entityhuman) {
        if (this.level instanceof WorldServer && itemstack.is(Items.WRITTEN_BOOK)) {
            ItemWrittenBook.resolveBookComponents(itemstack, this.createCommandSourceStack(entityhuman), entityhuman);
        }
        return itemstack;
    }

    @Override
    public void sendSystemMessage(IChatBaseComponent ichatbasecomponent) {
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return wrapper.getEntity() != null ? wrapper.getEntity().getBukkitSender(wrapper) : new CraftBlockCommandSender(wrapper, this);
    }

    @Override
    public boolean acceptsSuccess() {
        return false;
    }

    @Override
    public boolean acceptsFailure() {
        return false;
    }

    @Override
    public boolean shouldInformAdmins() {
        return false;
    }

    private CommandListenerWrapper createCommandSourceStack(@Nullable EntityHuman entityhuman) {
        IChatBaseComponent object;
        String s2;
        if (entityhuman == null) {
            s2 = "Lectern";
            object = IChatBaseComponent.literal("Lectern");
        } else {
            s2 = entityhuman.getName().getString();
            object = entityhuman.getDisplayName();
        }
        Vec3D vec3d = Vec3D.atCenterOf(this.worldPosition);
        return new CommandListenerWrapper(this, vec3d, Vec2F.ZERO, (WorldServer)this.level, 2, s2, object, this.level.getServer(), entityhuman);
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.book = nbttagcompound.contains("Book", 10) ? this.resolveBook(ItemStack.parse(holderlookup_a, nbttagcompound.getCompound("Book")).orElse(ItemStack.EMPTY), null) : ItemStack.EMPTY;
        this.pageCount = TileEntityLectern.getPageCount(this.book);
        this.page = MathHelper.clamp(nbttagcompound.getInt("Page"), 0, this.pageCount - 1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        if (!this.getBook().isEmpty()) {
            nbttagcompound.put("Book", this.getBook().save(holderlookup_a));
            nbttagcompound.putInt("Page", this.page);
        }
    }

    @Override
    public void clearContent() {
        this.setBook(ItemStack.EMPTY);
    }

    @Override
    public Container createMenu(int i2, PlayerInventory playerinventory, EntityHuman entityhuman) {
        return new ContainerLectern(i2, this.bookAccess, this.dataAccess, playerinventory);
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        return IChatBaseComponent.translatable("container.lectern");
    }

    private static int getPageCount(ItemStack itemstack) {
        WrittenBookContent writtenbookcontent = itemstack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (writtenbookcontent != null) {
            return writtenbookcontent.pages().size();
        }
        WritableBookContent writablebookcontent = itemstack.get(DataComponents.WRITABLE_BOOK_CONTENT);
        return writablebookcontent != null ? writablebookcontent.pages().size() : 0;
    }

    public class LecternInventory
    implements IInventory {
        public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
        private int maxStack = 1;

        @Override
        public List<ItemStack> getContents() {
            return Arrays.asList(TileEntityLectern.this.book);
        }

        @Override
        public void onOpen(CraftHumanEntity who) {
            this.transaction.add(who);
        }

        @Override
        public void onClose(CraftHumanEntity who) {
            this.transaction.remove(who);
        }

        @Override
        public List<HumanEntity> getViewers() {
            return this.transaction;
        }

        @Override
        public void setMaxStackSize(int i2) {
            this.maxStack = i2;
        }

        @Override
        public Location getLocation() {
            if (TileEntityLectern.this.level == null) {
                return null;
            }
            return CraftLocation.toBukkit(TileEntityLectern.this.worldPosition, (World)TileEntityLectern.this.level.getWorld());
        }

        @Override
        public InventoryHolder getOwner() {
            return (Lectern)TileEntityLectern.this.getOwner();
        }

        public TileEntityLectern getLectern() {
            return TileEntityLectern.this;
        }

        @Override
        public int getContainerSize() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return TileEntityLectern.this.book.isEmpty();
        }

        @Override
        public ItemStack getItem(int i2) {
            return i2 == 0 ? TileEntityLectern.this.book : ItemStack.EMPTY;
        }

        @Override
        public ItemStack removeItem(int i2, int j2) {
            if (i2 == 0) {
                ItemStack itemstack = TileEntityLectern.this.book.split(j2);
                if (TileEntityLectern.this.book.isEmpty()) {
                    TileEntityLectern.this.onBookItemRemove();
                }
                return itemstack;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public ItemStack removeItemNoUpdate(int i2) {
            if (i2 == 0) {
                ItemStack itemstack = TileEntityLectern.this.book;
                TileEntityLectern.this.book = ItemStack.EMPTY;
                TileEntityLectern.this.onBookItemRemove();
                return itemstack;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public void setItem(int i2, ItemStack itemstack) {
            if (i2 == 0) {
                TileEntityLectern.this.setBook(itemstack);
                if (TileEntityLectern.this.getLevel() != null) {
                    BlockLectern.resetBookState(null, TileEntityLectern.this.getLevel(), TileEntityLectern.this.getBlockPos(), TileEntityLectern.this.getBlockState(), TileEntityLectern.this.hasBook());
                }
            }
        }

        @Override
        public int getMaxStackSize() {
            return this.maxStack;
        }

        @Override
        public void setChanged() {
            TileEntityLectern.this.setChanged();
        }

        @Override
        public boolean stillValid(EntityHuman entityhuman) {
            return IInventory.stillValidBlockEntity(TileEntityLectern.this, entityhuman) && TileEntityLectern.this.hasBook();
        }

        @Override
        public boolean canPlaceItem(int i2, ItemStack itemstack) {
            return false;
        }

        @Override
        public void clearContent() {
        }
    }
}

