/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerShulkerBox;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;

public class TileEntityShulkerBox
extends TileEntityLootable
implements IWorldInventory {
    public static final int COLUMNS = 9;
    public static final int ROWS = 3;
    public static final int CONTAINER_SIZE = 27;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    public static final int OPENING_TICK_LENGTH = 10;
    public static final float MAX_LID_HEIGHT = 0.5f;
    public static final float MAX_LID_ROTATION = 270.0f;
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private NonNullList<ItemStack> itemStacks;
    public int openCount;
    private AnimationPhase animationStatus;
    private float progress;
    private float progressOld;
    @Nullable
    private final EnumColor color;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    public boolean opened;

    @Override
    public List<ItemStack> getContents() {
        return this.itemStacks;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public TileEntityShulkerBox(@Nullable EnumColor enumcolor, BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.SHULKER_BOX, blockposition, iblockdata);
        this.itemStacks = NonNullList.withSize(27, ItemStack.EMPTY);
        this.animationStatus = AnimationPhase.CLOSED;
        this.color = enumcolor;
    }

    public TileEntityShulkerBox(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.SHULKER_BOX, blockposition, iblockdata);
        this.itemStacks = NonNullList.withSize(27, ItemStack.EMPTY);
        this.animationStatus = AnimationPhase.CLOSED;
        this.color = BlockShulkerBox.getColorFromBlock(iblockdata.getBlock());
    }

    public static void tick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityShulkerBox tileentityshulkerbox) {
        tileentityshulkerbox.updateAnimation(world, blockposition, iblockdata);
    }

    private void updateAnimation(World world, BlockPosition blockposition, IBlockData iblockdata) {
        this.progressOld = this.progress;
        switch (this.animationStatus.ordinal()) {
            case 0: {
                this.progress = 0.0f;
                break;
            }
            case 1: {
                this.progress += 0.1f;
                if (this.progressOld == 0.0f) {
                    TileEntityShulkerBox.doNeighborUpdates(world, blockposition, iblockdata);
                }
                if (this.progress >= 1.0f) {
                    this.animationStatus = AnimationPhase.OPENED;
                    this.progress = 1.0f;
                    TileEntityShulkerBox.doNeighborUpdates(world, blockposition, iblockdata);
                }
                this.moveCollidedEntities(world, blockposition, iblockdata);
                break;
            }
            case 2: {
                this.progress = 1.0f;
                break;
            }
            case 3: {
                this.progress -= 0.1f;
                if (this.progressOld == 1.0f) {
                    TileEntityShulkerBox.doNeighborUpdates(world, blockposition, iblockdata);
                }
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationPhase.CLOSED;
                this.progress = 0.0f;
                TileEntityShulkerBox.doNeighborUpdates(world, blockposition, iblockdata);
            }
        }
    }

    public AnimationPhase getAnimationStatus() {
        return this.animationStatus;
    }

    public AxisAlignedBB getBoundingBox(IBlockData iblockdata) {
        return EntityShulker.getProgressAabb(1.0f, iblockdata.getValue(BlockShulkerBox.FACING), 0.5f * this.getProgress(1.0f));
    }

    private void moveCollidedEntities(World world, BlockPosition blockposition, IBlockData iblockdata) {
        EnumDirection enumdirection;
        AxisAlignedBB axisalignedbb;
        List<Entity> list;
        if (iblockdata.getBlock() instanceof BlockShulkerBox && !(list = world.getEntities(null, axisalignedbb = EntityShulker.getProgressDeltaAabb(1.0f, enumdirection = iblockdata.getValue(BlockShulkerBox.FACING), this.progressOld, this.progress).move(blockposition))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.getPistonPushReaction() == EnumPistonReaction.IGNORE) continue;
                entity.move(EnumMoveType.SHULKER_BOX, new Vec3D((axisalignedbb.getXsize() + 0.01) * (double)enumdirection.getStepX(), (axisalignedbb.getYsize() + 0.01) * (double)enumdirection.getStepY(), (axisalignedbb.getZsize() + 0.01) * (double)enumdirection.getStepZ()));
            }
        }
    }

    @Override
    public int getContainerSize() {
        return this.itemStacks.size();
    }

    @Override
    public boolean triggerEvent(int i2, int j2) {
        if (i2 == 1) {
            this.openCount = j2;
            if (j2 == 0) {
                this.animationStatus = AnimationPhase.CLOSING;
            }
            if (j2 == 1) {
                this.animationStatus = AnimationPhase.OPENING;
            }
            return true;
        }
        return super.triggerEvent(i2, j2);
    }

    private static void doNeighborUpdates(World world, BlockPosition blockposition, IBlockData iblockdata) {
        iblockdata.updateNeighbourShapes(world, blockposition, 3);
        world.updateNeighborsAt(blockposition, iblockdata.getBlock());
    }

    @Override
    public void startOpen(EntityHuman entityhuman) {
        if (!this.remove && !entityhuman.isSpectator()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            if (this.opened) {
                return;
            }
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount == 1) {
                this.level.gameEvent((Entity)entityhuman, GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.level.playSound((EntityHuman)null, this.worldPosition, SoundEffects.SHULKER_BOX_OPEN, SoundCategory.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public void stopOpen(EntityHuman entityhuman) {
        if (!this.remove && !entityhuman.isSpectator()) {
            --this.openCount;
            if (this.opened) {
                return;
            }
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.level.gameEvent((Entity)entityhuman, GameEvent.CONTAINER_CLOSE, this.worldPosition);
                this.level.playSound((EntityHuman)null, this.worldPosition, SoundEffects.SHULKER_BOX_CLOSE, SoundCategory.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.shulkerBox");
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.loadAdditional(nbttagcompound, holderlookup_a);
        this.loadFromTag(nbttagcompound, holderlookup_a);
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        if (!this.trySaveLootTable(nbttagcompound)) {
            ContainerUtil.saveAllItems(nbttagcompound, this.itemStacks, false, holderlookup_a);
        }
    }

    public void loadFromTag(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        this.itemStacks = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(nbttagcompound) && nbttagcompound.contains("Items", 9)) {
            ContainerUtil.loadAllItems(nbttagcompound, this.itemStacks, holderlookup_a);
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> nonnulllist) {
        this.itemStacks = nonnulllist;
    }

    @Override
    public int[] getSlotsForFace(EnumDirection enumdirection) {
        return SLOTS;
    }

    @Override
    public boolean canPlaceItemThroughFace(int i2, ItemStack itemstack, @Nullable EnumDirection enumdirection) {
        return !(Block.byItem(itemstack.getItem()) instanceof BlockShulkerBox);
    }

    @Override
    public boolean canTakeItemThroughFace(int i2, ItemStack itemstack, EnumDirection enumdirection) {
        return true;
    }

    public float getProgress(float f2) {
        return MathHelper.lerp(f2, this.progressOld, this.progress);
    }

    @Nullable
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    protected Container createMenu(int i2, PlayerInventory playerinventory) {
        return new ContainerShulkerBox(i2, playerinventory, this);
    }

    public boolean isClosed() {
        return this.animationStatus == AnimationPhase.CLOSED;
    }

    public static enum AnimationPhase {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

