/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R1.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;

public class TileEntitySign
extends TileEntity
implements ICommandListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TEXT_LINE_WIDTH = 90;
    private static final int TEXT_LINE_HEIGHT = 10;
    @Nullable
    public UUID playerWhoMayEdit;
    private SignText frontText = this.createDefaultSignText();
    private SignText backText = this.createDefaultSignText();
    private boolean isWaxed;

    public TileEntitySign(BlockPosition blockposition, IBlockData iblockdata) {
        this((TileEntityTypes)TileEntityTypes.SIGN, blockposition, iblockdata);
    }

    public TileEntitySign(TileEntityTypes tileentitytypes, BlockPosition blockposition, IBlockData iblockdata) {
        super(tileentitytypes, blockposition, iblockdata);
    }

    protected SignText createDefaultSignText() {
        return new SignText();
    }

    public boolean isFacingFrontText(EntityHuman entityhuman) {
        Block block = this.getBlockState().getBlock();
        if (block instanceof BlockSign) {
            float f1;
            BlockSign blocksign = (BlockSign)block;
            Vec3D vec3d = blocksign.getSignHitboxCenterPosition(this.getBlockState());
            double d0 = entityhuman.getX() - ((double)this.getBlockPos().getX() + vec3d.x);
            double d1 = entityhuman.getZ() - ((double)this.getBlockPos().getZ() + vec3d.z);
            float f2 = blocksign.getYRotationDegrees(this.getBlockState());
            return MathHelper.degreesDifferenceAbs(f2, f1 = (float)(MathHelper.atan2(d1, d0) * 57.2957763671875) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText getText(boolean flag) {
        return flag ? this.frontText : this.backText;
    }

    public SignText getFrontText() {
        return this.frontText;
    }

    public SignText getBackText() {
        return this.backText;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 90;
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        RegistryOps<NBTBase> dynamicops = holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE);
        DataResult dataresult = SignText.DIRECT_CODEC.encodeStart(dynamicops, (Object)this.frontText);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("front_text", (NBTBase)nbtbase));
        dataresult = SignText.DIRECT_CODEC.encodeStart(dynamicops, (Object)this.backText);
        logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("back_text", (NBTBase)nbtbase));
        nbttagcompound.putBoolean("is_waxed", this.isWaxed);
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        Logger logger;
        DataResult dataresult;
        super.loadAdditional(nbttagcompound, holderlookup_a);
        RegistryOps<NBTBase> dynamicops = holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE);
        if (nbttagcompound.contains("front_text")) {
            dataresult = SignText.DIRECT_CODEC.parse(dynamicops, (Object)nbttagcompound.getCompound("front_text"));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(signtext -> {
                this.frontText = this.loadLines((SignText)signtext);
            });
        }
        if (nbttagcompound.contains("back_text")) {
            dataresult = SignText.DIRECT_CODEC.parse(dynamicops, (Object)nbttagcompound.getCompound("back_text"));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(signtext -> {
                this.backText = this.loadLines((SignText)signtext);
            });
        }
        this.isWaxed = nbttagcompound.getBoolean("is_waxed");
    }

    private SignText loadLines(SignText signtext) {
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent ichatbasecomponent = this.loadLine(signtext.getMessage(i2, false));
            IChatBaseComponent ichatbasecomponent1 = this.loadLine(signtext.getMessage(i2, true));
            signtext = signtext.setMessage(i2, ichatbasecomponent, ichatbasecomponent1);
        }
        return signtext;
    }

    private IChatBaseComponent loadLine(IChatBaseComponent ichatbasecomponent) {
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            try {
                return ChatComponentUtils.updateForEntity(this.createCommandSourceStack(null, worldserver, this.worldPosition), ichatbasecomponent, (Entity)null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return ichatbasecomponent;
    }

    public void updateSignText(EntityHuman entityhuman, boolean flag, List<FilteredText> list) {
        if (!this.isWaxed() && entityhuman.getUUID().equals(this.getPlayerWhoMayEdit()) && this.level != null) {
            this.updateText(signtext -> this.setMessages(entityhuman, list, (SignText)signtext, flag), flag);
            this.setAllowedPlayerEditor(null);
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        } else {
            LOGGER.warn("Player {} just tried to change non-editable sign", (Object)entityhuman.getName().getString());
            ((EntityPlayer)entityhuman).connection.send(this.getUpdatePacket());
        }
    }

    public boolean updateText(UnaryOperator<SignText> unaryoperator, boolean flag) {
        SignText signtext = this.getText(flag);
        return this.setText((SignText)unaryoperator.apply(signtext), flag);
    }

    private SignText setMessages(EntityHuman entityhuman, List<FilteredText> list, SignText signtext, boolean front) {
        SignText originalText = signtext;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FilteredText filteredtext = list.get(i2);
            ChatModifier chatmodifier = signtext.getMessage(i2, entityhuman.isTextFilteringEnabled()).getStyle();
            signtext = entityhuman.isTextFilteringEnabled() ? signtext.setMessage(i2, IChatBaseComponent.literal(filteredtext.filteredOrEmpty()).setStyle(chatmodifier)) : signtext.setMessage(i2, IChatBaseComponent.literal(filteredtext.raw()).setStyle(chatmodifier), IChatBaseComponent.literal(filteredtext.filteredOrEmpty()).setStyle(chatmodifier));
        }
        CraftPlayer player = ((EntityPlayer)entityhuman).getBukkitEntity();
        String[] lines = new String[4];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            lines[i3] = CraftChatMessage.fromComponent(signtext.getMessage(i3, entityhuman.isTextFilteringEnabled()));
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.level, this.worldPosition), (Player)player, (String[])lines.clone(), front ? Side.FRONT : Side.BACK);
        entityhuman.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return originalText;
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(event.getLines());
        for (int i4 = 0; i4 < components.length; ++i4) {
            if (Objects.equals(lines[i4], event.getLine(i4))) continue;
            signtext = signtext.setMessage(i4, components[i4]);
        }
        return signtext;
    }

    public boolean setText(SignText signtext, boolean flag) {
        return flag ? this.setFrontText(signtext) : this.setBackText(signtext);
    }

    private boolean setBackText(SignText signtext) {
        if (signtext != this.backText) {
            this.backText = signtext;
            this.markUpdated();
            return true;
        }
        return false;
    }

    private boolean setFrontText(SignText signtext) {
        if (signtext != this.frontText) {
            this.frontText = signtext;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean canExecuteClickCommands(boolean flag, EntityHuman entityhuman) {
        return this.isWaxed() && this.getText(flag).hasAnyClickCommands(entityhuman);
    }

    public boolean executeClickCommandsIfPresent(EntityHuman entityhuman, World world, BlockPosition blockposition, boolean flag) {
        boolean flag1 = false;
        for (IChatBaseComponent ichatbasecomponent : this.getText(flag).getMessages(entityhuman.isTextFilteringEnabled())) {
            ChatModifier chatmodifier = ichatbasecomponent.getStyle();
            ChatClickable chatclickable = chatmodifier.getClickEvent();
            if (chatclickable == null || chatclickable.getAction() != ChatClickable.EnumClickAction.RUN_COMMAND) continue;
            entityhuman.getServer().getCommands().performPrefixedCommand(this.createCommandSourceStack(entityhuman, world, blockposition), chatclickable.getValue());
            flag1 = true;
        }
        return flag1;
    }

    @Override
    public void sendSystemMessage(IChatBaseComponent ichatbasecomponent) {
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return wrapper.getEntity() != null ? wrapper.getEntity().getBukkitSender(wrapper) : new CraftBlockCommandSender(wrapper, this);
    }

    @Override
    public boolean acceptsSuccess() {
        return false;
    }

    @Override
    public boolean acceptsFailure() {
        return false;
    }

    @Override
    public boolean shouldInformAdmins() {
        return false;
    }

    private CommandListenerWrapper createCommandSourceStack(@Nullable EntityHuman entityhuman, World world, BlockPosition blockposition) {
        String s2 = entityhuman == null ? "Sign" : entityhuman.getName().getString();
        IChatBaseComponent object = entityhuman == null ? IChatBaseComponent.literal("Sign") : entityhuman.getDisplayName();
        return new CommandListenerWrapper(this, Vec3D.atCenterOf(blockposition), Vec2F.ZERO, (WorldServer)world, 2, s2, object, world.getServer(), entityhuman);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a holderlookup_a) {
        return this.saveCustomOnly(holderlookup_a);
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public void setAllowedPlayerEditor(@Nullable UUID uuid) {
        this.playerWhoMayEdit = uuid;
    }

    @Nullable
    public UUID getPlayerWhoMayEdit() {
        if (this.level != null && this.playerWhoMayEdit != null) {
            this.clearInvalidPlayerWhoMayEdit(this, this.level, this.playerWhoMayEdit);
        }
        return this.playerWhoMayEdit;
    }

    private void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public boolean setWaxed(boolean flag) {
        if (this.isWaxed != flag) {
            this.isWaxed = flag;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean playerIsTooFarAwayToEdit(UUID uuid) {
        EntityHuman entityhuman = this.level.getPlayerByUUID(uuid);
        return entityhuman == null || !entityhuman.canInteractWithBlock(this.getBlockPos(), 4.0);
    }

    public static void tick(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntitySign tileentitysign) {
        UUID uuid = tileentitysign.getPlayerWhoMayEdit();
        if (uuid != null) {
            tileentitysign.clearInvalidPlayerWhoMayEdit(tileentitysign, world, uuid);
        }
    }

    private void clearInvalidPlayerWhoMayEdit(TileEntitySign tileentitysign, World world, UUID uuid) {
        if (tileentitysign.playerIsTooFarAwayToEdit(uuid)) {
            tileentitysign.setAllowedPlayerEditor(null);
        }
    }

    public SoundEffect getSignInteractionFailedSoundEvent() {
        return SoundEffects.WAXED_SIGN_INTERACT_FAIL;
    }
}

