/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public final class TrialSpawnerState
extends Enum<TrialSpawnerState>
implements INamable {
    public static final /* enum */ TrialSpawnerState INACTIVE = new TrialSpawnerState("inactive", 0, b.NONE, -1.0, false);
    public static final /* enum */ TrialSpawnerState WAITING_FOR_PLAYERS = new TrialSpawnerState("waiting_for_players", 4, b.SMALL_FLAMES, 200.0, true);
    public static final /* enum */ TrialSpawnerState ACTIVE = new TrialSpawnerState("active", 8, b.FLAMES_AND_SMOKE, 1000.0, true);
    public static final /* enum */ TrialSpawnerState WAITING_FOR_REWARD_EJECTION = new TrialSpawnerState("waiting_for_reward_ejection", 8, b.SMALL_FLAMES, -1.0, false);
    public static final /* enum */ TrialSpawnerState EJECTING_REWARD = new TrialSpawnerState("ejecting_reward", 8, b.SMALL_FLAMES, -1.0, false);
    public static final /* enum */ TrialSpawnerState COOLDOWN = new TrialSpawnerState("cooldown", 0, b.SMOKE_INSIDE_AND_TOP_FACE, -1.0, false);
    private static final float DELAY_BEFORE_EJECT_AFTER_KILLING_LAST_MOB = 40.0f;
    private static final int TIME_BETWEEN_EACH_EJECTION;
    private final String name;
    private final int lightLevel;
    private final double spinningMobSpeed;
    private final b particleEmission;
    private final boolean isCapableOfSpawning;
    private static final /* synthetic */ TrialSpawnerState[] n;

    public static TrialSpawnerState[] values() {
        return (TrialSpawnerState[])n.clone();
    }

    public static TrialSpawnerState valueOf(String var0) {
        return Enum.valueOf(TrialSpawnerState.class, var0);
    }

    private TrialSpawnerState(String var2, int var3, b var4, double var5, boolean var7) {
        this.name = var2;
        this.lightLevel = var3;
        this.particleEmission = var4;
        this.spinningMobSpeed = var5;
        this.isCapableOfSpawning = var7;
    }

    TrialSpawnerState tickAndGetNext(BlockPosition var0, TrialSpawner var1, WorldServer var2) {
        TrialSpawnerData var32 = var1.getData();
        TrialSpawnerConfig var42 = var1.getConfig();
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (var32.getOrCreateDisplayEntity(var1, var2, WAITING_FOR_PLAYERS) == null) {
                    yield this;
                }
                yield WAITING_FOR_PLAYERS;
            }
            case 1 -> {
                if (!var1.canSpawnInLevel(var2)) {
                    var32.reset();
                    yield this;
                }
                if (!var32.hasMobToSpawn(var1, var2.random)) {
                    yield INACTIVE;
                }
                var32.tryDetectPlayers(var2, var0, var1);
                if (var32.detectedPlayers.isEmpty()) {
                    yield this;
                }
                yield ACTIVE;
            }
            case 2 -> {
                if (!var1.canSpawnInLevel(var2)) {
                    var32.reset();
                    yield WAITING_FOR_PLAYERS;
                }
                if (!var32.hasMobToSpawn(var1, var2.random)) {
                    yield INACTIVE;
                }
                int var5 = var32.countAdditionalPlayers(var0);
                var32.tryDetectPlayers(var2, var0, var1);
                if (var1.isOminous()) {
                    this.spawnOminousOminousItemSpawner(var2, var0, var1);
                }
                if (var32.hasFinishedSpawningAllMobs(var42, var5)) {
                    if (var32.haveAllCurrentMobsDied()) {
                        var32.cooldownEndsAt = var2.getGameTime() + (long)var1.getTargetCooldownLength();
                        var32.totalMobsSpawned = 0;
                        var32.nextMobSpawnsAt = 0L;
                        yield WAITING_FOR_REWARD_EJECTION;
                    }
                } else if (var32.isReadyToSpawnNextMob(var2, var42, var5)) {
                    var1.spawnMob(var2, var0).ifPresent(var4 -> {
                        var0.currentMobs.add((UUID)var4);
                        ++var0.totalMobsSpawned;
                        var0.nextMobSpawnsAt = var2.getGameTime() + (long)var42.ticksBetweenSpawn();
                        var42.spawnPotentialsDefinition().getRandom(var2.getRandom()).ifPresent(var2 -> {
                            var0.nextSpawnData = Optional.of((MobSpawnerData)var2.data());
                            var1.markUpdated();
                        });
                    });
                }
                yield this;
            }
            case 3 -> {
                if (var32.isReadyToOpenShutter(var2, 40.0f, var1.getTargetCooldownLength())) {
                    var2.playSound(null, var0, SoundEffects.TRIAL_SPAWNER_OPEN_SHUTTER, SoundCategory.BLOCKS);
                    yield EJECTING_REWARD;
                }
                yield this;
            }
            case 4 -> {
                if (!var32.isReadyToEjectItems(var2, TIME_BETWEEN_EACH_EJECTION, var1.getTargetCooldownLength())) {
                    yield this;
                }
                if (var32.detectedPlayers.isEmpty()) {
                    var2.playSound(null, var0, SoundEffects.TRIAL_SPAWNER_CLOSE_SHUTTER, SoundCategory.BLOCKS);
                    var32.ejectingLootTable = Optional.empty();
                    yield COOLDOWN;
                }
                if (var32.ejectingLootTable.isEmpty()) {
                    var32.ejectingLootTable = var42.lootTablesToEject().getRandomValue(var2.getRandom());
                }
                var32.ejectingLootTable.ifPresent(var3 -> var1.ejectReward(var2, var0, (ResourceKey<LootTable>)var3));
                var32.detectedPlayers.remove(var32.detectedPlayers.iterator().next());
                yield this;
            }
            case 5 -> {
                var32.tryDetectPlayers(var2, var0, var1);
                if (!var32.detectedPlayers.isEmpty()) {
                    var32.totalMobsSpawned = 0;
                    var32.nextMobSpawnsAt = 0L;
                    yield ACTIVE;
                }
                if (var32.isCooldownFinished(var2)) {
                    var1.removeOminous(var2, var0);
                    var32.reset();
                    yield WAITING_FOR_PLAYERS;
                }
                yield this;
            }
        };
    }

    private void spawnOminousOminousItemSpawner(WorldServer var0, BlockPosition var1, TrialSpawner var2) {
        TrialSpawnerConfig var42;
        TrialSpawnerData var3 = var2.getData();
        ItemStack var5 = var3.getDispensingItems(var0, var42 = var2.getConfig(), var1).getRandomValue(var0.random).orElse(ItemStack.EMPTY);
        if (var5.isEmpty()) {
            return;
        }
        if (this.timeToSpawnItemSpawner(var0, var3)) {
            TrialSpawnerState.calculatePositionToSpawnSpawner(var0, var1, var2, var3).ifPresent(var4 -> {
                OminousItemSpawner var5 = OminousItemSpawner.create(var0, var5);
                var5.moveTo((Vec3D)var4);
                var0.addFreshEntity(var5);
                float var6 = (var0.getRandom().nextFloat() - var0.getRandom().nextFloat()) * 0.2f + 1.0f;
                var0.playSound(null, BlockPosition.containing(var4), SoundEffects.TRIAL_SPAWNER_SPAWN_ITEM_BEGIN, SoundCategory.BLOCKS, 1.0f, var6);
                var2.cooldownEndsAt = var0.getGameTime() + var2.getOminousConfig().ticksBetweenItemSpawners();
            });
        }
    }

    private static Optional<Vec3D> calculatePositionToSpawnSpawner(WorldServer var0, BlockPosition var1, TrialSpawner var22, TrialSpawnerData var3) {
        List<EntityHuman> var4 = var3.detectedPlayers.stream().map(var0::getPlayerByUUID).filter(Objects::nonNull).filter(var2 -> !var2.isCreative() && !var2.isSpectator() && var2.isAlive() && var2.distanceToSqr(var1.getCenter()) <= (double)MathHelper.square(var22.getRequiredPlayerRange())).toList();
        if (var4.isEmpty()) {
            return Optional.empty();
        }
        Entity var5 = TrialSpawnerState.selectEntityToSpawnItemAbove(var4, var3.currentMobs, var22, var1, var0);
        if (var5 == null) {
            return Optional.empty();
        }
        return TrialSpawnerState.calculatePositionAbove(var5, var0);
    }

    private static Optional<Vec3D> calculatePositionAbove(Entity var0, WorldServer var1) {
        Vec3D var3;
        Vec3D var2 = var0.position();
        MovingObjectPositionBlock var4 = var1.clip(new RayTrace(var2, var3 = var2.relative(EnumDirection.UP, var0.getBbHeight() + 2.0f + (float)var1.random.nextInt(4)), RayTrace.BlockCollisionOption.VISUAL, RayTrace.FluidCollisionOption.NONE, VoxelShapeCollision.empty()));
        Vec3D var5 = var4.getBlockPos().getCenter().relative(EnumDirection.DOWN, 1.0);
        BlockPosition var6 = BlockPosition.containing(var5);
        if (!var1.getBlockState(var6).getCollisionShape(var1, var6).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(var5);
    }

    @Nullable
    private static Entity selectEntityToSpawnItemAbove(List<EntityHuman> var0, Set<UUID> var1, TrialSpawner var22, BlockPosition var3, WorldServer var4) {
        List<Entity> var6;
        Stream<Entity> var5 = var1.stream().map(var4::getEntity).filter(Objects::nonNull).filter(var2 -> var2.isAlive() && var2.distanceToSqr(var3.getCenter()) <= (double)MathHelper.square(var22.getRequiredPlayerRange()));
        List<Entity> list = var6 = var4.random.nextBoolean() ? var5.toList() : var0;
        if (var6.isEmpty()) {
            return null;
        }
        if (var6.size() == 1) {
            return var6.getFirst();
        }
        return SystemUtils.getRandom(var6, var4.random);
    }

    private boolean timeToSpawnItemSpawner(WorldServer var0, TrialSpawnerData var1) {
        return var0.getGameTime() >= var1.cooldownEndsAt;
    }

    public int lightLevel() {
        return this.lightLevel;
    }

    public double spinningMobSpeed() {
        return this.spinningMobSpeed;
    }

    public boolean hasSpinningMob() {
        return this.spinningMobSpeed >= 0.0;
    }

    public boolean isCapableOfSpawning() {
        return this.isCapableOfSpawning;
    }

    public void emitParticles(World var0, BlockPosition var1, boolean var2) {
        this.particleEmission.emit(var0, var0.getRandom(), var1, var2);
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    private static /* synthetic */ TrialSpawnerState[] f() {
        return new TrialSpawnerState[]{INACTIVE, WAITING_FOR_PLAYERS, ACTIVE, WAITING_FOR_REWARD_EJECTION, EJECTING_REWARD, COOLDOWN};
    }

    static {
        n = TrialSpawnerState.f();
        TIME_BETWEEN_EACH_EJECTION = MathHelper.floor(30.0f);
    }

    static interface b {
        public static final b NONE = (var0, var1, var2, var3) -> {};
        public static final b SMALL_FLAMES = (var0, var1, var2, var3) -> {
            if (var1.nextInt(2) == 0) {
                Vec3D var4 = var2.getCenter().offsetRandom(var1, 0.9f);
                b.addParticle(var3 ? Particles.SOUL_FIRE_FLAME : Particles.SMALL_FLAME, var4, var0);
            }
        };
        public static final b FLAMES_AND_SMOKE = (var0, var1, var2, var3) -> {
            Vec3D var4 = var2.getCenter().offsetRandom(var1, 1.0f);
            b.addParticle(Particles.SMOKE, var4, var0);
            b.addParticle(var3 ? Particles.SOUL_FIRE_FLAME : Particles.FLAME, var4, var0);
        };
        public static final b SMOKE_INSIDE_AND_TOP_FACE = (var0, var1, var2, var3) -> {
            Vec3D var4 = var2.getCenter().offsetRandom(var1, 0.9f);
            if (var1.nextInt(3) == 0) {
                b.addParticle(Particles.SMOKE, var4, var0);
            }
            if (var0.getGameTime() % 20L == 0L) {
                Vec3D var5 = var2.getCenter().add(0.0, 0.5, 0.0);
                int var6 = var0.getRandom().nextInt(4) + 20;
                for (int var7 = 0; var7 < var6; ++var7) {
                    b.addParticle(Particles.SMOKE, var5, var0);
                }
            }
        };

        private static void addParticle(ParticleType var0, Vec3D var1, World var2) {
            var2.addParticle(var0, var1.x(), var1.y(), var1.z(), 0.0, 0.0, 0.0);
        }

        public void emit(World var1, RandomSource var2, BlockPosition var3, boolean var4);
    }

    static class a {
        private static final int UNLIT = 0;
        private static final int HALF_LIT = 4;
        private static final int LIT = 8;

        private a() {
        }
    }

    static class c {
        private static final double NONE = -1.0;
        private static final double SLOW = 200.0;
        private static final double FAST = 1000.0;

        private c() {
        }
    }
}

