/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.block.VaultDisplayItemEvent;
import org.slf4j.Logger;

public class VaultBlockEntity
extends TileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final VaultServerData serverData = new VaultServerData();
    private final VaultSharedData sharedData = new VaultSharedData();
    private final VaultClientData clientData = new VaultClientData();
    private VaultConfig config = VaultConfig.DEFAULT;

    public VaultBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.VAULT, blockposition, iblockdata);
    }

    @Override
    @Nullable
    public Packet<PacketListenerPlayOut> getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a holderlookup_a) {
        return SystemUtils.make(new NBTTagCompound(), nbttagcompound -> nbttagcompound.put("shared_data", VaultBlockEntity.encode(VaultSharedData.CODEC, this.sharedData, holderlookup_a)));
    }

    @Override
    protected void saveAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.saveAdditional(nbttagcompound, holderlookup_a);
        nbttagcompound.put("config", VaultBlockEntity.encode(VaultConfig.CODEC, this.config, holderlookup_a));
        nbttagcompound.put("shared_data", VaultBlockEntity.encode(VaultSharedData.CODEC, this.sharedData, holderlookup_a));
        nbttagcompound.put("server_data", VaultBlockEntity.encode(VaultServerData.CODEC, this.serverData, holderlookup_a));
    }

    private static <T> NBTBase encode(Codec<T> codec, T t0, HolderLookup.a holderlookup_a) {
        return (NBTBase)codec.encodeStart(holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE), t0).getOrThrow();
    }

    @Override
    protected void loadAdditional(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        Optional optional;
        Logger logger;
        DataResult dataresult;
        super.loadAdditional(nbttagcompound, holderlookup_a);
        RegistryOps<NBTBase> dynamicops = holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE);
        if (nbttagcompound.contains("server_data")) {
            dataresult = VaultServerData.CODEC.parse(dynamicops, (Object)nbttagcompound.get("server_data"));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
            VaultServerData vaultserverdata = this.serverData;
            Objects.requireNonNull(this.serverData);
            optional.ifPresent(vaultserverdata::set);
        }
        if (nbttagcompound.contains("config")) {
            dataresult = VaultConfig.CODEC.parse(dynamicops, (Object)nbttagcompound.get("config"));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(vaultconfig -> {
                this.config = vaultconfig;
            });
        }
        if (nbttagcompound.contains("shared_data")) {
            dataresult = VaultSharedData.CODEC.parse(dynamicops, (Object)nbttagcompound.get("shared_data"));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
            VaultSharedData vaultshareddata = this.sharedData;
            Objects.requireNonNull(this.sharedData);
            optional.ifPresent(vaultshareddata::set);
        }
    }

    @Nullable
    public VaultServerData getServerData() {
        return this.level != null && !this.level.isClientSide ? this.serverData : null;
    }

    public VaultSharedData getSharedData() {
        return this.sharedData;
    }

    public VaultClientData getClientData() {
        return this.clientData;
    }

    public VaultConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public void setConfig(VaultConfig vaultconfig) {
        this.config = vaultconfig;
    }

    public static final class b {
        private static final int UNLOCKING_DELAY_TICKS = 14;
        private static final int DISPLAY_CYCLE_TICK_RATE = 20;
        private static final int INSERT_FAIL_SOUND_BUFFER_TICKS = 15;

        public static void tick(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata) {
            VaultState vaultstate = iblockdata.getValue(VaultBlock.STATE);
            if (b.shouldCycleDisplayItem(worldserver.getGameTime(), vaultstate)) {
                b.cycleDisplayItemFromLootTable(worldserver, vaultstate, vaultconfig, vaultshareddata, blockposition);
            }
            IBlockData iblockdata1 = iblockdata;
            if (worldserver.getGameTime() >= vaultserverdata.stateUpdatingResumesAt() && !iblockdata.equals(iblockdata1 = (IBlockData)iblockdata.setValue(VaultBlock.STATE, vaultstate.tickAndGetNext(worldserver, blockposition, vaultconfig, vaultserverdata, vaultshareddata)))) {
                b.setVaultState(worldserver, blockposition, iblockdata, iblockdata1, vaultconfig, vaultshareddata);
            }
            if (vaultserverdata.isDirty || vaultshareddata.isDirty) {
                VaultBlockEntity.setChanged(worldserver, blockposition, iblockdata);
                if (vaultshareddata.isDirty) {
                    worldserver.sendBlockUpdated(blockposition, iblockdata, iblockdata1, 2);
                }
                vaultserverdata.isDirty = false;
                vaultshareddata.isDirty = false;
            }
        }

        public static void tryInsertKey(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata, EntityHuman entityhuman, ItemStack itemstack) {
            VaultState vaultstate = iblockdata.getValue(VaultBlock.STATE);
            if (b.canEjectReward(vaultconfig, vaultstate)) {
                if (!b.isValidToInsert(vaultconfig, itemstack)) {
                    b.playInsertFailSound(worldserver, vaultserverdata, blockposition, SoundEffects.VAULT_INSERT_ITEM_FAIL);
                } else if (vaultserverdata.hasRewardedPlayer(entityhuman)) {
                    b.playInsertFailSound(worldserver, vaultserverdata, blockposition, SoundEffects.VAULT_REJECT_REWARDED_PLAYER);
                } else {
                    List<ItemStack> list = b.resolveItemsToEject(worldserver, vaultconfig, blockposition, entityhuman);
                    if (!list.isEmpty()) {
                        entityhuman.awardStat(StatisticList.ITEM_USED.get(itemstack.getItem()));
                        itemstack.consume(vaultconfig.keyItem().getCount(), entityhuman);
                        BlockDispenseLootEvent vaultDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(worldserver, blockposition, entityhuman, list);
                        if (vaultDispenseLootEvent.isCancelled()) {
                            return;
                        }
                        list = vaultDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList();
                        b.unlock(worldserver, iblockdata, blockposition, vaultconfig, vaultserverdata, vaultshareddata, list);
                        vaultserverdata.addToRewardedPlayers(entityhuman);
                        vaultshareddata.updateConnectedPlayersWithinRange(worldserver, blockposition, vaultserverdata, vaultconfig, vaultconfig.deactivationRange());
                    }
                }
            }
        }

        static void setVaultState(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, VaultConfig vaultconfig, VaultSharedData vaultshareddata) {
            VaultState vaultstate = iblockdata.getValue(VaultBlock.STATE);
            VaultState vaultstate1 = iblockdata1.getValue(VaultBlock.STATE);
            worldserver.setBlock(blockposition, iblockdata1, 3);
            vaultstate.onTransition(worldserver, blockposition, vaultstate1, vaultconfig, vaultshareddata, iblockdata1.getValue(VaultBlock.OMINOUS));
        }

        static void cycleDisplayItemFromLootTable(WorldServer worldserver, VaultState vaultstate, VaultConfig vaultconfig, VaultSharedData vaultshareddata, BlockPosition blockposition) {
            if (!b.canEjectReward(vaultconfig, vaultstate)) {
                vaultshareddata.setDisplayItem(ItemStack.EMPTY);
            } else {
                ItemStack itemstack = b.getRandomDisplayItemFromLootTable(worldserver, blockposition, vaultconfig.overrideLootTableToDisplay().orElse(vaultconfig.lootTable()));
                VaultDisplayItemEvent event = CraftEventFactory.callVaultDisplayItemEvent(worldserver, blockposition, itemstack);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = CraftItemStack.asNMSCopy(event.getDisplayItem());
                vaultshareddata.setDisplayItem(itemstack);
            }
        }

        private static ItemStack getRandomDisplayItemFromLootTable(WorldServer worldserver, BlockPosition blockposition, ResourceKey<LootTable> resourcekey) {
            LootParams lootparams;
            LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(resourcekey);
            ObjectArrayList<ItemStack> list = loottable.getRandomItems(lootparams = new LootParams.a(worldserver).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(blockposition)).create(LootContextParameterSets.VAULT), worldserver.getRandom());
            return list.isEmpty() ? ItemStack.EMPTY : SystemUtils.getRandom(list, worldserver.getRandom());
        }

        private static void unlock(WorldServer worldserver, IBlockData iblockdata, BlockPosition blockposition, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata, List<ItemStack> list) {
            vaultserverdata.setItemsToEject(list);
            vaultshareddata.setDisplayItem(vaultserverdata.getNextItemToEject());
            vaultserverdata.pauseStateUpdatingUntil(worldserver.getGameTime() + 14L);
            b.setVaultState(worldserver, blockposition, iblockdata, (IBlockData)iblockdata.setValue(VaultBlock.STATE, VaultState.UNLOCKING), vaultconfig, vaultshareddata);
        }

        private static List<ItemStack> resolveItemsToEject(WorldServer worldserver, VaultConfig vaultconfig, BlockPosition blockposition, EntityHuman entityhuman) {
            LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(vaultconfig.lootTable());
            LootParams lootparams = new LootParams.a(worldserver).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(blockposition)).withLuck(entityhuman.getLuck()).withParameter(LootContextParameters.THIS_ENTITY, entityhuman).create(LootContextParameterSets.VAULT);
            return loottable.getRandomItems(lootparams);
        }

        private static boolean canEjectReward(VaultConfig vaultconfig, VaultState vaultstate) {
            return vaultconfig.lootTable() != LootTables.EMPTY && !vaultconfig.keyItem().isEmpty() && vaultstate != VaultState.INACTIVE;
        }

        private static boolean isValidToInsert(VaultConfig vaultconfig, ItemStack itemstack) {
            return ItemStack.isSameItemSameComponents(itemstack, vaultconfig.keyItem()) && itemstack.getCount() >= vaultconfig.keyItem().getCount();
        }

        private static boolean shouldCycleDisplayItem(long i2, VaultState vaultstate) {
            return i2 % 20L == 0L && vaultstate == VaultState.ACTIVE;
        }

        private static void playInsertFailSound(WorldServer worldserver, VaultServerData vaultserverdata, BlockPosition blockposition, SoundEffect soundeffect) {
            if (worldserver.getGameTime() >= vaultserverdata.getLastInsertFailTimestamp() + 15L) {
                worldserver.playSound(null, blockposition, soundeffect, SoundCategory.BLOCKS);
                vaultserverdata.setLastInsertFailTimestamp(worldserver.getGameTime());
            }
        }
    }

    public static final class a {
        private static final int PARTICLE_TICK_RATE = 20;
        private static final float IDLE_PARTICLE_CHANCE = 0.5f;
        private static final float AMBIENT_SOUND_CHANCE = 0.02f;
        private static final int ACTIVATION_PARTICLE_COUNT = 20;
        private static final int DEACTIVATION_PARTICLE_COUNT = 20;

        public static void tick(World world, BlockPosition blockposition, IBlockData iblockdata, VaultClientData vaultclientdata, VaultSharedData vaultshareddata) {
            vaultclientdata.updateDisplayItemSpin();
            if (world.getGameTime() % 20L == 0L) {
                a.emitConnectionParticlesForNearbyPlayers(world, blockposition, iblockdata, vaultshareddata);
            }
            a.emitIdleParticles(world, blockposition, vaultshareddata, iblockdata.getValue(VaultBlock.OMINOUS) != false ? Particles.SOUL_FIRE_FLAME : Particles.SMALL_FLAME);
            a.playIdleSounds(world, blockposition, vaultshareddata);
        }

        public static void emitActivationParticles(World world, BlockPosition blockposition, IBlockData iblockdata, VaultSharedData vaultshareddata, ParticleParam particleparam) {
            a.emitConnectionParticlesForNearbyPlayers(world, blockposition, iblockdata, vaultshareddata);
            RandomSource randomsource = world.random;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3d = a.randomPosInsideCage(blockposition, randomsource);
                world.addParticle(Particles.SMOKE, vec3d.x(), vec3d.y(), vec3d.z(), 0.0, 0.0, 0.0);
                world.addParticle(particleparam, vec3d.x(), vec3d.y(), vec3d.z(), 0.0, 0.0, 0.0);
            }
        }

        public static void emitDeactivationParticles(World world, BlockPosition blockposition, ParticleParam particleparam) {
            RandomSource randomsource = world.random;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3d = a.randomPosCenterOfCage(blockposition, randomsource);
                Vec3D vec3d1 = new Vec3D(randomsource.nextGaussian() * 0.02, randomsource.nextGaussian() * 0.02, randomsource.nextGaussian() * 0.02);
                world.addParticle(particleparam, vec3d.x(), vec3d.y(), vec3d.z(), vec3d1.x(), vec3d1.y(), vec3d1.z());
            }
        }

        private static void emitIdleParticles(World world, BlockPosition blockposition, VaultSharedData vaultshareddata, ParticleParam particleparam) {
            RandomSource randomsource = world.getRandom();
            if (randomsource.nextFloat() <= 0.5f) {
                Vec3D vec3d = a.randomPosInsideCage(blockposition, randomsource);
                world.addParticle(Particles.SMOKE, vec3d.x(), vec3d.y(), vec3d.z(), 0.0, 0.0, 0.0);
                if (a.shouldDisplayActiveEffects(vaultshareddata)) {
                    world.addParticle(particleparam, vec3d.x(), vec3d.y(), vec3d.z(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void emitConnectionParticlesForPlayer(World world, Vec3D vec3d, EntityHuman entityhuman) {
            RandomSource randomsource = world.random;
            Vec3D vec3d1 = vec3d.vectorTo(entityhuman.position().add(0.0, entityhuman.getBbHeight() / 2.0f, 0.0));
            int i2 = MathHelper.nextInt(randomsource, 2, 5);
            for (int j2 = 0; j2 < i2; ++j2) {
                Vec3D vec3d2 = vec3d1.offsetRandom(randomsource, 1.0f);
                world.addParticle(Particles.VAULT_CONNECTION, vec3d.x(), vec3d.y(), vec3d.z(), vec3d2.x(), vec3d2.y(), vec3d2.z());
            }
        }

        private static void emitConnectionParticlesForNearbyPlayers(World world, BlockPosition blockposition, IBlockData iblockdata, VaultSharedData vaultshareddata) {
            Set<UUID> set = vaultshareddata.getConnectedPlayers();
            if (!set.isEmpty()) {
                Vec3D vec3d = a.keyholePos(blockposition, iblockdata.getValue(VaultBlock.FACING));
                for (UUID uuid : set) {
                    EntityHuman entityhuman = world.getPlayerByUUID(uuid);
                    if (entityhuman == null || !a.isWithinConnectionRange(blockposition, vaultshareddata, entityhuman)) continue;
                    a.emitConnectionParticlesForPlayer(world, vec3d, entityhuman);
                }
            }
        }

        private static boolean isWithinConnectionRange(BlockPosition blockposition, VaultSharedData vaultshareddata, EntityHuman entityhuman) {
            return entityhuman.blockPosition().distSqr(blockposition) <= MathHelper.square(vaultshareddata.connectedParticlesRange());
        }

        private static void playIdleSounds(World world, BlockPosition blockposition, VaultSharedData vaultshareddata) {
            RandomSource randomsource;
            if (a.shouldDisplayActiveEffects(vaultshareddata) && (randomsource = world.getRandom()).nextFloat() <= 0.02f) {
                world.playLocalSound(blockposition, SoundEffects.VAULT_AMBIENT, SoundCategory.BLOCKS, randomsource.nextFloat() * 0.25f + 0.75f, randomsource.nextFloat() + 0.5f, false);
            }
        }

        public static boolean shouldDisplayActiveEffects(VaultSharedData vaultshareddata) {
            return vaultshareddata.hasDisplayItem();
        }

        private static Vec3D randomPosCenterOfCage(BlockPosition blockposition, RandomSource randomsource) {
            return Vec3D.atLowerCornerOf(blockposition).add(MathHelper.nextDouble(randomsource, 0.4, 0.6), MathHelper.nextDouble(randomsource, 0.4, 0.6), MathHelper.nextDouble(randomsource, 0.4, 0.6));
        }

        private static Vec3D randomPosInsideCage(BlockPosition blockposition, RandomSource randomsource) {
            return Vec3D.atLowerCornerOf(blockposition).add(MathHelper.nextDouble(randomsource, 0.1, 0.9), MathHelper.nextDouble(randomsource, 0.25, 0.75), MathHelper.nextDouble(randomsource, 0.1, 0.9));
        }

        private static Vec3D keyholePos(BlockPosition blockposition, EnumDirection enumdirection) {
            return Vec3D.atBottomCenterOf(blockposition).add((double)enumdirection.getStepX() * 0.5, 1.75, (double)enumdirection.getStepZ() * 0.5);
        }
    }
}

