/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.piston.PistonExtendsChecker;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class BlockPiston
extends BlockDirectional {
    public static final MapCodec<BlockPiston> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("sticky").forGetter(blockpiston -> blockpiston.isSticky), BlockPiston.propertiesCodec()).apply((Applicative)instance, BlockPiston::new));
    public static final BlockStateBoolean EXTENDED = BlockProperties.EXTENDED;
    public static final int TRIGGER_EXTEND = 0;
    public static final int TRIGGER_CONTRACT = 1;
    public static final int TRIGGER_DROP = 2;
    public static final float PLATFORM_THICKNESS = 4.0f;
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape WEST_AABB = Block.box(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape UP_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape DOWN_AABB = Block.box(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean isSticky;

    public MapCodec<BlockPiston> codec() {
        return CODEC;
    }

    public BlockPiston(boolean flag, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(EXTENDED, false));
        this.isSticky = flag;
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        if (iblockdata.getValue(EXTENDED).booleanValue()) {
            switch (iblockdata.getValue(FACING)) {
                case DOWN: {
                    return DOWN_AABB;
                }
                default: {
                    return UP_AABB;
                }
                case NORTH: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case EAST: 
            }
            return EAST_AABB;
        }
        return VoxelShapes.block();
    }

    @Override
    public void setPlacedBy(World world, BlockPosition blockposition, IBlockData iblockdata, EntityLiving entityliving, ItemStack itemstack) {
        if (!world.isClientSide) {
            this.checkIfExtend(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void neighborChanged(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        if (!world.isClientSide) {
            this.checkIfExtend(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata1.is(iblockdata.getBlock()) && !world.isClientSide && world.getBlockEntity(blockposition) == null) {
            this.checkIfExtend(world, blockposition, iblockdata);
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, blockactioncontext.getNearestLookingDirection().getOpposite())).setValue(EXTENDED, false);
    }

    private void checkIfExtend(World world, BlockPosition blockposition, IBlockData iblockdata) {
        EnumDirection enumdirection = iblockdata.getValue(FACING);
        boolean flag = this.getNeighborSignal(world, blockposition, enumdirection);
        if (flag && !iblockdata.getValue(EXTENDED).booleanValue()) {
            if (new PistonExtendsChecker(world, blockposition, enumdirection, true).resolve()) {
                world.blockEvent(blockposition, this, 0, enumdirection.get3DDataValue());
            }
        } else if (!flag && iblockdata.getValue(EXTENDED).booleanValue()) {
            TileEntityPiston tileentitypiston;
            TileEntity tileentity;
            BlockPosition blockposition1 = blockposition.relative(enumdirection, 2);
            IBlockData iblockdata1 = world.getBlockState(blockposition1);
            int b0 = 1;
            if (iblockdata1.is(Blocks.MOVING_PISTON) && iblockdata1.getValue(FACING) == enumdirection && (tileentity = world.getBlockEntity(blockposition1)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity).isExtending() && (tileentitypiston.getProgress(0.0f) < 0.5f || world.getGameTime() == tileentitypiston.getLastTicked() || ((WorldServer)world).isHandlingTick())) {
                b0 = 2;
            }
            if (!this.isSticky) {
                org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
                BlockPistonRetractEvent event = new BlockPistonRetractEvent(block, (List)ImmutableList.of(), CraftBlock.notchToBlockFace(enumdirection));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            world.blockEvent(blockposition, this, b0, enumdirection.get3DDataValue());
        }
    }

    private boolean getNeighborSignal(SignalGetter signalgetter, BlockPosition blockposition, EnumDirection enumdirection) {
        for (EnumDirection enumdirection1 : EnumDirection.values()) {
            if (enumdirection1 == enumdirection || !signalgetter.hasSignal(blockposition.relative(enumdirection1), enumdirection1)) continue;
            return true;
        }
        if (signalgetter.hasSignal(blockposition, EnumDirection.DOWN)) {
            return true;
        }
        BlockPosition blockposition1 = blockposition.above();
        for (EnumDirection enumdirection2 : EnumDirection.values()) {
            if (enumdirection2 == EnumDirection.DOWN || !signalgetter.hasSignal(blockposition1.relative(enumdirection2), enumdirection2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean triggerEvent(IBlockData iblockdata, World world, BlockPosition blockposition, int i2, int j2) {
        EnumDirection enumdirection = iblockdata.getValue(FACING);
        IBlockData iblockdata1 = (IBlockData)iblockdata.setValue(EXTENDED, true);
        if (!world.isClientSide) {
            boolean flag = this.getNeighborSignal(world, blockposition, enumdirection);
            if (flag && (i2 == 1 || i2 == 2)) {
                world.setBlock(blockposition, iblockdata1, 2);
                return false;
            }
            if (!flag && i2 == 0) {
                return false;
            }
        }
        if (i2 == 0) {
            if (!this.moveBlocks(world, blockposition, enumdirection, true)) {
                return false;
            }
            world.setBlock(blockposition, iblockdata1, 67);
            world.playSound((EntityHuman)null, blockposition, SoundEffects.PISTON_EXTEND, SoundCategory.BLOCKS, 0.5f, world.random.nextFloat() * 0.25f + 0.6f);
            world.gameEvent(GameEvent.BLOCK_ACTIVATE, blockposition, GameEvent.a.of(iblockdata1));
        } else if (i2 == 1 || i2 == 2) {
            TileEntity tileentity = world.getBlockEntity(blockposition.relative(enumdirection));
            if (tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).finalTick();
            }
            IBlockData iblockdata2 = (IBlockData)((IBlockData)Blocks.MOVING_PISTON.defaultBlockState().setValue(BlockPistonMoving.FACING, enumdirection)).setValue(BlockPistonMoving.TYPE, this.isSticky ? BlockPropertyPistonType.STICKY : BlockPropertyPistonType.DEFAULT);
            world.setBlock(blockposition, iblockdata2, 20);
            world.setBlockEntity(BlockPistonMoving.newMovingBlockEntity(blockposition, iblockdata2, (IBlockData)this.defaultBlockState().setValue(FACING, EnumDirection.from3DDataValue(j2 & 7)), enumdirection, false, true));
            world.blockUpdated(blockposition, iblockdata2.getBlock());
            iblockdata2.updateNeighbourShapes(world, blockposition, 2);
            if (this.isSticky) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity1;
                BlockPosition blockposition1 = blockposition.offset(enumdirection.getStepX() * 2, enumdirection.getStepY() * 2, enumdirection.getStepZ() * 2);
                IBlockData iblockdata3 = world.getBlockState(blockposition1);
                boolean flag1 = false;
                if (iblockdata3.is(Blocks.MOVING_PISTON) && (tileentity1 = world.getBlockEntity(blockposition1)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity1).getDirection() == enumdirection && tileentitypiston.isExtending()) {
                    tileentitypiston.finalTick();
                    flag1 = true;
                }
                if (!flag1) {
                    if (i2 == 1 && !iblockdata3.isAir() && BlockPiston.isPushable(iblockdata3, world, blockposition1, enumdirection.getOpposite(), false, enumdirection) && (iblockdata3.getPistonPushReaction() == EnumPistonReaction.NORMAL || iblockdata3.is(Blocks.PISTON) || iblockdata3.is(Blocks.STICKY_PISTON))) {
                        this.moveBlocks(world, blockposition, enumdirection, false);
                    } else {
                        world.removeBlock(blockposition.relative(enumdirection), false);
                    }
                }
            } else {
                world.removeBlock(blockposition.relative(enumdirection), false);
            }
            world.playSound((EntityHuman)null, blockposition, SoundEffects.PISTON_CONTRACT, SoundCategory.BLOCKS, 0.5f, world.random.nextFloat() * 0.15f + 0.6f);
            world.gameEvent(GameEvent.BLOCK_DEACTIVATE, blockposition, GameEvent.a.of(iblockdata2));
        }
        return true;
    }

    public static boolean isPushable(IBlockData iblockdata, World world, BlockPosition blockposition, EnumDirection enumdirection, boolean flag, EnumDirection enumdirection1) {
        if (blockposition.getY() >= world.getMinBuildHeight() && blockposition.getY() <= world.getMaxBuildHeight() - 1 && world.getWorldBorder().isWithinBounds(blockposition)) {
            if (iblockdata.isAir()) {
                return true;
            }
            if (!(iblockdata.is(Blocks.OBSIDIAN) || iblockdata.is(Blocks.CRYING_OBSIDIAN) || iblockdata.is(Blocks.RESPAWN_ANCHOR) || iblockdata.is(Blocks.REINFORCED_DEEPSLATE))) {
                if (enumdirection == EnumDirection.DOWN && blockposition.getY() == world.getMinBuildHeight()) {
                    return false;
                }
                if (enumdirection == EnumDirection.UP && blockposition.getY() == world.getMaxBuildHeight() - 1) {
                    return false;
                }
                if (!iblockdata.is(Blocks.PISTON) && !iblockdata.is(Blocks.STICKY_PISTON)) {
                    if (iblockdata.getDestroySpeed(world, blockposition) == -1.0f) {
                        return false;
                    }
                    switch (iblockdata.getPistonPushReaction()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return flag;
                        }
                        case PUSH_ONLY: {
                            return enumdirection == enumdirection1;
                        }
                    }
                } else if (iblockdata.getValue(EXTENDED).booleanValue()) {
                    return false;
                }
                return !iblockdata.hasBlockEntity();
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean moveBlocks(World world, BlockPosition blockposition, EnumDirection enumdirection, boolean flag) {
        void var26_32;
        void var26_30;
        BlockPosition blockposition5;
        IBlockData iblockdata1;
        BlockPosition blockposition3;
        int j2;
        PistonExtendsChecker pistonextendschecker;
        BlockPosition blockposition1 = blockposition.relative(enumdirection);
        if (!flag && world.getBlockState(blockposition1).is(Blocks.PISTON_HEAD)) {
            world.setBlock(blockposition1, Blocks.AIR.defaultBlockState(), 20);
        }
        if (!(pistonextendschecker = new PistonExtendsChecker(world, blockposition, enumdirection, flag)).resolve()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPosition> list = pistonextendschecker.getToPush();
        ArrayList list1 = Lists.newArrayList();
        for (BlockPosition blockposition2 : list) {
            IBlockData iblockdata = world.getBlockState(blockposition2);
            list1.add(iblockdata);
            map.put(blockposition2, iblockdata);
        }
        List<BlockPosition> list2 = pistonextendschecker.getToDestroy();
        IBlockData[] aiblockdata = new IBlockData[list.size() + list2.size()];
        EnumDirection enumdirection1 = flag ? enumdirection : enumdirection.getOpposite();
        int i2 = 0;
        final org.bukkit.block.Block bblock = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
        final List<BlockPosition> moved = pistonextendschecker.getToPush();
        final List<BlockPosition> broken = pistonextendschecker.getToDestroy();
        AbstractList<org.bukkit.block.Block> blocks = new AbstractList<org.bukkit.block.Block>(this){

            @Override
            public int size() {
                return moved.size() + broken.size();
            }

            @Override
            public org.bukkit.block.Block get(int index) {
                if (index >= this.size() || index < 0) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                BlockPosition pos = index < moved.size() ? (BlockPosition)moved.get(index) : (BlockPosition)broken.get(index - moved.size());
                return bblock.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            }
        };
        Object event = flag ? new BlockPistonExtendEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1)) : new BlockPistonRetractEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            for (BlockPosition b2 : broken) {
                world.sendBlockUpdated(b2, Blocks.AIR.defaultBlockState(), world.getBlockState(b2), 3);
            }
            for (BlockPosition b2 : moved) {
                world.sendBlockUpdated(b2, Blocks.AIR.defaultBlockState(), world.getBlockState(b2), 3);
                b2 = b2.relative(enumdirection1);
                world.sendBlockUpdated(b2, Blocks.AIR.defaultBlockState(), world.getBlockState(b2), 3);
            }
            return false;
        }
        for (j2 = list2.size() - 1; j2 >= 0; --j2) {
            blockposition3 = list2.get(j2);
            iblockdata1 = world.getBlockState(blockposition3);
            TileEntity tileentity = iblockdata1.hasBlockEntity() ? world.getBlockEntity(blockposition3) : null;
            BlockPiston.dropResources(iblockdata1, world, blockposition3, tileentity);
            world.setBlock(blockposition3, Blocks.AIR.defaultBlockState(), 18);
            world.gameEvent(GameEvent.BLOCK_DESTROY, blockposition3, GameEvent.a.of(iblockdata1));
            if (!iblockdata1.is(TagsBlock.FIRE)) {
                world.addDestroyBlockEffect(blockposition3, iblockdata1);
            }
            aiblockdata[i2++] = iblockdata1;
        }
        for (j2 = list.size() - 1; j2 >= 0; --j2) {
            blockposition3 = list.get(j2);
            iblockdata1 = world.getBlockState(blockposition3);
            blockposition3 = blockposition3.relative(enumdirection1);
            map.remove(blockposition3);
            IBlockData iblockdata2 = (IBlockData)Blocks.MOVING_PISTON.defaultBlockState().setValue(FACING, enumdirection);
            world.setBlock(blockposition3, iblockdata2, 68);
            world.setBlockEntity(BlockPistonMoving.newMovingBlockEntity(blockposition3, iblockdata2, (IBlockData)list1.get(j2), enumdirection, flag, false));
            aiblockdata[i2++] = iblockdata1;
        }
        if (flag) {
            BlockPropertyPistonType blockpropertypistontype = this.isSticky ? BlockPropertyPistonType.STICKY : BlockPropertyPistonType.DEFAULT;
            IBlockData iblockdata3 = (IBlockData)((IBlockData)Blocks.PISTON_HEAD.defaultBlockState().setValue(BlockPistonExtension.FACING, enumdirection)).setValue(BlockPistonExtension.TYPE, blockpropertypistontype);
            iblockdata1 = (IBlockData)((IBlockData)Blocks.MOVING_PISTON.defaultBlockState().setValue(BlockPistonMoving.FACING, enumdirection)).setValue(BlockPistonMoving.TYPE, this.isSticky ? BlockPropertyPistonType.STICKY : BlockPropertyPistonType.DEFAULT);
            map.remove(blockposition1);
            world.setBlock(blockposition1, iblockdata1, 68);
            world.setBlockEntity(BlockPistonMoving.newMovingBlockEntity(blockposition1, iblockdata1, iblockdata3, enumdirection, true, true));
        }
        IBlockData iblockdata4 = Blocks.AIR.defaultBlockState();
        for (BlockPosition blockposition4 : map.keySet()) {
            world.setBlock(blockposition4, iblockdata4, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            blockposition5 = (BlockPosition)entry.getKey();
            IBlockData iblockdata5 = (IBlockData)entry.getValue();
            iblockdata5.updateIndirectNeighbourShapes(world, blockposition5, 2);
            iblockdata4.updateNeighbourShapes(world, blockposition5, 2);
            iblockdata4.updateIndirectNeighbourShapes(world, blockposition5, 2);
        }
        i2 = 0;
        int n2 = list2.size() - 1;
        while (var26_30 >= 0) {
            iblockdata1 = aiblockdata[i2++];
            blockposition5 = list2.get((int)var26_30);
            iblockdata1.updateIndirectNeighbourShapes(world, blockposition5, 2);
            world.updateNeighborsAt(blockposition5, iblockdata1.getBlock());
            --var26_30;
        }
        int n3 = list.size() - 1;
        while (var26_32 >= 0) {
            world.updateNeighborsAt(list.get((int)var26_32), aiblockdata[i2++].getBlock());
            --var26_32;
        }
        if (flag) {
            world.updateNeighborsAt(blockposition1, Blocks.PISTON_HEAD);
        }
        return true;
    }

    @Override
    protected IBlockData rotate(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(FACING, EXTENDED);
    }

    @Override
    protected boolean useShapeForLightOcclusion(IBlockData iblockdata) {
        return iblockdata.getValue(EXTENDED);
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }
}

