/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.EuclideanGameEventListenerRegistry;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.slf4j.Logger;

public class Chunk
extends IChunkAccess {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final TickingBlockEntity NULL_TICKER = new TickingBlockEntity(){

        @Override
        public void tick() {
        }

        @Override
        public boolean isRemoved() {
            return true;
        }

        @Override
        public BlockPosition getPos() {
            return BlockPosition.ZERO;
        }

        @Override
        public String getType() {
            return "<null>";
        }
    };
    private final Map<BlockPosition, d> tickersInLevel = Maps.newHashMap();
    public boolean loaded;
    public final WorldServer level;
    @Nullable
    private Supplier<FullChunkStatus> fullStatus;
    @Nullable
    private c postLoad;
    private final Int2ObjectMap<GameEventListenerRegistry> gameEventListenerRegistrySections;
    private final LevelChunkTicks<Block> blockTicks;
    private final LevelChunkTicks<FluidType> fluidTicks;
    public boolean mustNotSave;
    public boolean needsDecoration;

    public Chunk(World world, ChunkCoordIntPair chunkcoordintpair) {
        this(world, chunkcoordintpair, ChunkConverter.EMPTY, new LevelChunkTicks<Block>(), new LevelChunkTicks<FluidType>(), 0L, null, null, null);
    }

    public Chunk(World world, ChunkCoordIntPair chunkcoordintpair, ChunkConverter chunkconverter, LevelChunkTicks<Block> levelchunkticks, LevelChunkTicks<FluidType> levelchunkticks1, long i2, @Nullable ChunkSection[] achunksection, @Nullable c chunk_c, @Nullable BlendingData blendingdata) {
        super(chunkcoordintpair, chunkconverter, world, world.registryAccess().registryOrThrow(Registries.BIOME), i2, achunksection, blendingdata);
        this.level = (WorldServer)world;
        this.gameEventListenerRegistrySections = new Int2ObjectOpenHashMap();
        for (HeightMap.Type heightmap_type : HeightMap.Type.values()) {
            if (!ChunkStatus.FULL.heightmapsAfter().contains(heightmap_type)) continue;
            this.heightmaps.put(heightmap_type, new HeightMap(this, heightmap_type));
        }
        this.postLoad = chunk_c;
        this.blockTicks = levelchunkticks;
        this.fluidTicks = levelchunkticks1;
    }

    /*
     * WARNING - void declaration
     */
    public Chunk(WorldServer worldserver, ProtoChunk protochunk, @Nullable c chunk_c) {
        this(worldserver, protochunk.getPos(), protochunk.getUpgradeData(), protochunk.unpackBlockTicks(), protochunk.unpackFluidTicks(), protochunk.getInhabitedTime(), protochunk.getSections(), chunk_c, protochunk.getBlendingData());
        void var5_7;
        for (TileEntity tileEntity : protochunk.getBlockEntities().values()) {
            this.setBlockEntity(tileEntity);
        }
        this.pendingBlockEntities.putAll(protochunk.getBlockEntityNbts());
        boolean bl = false;
        while (var5_7 < protochunk.getPostProcessing().length) {
            this.postProcessing[var5_7] = protochunk.getPostProcessing()[var5_7];
            ++var5_7;
        }
        this.setAllStarts(protochunk.getAllStarts());
        this.setAllReferences(protochunk.getAllReferences());
        for (Map.Entry entry : protochunk.getHeightmaps()) {
            if (!ChunkStatus.FULL.heightmapsAfter().contains(entry.getKey())) continue;
            this.setHeightmap((HeightMap.Type)entry.getKey(), ((HeightMap)entry.getValue()).getRawData());
        }
        this.skyLightSources = protochunk.skyLightSources;
        this.setLightCorrect(protochunk.isLightCorrect());
        this.unsaved = true;
        this.needsDecoration = true;
        this.persistentDataContainer = protochunk.persistentDataContainer;
    }

    @Override
    public TickContainerAccess<Block> getBlockTicks() {
        return this.blockTicks;
    }

    @Override
    public TickContainerAccess<FluidType> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    public IChunkAccess.a getTicksForSerialization() {
        return new IChunkAccess.a(this.blockTicks, this.fluidTicks);
    }

    @Override
    public GameEventListenerRegistry getListenerRegistry(int i2) {
        WorldServer world = this.level;
        if (world instanceof WorldServer) {
            WorldServer worldserver = world;
            return (GameEventListenerRegistry)this.gameEventListenerRegistrySections.computeIfAbsent(i2, j2 -> new EuclideanGameEventListenerRegistry(worldserver, i2, this::removeGameEventListenerRegistry));
        }
        return super.getListenerRegistry(i2);
    }

    @Override
    public IBlockData getBlockState(BlockPosition blockposition) {
        int i2 = blockposition.getX();
        int j2 = blockposition.getY();
        int k2 = blockposition.getZ();
        if (this.level.isDebug()) {
            IBlockData iblockdata = null;
            if (j2 == 60) {
                iblockdata = Blocks.BARRIER.defaultBlockState();
            }
            if (j2 == 70) {
                iblockdata = ChunkProviderDebug.getBlockStateFor(i2, k2);
            }
            return iblockdata == null ? Blocks.AIR.defaultBlockState() : iblockdata;
        }
        try {
            ChunkSection chunksection;
            int l2 = this.getSectionIndex(j2);
            if (l2 >= 0 && l2 < this.sections.length && !(chunksection = this.sections[l2]).hasOnlyAir()) {
                return chunksection.getBlockState(i2 & 0xF, j2 & 0xF, k2 & 0xF);
            }
            return Blocks.AIR.defaultBlockState();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Getting block state");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Block being got");
            crashreportsystemdetails.setDetail("Location", () -> CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public Fluid getFluidState(BlockPosition blockposition) {
        return this.getFluidState(blockposition.getX(), blockposition.getY(), blockposition.getZ());
    }

    public Fluid getFluidState(int i2, int j2, int k2) {
        try {
            ChunkSection chunksection;
            int l2 = this.getSectionIndex(j2);
            if (l2 >= 0 && l2 < this.sections.length && !(chunksection = this.sections[l2]).hasOnlyAir()) {
                return chunksection.getFluidState(i2 & 0xF, j2 & 0xF, k2 & 0xF);
            }
            return FluidTypes.EMPTY.defaultFluidState();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Getting fluid state");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Block being got");
            crashreportsystemdetails.setDetail("Location", () -> CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    @Nullable
    public IBlockData setBlockState(BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
        return this.setBlockState(blockposition, iblockdata, flag, true);
    }

    @Nullable
    public IBlockData setBlockState(BlockPosition blockposition, IBlockData iblockdata, boolean flag, boolean doPlace) {
        int l2;
        int k2;
        int i2 = blockposition.getY();
        ChunkSection chunksection = this.getSection(this.getSectionIndex(i2));
        boolean flag1 = chunksection.hasOnlyAir();
        if (flag1 && iblockdata.isAir()) {
            return null;
        }
        int j2 = blockposition.getX() & 0xF;
        IBlockData iblockdata1 = chunksection.setBlockState(j2, k2 = i2 & 0xF, l2 = blockposition.getZ() & 0xF, iblockdata);
        if (iblockdata1 == iblockdata) {
            return null;
        }
        Block block = iblockdata.getBlock();
        ((HeightMap)this.heightmaps.get(HeightMap.Type.MOTION_BLOCKING)).update(j2, i2, l2, iblockdata);
        ((HeightMap)this.heightmaps.get(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES)).update(j2, i2, l2, iblockdata);
        ((HeightMap)this.heightmaps.get(HeightMap.Type.OCEAN_FLOOR)).update(j2, i2, l2, iblockdata);
        ((HeightMap)this.heightmaps.get(HeightMap.Type.WORLD_SURFACE)).update(j2, i2, l2, iblockdata);
        boolean flag2 = chunksection.hasOnlyAir();
        if (flag1 != flag2) {
            this.level.getChunkSource().getLightEngine().updateSectionStatus(blockposition, flag2);
        }
        if (LightEngine.hasDifferentLightProperties(this, blockposition, iblockdata1, iblockdata)) {
            GameProfilerFiller gameprofilerfiller = this.level.getProfiler();
            gameprofilerfiller.push("updateSkyLightSources");
            this.skyLightSources.update(this, j2, i2, l2);
            gameprofilerfiller.popPush("queueCheckLight");
            this.level.getChunkSource().getLightEngine().checkBlock(blockposition);
            gameprofilerfiller.pop();
        }
        boolean flag3 = iblockdata1.hasBlockEntity();
        if (!this.level.isClientSide) {
            iblockdata1.onRemove(this.level, blockposition, iblockdata, flag);
        } else if (!iblockdata1.is(block) && flag3) {
            this.removeBlockEntity(blockposition);
        }
        if (!chunksection.getBlockState(j2, k2, l2).is(block)) {
            return null;
        }
        if (!this.level.isClientSide && doPlace && (!this.level.captureBlockStates || block instanceof BlockTileEntity)) {
            iblockdata.onPlace(this.level, blockposition, iblockdata1, flag);
        }
        if (iblockdata.hasBlockEntity()) {
            TileEntity tileentity = this.getBlockEntity(blockposition, EnumTileEntityState.CHECK);
            if (tileentity != null && !tileentity.isValidBlockState(iblockdata)) {
                this.removeBlockEntity(blockposition);
                tileentity = null;
            }
            if (tileentity == null) {
                tileentity = ((ITileEntity)((Object)block)).newBlockEntity(blockposition, iblockdata);
                if (tileentity != null) {
                    this.addAndRegisterBlockEntity(tileentity);
                }
            } else {
                tileentity.setBlockState(iblockdata);
                this.updateBlockEntityTicker(tileentity);
            }
        }
        this.unsaved = true;
        return iblockdata1;
    }

    @Override
    @Deprecated
    public void addEntity(Entity entity) {
    }

    @Nullable
    private TileEntity createBlockEntity(BlockPosition blockposition) {
        IBlockData iblockdata = this.getBlockState(blockposition);
        return !iblockdata.hasBlockEntity() ? null : ((ITileEntity)((Object)iblockdata.getBlock())).newBlockEntity(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition) {
        return this.getBlockEntity(blockposition, EnumTileEntityState.CHECK);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition, EnumTileEntityState chunk_enumtileentitystate) {
        TileEntity tileentity1;
        NBTTagCompound nbttagcompound;
        TileEntity tileentity = (TileEntity)this.level.capturedTileEntities.get(blockposition);
        if (tileentity == null) {
            tileentity = (TileEntity)this.blockEntities.get(blockposition);
        }
        if (tileentity == null && (nbttagcompound = (NBTTagCompound)this.pendingBlockEntities.remove(blockposition)) != null && (tileentity1 = this.promotePendingBlockEntity(blockposition, nbttagcompound)) != null) {
            return tileentity1;
        }
        if (tileentity == null) {
            if (chunk_enumtileentitystate == EnumTileEntityState.IMMEDIATE && (tileentity = this.createBlockEntity(blockposition)) != null) {
                this.addAndRegisterBlockEntity(tileentity);
            }
        } else if (tileentity.isRemoved()) {
            this.blockEntities.remove(blockposition);
            return null;
        }
        return tileentity;
    }

    public void addAndRegisterBlockEntity(TileEntity tileentity) {
        this.setBlockEntity(tileentity);
        if (this.isInLevel()) {
            WorldServer world = this.level;
            if (world instanceof WorldServer) {
                WorldServer worldserver = world;
                this.addGameEventListener(tileentity, worldserver);
            }
            this.updateBlockEntityTicker(tileentity);
        }
    }

    private boolean isInLevel() {
        return this.loaded || this.level.isClientSide();
    }

    boolean isTicking(BlockPosition blockposition) {
        if (!this.level.getWorldBorder().isWithinBounds(blockposition)) {
            return false;
        }
        WorldServer world = this.level;
        if (!(world instanceof WorldServer)) {
            return true;
        }
        WorldServer worldserver = world;
        return this.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING) && worldserver.areEntitiesLoaded(ChunkCoordIntPair.asLong(blockposition));
    }

    @Override
    public void setBlockEntity(TileEntity tileentity) {
        BlockPosition blockposition = tileentity.getBlockPos();
        IBlockData iblockdata = this.getBlockState(blockposition);
        if (!iblockdata.hasBlockEntity()) {
            LOGGER.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{tileentity, blockposition, iblockdata});
            new Exception().printStackTrace();
        } else {
            IBlockData iblockdata1 = tileentity.getBlockState();
            if (iblockdata != iblockdata1) {
                if (!tileentity.getType().isValid(iblockdata)) {
                    LOGGER.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{tileentity, blockposition, iblockdata});
                    return;
                }
                if (iblockdata.getBlock() != iblockdata1.getBlock()) {
                    LOGGER.warn("Block state mismatch on block entity {} in position {}, {} != {}, updating", new Object[]{tileentity, blockposition, iblockdata, iblockdata1});
                }
                tileentity.setBlockState(iblockdata);
            }
            tileentity.setLevel(this.level);
            tileentity.clearRemoved();
            TileEntity tileentity1 = this.blockEntities.put(blockposition.immutable(), tileentity);
            if (tileentity1 != null && tileentity1 != tileentity) {
                tileentity1.setRemoved();
            }
        }
    }

    @Override
    @Nullable
    public NBTTagCompound getBlockEntityNbtForSaving(BlockPosition blockposition, HolderLookup.a holderlookup_a) {
        TileEntity tileentity = this.getBlockEntity(blockposition);
        if (tileentity != null && !tileentity.isRemoved()) {
            NBTTagCompound nbttagcompound = tileentity.saveWithFullMetadata(this.level.registryAccess());
            nbttagcompound.putBoolean("keepPacked", false);
            return nbttagcompound;
        }
        NBTTagCompound nbttagcompound = (NBTTagCompound)this.pendingBlockEntities.get(blockposition);
        if (nbttagcompound != null) {
            nbttagcompound = nbttagcompound.copy();
            nbttagcompound.putBoolean("keepPacked", true);
        }
        return nbttagcompound;
    }

    @Override
    public void removeBlockEntity(BlockPosition blockposition) {
        if (this.isInLevel()) {
            TileEntity tileentity = (TileEntity)this.blockEntities.remove(blockposition);
            if (!this.pendingBlockEntities.isEmpty()) {
                this.pendingBlockEntities.remove(blockposition);
            }
            if (tileentity != null) {
                WorldServer world = this.level;
                if (world instanceof WorldServer) {
                    WorldServer worldserver = world;
                    this.removeGameEventListener(tileentity, worldserver);
                }
                tileentity.setRemoved();
            }
        }
        this.removeBlockEntityTicker(blockposition);
    }

    private <T extends TileEntity> void removeGameEventListener(T t0, WorldServer worldserver) {
        GameEventListener gameeventlistener;
        Block block = t0.getBlockState().getBlock();
        if (block instanceof ITileEntity && (gameeventlistener = ((ITileEntity)((Object)block)).getListener(worldserver, t0)) != null) {
            int i2 = SectionPosition.blockToSectionCoord(t0.getBlockPos().getY());
            GameEventListenerRegistry gameeventlistenerregistry = this.getListenerRegistry(i2);
            gameeventlistenerregistry.unregister(gameeventlistener);
        }
    }

    private void removeGameEventListenerRegistry(int i2) {
        this.gameEventListenerRegistrySections.remove(i2);
    }

    private void removeBlockEntityTicker(BlockPosition blockposition) {
        d chunk_d = this.tickersInLevel.remove(blockposition);
        if (chunk_d != null) {
            chunk_d.rebind(NULL_TICKER);
        }
    }

    public void runPostLoad() {
        if (this.postLoad != null) {
            this.postLoad.run(this);
            this.postLoad = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCallback() {
        CraftServer server = this.level.getCraftServer();
        if (server != null) {
            CraftChunk bukkitChunk = new CraftChunk(this);
            server.getPluginManager().callEvent((Event)new ChunkLoadEvent((org.bukkit.Chunk)bukkitChunk, this.needsDecoration));
            if (this.needsDecoration) {
                this.needsDecoration = false;
                Random random = new Random();
                random.setSeed(this.level.getSeed());
                long xRand = random.nextLong() / 2L * 2L + 1L;
                long zRand = random.nextLong() / 2L * 2L + 1L;
                random.setSeed((long)this.chunkPos.x * xRand + (long)this.chunkPos.z * zRand ^ this.level.getSeed());
                CraftWorld world = this.level.getWorld();
                if (world != null) {
                    this.level.populating = true;
                    try {
                        for (BlockPopulator populator : world.getPopulators()) {
                            populator.populate((org.bukkit.World)world, random, (org.bukkit.Chunk)bukkitChunk);
                        }
                    }
                    finally {
                        this.level.populating = false;
                    }
                }
                server.getPluginManager().callEvent((Event)new ChunkPopulateEvent((org.bukkit.Chunk)bukkitChunk));
            }
        }
    }

    public void unloadCallback() {
        CraftServer server = this.level.getCraftServer();
        CraftChunk bukkitChunk = new CraftChunk(this);
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent((org.bukkit.Chunk)bukkitChunk, this.isUnsaved());
        server.getPluginManager().callEvent((Event)unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
    }

    @Override
    public boolean isUnsaved() {
        return super.isUnsaved() && !this.mustNotSave;
    }

    public boolean isEmpty() {
        return false;
    }

    public void replaceWithPacketData(PacketDataSerializer packetdataserializer, NBTTagCompound nbttagcompound, Consumer<ClientboundLevelChunkPacketData.b> consumer) {
        this.clearAllBlockEntities();
        for (ChunkSection chunksection : this.sections) {
            chunksection.read(packetdataserializer);
        }
        for (HeightMap.Type heightmap_type : HeightMap.Type.values()) {
            String s2 = heightmap_type.getSerializationKey();
            if (!nbttagcompound.contains(s2, 12)) continue;
            this.setHeightmap(heightmap_type, nbttagcompound.getLongArray(s2));
        }
        this.initializeLightSources();
        consumer.accept((blockposition, tileentitytypes, nbttagcompound1) -> {
            TileEntity tileentity = this.getBlockEntity(blockposition, EnumTileEntityState.IMMEDIATE);
            if (tileentity != null && nbttagcompound1 != null && tileentity.getType() == tileentitytypes) {
                tileentity.loadWithComponents(nbttagcompound1, this.level.registryAccess());
            }
        });
    }

    public void replaceBiomes(PacketDataSerializer packetdataserializer) {
        for (ChunkSection chunksection : this.sections) {
            chunksection.readBiomes(packetdataserializer);
        }
    }

    public void setLoaded(boolean flag) {
        this.loaded = flag;
    }

    public World getLevel() {
        return this.level;
    }

    public Map<BlockPosition, TileEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public void postProcessGeneration() {
        ChunkCoordIntPair chunkcoordintpair = this.getPos();
        for (int i2 = 0; i2 < this.postProcessing.length; ++i2) {
            if (this.postProcessing[i2] == null) continue;
            for (Short oshort : this.postProcessing[i2]) {
                BlockPosition blockposition = ProtoChunk.unpackOffsetCoordinates(oshort, this.getSectionYFromSectionIndex(i2), chunkcoordintpair);
                IBlockData iblockdata = this.getBlockState(blockposition);
                Fluid fluid = iblockdata.getFluidState();
                if (!fluid.isEmpty()) {
                    fluid.tick(this.level, blockposition);
                }
                if (iblockdata.getBlock() instanceof BlockFluids) continue;
                IBlockData iblockdata1 = Block.updateFromNeighbourShapes(iblockdata, this.level, blockposition);
                this.level.setBlock(blockposition, iblockdata1, 20);
            }
            this.postProcessing[i2].clear();
        }
        for (BlockPosition blockposition1 : ImmutableList.copyOf(this.pendingBlockEntities.keySet())) {
            this.getBlockEntity(blockposition1);
        }
        this.pendingBlockEntities.clear();
        this.upgradeData.upgrade(this);
    }

    @Nullable
    private TileEntity promotePendingBlockEntity(BlockPosition blockposition, NBTTagCompound nbttagcompound) {
        TileEntity tileentity;
        IBlockData iblockdata = this.getBlockState(blockposition);
        if ("DUMMY".equals(nbttagcompound.getString("id"))) {
            if (iblockdata.hasBlockEntity()) {
                tileentity = ((ITileEntity)((Object)iblockdata.getBlock())).newBlockEntity(blockposition, iblockdata);
            } else {
                tileentity = null;
                LOGGER.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)blockposition, (Object)iblockdata);
            }
        } else {
            tileentity = TileEntity.loadStatic(blockposition, iblockdata, nbttagcompound, this.level.registryAccess());
        }
        if (tileentity != null) {
            tileentity.setLevel(this.level);
            this.addAndRegisterBlockEntity(tileentity);
        } else {
            LOGGER.warn("Tried to load a block entity for block {} but failed at location {}", (Object)iblockdata, (Object)blockposition);
        }
        return tileentity;
    }

    public void unpackTicks(long i2) {
        this.blockTicks.unpack(i2);
        this.fluidTicks.unpack(i2);
    }

    public void registerTickContainerInLevel(WorldServer worldserver) {
        ((TickListServer)worldserver.getBlockTicks()).addContainer(this.chunkPos, this.blockTicks);
        ((TickListServer)worldserver.getFluidTicks()).addContainer(this.chunkPos, this.fluidTicks);
    }

    public void unregisterTickContainerFromLevel(WorldServer worldserver) {
        ((TickListServer)worldserver.getBlockTicks()).removeContainer(this.chunkPos);
        ((TickListServer)worldserver.getFluidTicks()).removeContainer(this.chunkPos);
    }

    @Override
    public ChunkStatus getPersistedStatus() {
        return ChunkStatus.FULL;
    }

    public FullChunkStatus getFullStatus() {
        return this.fullStatus == null ? FullChunkStatus.FULL : this.fullStatus.get();
    }

    public void setFullStatus(Supplier<FullChunkStatus> supplier) {
        this.fullStatus = supplier;
    }

    public void clearAllBlockEntities() {
        this.blockEntities.values().forEach(TileEntity::setRemoved);
        this.blockEntities.clear();
        this.tickersInLevel.values().forEach(chunk_d -> chunk_d.rebind(NULL_TICKER));
        this.tickersInLevel.clear();
    }

    public void registerAllBlockEntitiesAfterLevelLoad() {
        this.blockEntities.values().forEach(tileentity -> {
            WorldServer world = this.level;
            if (world instanceof WorldServer) {
                WorldServer worldserver = world;
                this.addGameEventListener(tileentity, worldserver);
            }
            this.updateBlockEntityTicker(tileentity);
        });
    }

    private <T extends TileEntity> void addGameEventListener(T t0, WorldServer worldserver) {
        GameEventListener gameeventlistener;
        Block block = t0.getBlockState().getBlock();
        if (block instanceof ITileEntity && (gameeventlistener = ((ITileEntity)((Object)block)).getListener(worldserver, t0)) != null) {
            this.getListenerRegistry(SectionPosition.blockToSectionCoord(t0.getBlockPos().getY())).register(gameeventlistener);
        }
    }

    private <T extends TileEntity> void updateBlockEntityTicker(T t0) {
        IBlockData iblockdata = t0.getBlockState();
        BlockEntityTicker<?> blockentityticker = iblockdata.getTicker(this.level, t0.getType());
        if (blockentityticker == null) {
            this.removeBlockEntityTicker(t0.getBlockPos());
        } else {
            this.tickersInLevel.compute(t0.getBlockPos(), (blockposition, chunk_d) -> {
                TickingBlockEntity tickingblockentity = this.createTicker(t0, blockentityticker);
                if (chunk_d != null) {
                    chunk_d.rebind(tickingblockentity);
                    return chunk_d;
                }
                if (this.isInLevel()) {
                    d chunk_d1 = new d(this, this, tickingblockentity);
                    this.level.addBlockEntityTicker(chunk_d1);
                    return chunk_d1;
                }
                return null;
            });
        }
    }

    private <T extends TileEntity> TickingBlockEntity createTicker(T t0, BlockEntityTicker<T> blockentityticker) {
        return new a(t0, blockentityticker);
    }

    @FunctionalInterface
    public static interface c {
        public void run(Chunk var1);
    }

    public static enum EnumTileEntityState {
        IMMEDIATE,
        QUEUED,
        CHECK;

    }

    private class d
    implements TickingBlockEntity {
        private TickingBlockEntity ticker;

        d(Chunk chunk, Chunk chunk2, TickingBlockEntity tickingblockentity) {
            this.ticker = tickingblockentity;
        }

        void rebind(TickingBlockEntity tickingblockentity) {
            this.ticker = tickingblockentity;
        }

        @Override
        public void tick() {
            this.ticker.tick();
        }

        @Override
        public boolean isRemoved() {
            return this.ticker.isRemoved();
        }

        @Override
        public BlockPosition getPos() {
            return this.ticker.getPos();
        }

        @Override
        public String getType() {
            return this.ticker.getType();
        }

        public String toString() {
            return String.valueOf(this.ticker) + " <wrapped>";
        }
    }

    private class a<T extends TileEntity>
    implements TickingBlockEntity {
        private final T blockEntity;
        private final BlockEntityTicker<T> ticker;
        private boolean loggedInvalidBlockState;

        a(TileEntity tileentity, BlockEntityTicker blockentityticker) {
            this.blockEntity = tileentity;
            this.ticker = blockentityticker;
        }

        @Override
        public void tick() {
            BlockPosition blockposition;
            if (!((TileEntity)this.blockEntity).isRemoved() && ((TileEntity)this.blockEntity).hasLevel() && Chunk.this.isTicking(blockposition = ((TileEntity)this.blockEntity).getBlockPos())) {
                try {
                    GameProfilerFiller gameprofilerfiller = Chunk.this.level.getProfiler();
                    gameprofilerfiller.push(this::getType);
                    ((TileEntity)this.blockEntity).tickTimer.startTiming();
                    IBlockData iblockdata = Chunk.this.getBlockState(blockposition);
                    if (((TileEntity)this.blockEntity).getType().isValid(iblockdata)) {
                        this.ticker.tick(Chunk.this.level, ((TileEntity)this.blockEntity).getBlockPos(), iblockdata, this.blockEntity);
                        this.loggedInvalidBlockState = false;
                    } else if (!this.loggedInvalidBlockState) {
                        this.loggedInvalidBlockState = true;
                        LOGGER.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::getType), LogUtils.defer(this::getPos), iblockdata});
                    }
                    gameprofilerfiller.pop();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable(throwable, "Ticking block entity");
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Block entity being ticked");
                    ((TileEntity)this.blockEntity).fillCrashReportCategory(crashreportsystemdetails);
                    throw new ReportedException(crashreport);
                }
                finally {
                    ((TileEntity)this.blockEntity).tickTimer.stopTiming();
                }
            }
        }

        @Override
        public boolean isRemoved() {
            return ((TileEntity)this.blockEntity).isRemoved();
        }

        @Override
        public BlockPosition getPos() {
            return ((TileEntity)this.blockEntity).getBlockPos();
        }

        @Override
        public String getType() {
            return TileEntityTypes.getKey(((TileEntity)this.blockEntity).getType()).toString();
        }

        public String toString() {
            String s2 = this.getType();
            return "Level ticker for " + s2 + "@" + String.valueOf(this.getPos());
        }
    }
}

