/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_21_R1.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R1.util.RandomSourceWrapper;
import org.bukkit.event.Event;
import org.bukkit.event.world.AsyncStructureSpawnEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.BoundingBox;
import org.spigotmc.SpigotWorldConfig;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> CODEC = BuiltInRegistries.CHUNK_GENERATOR.byNameCodec().dispatchStable(ChunkGenerator::codec, Function.identity());
    protected final WorldChunkManager biomeSource;
    private final Supplier<List<FeatureSorter.b>> featuresPerStep;
    public final Function<Holder<BiomeBase>, BiomeSettingsGeneration> generationSettingsGetter;

    public ChunkGenerator(WorldChunkManager worldchunkmanager) {
        this(worldchunkmanager, holder -> ((BiomeBase)holder.value()).getGenerationSettings());
    }

    public ChunkGenerator(WorldChunkManager worldchunkmanager, Function<Holder<BiomeBase>, BiomeSettingsGeneration> function) {
        this.biomeSource = worldchunkmanager;
        this.generationSettingsGetter = function;
        this.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(worldchunkmanager.possibleBiomes()), holder -> ((BiomeSettingsGeneration)function.apply((Holder<BiomeBase>)holder)).features(), true));
    }

    public void validate() {
        this.featuresPerStep.get();
    }

    protected abstract MapCodec<? extends ChunkGenerator> codec();

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> holderlookup, RandomState randomstate, long i2, SpigotWorldConfig conf) {
        return ChunkGeneratorStructureState.createForNormal(randomstate, i2, this.biomeSource, holderlookup, conf);
    }

    public Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> getTypeNameForDataFixer() {
        return BuiltInRegistries.CHUNK_GENERATOR.getResourceKey(this.codec());
    }

    public CompletableFuture<IChunkAccess> createBiomes(RandomState randomstate, Blender blender, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        return CompletableFuture.supplyAsync(SystemUtils.wrapThreadWithTaskName("init_biomes", () -> {
            ichunkaccess.fillBiomesFromNoise(this.biomeSource, randomstate.sampler());
            return ichunkaccess;
        }), SystemUtils.backgroundExecutor());
    }

    public abstract void applyCarvers(RegionLimitedWorldAccess var1, long var2, RandomState var4, BiomeManager var5, StructureManager var6, IChunkAccess var7, WorldGenStage.Features var8);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Pair<BlockPosition, Holder<Structure>> findNearestMapStructure(WorldServer worldserver, HolderSet<Structure> holderset, BlockPosition blockposition, int i2, boolean flag) {
        void var9_13;
        ChunkGeneratorStructureState chunkgeneratorstructurestate = worldserver.getChunkSource().getGeneratorState();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Holder holder : holderset) {
            for (StructurePlacement structureplacement : chunkgeneratorstructurestate.getPlacementsForStructure(holder)) {
                map.computeIfAbsent(structureplacement, structureplacement1 -> new ObjectArraySet()).add(holder);
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        Object var9_10 = null;
        double d0 = Double.MAX_VALUE;
        StructureManager structuremanager = worldserver.structureManager();
        ArrayList list = new ArrayList(map.size());
        for (Map.Entry entry : map.entrySet()) {
            StructurePlacement structureplacement12 = (StructurePlacement)entry.getKey();
            if (structureplacement12 instanceof ConcentricRingsStructurePlacement) {
                BlockPosition blockposition1;
                double d2;
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement12;
                Pair<BlockPosition, Holder<Structure>> pair1 = this.getNearestGeneratedStructure((Set)entry.getValue(), worldserver, structuremanager, blockposition, flag, concentricringsstructureplacement);
                if (pair1 == null || !((d2 = blockposition.distSqr(blockposition1 = (BlockPosition)pair1.getFirst())) < d0)) continue;
                d0 = d2;
                Pair<BlockPosition, Holder<Structure>> pair = pair1;
                continue;
            }
            if (!(structureplacement12 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int j2 = SectionPosition.blockToSectionCoord(blockposition.getX());
            int k2 = SectionPosition.blockToSectionCoord(blockposition.getZ());
            for (int l2 = 0; l2 <= i2; ++l2) {
                boolean flag1 = false;
                for (Map.Entry entry : list) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPosition, Holder<Structure>> pair2 = ChunkGenerator.getNearestGeneratedStructure((Set)entry.getValue(), worldserver, structuremanager, j2, k2, l2, flag, chunkgeneratorstructurestate.getLevelSeed(), randomspreadstructureplacement);
                    if (pair2 == null) continue;
                    flag1 = true;
                    double d2 = blockposition.distSqr((BaseBlockPosition)pair2.getFirst());
                    if (!(d2 < d0)) continue;
                    d0 = d2;
                    Pair<BlockPosition, Holder<Structure>> pair = pair2;
                }
                if (!flag1) continue;
                return var9_13;
            }
        }
        return var9_13;
    }

    @Nullable
    private Pair<BlockPosition, Holder<Structure>> getNearestGeneratedStructure(Set<Holder<Structure>> set, WorldServer worldserver, StructureManager structuremanager, BlockPosition blockposition, boolean flag, ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        List<ChunkCoordIntPair> list = worldserver.getChunkSource().getGeneratorState().getRingPositionsFor(concentricringsstructureplacement);
        if (list == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        Pair<BlockPosition, Holder<Structure>> pair = null;
        double d0 = Double.MAX_VALUE;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (ChunkCoordIntPair chunkcoordintpair : list) {
            Pair<BlockPosition, Holder<Structure>> pair1;
            blockposition_mutableblockposition.set(SectionPosition.sectionToBlockCoord(chunkcoordintpair.x, 8), 32, SectionPosition.sectionToBlockCoord(chunkcoordintpair.z, 8));
            double d1 = blockposition_mutableblockposition.distSqr(blockposition);
            boolean flag1 = pair == null || d1 < d0;
            if (!flag1 || (pair1 = ChunkGenerator.getStructureGeneratingAt(set, worldserver, structuremanager, flag, concentricringsstructureplacement, chunkcoordintpair)) == null) continue;
            pair = pair1;
            d0 = d1;
        }
        return pair;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<Structure>> getNearestGeneratedStructure(Set<Holder<Structure>> set, IWorldReader iworldreader, StructureManager structuremanager, int i2, int j2, int k2, boolean flag, long l2, RandomSpreadStructurePlacement randomspreadstructureplacement) {
        int i1 = randomspreadstructureplacement.spacing();
        for (int j1 = -k2; j1 <= k2; ++j1) {
            boolean flag1 = j1 == -k2 || j1 == k2;
            for (int k1 = -k2; k1 <= k2; ++k1) {
                int i22;
                int l1;
                ChunkCoordIntPair chunkcoordintpair;
                Pair<BlockPosition, Holder<Structure>> pair;
                boolean flag2;
                boolean bl = flag2 = k1 == -k2 || k1 == k2;
                if (!flag1 && !flag2 || (pair = ChunkGenerator.getStructureGeneratingAt(set, iworldreader, structuremanager, flag, randomspreadstructureplacement, chunkcoordintpair = randomspreadstructureplacement.getPotentialStructureChunk(l2, l1 = i2 + i1 * j1, i22 = j2 + i1 * k1))) == null) continue;
                return pair;
            }
        }
        return null;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<Structure>> getStructureGeneratingAt(Set<Holder<Structure>> set, IWorldReader iworldreader, StructureManager structuremanager, boolean flag, StructurePlacement structureplacement, ChunkCoordIntPair chunkcoordintpair) {
        StructureStart structurestart;
        Holder<Structure> holder;
        Iterator<Holder<Structure>> iterator = set.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return null;
            }
            holder = iterator.next();
            StructureCheckResult structurecheckresult = structuremanager.checkStructurePresence(chunkcoordintpair, holder.value(), structureplacement, flag);
            if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!flag && structurecheckresult == StructureCheckResult.START_PRESENT) {
                return Pair.of((Object)structureplacement.getLocatePos(chunkcoordintpair), holder);
            }
            IChunkAccess ichunkaccess = iworldreader.getChunk(chunkcoordintpair.x, chunkcoordintpair.z, ChunkStatus.STRUCTURE_STARTS);
            structurestart = structuremanager.getStartForStructure(SectionPosition.bottomOf(ichunkaccess), holder.value(), ichunkaccess);
            if (structurestart != null && structurestart.isValid() && (!flag || ChunkGenerator.tryAddReference(structuremanager, structurestart))) break;
        }
        return Pair.of((Object)structureplacement.getLocatePos(structurestart.getChunkPos()), holder);
    }

    private static boolean tryAddReference(StructureManager structuremanager, StructureStart structurestart) {
        if (structurestart.canBeReferenced()) {
            structuremanager.addReference(structurestart);
            return true;
        }
        return false;
    }

    public void addVanillaDecorations(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
        if (!SharedConstants.debugVoidTerrain(chunkcoordintpair)) {
            SectionPosition sectionposition = SectionPosition.of(chunkcoordintpair, generatoraccessseed.getMinSection());
            BlockPosition blockposition = sectionposition.origin();
            IRegistry<Structure> iregistry = generatoraccessseed.registryAccess().registryOrThrow(Registries.STRUCTURE);
            Map<Integer, List<Structure>> map = iregistry.stream().collect(Collectors.groupingBy(structure -> structure.step().ordinal()));
            List<FeatureSorter.b> list = this.featuresPerStep.get();
            SeededRandom seededrandom = new SeededRandom(new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
            long i2 = seededrandom.setDecorationSeed(generatoraccessseed.getSeed(), blockposition.getX(), blockposition.getZ());
            ObjectArraySet set = new ObjectArraySet();
            ChunkCoordIntPair.rangeClosed(sectionposition.chunk(), 1).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$6(generatoraccessseed, (Set)set, arg_0));
            set.retainAll(this.biomeSource.possibleBiomes());
            int j2 = list.size();
            try {
                IRegistry<PlacedFeature> iregistry1 = generatoraccessseed.registryAccess().registryOrThrow(Registries.PLACED_FEATURE);
                int k2 = Math.max(WorldGenStage.Decoration.values().length, j2);
                for (int l2 = 0; l2 < k2; ++l2) {
                    int i1 = 0;
                    if (structuremanager.shouldGenerateStructures()) {
                        List list1 = map.getOrDefault(l2, Collections.emptyList());
                        for (Structure structure2 : list1) {
                            seededrandom.setFeatureSeed(i2, i1, l2);
                            Supplier<String> supplier = () -> {
                                Optional<String> optional = iregistry.getResourceKey(structure2).map(Object::toString);
                                Objects.requireNonNull(structure2);
                                return (String)optional.orElseGet(structure2::toString);
                            };
                            try {
                                generatoraccessseed.setCurrentlyGenerating(supplier);
                                structuremanager.startsForStructure(sectionposition, structure2).forEach(structurestart -> structurestart.placeInChunk(generatoraccessseed, structuremanager, this, seededrandom, ChunkGenerator.getWritableArea(ichunkaccess), chunkcoordintpair));
                            }
                            catch (Exception exception) {
                                CrashReport crashreport = CrashReport.forThrowable(exception, "Feature placement");
                                CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Feature");
                                Objects.requireNonNull(supplier);
                                crashreportsystemdetails.setDetail("Description", supplier::get);
                                throw new ReportedException(crashreport);
                            }
                            ++i1;
                        }
                    }
                    if (l2 >= j2) continue;
                    IntArraySet intarrayset = new IntArraySet();
                    for (Holder holder : set) {
                        List<HolderSet<PlacedFeature>> list2 = this.generationSettingsGetter.apply(holder).features();
                        if (l2 >= list2.size()) continue;
                        HolderSet<PlacedFeature> holderset = list2.get(l2);
                        FeatureSorter.b featuresorter_b = list.get(l2);
                        holderset.stream().map(Holder::value).forEach(placedfeature -> intarrayset.add(featuresorter_b.indexMapping().applyAsInt((PlacedFeature)placedfeature)));
                    }
                    int j1 = intarrayset.size();
                    int[] aint = intarrayset.toIntArray();
                    Arrays.sort(aint);
                    FeatureSorter.b featuresorter_b1 = list.get(l2);
                    for (int k1 = 0; k1 < j1; ++k1) {
                        int l1 = aint[k1];
                        PlacedFeature placedfeature2 = featuresorter_b1.features().get(l1);
                        Supplier<String> supplier1 = () -> {
                            Optional<String> optional = iregistry1.getResourceKey(placedfeature2).map(Object::toString);
                            Objects.requireNonNull(placedfeature2);
                            return (String)optional.orElseGet(placedfeature2::toString);
                        };
                        seededrandom.setFeatureSeed(i2, l1, l2);
                        try {
                            generatoraccessseed.setCurrentlyGenerating(supplier1);
                            placedfeature2.placeWithBiomeCheck(generatoraccessseed, this, seededrandom, blockposition);
                            continue;
                        }
                        catch (Exception exception1) {
                            CrashReport crashreport1 = CrashReport.forThrowable(exception1, "Feature placement");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport1.addCategory("Feature");
                            Objects.requireNonNull(supplier1);
                            crashreportsystemdetails.setDetail("Description", supplier1::get);
                            throw new ReportedException(crashreport1);
                        }
                    }
                }
                generatoraccessseed.setCurrentlyGenerating(null);
            }
            catch (Exception exception2) {
                CrashReport crashreport2 = CrashReport.forThrowable(exception2, "Biome decoration");
                crashreport2.addCategory("Generation").setDetail("CenterX", chunkcoordintpair.x).setDetail("CenterZ", chunkcoordintpair.z).setDetail("Decoration Seed", i2);
                throw new ReportedException(crashreport2);
            }
        }
    }

    public void applyBiomeDecoration(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        this.applyBiomeDecoration(generatoraccessseed, ichunkaccess, structuremanager, true);
    }

    public void applyBiomeDecoration(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager, boolean vanilla) {
        CraftWorld world;
        if (vanilla) {
            this.addVanillaDecorations(generatoraccessseed, ichunkaccess, structuremanager);
        }
        if (!(world = generatoraccessseed.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(generatoraccessseed, ichunkaccess.getPos());
            int x2 = ichunkaccess.getPos().x;
            int z2 = ichunkaccess.getPos().z;
            for (BlockPopulator populator : world.getPopulators()) {
                SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(generatoraccessseed.getSeed()));
                seededrandom.setDecorationSeed(generatoraccessseed.getSeed(), x2, z2);
                populator.populate((WorldInfo)world, (Random)new RandomSourceWrapper.RandomWrapper(seededrandom), x2, z2, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    private static StructureBoundingBox getWritableArea(IChunkAccess ichunkaccess) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
        int i2 = chunkcoordintpair.getMinBlockX();
        int j2 = chunkcoordintpair.getMinBlockZ();
        LevelHeightAccessor levelheightaccessor = ichunkaccess.getHeightAccessorForGeneration();
        int k2 = levelheightaccessor.getMinBuildHeight() + 1;
        int l2 = levelheightaccessor.getMaxBuildHeight() - 1;
        return new StructureBoundingBox(i2, k2, j2, i2 + 15, l2, j2 + 15);
    }

    public abstract void buildSurface(RegionLimitedWorldAccess var1, StructureManager var2, RandomState var3, IChunkAccess var4);

    public abstract void spawnOriginalMobs(RegionLimitedWorldAccess var1);

    public int getSpawnHeight(LevelHeightAccessor levelheightaccessor) {
        return 64;
    }

    public WorldChunkManager getBiomeSource() {
        return this.biomeSource;
    }

    public abstract int getGenDepth();

    public WeightedRandomList<BiomeSettingsMobs.c> getMobsAt(Holder<BiomeBase> holder, StructureManager structuremanager, EnumCreatureType enumcreaturetype, BlockPosition blockposition) {
        Map<Structure, LongSet> map = structuremanager.getAllStructuresAt(blockposition);
        for (Map.Entry<Structure, LongSet> entry : map.entrySet()) {
            Structure structure = entry.getKey();
            StructureSpawnOverride structurespawnoverride = structure.spawnOverrides().get(enumcreaturetype);
            if (structurespawnoverride == null) continue;
            MutableBoolean mutableboolean = new MutableBoolean(false);
            Predicate<StructureStart> predicate = structurespawnoverride.boundingBox() == StructureSpawnOverride.a.PIECE ? structurestart -> structuremanager.structureHasPieceAt(blockposition, (StructureStart)structurestart) : structurestart -> structurestart.getBoundingBox().isInside(blockposition);
            structuremanager.fillStartsForStructure(structure, entry.getValue(), structurestart -> {
                if (mutableboolean.isFalse() && predicate.test((StructureStart)structurestart)) {
                    mutableboolean.setTrue();
                }
            });
            if (!mutableboolean.isTrue()) continue;
            return structurespawnoverride.spawns();
        }
        return holder.value().getMobSettings().getMobs(enumcreaturetype);
    }

    public void createStructures(IRegistryCustom iregistrycustom, ChunkGeneratorStructureState chunkgeneratorstructurestate, StructureManager structuremanager, IChunkAccess ichunkaccess, StructureTemplateManager structuretemplatemanager) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
        SectionPosition sectionposition = SectionPosition.bottomOf(ichunkaccess);
        RandomState randomstate = chunkgeneratorstructurestate.randomState();
        chunkgeneratorstructurestate.possibleStructureSets().forEach(holder -> {
            StructurePlacement structureplacement = ((StructureSet)holder.value()).placement();
            List<StructureSet.a> list = ((StructureSet)holder.value()).structures();
            for (StructureSet.a structureset_a : list) {
                StructureStart structurestart = structuremanager.getStartForStructure(sectionposition, structureset_a.structure().value(), ichunkaccess);
                if (structurestart == null || !structurestart.isValid()) continue;
                return;
            }
            if (structureplacement.isStructureChunk(chunkgeneratorstructurestate, chunkcoordintpair.x, chunkcoordintpair.z)) {
                if (list.size() == 1) {
                    this.tryGenerateStructure(list.get(0), structuremanager, iregistrycustom, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.getLevelSeed(), ichunkaccess, chunkcoordintpair, sectionposition);
                } else {
                    ArrayList<StructureSet.a> arraylist = new ArrayList<StructureSet.a>(list.size());
                    arraylist.addAll(list);
                    SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(0L));
                    seededrandom.setLargeFeatureSeed(chunkgeneratorstructurestate.getLevelSeed(), chunkcoordintpair.x, chunkcoordintpair.z);
                    int i2 = 0;
                    for (StructureSet.a structureset_a1 : arraylist) {
                        i2 += structureset_a1.weight();
                    }
                    while (!arraylist.isEmpty()) {
                        StructureSet.a structureset_a2;
                        int j2 = seededrandom.nextInt(i2);
                        int k2 = 0;
                        Iterator iterator2 = arraylist.iterator();
                        while (iterator2.hasNext() && (j2 -= (structureset_a2 = (StructureSet.a)iterator2.next()).weight()) >= 0) {
                            ++k2;
                        }
                        StructureSet.a structureset_a3 = (StructureSet.a)arraylist.get(k2);
                        if (this.tryGenerateStructure(structureset_a3, structuremanager, iregistrycustom, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.getLevelSeed(), ichunkaccess, chunkcoordintpair, sectionposition)) {
                            return;
                        }
                        arraylist.remove(k2);
                        i2 -= structureset_a3.weight();
                    }
                }
            }
        });
    }

    private boolean tryGenerateStructure(StructureSet.a structureset_a, StructureManager structuremanager, IRegistryCustom iregistrycustom, RandomState randomstate, StructureTemplateManager structuretemplatemanager, long i2, IChunkAccess ichunkaccess, ChunkCoordIntPair chunkcoordintpair, SectionPosition sectionposition) {
        Structure structure = structureset_a.structure().value();
        int j2 = ChunkGenerator.fetchReferences(structuremanager, ichunkaccess, sectionposition, structure);
        HolderSet<BiomeBase> holderset = structure.biomes();
        Objects.requireNonNull(holderset);
        Predicate<Holder<BiomeBase>> predicate = holderset::contains;
        StructureStart structurestart = structure.generate(iregistrycustom, this, this.biomeSource, randomstate, structuretemplatemanager, i2, chunkcoordintpair, j2, ichunkaccess, predicate);
        if (structurestart.isValid()) {
            StructureBoundingBox box = structurestart.getBoundingBox();
            AsyncStructureSpawnEvent event = new AsyncStructureSpawnEvent((World)structuremanager.level.getMinecraftWorld().getWorld(), CraftStructure.minecraftToBukkit(structure), new BoundingBox((double)box.minX(), (double)box.minY(), (double)box.minZ(), (double)box.maxX(), (double)box.maxY(), (double)box.maxZ()), chunkcoordintpair.x, chunkcoordintpair.z);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return true;
            }
            structuremanager.setStartForStructure(sectionposition, structure, structurestart, ichunkaccess);
            return true;
        }
        return false;
    }

    private static int fetchReferences(StructureManager structuremanager, IChunkAccess ichunkaccess, SectionPosition sectionposition, Structure structure) {
        StructureStart structurestart = structuremanager.getStartForStructure(sectionposition, structure, ichunkaccess);
        return structurestart != null ? structurestart.getReferences() : 0;
    }

    public void createReferences(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        boolean flag = true;
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
        int i2 = chunkcoordintpair.x;
        int j2 = chunkcoordintpair.z;
        int k2 = chunkcoordintpair.getMinBlockX();
        int l2 = chunkcoordintpair.getMinBlockZ();
        SectionPosition sectionposition = SectionPosition.bottomOf(ichunkaccess);
        for (int i1 = i2 - 8; i1 <= i2 + 8; ++i1) {
            for (int j1 = j2 - 8; j1 <= j2 + 8; ++j1) {
                long k1 = ChunkCoordIntPair.asLong(i1, j1);
                for (StructureStart structurestart : generatoraccessseed.getChunk(i1, j1).getAllStarts().values()) {
                    try {
                        if (!structurestart.isValid() || !structurestart.getBoundingBox().intersects(k2, l2, k2 + 15, l2 + 15)) continue;
                        structuremanager.addReferenceForStructure(sectionposition, structurestart.getStructure(), k1, ichunkaccess);
                        PacketDebug.sendStructurePacket(generatoraccessseed, structurestart);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.forThrowable(exception, "Generating structure reference");
                        CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Structure");
                        Optional<IRegistry<Structure>> optional = generatoraccessseed.registryAccess().registry(Registries.STRUCTURE);
                        crashreportsystemdetails.setDetail("Id", () -> optional.map(iregistry -> iregistry.getKey(structurestart.getStructure()).toString()).orElse("UNKNOWN"));
                        crashreportsystemdetails.setDetail("Name", () -> BuiltInRegistries.STRUCTURE_TYPE.getKey(structurestart.getStructure().type()).toString());
                        crashreportsystemdetails.setDetail("Class", () -> structurestart.getStructure().getClass().getCanonicalName());
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<IChunkAccess> fillFromNoise(Blender var1, RandomState var2, StructureManager var3, IChunkAccess var4);

    public abstract int getSeaLevel();

    public abstract int getMinY();

    public abstract int getBaseHeight(int var1, int var2, HeightMap.Type var3, LevelHeightAccessor var4, RandomState var5);

    public abstract BlockColumn getBaseColumn(int var1, int var2, LevelHeightAccessor var3, RandomState var4);

    public int getFirstFreeHeight(int i2, int j2, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.getBaseHeight(i2, j2, heightmap_type, levelheightaccessor, randomstate);
    }

    public int getFirstOccupiedHeight(int i2, int j2, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.getBaseHeight(i2, j2, heightmap_type, levelheightaccessor, randomstate) - 1;
    }

    public abstract void addDebugScreenInfo(List<String> var1, RandomState var2, BlockPosition var3);

    @Deprecated
    public BiomeSettingsGeneration getBiomeGenerationSettings(Holder<BiomeBase> holder) {
        return this.generationSettingsGetter.apply(holder);
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$6(GeneratorAccessSeed generatoraccessseed, Set set, ChunkCoordIntPair chunkcoordintpair1) {
        IChunkAccess ichunkaccess1 = generatoraccessseed.getChunk(chunkcoordintpair1.x, chunkcoordintpair1.z);
        for (ChunkSection chunksection : ichunkaccess1.getSections()) {
            PalettedContainerRO<Holder<BiomeBase>> palettedcontainerro = chunksection.getBiomes();
            Objects.requireNonNull(set);
            palettedcontainerro.getAll(set::add);
        }
    }
}

